/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ByteBuffer;
import com.teragard.PalettedTexture;

public final class AlphaPalettedTexture
extends PalettedTexture {
    private final byte[] alpha;

    public AlphaPalettedTexture(int width, int height, ByteBuffer buffer) {
        super(width, height, buffer, true);
        int count = width * height;
        this.alpha = new byte[count];
        byte[] alpha = this.alpha;
        for (int i = 0; i != count; ++i) {
            alpha[i] = buffer.readSignedByte();
            if (alpha[i] == 0) {
                this.indices[i] = 0;
                this.opaque = false;
                continue;
            }
            if (alpha[i] == -1) continue;
            this.opaque = false;
            this.hasAlpha = true;
        }
    }

    public String getID() {
        return "2";
    }

    @Override
    public int getPixel(int i) {
        return (this.alpha[i] & 0xFF) << 24 | this.palette[this.indices[i] & 0xFF];
    }
}

