/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.signlink;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class CacheDownloader
implements Runnable {
    private static final String CACHE_PATH = System.getProperty("user.home") + File.separator + "TeragardCache" + File.separator;
    private static final String ZIP_URL = "http://157.180.65.96/TeragardCache.zip";
    private static final String VERSION_FILE = CACHE_PATH + "cacheVersion.dat";
    private GUI g;
    long newest;

    public long getCurrentVersion() {
        try {
            File versionDir = new File(VERSION_FILE);
            if (!versionDir.exists()) {
                versionDir.createNewFile();
                return -1L;
            }
            return Long.parseLong(new BufferedReader(new InputStreamReader(new FileInputStream(VERSION_FILE))).readLine());
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public long getNewestVersion() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(ZIP_URL).openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            return conn.getContentLengthLong();
        }
        catch (UnknownHostException e) {
            System.out.println("[CacheDownloader] Cache server not reachable, using local cache");
            return this.getCurrentVersion();
        }
        catch (Exception e) {
            this.handleException(e);
            return -1L;
        }
    }

    private void handleException(Exception e) {
        if (e instanceof UnknownHostException || e instanceof ConnectException || e instanceof SocketTimeoutException) {
            String msg = "Unable to connect to the cache server.\n\nThis is normal if you're running a local server.\nThe client will use your existing cache files.\n\nIf this persists, check your internet connection.";
            System.out.println("[CacheDownloader] " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return;
        }
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("Cache Update Error\n\n");
        strBuff.append("An error occurred while updating the cache.\n");
        strBuff.append("The client will continue with existing cache files.\n\n");
        strBuff.append("Technical details:\n");
        strBuff.append(e.getClass().getName() + " \"" + e.getMessage() + "\"\n");
        for (int i = 0; i < Math.min(5, e.getStackTrace().length); ++i) {
            strBuff.append(e.getStackTrace()[i].toString() + "\n");
        }
        this.alert("Cache Update Error", strBuff.toString(), true);
        e.printStackTrace();
    }

    private void alert(String title, String msg, boolean error) {
        JOptionPane.showMessageDialog(null, msg, title, error ? 0 : -1);
    }

    @Override
    public void run() {
        try {
            System.out.println("[CacheDownloader] Checking for cache updates...");
            this.newest = this.getNewestVersion();
            long current = this.getCurrentVersion();
            if (this.newest != current) {
                System.out.println("[CacheDownloader] Update available, downloading new cache...");
                this.g = new GUI();
                this.g.setLocationRelativeTo(null);
                this.g.setVisible(true);
                this.updateCache();
                this.g.dispose();
            } else {
                System.out.println("[CacheDownloader] Cache is up to date");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void updateCache() {
        File clientZip = this.downloadCache();
        if (clientZip != null) {
            this.unZip(clientZip);
        }
    }

    private void unZip(File clientZip) {
        try {
            this.unZipFile(clientZip, new File(signlink.findcachedir()));
            Files.delete(clientZip.toPath());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void unZipFile(File srcFile, File temp) {
        this.g.setStatus("Unzipping The Cache...");
        this.g.setPercent(0);
        if (!temp.exists()) {
            temp.mkdirs();
        }
        byte[] buffer = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(srcFile);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                try {
                    String fileName = ze.getName();
                    File newFile = new File(String.valueOf(temp) + File.separator + fileName);
                    System.out.println("Unzipping to " + newFile.getAbsolutePath());
                    new File(newFile.getParent()).mkdirs();
                    if (ze.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        int len;
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zis.closeEntry();
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
            new FileOutputStream(VERSION_FILE).write(String.valueOf(this.newest).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File downloadCache() {
        File file;
        this.g.setStatus("Downloading Cache... Hold Tight...");
        File ret = new File(CACHE_PATH + "TeragardCache.zip");
        FileOutputStream out = new FileOutputStream(ret);
        try {
            int len;
            HttpURLConnection conn = (HttpURLConnection)new URL(ZIP_URL).openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            InputStream in = conn.getInputStream();
            long max = conn.getContentLength();
            long curr = 0L;
            byte[] b = new byte[1024];
            while ((len = in.read(b, 0, b.length)) > -1) {
                ((OutputStream)out).write(b, 0, len);
                this.g.setPercent((int)((curr += (long)len) * 100L / max));
            }
            out.flush();
            in.close();
            file = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.handleException(e);
                ret.delete();
                return null;
            }
        }
        ((OutputStream)out).close();
        return file;
    }

    public class GUI
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private int percent = 0;
        private JLabel jLabel1;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JProgressBar jProgressBar1;

        public GUI() {
            try {
                UIManager.setLookAndFeel("org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initComponents();
        }

        private void initComponents() {
            this.jProgressBar1 = new JProgressBar();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.setDefaultCloseOperation(2);
            this.setTitle("Teragard Cache Update");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    GUI.this.formWindowClosing(evt);
                }
            });
            this.jLabel1.setText("Status:");
            this.jLabel2.setText("N/A");
            this.jLabel3.setText("0%");
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 304, Short.MAX_VALUE).addComponent(this.jLabel3)).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -1, 380, Short.MAX_VALUE)).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3)).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
            this.pack();
        }

        private void formWindowClosing(WindowEvent evt) {
        }

        public void setStatus(String s) {
            this.jLabel2.setText(s);
        }

        public String getStatus() {
            return this.jLabel2.getText();
        }

        public void setPercent(int amount) {
            this.percent = amount;
            this.jLabel3.setText(amount + "%");
            this.jProgressBar1.setValue(amount);
        }

        public int getPercent() {
            return this.percent;
        }
    }
}

