/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teragard.ItemDef;
import com.teragard.signlink;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomItemLoader {
    private static final String LEGACY_PATH = "data/custom_items.json";
    private static final String CONTENT_PATH = "data/content/items/";
    private static final Map<Integer, CustomItemDef> customItems = new HashMap<Integer, CustomItemDef>();
    private static final Map<Integer, TierColor> tierColors = new HashMap<Integer, TierColor>();
    private static final Set<Integer> stackableOverrides = new HashSet<Integer>();
    private static boolean loaded = false;
    private static final Gson gson = new Gson();

    public static void load() {
        if (loaded) {
            return;
        }
        CustomItemLoader.initDefaultTierColors();
        CustomItemLoader.loadLegacyFile();
        CustomItemLoader.loadContentDirectory();
        System.out.println("[CustomItemLoader] Loaded " + customItems.size() + " custom items total.");
        loaded = true;
    }

    private static void initDefaultTierColors() {
        TierColor t0 = new TierColor();
        t0.namePrefix = "";
        tierColors.put(0, t0);
        TierColor t1 = new TierColor();
        t1.namePrefix = "@gre@";
        tierColors.put(1, t1);
        TierColor t2 = new TierColor();
        t2.namePrefix = "@pur@";
        tierColors.put(2, t2);
        TierColor t3 = new TierColor();
        t3.namePrefix = "@or3@";
        tierColors.put(3, t3);
    }

    private static void loadLegacyFile() {
        try {
            String localPath = "./data/custom_items.json";
            String cachePath = signlink.findcachedir() + LEGACY_PATH;
            Object jsonPath = null;
            if (Files.exists(Paths.get(localPath, new String[0]), new LinkOption[0])) {
                jsonPath = localPath;
            } else if (Files.exists(Paths.get(cachePath, new String[0]), new LinkOption[0])) {
                jsonPath = cachePath;
            }
            if (jsonPath == null) {
                return;
            }
            String content = new String(Files.readAllBytes(Paths.get((String)jsonPath, new String[0])));
            JsonObject root = gson.fromJson(content, JsonObject.class);
            if (root.has("tier_colors")) {
                JsonObject colors = root.getAsJsonObject("tier_colors");
                for (String tierKey : colors.keySet()) {
                    int tier = Integer.parseInt(tierKey);
                    JsonObject colorData = colors.getAsJsonObject(tierKey);
                    TierColor tc = new TierColor();
                    String string = tc.namePrefix = colorData.has("namePrefix") ? colorData.get("namePrefix").getAsString() : "";
                    if (colorData.has("modelColor") && !colorData.get("modelColor").isJsonNull()) {
                        JsonObject mc = colorData.getAsJsonObject("modelColor");
                        tc.colorFind = mc.get("find").getAsInt();
                        tc.colorReplace = mc.get("replace").getAsInt();
                    }
                    tierColors.put(tier, tc);
                }
            }
            if (root.has("item_sets")) {
                JsonObject itemSets = root.getAsJsonObject("item_sets");
                for (String setName : itemSets.keySet()) {
                    CustomItemLoader.loadItemSet(itemSets.getAsJsonObject(setName));
                }
            }
            if (root.has("materials")) {
                JsonArray materials = root.getAsJsonArray("materials");
                for (JsonElement elem : materials) {
                    CustomItemLoader.loadMaterial(elem.getAsJsonObject());
                }
            }
            if (root.has("standalone_equipment")) {
                JsonArray equipment = root.getAsJsonArray("standalone_equipment");
                for (JsonElement elem : equipment) {
                    CustomItemLoader.loadStandaloneEquipment(elem.getAsJsonObject());
                }
                System.out.println("[CustomItemLoader] Loaded " + equipment.size() + " standalone equipment items");
            }
            if (root.has("stackable_items")) {
                JsonArray stackables = root.getAsJsonArray("stackable_items");
                for (JsonElement elem : stackables) {
                    stackableOverrides.add(elem.getAsInt());
                }
            }
            if (root.has("boxes")) {
                JsonArray boxes = root.getAsJsonArray("boxes");
                for (JsonElement elem : boxes) {
                    CustomItemLoader.loadBox(elem.getAsJsonObject());
                }
            }
            System.out.println("[CustomItemLoader] Loaded from legacy: " + (String)jsonPath);
        }
        catch (Exception e) {
            System.err.println("[CustomItemLoader] Failed to load legacy file: " + e.getMessage());
        }
    }

    private static void loadContentDirectory() {
        try {
            File boxesDir;
            File standaloneDir;
            String localPath = "./data/content/items/";
            String cachePath = signlink.findcachedir() + CONTENT_PATH;
            File contentDir = null;
            if (new File(localPath).exists()) {
                contentDir = new File(localPath);
            } else if (new File(cachePath).exists()) {
                contentDir = new File(cachePath);
            }
            if (contentDir == null || !contentDir.exists()) {
                return;
            }
            File setsDir = new File(contentDir, "sets");
            if (setsDir.exists()) {
                CustomItemLoader.loadJsonFilesFromDirectory(setsDir, true);
            }
            if ((standaloneDir = new File(contentDir, "standalone")).exists()) {
                CustomItemLoader.loadJsonFilesFromDirectory(standaloneDir, false);
            }
            if ((boxesDir = new File(contentDir, "boxes")).exists()) {
                CustomItemLoader.loadBoxFilesFromDirectory(boxesDir);
            }
            System.out.println("[CustomItemLoader] Loaded from content directory: " + contentDir.getPath());
        }
        catch (Exception e) {
            System.err.println("[CustomItemLoader] Failed to load content directory: " + e.getMessage());
        }
    }

    private static void loadJsonFilesFromDirectory(File directory, boolean isSetFile) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CustomItemLoader.loadJsonFilesFromDirectory(file, isSetFile);
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            if (isSetFile) {
                CustomItemLoader.loadSetFromNewFormat(file);
                continue;
            }
            CustomItemLoader.loadStandaloneFromNewFormat(file);
        }
    }

    private static void loadSetFromNewFormat(File jsonFile) {
        try (FileReader reader = new FileReader(jsonFile);){
            JsonObject root = gson.fromJson((Reader)reader, JsonObject.class);
            if (!root.has("items")) {
                return;
            }
            JsonObject slots = root.has("slots") ? root.getAsJsonObject("slots") : null;
            JsonArray items = root.getAsJsonArray("items");
            for (JsonElement elem : items) {
                String slot;
                JsonObject itemObj = elem.getAsJsonObject();
                int tier = itemObj.has("tier") ? itemObj.get("tier").getAsInt() : 0;
                JsonObject model = null;
                JsonObject slotDef = null;
                if (itemObj.has("model")) {
                    model = itemObj.getAsJsonObject("model");
                } else if (slots != null && itemObj.has("slot")) {
                    String slotName = itemObj.get("slot").getAsString();
                    JsonObject jsonObject = slotDef = slots.has(slotName) ? slots.getAsJsonObject(slotName) : null;
                    if (slotDef != null && slotDef.has("model")) {
                        model = slotDef.getAsJsonObject("model");
                    }
                }
                if (model == null) continue;
                CustomItemDef def = new CustomItemDef();
                def.id = itemObj.get("id").getAsInt();
                def.name = itemObj.get("name").getAsString();
                def.tier = tier;
                def.modelId = model.get("inventory").getAsInt();
                def.maleEquip = model.get("male").getAsInt();
                def.femaleEquip = model.has("female") ? model.get("female").getAsInt() : def.maleEquip;
                def.modelZoom = model.has("zoom") ? model.get("zoom").getAsInt() : 1000;
                def.rotationX = model.has("rotationX") ? model.get("rotationX").getAsInt() : 0;
                def.rotationY = model.has("rotationY") ? model.get("rotationY").getAsInt() : 0;
                def.offsetX = model.has("offsetX") ? model.get("offsetX").getAsInt() : 0;
                int n = def.offsetY = model.has("offsetY") ? model.get("offsetY").getAsInt() : 0;
                if (model.has("modelIDs")) {
                    JsonArray modelIDsArray = model.getAsJsonArray("modelIDs");
                    def.modelIDs = new int[modelIDsArray.size()];
                    for (int i = 0; i < modelIDsArray.size(); ++i) {
                        def.modelIDs[i] = modelIDsArray.get(i).getAsInt();
                    }
                }
                def.action = slotDef != null && slotDef.has("action") ? slotDef.get("action").getAsString() : (itemObj.has("slot") ? ("weapon".equalsIgnoreCase(slot = itemObj.get("slot").getAsString()) ? "Wield" : "Wear") : "Wear");
                def.stackable = false;
                customItems.put(def.id, def);
            }
        }
        catch (Exception e) {
            System.err.println("[CustomItemLoader] Error loading set file " + jsonFile.getName() + ": " + e.getMessage());
        }
    }

    private static void loadStandaloneFromNewFormat(File jsonFile) {
        try (FileReader reader = new FileReader(jsonFile);){
            JsonObject itemObj = gson.fromJson((Reader)reader, JsonObject.class);
            if (!itemObj.has("id") || !itemObj.has("model")) {
                return;
            }
            JsonObject model = itemObj.getAsJsonObject("model");
            CustomItemDef def = new CustomItemDef();
            def.id = itemObj.get("id").getAsInt();
            def.name = itemObj.get("name").getAsString();
            def.tier = 0;
            def.modelId = model.get("inventory").getAsInt();
            def.maleEquip = model.get("male").getAsInt();
            def.femaleEquip = model.has("female") ? model.get("female").getAsInt() : def.maleEquip;
            def.modelZoom = model.has("zoom") ? model.get("zoom").getAsInt() : 1000;
            def.rotationX = model.has("rotationX") ? model.get("rotationX").getAsInt() : 0;
            def.rotationY = model.has("rotationY") ? model.get("rotationY").getAsInt() : 0;
            def.offsetX = model.has("offsetX") ? model.get("offsetX").getAsInt() : 0;
            def.offsetY = model.has("offsetY") ? model.get("offsetY").getAsInt() : 0;
            def.action = itemObj.has("action") ? itemObj.get("action").getAsString() : "Wear";
            boolean bl = def.stackable = itemObj.has("stackable") && itemObj.get("stackable").getAsBoolean();
            if (model.has("modelIDs")) {
                JsonArray modelIDsArray = model.getAsJsonArray("modelIDs");
                def.modelIDs = new int[modelIDsArray.size()];
                for (int i = 0; i < modelIDsArray.size(); ++i) {
                    def.modelIDs[i] = modelIDsArray.get(i).getAsInt();
                }
            }
            customItems.put(def.id, def);
        }
        catch (Exception e) {
            System.err.println("[CustomItemLoader] Error loading standalone file " + jsonFile.getName() + ": " + e.getMessage());
        }
    }

    private static void loadBoxFilesFromDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CustomItemLoader.loadBoxFilesFromDirectory(file);
                continue;
            }
            if (!file.getName().endsWith(".json")) continue;
            CustomItemLoader.loadBoxFromNewFormat(file);
        }
    }

    private static void loadBoxFromNewFormat(File jsonFile) {
        try (FileReader reader = new FileReader(jsonFile);){
            JsonObject recolors;
            JsonObject itemObj = gson.fromJson((Reader)reader, JsonObject.class);
            if (!itemObj.has("id") || !itemObj.has("model")) {
                return;
            }
            JsonObject model = itemObj.getAsJsonObject("model");
            CustomItemDef def = new CustomItemDef();
            def.id = itemObj.get("id").getAsInt();
            def.name = itemObj.has("name") ? itemObj.get("name").getAsString() : "Box";
            def.tier = 0;
            def.modelId = model.get("inventory").getAsInt();
            def.maleEquip = -1;
            def.femaleEquip = -1;
            def.copyFromId = itemObj.has("copyFrom") ? itemObj.get("copyFrom").getAsInt() : -1;
            def.modelZoom = model.has("zoom") ? model.get("zoom").getAsInt() : -1;
            def.rotationX = model.has("rotationX") ? model.get("rotationX").getAsInt() : -9999;
            def.rotationY = model.has("rotationY") ? model.get("rotationY").getAsInt() : -9999;
            def.offsetX = model.has("offsetX") ? model.get("offsetX").getAsInt() : -9999;
            def.offsetY = model.has("offsetY") ? model.get("offsetY").getAsInt() : -9999;
            boolean bl = def.stackable = itemObj.has("stackable") && itemObj.get("stackable").getAsBoolean();
            if (itemObj.has("actions")) {
                JsonArray actionsArray = itemObj.getAsJsonArray("actions");
                def.actions = new String[5];
                for (int i = 0; i < Math.min(actionsArray.size(), 5); ++i) {
                    JsonElement actionElem = actionsArray.get(i);
                    def.actions[i] = actionElem.isJsonNull() ? null : actionElem.getAsString();
                }
            }
            if (itemObj.has("recolors") && (recolors = itemObj.getAsJsonObject("recolors")).has("find") && recolors.has("replace")) {
                int i;
                JsonArray findArray = recolors.getAsJsonArray("find");
                JsonArray replaceArray = recolors.getAsJsonArray("replace");
                def.editedModelColor = new int[findArray.size()];
                def.newModelColor = new int[replaceArray.size()];
                for (i = 0; i < findArray.size(); ++i) {
                    def.editedModelColor[i] = findArray.get(i).getAsInt();
                }
                for (i = 0; i < replaceArray.size(); ++i) {
                    def.newModelColor[i] = replaceArray.get(i).getAsInt();
                }
            }
            customItems.put(def.id, def);
            System.out.println("[CustomItemLoader] Loaded box from file: " + jsonFile.getName() + " (id=" + def.id + ", model=" + def.modelId + ")");
        }
        catch (Exception e) {
            System.err.println("[CustomItemLoader] Error loading box file " + jsonFile.getName() + ": " + e.getMessage());
        }
    }

    private static void loadStandaloneEquipment(JsonObject equipData) {
        CustomItemDef def = new CustomItemDef();
        def.id = equipData.get("id").getAsInt();
        def.name = equipData.get("name").getAsString();
        def.tier = equipData.has("tier") ? equipData.get("tier").getAsInt() : 0;
        def.modelId = equipData.get("modelId").getAsInt();
        def.maleEquip = equipData.get("maleEquipId").getAsInt();
        def.femaleEquip = equipData.has("femaleEquipId") ? equipData.get("femaleEquipId").getAsInt() : def.maleEquip;
        def.modelZoom = equipData.get("zoom").getAsInt();
        def.rotationX = equipData.has("rotationX") ? equipData.get("rotationX").getAsInt() : 0;
        def.rotationY = equipData.has("rotationY") ? equipData.get("rotationY").getAsInt() : 0;
        def.action = equipData.has("action") ? equipData.get("action").getAsString() : "Wear";
        def.stackable = false;
        customItems.put(def.id, def);
    }

    private static void loadItemSet(JsonObject setData) {
        if (!setData.has("base_models")) {
            return;
        }
        JsonObject baseModels = setData.getAsJsonObject("base_models");
        JsonArray items = setData.getAsJsonArray("items");
        for (JsonElement elem : items) {
            JsonObject itemData = elem.getAsJsonObject();
            String slot = itemData.get("slot").getAsString();
            if (!baseModels.has(slot)) continue;
            JsonObject slotModels = baseModels.getAsJsonObject(slot);
            CustomItemDef def = new CustomItemDef();
            def.id = itemData.get("id").getAsInt();
            def.name = itemData.get("name").getAsString();
            def.tier = itemData.has("tier") ? itemData.get("tier").getAsInt() : 0;
            def.modelId = slotModels.get("modelId").getAsInt();
            def.maleEquip = slotModels.get("equipId").getAsInt();
            def.femaleEquip = slotModels.get("equipId").getAsInt();
            def.modelZoom = slotModels.get("zoom").getAsInt();
            def.rotationX = slotModels.get("rotationX").getAsInt();
            def.rotationY = slotModels.get("rotationY").getAsInt();
            def.action = itemData.has("action") ? itemData.get("action").getAsString() : "Wear";
            def.stackable = false;
            customItems.put(def.id, def);
        }
    }

    private static void loadMaterial(JsonObject materialData) {
        CustomItemDef def = new CustomItemDef();
        def.id = materialData.get("id").getAsInt();
        def.name = materialData.get("name").getAsString();
        def.tier = 0;
        def.modelId = materialData.get("modelId").getAsInt();
        def.maleEquip = materialData.get("equipId").getAsInt();
        def.femaleEquip = materialData.get("equipId").getAsInt();
        def.modelZoom = materialData.get("zoom").getAsInt();
        def.rotationX = materialData.get("rotationX").getAsInt();
        def.rotationY = materialData.get("rotationY").getAsInt();
        def.action = null;
        def.stackable = materialData.has("stackable") && materialData.get("stackable").getAsBoolean();
        customItems.put(def.id, def);
    }

    private static void loadBox(JsonObject boxData) {
        int copyFromId;
        CustomItemDef def = new CustomItemDef();
        def.id = boxData.get("id").getAsInt();
        def.name = boxData.get("name").getAsString();
        def.tier = 0;
        def.maleEquip = -1;
        def.femaleEquip = -1;
        def.copyFromId = copyFromId = boxData.has("copyFrom") ? boxData.get("copyFrom").getAsInt() : -1;
        if (boxData.has("modelId")) {
            def.modelId = boxData.get("modelId").getAsInt();
        } else if (copyFromId == -1) {
            System.err.println("[CustomItemLoader] Box " + def.id + " missing modelId");
            return;
        }
        def.modelZoom = boxData.has("zoom") ? boxData.get("zoom").getAsInt() : -1;
        def.rotationX = boxData.has("rotationX") ? boxData.get("rotationX").getAsInt() : -9999;
        def.rotationY = boxData.has("rotationY") ? boxData.get("rotationY").getAsInt() : -9999;
        def.offsetX = boxData.has("offsetX") ? boxData.get("offsetX").getAsInt() : -9999;
        def.offsetY = boxData.has("offsetY") ? boxData.get("offsetY").getAsInt() : -9999;
        boolean bl = def.stackable = boxData.has("stackable") && boxData.get("stackable").getAsBoolean();
        if (boxData.has("editedModelColor") && boxData.has("newModelColor")) {
            int i;
            JsonArray editedColors = boxData.getAsJsonArray("editedModelColor");
            JsonArray newColors = boxData.getAsJsonArray("newModelColor");
            def.editedModelColor = new int[editedColors.size()];
            def.newModelColor = new int[newColors.size()];
            for (i = 0; i < editedColors.size(); ++i) {
                def.editedModelColor[i] = editedColors.get(i).getAsInt();
            }
            for (i = 0; i < newColors.size(); ++i) {
                def.newModelColor[i] = newColors.get(i).getAsInt();
            }
        }
        if (boxData.has("actions")) {
            JsonArray actionsArray = boxData.getAsJsonArray("actions");
            def.actions = new String[5];
            for (int i = 0; i < Math.min(actionsArray.size(), 5); ++i) {
                JsonElement actionElem = actionsArray.get(i);
                def.actions[i] = actionElem.isJsonNull() ? null : actionElem.getAsString();
            }
        }
        customItems.put(def.id, def);
    }

    public static boolean hasCustomItem(int itemId) {
        return customItems.containsKey(itemId);
    }

    public static boolean isStackableOverride(int itemId) {
        return stackableOverrides.contains(itemId);
    }

    public static void applyStackableOverride(ItemDef itemDef) {
        if (stackableOverrides.contains(itemDef.id)) {
            itemDef.stackable = true;
        }
    }

    public static int getItemTier(int itemId) {
        CustomItemDef def = customItems.get(itemId);
        if (def == null) {
            return -1;
        }
        return def.tier;
    }

    public static String getTierOverlayText(int tier) {
        switch (tier) {
            case 1: {
                return "(i)";
            }
            case 2: {
                return "(ii)";
            }
            case 3: {
                return "(iii)";
            }
        }
        return null;
    }

    public static int getTierOverlayColor(int tier) {
        switch (tier) {
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFF00FF;
            }
            case 3: {
                return 0xFF9900;
            }
        }
        return -1;
    }

    public static void applyToItemDef(ItemDef itemDef, int itemId) {
        TierColor tc;
        ItemDef source;
        CustomItemDef custom = customItems.get(itemId);
        if (custom == null) {
            return;
        }
        if (custom.copyFromId > 0 && (source = ItemDef.forID(custom.copyFromId)) != null) {
            if (custom.modelId <= 0) {
                itemDef.modelID = source.modelID;
            }
            if (custom.modelZoom < 0) {
                itemDef.modelZoom = source.modelZoom;
            }
            if (custom.rotationX == -9999) {
                itemDef.rotationX = source.rotationX;
            }
            if (custom.rotationY == -9999) {
                itemDef.rotationY = source.rotationY;
            }
            if (custom.offsetX == -9999) {
                itemDef.modelOffsetX = source.modelOffsetX;
            }
            if (custom.offsetY == -9999) {
                itemDef.modelOffset1 = source.modelOffset1;
                itemDef.modelOffsetY = source.modelOffsetY;
            }
            if (custom.offsetY == -9999) {
                itemDef.modelOffsetY = source.modelOffsetY;
            }
        }
        if (itemDef.modelZoom <= 0) {
            itemDef.modelZoom = 2000;
        }
        itemDef.name = (tc = tierColors.get(custom.tier)) != null && tc.namePrefix != null && !tc.namePrefix.isEmpty() ? tc.namePrefix + custom.name : custom.name;
        if (custom.modelId > 0) {
            itemDef.modelID = custom.modelId;
        }
        if (custom.maleEquip >= 0) {
            itemDef.maleEquip1 = custom.maleEquip;
        }
        if (custom.femaleEquip >= 0) {
            itemDef.femaleEquip1 = custom.femaleEquip;
        }
        if (custom.modelZoom >= 0) {
            itemDef.modelZoom = custom.modelZoom;
        }
        if (custom.rotationX != -9999) {
            itemDef.rotationX = custom.rotationX;
        }
        if (custom.rotationY != -9999) {
            itemDef.rotationY = custom.rotationY;
        }
        if (custom.offsetX != -9999 && custom.offsetX >= 0 && custom.offsetX < 2048) {
            itemDef.modelOffsetX = custom.offsetX;
        }
        if (custom.offsetY != -9999 && custom.offsetY >= 0 && custom.offsetY < 2048) {
            itemDef.modelOffset1 = custom.offsetY;
        }
        if (custom.modelIDs != null && custom.modelIDs.length > 0) {
            itemDef.modelIDs = custom.modelIDs;
        }
        if (custom.editedModelColor != null && custom.newModelColor != null) {
            itemDef.editedModelColor = custom.editedModelColor;
            itemDef.newModelColor = custom.newModelColor;
        } else if (tc != null && tc.colorFind != null && tc.colorReplace != null) {
            itemDef.editedModelColor = new int[]{tc.colorFind};
            itemDef.newModelColor = new int[]{tc.colorReplace};
        }
        if (custom.stackable) {
            itemDef.stackable = true;
        }
        if (custom.actions != null) {
            itemDef.actions = (String[])custom.actions.clone();
        } else {
            itemDef.actions = new String[5];
            if (custom.action != null) {
                itemDef.actions[1] = custom.action;
            }
            itemDef.actions[4] = "Drop";
        }
    }

    public static class CustomItemDef {
        public int id;
        public String name;
        public int modelId;
        public int[] modelIDs;
        public int maleEquip;
        public int femaleEquip;
        public int modelZoom;
        public int rotationX;
        public int rotationY;
        public int offsetX;
        public int offsetY;
        public String action;
        public String[] actions;
        public boolean stackable;
        public int tier;
        public int[] editedModelColor;
        public int[] newModelColor;
        public int copyFromId = -1;
    }

    public static class TierColor {
        public String namePrefix;
        public Integer colorFind;
        public Integer colorReplace;
    }
}

