/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import java.io.IOException;
import java.io.RandomAccessFile;

final class Decompressor {
    private static final byte[] buffer = new byte[520];
    private final RandomAccessFile dataFile;
    private final RandomAccessFile indexFile;
    private final int storeIndex;

    public Decompressor(RandomAccessFile randomaccessfile, RandomAccessFile randomaccessfile1, int j) {
        this.storeIndex = j;
        this.dataFile = randomaccessfile;
        this.indexFile = randomaccessfile1;
    }

    public long getFileCount() {
        try {
            if (this.indexFile != null) {
                return this.indexFile.length() / 6L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized byte[] get(int id) {
        try {
            int in;
            long indexLength = this.indexFile.length();
            long seekPos = (long)id * 6L;
            if (seekPos + 6L > indexLength) {
                return null;
            }
            this.seekTo(this.indexFile, id * 6);
            for (int read = 0; read < 6; read += in) {
                in = this.indexFile.read(buffer, read, 6 - read);
                if (in != -1) continue;
                return null;
            }
            int size = ((buffer[0] & 0xFF) << 16) + ((buffer[1] & 0xFF) << 8) + (buffer[2] & 0xFF);
            int sector = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
            if (sector <= 0) {
                return null;
            }
            byte[] buf = new byte[size];
            int totalRead = 0;
            int part = 0;
            while (totalRead < size) {
                int currentFile;
                int nextSector;
                int currentPart;
                int currentIndex;
                boolean stdMatches;
                int in2;
                if (sector == 0) {
                    return null;
                }
                this.seekTo(this.dataFile, sector * 520);
                int maxHeaderLength = 10;
                int unread = size - totalRead;
                int chunkLength = 512;
                int headerLength = 8;
                int toRead = Math.min(unread + maxHeaderLength, 520);
                for (int read = 0; read < toRead; read += in2) {
                    in2 = this.dataFile.read(buffer, read, toRead - read);
                    if (in2 != -1) continue;
                    return null;
                }
                int stdIndex = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                int stdPart = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                int stdNextSector = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                int stdFile = buffer[7] & 0xFF;
                boolean bl = stdMatches = (stdIndex == id || id > 65535 && stdIndex == (id & 0xFFFF)) && stdPart == part && stdFile == this.storeIndex;
                if (stdMatches) {
                    currentIndex = stdIndex;
                    currentPart = stdPart;
                    nextSector = stdNextSector;
                    currentFile = stdFile;
                    headerLength = 8;
                    chunkLength = 512;
                } else {
                    if (id <= 65535) return null;
                    int extIndex = ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                    int extPart = ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                    int extNextSector = ((buffer[6] & 0xFF) << 16) + ((buffer[7] & 0xFF) << 8) + (buffer[8] & 0xFF);
                    int extFile = buffer[9] & 0xFF;
                    if (extIndex != id || extPart != part || extFile != this.storeIndex) return null;
                    currentIndex = extIndex;
                    currentPart = extPart;
                    nextSector = extNextSector;
                    currentFile = extFile;
                    headerLength = 10;
                    chunkLength = 510;
                }
                if (unread > chunkLength) {
                    unread = chunkLength;
                }
                if (nextSector < 0) {
                    return null;
                }
                for (int i = 0; i < unread; ++i) {
                    buf[totalRead++] = buffer[i + headerLength];
                }
                sector = nextSector;
                ++part;
            }
            return buf;
        }
        catch (IOException _ex) {
            return null;
        }
    }

    public synchronized boolean put(int length, byte[] data, int index) {
        boolean entered = this.enterData(true, index, length, data);
        if (!entered) {
            entered = this.enterData(false, index, length, data);
        }
        return entered;
    }

    private synchronized boolean enterData(boolean exists, int position, int length, byte[] data) {
        try {
            int sector;
            if (exists) {
                int in;
                this.seekTo(this.indexFile, position * 6);
                for (int read = 0; read < 6; read += in) {
                    in = this.indexFile.read(buffer, read, 6 - read);
                    if (in != -1) continue;
                    return false;
                }
                sector = ((buffer[3] & 0xFF) << 16) + ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                if (sector <= 0) {
                    return false;
                }
            } else {
                sector = (int)((this.dataFile.length() + 519L) / 520L);
                if (sector == 0) {
                    sector = 1;
                }
            }
            Decompressor.buffer[0] = (byte)(length >> 16);
            Decompressor.buffer[1] = (byte)(length >> 8);
            Decompressor.buffer[2] = (byte)length;
            Decompressor.buffer[3] = (byte)(sector >> 16);
            Decompressor.buffer[4] = (byte)(sector >> 8);
            Decompressor.buffer[5] = (byte)sector;
            this.seekTo(this.indexFile, position * 6);
            this.indexFile.write(buffer, 0, 6);
            int written = 0;
            int chunkLength = position <= 65535 ? 512 : 510;
            int headerLength = position <= 65535 ? 8 : 10;
            int part = 0;
            while (written < length) {
                int nextSector = 0;
                if (exists) {
                    int read;
                    int in;
                    this.seekTo(this.dataFile, sector * 520);
                    for (read = 0; read < headerLength && (in = this.dataFile.read(buffer, read, headerLength - read)) != -1; read += in) {
                    }
                    if (read == headerLength) {
                        int currentFile;
                        int currentPart;
                        int currentIndex;
                        if (position <= 65535) {
                            currentIndex = ((buffer[0] & 0xFF) << 8) + (buffer[1] & 0xFF);
                            currentPart = ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                            nextSector = ((buffer[4] & 0xFF) << 16) + ((buffer[5] & 0xFF) << 8) + (buffer[6] & 0xFF);
                            currentFile = buffer[7] & 0xFF;
                        } else {
                            currentIndex = ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                            currentPart = ((buffer[4] & 0xFF) << 8) + (buffer[5] & 0xFF);
                            nextSector = ((buffer[6] & 0xFF) << 16) + ((buffer[7] & 0xFF) << 8) + (buffer[8] & 0xFF);
                            currentFile = buffer[9] & 0xFF;
                        }
                        if (currentIndex != position || currentPart != part || currentFile != this.storeIndex) {
                            return false;
                        }
                        if (nextSector < 0) {
                            return false;
                        }
                    }
                }
                if (nextSector == 0) {
                    exists = false;
                    nextSector = (int)((this.dataFile.length() + 519L) / 520L);
                    if (nextSector == 0) {
                        ++nextSector;
                    }
                    if (nextSector == sector) {
                        ++nextSector;
                    }
                }
                if (length - written <= chunkLength) {
                    nextSector = 0;
                }
                if (position <= 65535) {
                    System.out.println("POSITION: " + position);
                    Decompressor.buffer[0] = (byte)(position >> 8);
                    Decompressor.buffer[1] = (byte)position;
                    Decompressor.buffer[2] = (byte)(part >> 8);
                    Decompressor.buffer[3] = (byte)part;
                    Decompressor.buffer[4] = (byte)(nextSector >> 16);
                    Decompressor.buffer[5] = (byte)(nextSector >> 8);
                    Decompressor.buffer[6] = (byte)nextSector;
                    Decompressor.buffer[7] = (byte)this.storeIndex;
                } else {
                    Decompressor.buffer[0] = (byte)(position >> 24);
                    Decompressor.buffer[1] = (byte)(position >> 16);
                    Decompressor.buffer[2] = (byte)(position >> 8);
                    Decompressor.buffer[3] = (byte)position;
                    Decompressor.buffer[4] = (byte)(part >> 8);
                    Decompressor.buffer[5] = (byte)part;
                    Decompressor.buffer[6] = (byte)(nextSector >> 16);
                    Decompressor.buffer[7] = (byte)(nextSector >> 8);
                    Decompressor.buffer[8] = (byte)nextSector;
                    Decompressor.buffer[9] = (byte)this.storeIndex;
                }
                this.seekTo(this.dataFile, sector * 520);
                this.dataFile.write(buffer, 0, headerLength);
                int unwritten = length - written;
                if (unwritten > chunkLength) {
                    unwritten = chunkLength;
                }
                this.dataFile.write(data, written, unwritten);
                written += unwritten;
                sector = nextSector;
                ++part;
            }
            return true;
        }
        catch (IOException _ex) {
            return false;
        }
    }

    private synchronized void seekTo(RandomAccessFile randomaccessfile, int j) throws IOException {
        try {
            randomaccessfile.seek(j);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

