/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.QueueNode;

public class DrawingArea
extends QueueNode {
    public static int[] pixels;
    public static int width;
    public static int height;
    public static int topY;
    public static int bottomY;
    public static int topX;
    public static int bottomX;
    public static int viewportRX;
    public static int viewport_centerX;
    public static int viewport_centerY;

    public static void initDrawingArea(int i, int j, int[] ai) {
        pixels = ai;
        width = j;
        height = i;
        DrawingArea.setDrawingArea(i, 0, j, 0);
    }

    public static void drawBoxOutline(int leftX, int topY, int width, int height, int rgbColour) {
        DrawingArea.drawHorizontalLine(leftX, topY, width, rgbColour);
        DrawingArea.drawHorizontalLine(leftX, topY + height - 1, width, rgbColour);
        DrawingArea.drawVLine(leftX, topY, height, rgbColour);
        DrawingArea.drawVLine(leftX + width - 1, topY, height, rgbColour);
    }

    public static void drawTransparentBox(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        if (leftX < topX) {
            width -= topX - leftX;
            leftX = topX;
        }
        if (topY < DrawingArea.topY) {
            height -= DrawingArea.topY - topY;
            topY = DrawingArea.topY;
        }
        if (leftX + width > bottomX) {
            width = bottomX - leftX;
        }
        if (topY + height > bottomY) {
            height = bottomY - topY;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int leftOver = DrawingArea.width - width;
        int pixelIndex = leftX + topY * DrawingArea.width;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
                int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
                int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
                int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
                int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
                DrawingArea.pixels[pixelIndex++] = transparentColour;
            }
            pixelIndex += leftOver;
        }
    }

    public static void method339(int i, int j, int k, int l) {
        if (i < topY || i >= bottomY) {
            return;
        }
        if (l < topX) {
            k -= topX - l;
            l = topX;
        }
        if (l + k > bottomX) {
            k = bottomX - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            DrawingArea.pixels[i1 + j1] = j;
        }
    }

    public static void drawPixelsWithOpacity(int color, int yPos, int pixelWidth, int pixelHeight, int opacityLevel, int xPos) {
        if (xPos < topX) {
            pixelWidth -= topX - xPos;
            xPos = topX;
        }
        if (yPos < topY) {
            pixelHeight -= topY - yPos;
            yPos = topY;
        }
        if (xPos + pixelWidth > bottomX) {
            pixelWidth = bottomX - xPos;
        }
        if (yPos + pixelHeight > bottomY) {
            pixelHeight = bottomY - yPos;
        }
        int l1 = 256 - opacityLevel;
        int i2 = (color >> 16 & 0xFF) * opacityLevel;
        int j2 = (color >> 8 & 0xFF) * opacityLevel;
        int k2 = (color & 0xFF) * opacityLevel;
        int k3 = width - pixelWidth;
        int l3 = xPos + yPos * width;
        if (l3 > pixels.length - 1) {
            l3 = pixels.length - 1;
        }
        for (int i4 = 0; i4 < pixelHeight; ++i4) {
            for (int j4 = -pixelWidth; j4 < 0; ++j4) {
                int l2 = (pixels[l3] >> 16 & 0xFF) * l1;
                int i3 = (pixels[l3] >> 8 & 0xFF) * l1;
                int j3 = (pixels[l3] & 0xFF) * l1;
                int k4 = (i2 + l2 >> 8 << 16) + (j2 + i3 >> 8 << 8) + (k2 + j3 >> 8);
                DrawingArea.pixels[l3++] = k4;
            }
            l3 += k3;
        }
    }

    public static void defaultDrawingAreaSize() {
        topX = 0;
        topY = 0;
        bottomX = width;
        bottomY = height;
        viewportRX = bottomX - 0;
        viewport_centerX = bottomX / 1;
    }

    public static void setDrawingArea(int yBottom, int xTop, int xBottom, int yTop) {
        if (xTop < 0) {
            xTop = 0;
        }
        if (yTop < 0) {
            yTop = 0;
        }
        if (xBottom > width) {
            xBottom = width;
        }
        if (yBottom > height) {
            yBottom = height;
        }
        topX = xTop;
        topY = yTop;
        bottomX = xBottom;
        bottomY = yBottom;
        viewportRX = bottomX - 0;
        viewport_centerX = bottomX / 2;
        viewport_centerY = bottomY / 2;
    }

    public static int clamp(int x, int a, int b) {
        return x < a ? a : (x > b ? b : x);
    }

    public static void blur(int[] in, int[] out, int width, int height, int radius) {
        int widthMinus1 = width - 1;
        int tableSize = 2 * radius + 1;
        int[] divide = new int[256 * tableSize];
        for (int i = 0; i < 256 * tableSize; ++i) {
            divide[i] = i / tableSize;
        }
        int inIndex = 0;
        for (int y = 0; y < height; ++y) {
            int outIndex = y;
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            for (int i = -radius; i <= radius; ++i) {
                int rgb = in[inIndex + DrawingArea.clamp(i, 0, width - 1)];
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int i2;
                out[outIndex] = divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb];
                int i1 = x + radius + 1;
                if (i1 > widthMinus1) {
                    i1 = widthMinus1;
                }
                if ((i2 = x - radius) < 0) {
                    i2 = 0;
                }
                int rgb1 = in[inIndex + i1];
                int rgb2 = in[inIndex + i2];
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
                outIndex += height;
            }
            inIndex += width;
        }
    }

    public static void drawDiagonalLine(int x, int y, int areaWidth, int areaHeight, int color) {
        areaWidth -= x;
        if ((areaHeight -= y) == 0) {
            if (areaWidth >= 0) {
                DrawingArea.drawHorizontalLine(x, y, areaWidth + 1, color);
                return;
            }
            DrawingArea.drawHorizontalLine(x + areaWidth, y, -areaWidth + 1, color);
            return;
        }
        if (areaWidth == 0) {
            if (areaHeight >= 0) {
                DrawingArea.drawVLine(x, y, areaHeight + 1, color);
                return;
            }
            DrawingArea.drawHLine(x, y + areaHeight, -areaHeight + 1, color);
            return;
        }
        if (areaWidth + areaHeight < 0) {
            x += areaWidth;
            areaWidth = -areaWidth;
            y += areaHeight;
            areaHeight = -areaHeight;
        }
        if (areaWidth > areaHeight) {
            y <<= 16;
            y += 32768;
            int j1 = (int)Math.floor((double)(areaHeight <<= 16) / (double)areaWidth + 0.5);
            areaWidth += x;
            if (x < topX) {
                y += j1 * (topX - x);
                x = topX;
            }
            if (areaWidth >= bottomX) {
                areaWidth = bottomX - 1;
            }
            while (x <= areaWidth) {
                int l1 = y >> 16;
                if (l1 >= topY && l1 < bottomY) {
                    DrawingArea.pixels[x + l1 * DrawingArea.width] = color;
                }
                y += j1;
                ++x;
            }
            return;
        }
        x <<= 16;
        x += 32768;
        int k1 = (int)Math.floor((double)(areaWidth <<= 16) / (double)areaHeight + 0.5);
        areaHeight += y;
        if (y < topY) {
            x += k1 * (topY - y);
            y = topY;
        }
        if (areaHeight >= bottomY) {
            areaHeight = bottomY - 1;
        }
        while (y <= areaHeight) {
            int i2 = x >> 16;
            if (i2 >= topX && i2 < bottomX) {
                DrawingArea.pixels[i2 + y * DrawingArea.width] = color;
            }
            x += k1;
            ++y;
        }
    }

    public static void drawGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < topX) {
            gradientWidth -= topX - x;
            x = topX;
        }
        if (y < topY) {
            k1 += (topY - y) * l1;
            gradientHeight -= topY - y;
            y = topY;
        }
        if (x + gradientWidth > bottomX) {
            gradientWidth = bottomX - x;
        }
        if (y + gradientHeight > bottomY) {
            gradientHeight = bottomY - y;
        }
        int i2 = width - gradientWidth;
        int j2 = x + y * width;
        for (int k2 = -gradientHeight; k2 < 0; ++k2) {
            int l2 = 65536 - k1 >> 8;
            int i3 = k1 >> 8;
            int j3 = ((startColor & 0xFF00FF) * l2 + (endColor & 0xFF00FF) * i3 & 0xFF00FF00) + ((startColor & 0xFF00) * l2 + (endColor & 0xFF00) * i3 & 0xFF0000) >>> 8;
            for (int k3 = -gradientWidth; k3 < 0; ++k3) {
                DrawingArea.pixels[j2++] = j3;
            }
            j2 += i2;
            k1 += l1;
        }
    }

    public static void drawAlphaGradient2(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < topX) {
            gradientWidth -= topX - x;
            x = topX;
        }
        if (y < topY) {
            k1 -= (topY - y) * l1;
            gradientHeight -= topY - y;
            y = topY;
        }
        if (x + gradientWidth > bottomX) {
            gradientWidth = bottomX - x;
        }
        if (y + gradientHeight > bottomY) {
            gradientHeight = bottomY - y;
        }
        int i2 = width - gradientWidth;
        int total_pixels = x + y * width;
        for (int k2 = -gradientHeight; k2 < 0; ++k2) {
            int alpha2 = (gradientHeight + k2) * (gradientHeight / alpha);
            int result_alpha = 256 - alpha2;
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            for (int k3 = -gradientWidth; k3 < 0; ++k3) {
                int colored_pixel = pixels[total_pixels];
                colored_pixel = ((colored_pixel & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((colored_pixel & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea.pixels[total_pixels++] = color + colored_pixel;
            }
            total_pixels += i2;
            k1 -= l1;
        }
    }

    public void drawAlphaGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < topX) {
            gradientWidth -= topX - x;
            x = topX;
        }
        if (y < topY) {
            k1 += (topY - y) * l1;
            gradientHeight -= topY - y;
            y = topY;
        }
        if (x + gradientWidth > bottomX) {
            gradientWidth = bottomX - x;
        }
        if (y + gradientHeight > bottomY) {
            gradientHeight = bottomY - y;
        }
        int i2 = width - gradientWidth;
        int result_alpha = 256 - alpha;
        int total_pixels = x + y * width;
        for (int k2 = -gradientHeight; k2 < 0; ++k2) {
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            for (int k3 = -gradientWidth; k3 < 0; ++k3) {
                int colored_pixel = pixels[total_pixels];
                colored_pixel = ((colored_pixel & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((colored_pixel & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea.pixels[total_pixels++] = color + colored_pixel;
            }
            total_pixels += i2;
            k1 += l1;
        }
    }

    public static void drawAlphaHorizontalLine2(int x, int y, int lineWidth, int color, int alpha) {
        if (y < topY || y >= bottomY) {
            return;
        }
        if (x < topX) {
            lineWidth -= topX - x;
            x = topX;
        }
        if (x + lineWidth > bottomX) {
            lineWidth = bottomX - x;
        }
        int i3 = x + y * width;
        for (int j3 = 0; j3 < lineWidth; ++j3) {
            int alpha2 = (lineWidth - j3) / (lineWidth / alpha);
            int j1 = 256 - alpha2;
            int k1 = (color >> 16 & 0xFF) * alpha2;
            int l1 = (color >> 8 & 0xFF) * alpha2;
            int i2 = (color & 0xFF) * alpha2;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea.pixels[i3++] = k3;
        }
    }

    public static void resetImage() {
        int i = width * height;
        for (int j = 0; j < i; ++j) {
            DrawingArea.pixels[j] = 0;
        }
    }

    public static void drawVLine(int x, int y, int height, int colour) {
        if (x < topX || x >= bottomY) {
            return;
        }
        if (y < topY) {
            height -= topY - y;
            y = topY;
        }
        if (y + height > bottomX) {
            height = bottomX - y;
        }
        int ptr = x + y * width;
        for (int y_off = 0; y_off < height; ++y_off) {
            DrawingArea.pixels[ptr + y_off * DrawingArea.width] = colour;
        }
    }

    public static void blur(int x, int y, int width, int height, int speed) {
        try {
            DrawingArea.blur(pixels, pixels, width, height, speed);
            DrawingArea.blur(pixels, pixels, height, width, speed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawHLine(int x, int y, int width, int colour) {
        if (y < topY || y >= bottomY) {
            return;
        }
        if (x < topX) {
            width -= topX - x;
            x = topX;
        }
        if (x + width > bottomX) {
            width = bottomX - x;
        }
        int i1 = x + y * DrawingArea.width;
        for (int x_off = 0; x_off < width; ++x_off) {
            DrawingArea.pixels[i1 + x_off] = colour;
        }
    }

    public static void fillRectangle(int color, int y, int widthz, int heightz, int opacity, int x) {
        if (x < topX) {
            widthz -= topX - x;
            x = topX;
        }
        if (y < topY) {
            heightz -= topY - y;
            y = topY;
        }
        if (x + widthz > bottomX) {
            widthz = bottomX - x;
        }
        if (y + heightz > bottomY) {
            heightz = bottomY - y;
        }
        int decodedOpacity = 256 - opacity;
        int red = (color >> 16 & 0xFF) * opacity;
        int green = (color >> 8 & 0xFF) * opacity;
        int blue = (color & 0xFF) * opacity;
        int pixelWidthStep = width - widthz;
        int startPixel = x + y * width;
        for (int h = 0; h < heightz; ++h) {
            for (int w = -widthz; w < 0; ++w) {
                int pixelRed = (pixels[startPixel] >> 16 & 0xFF) * decodedOpacity;
                int pixelBlue = (pixels[startPixel] >> 8 & 0xFF) * decodedOpacity;
                int pixelGreen = (pixels[startPixel] & 0xFF) * decodedOpacity;
                int pixelRGB = (red + pixelRed >> 8 << 16) + (green + pixelBlue >> 8 << 8) + (blue + pixelGreen >> 8);
                DrawingArea.pixels[startPixel++] = pixelRGB;
            }
            startPixel += pixelWidthStep;
        }
    }

    public static void drawPixels(int height_, int yPos, int xPos, int color, int width_, int alpha) {
        if (xPos < topX) {
            width_ -= topX - xPos;
            xPos = topX;
        }
        if (yPos < topY) {
            height_ -= topY - yPos;
            yPos = topY;
        }
        if (xPos + width_ > bottomX) {
            width_ = bottomX - xPos;
        }
        if (yPos + height_ > bottomY) {
            height_ = bottomY - yPos;
        }
        int decodedOpacity = 256 - alpha;
        int widthPixelStep = width - width_;
        int startPixel = xPos + yPos * width;
        int red = (color >> 16 & 0xFF) * alpha;
        int green = (color >> 8 & 0xFF) * alpha;
        int blue = (color & 0xFF) * alpha;
        for (int i2 = -height_; i2 < 0; ++i2) {
            for (int j2 = -width_; j2 < 0; ++j2) {
                int pixelRed = (pixels[startPixel] >> 16 & 0xFF) * decodedOpacity;
                int pixelBlue = (pixels[startPixel] >> 8 & 0xFF) * decodedOpacity;
                int pixelGreen = (pixels[startPixel] & 0xFF) * decodedOpacity;
                int pixelRGB = (red + pixelRed >> 8 << 16) + (green + pixelBlue >> 8 << 8) + (blue + pixelGreen >> 8);
                DrawingArea.pixels[startPixel++] = pixelRGB;
            }
            startPixel += widthPixelStep;
        }
    }

    public static void drawPixels(int height_, int yPos, int xPos, int color, int width_) {
        if (xPos < topX) {
            width_ -= topX - xPos;
            xPos = topX;
        }
        if (yPos < topY) {
            height_ -= topY - yPos;
            yPos = topY;
        }
        if (xPos + width_ > bottomX) {
            width_ = bottomX - xPos;
        }
        if (yPos + height_ > bottomY) {
            height_ = bottomY - yPos;
        }
        int k1 = width - width_;
        int l1 = xPos + yPos * width;
        for (int i2 = -height_; i2 < 0; ++i2) {
            for (int j2 = -width_; j2 < 0; ++j2) {
                int s;
                if ((s = l1++) >= pixels.length) continue;
                DrawingArea.pixels[s] = color;
            }
            l1 += k1;
        }
    }

    public static void fillPixels(int i, int j, int k, int l, int i1) {
        DrawingArea.drawLine(i1, l, j, i);
        DrawingArea.drawLine(i1 + k - 1, l, j, i);
        DrawingArea.drawLineVertical(i1, l, k, i);
        DrawingArea.drawLineVertical(i1, l, k, i + j - 1);
    }

    public static void drawRectangle(int y, int height, int opacity, int color, int width, int x) {
        DrawingArea.drawHLine(color, width, y, opacity, x);
        DrawingArea.drawHLine(color, width, y + height - 1, opacity, x);
        if (height >= 3) {
            DrawingArea.drawVLine(color, x, opacity, y + 1, height - 2);
            DrawingArea.drawVLine(color, x + width - 1, opacity, y + 1, height - 2);
        }
    }

    public static void drawLine(int yPos, int color, int widthToDraw, int xPos) {
        if (yPos < topY || yPos >= bottomY) {
            return;
        }
        if (xPos < topX) {
            widthToDraw -= topX - xPos;
            xPos = topX;
        }
        if (xPos + widthToDraw > bottomX) {
            widthToDraw = bottomX - xPos;
        }
        int base = xPos + yPos * width;
        for (int ptr = 0; ptr < widthToDraw; ++ptr) {
            DrawingArea.pixels[base + ptr] = color;
        }
    }

    public static void drawHorizontalLine(int i, int j, int k, int l) {
        if (i < topY || i >= bottomY) {
            return;
        }
        if (l < topX) {
            k -= topX - l;
            l = topX;
        }
        if (l + k > bottomX) {
            k = bottomX - l;
        }
        int i1 = l + i * width;
        for (int j1 = 0; j1 < k; ++j1) {
            DrawingArea.pixels[i1 + j1] = j;
        }
    }

    public static void drawVerticalLine(int x, int y, int length, int colour) {
        if (x < topX || x >= bottomX) {
            return;
        }
        if (y < topY) {
            length -= topY - y;
            y = topY;
        }
        if (y + length > bottomY) {
            length = bottomY - y;
        }
        int j1 = x + y * width;
        for (int k1 = 0; k1 < length; ++k1) {
            DrawingArea.pixels[j1 + k1 * DrawingArea.width] = colour;
        }
    }

    public static void drawRectangle(int x, int y, int width, int height, int colour) {
        DrawingArea.drawHorizontalLine(x, y, width, colour, false);
        DrawingArea.drawHorizontalLine(x, y + height - 1, width, colour, false);
        DrawingArea.drawVerticalLine(x, y, height, colour);
        DrawingArea.drawVerticalLine(x + width - 1, y, height, colour);
    }

    public static void drawHorizontalLine(int x, int y, int length, int colour, boolean shaded) {
        if (shaded) {
            DrawingArea.drawHorizontalLine(x + 1, y + 1, length, 0, false);
        }
        if (y < topY || y >= bottomY) {
            return;
        }
        if (x < topX) {
            length -= topX - x;
            x = topX;
        }
        if (x + length > bottomX) {
            length = bottomX - x;
        }
        int i1 = x + y * width;
        for (int j1 = 0; j1 < length; ++j1) {
            DrawingArea.pixels[i1 + j1] = colour;
        }
    }

    protected static void drawHLine(int i, int j, int k, int l, int i1) {
        if (k < topY || k >= bottomY) {
            return;
        }
        if (i1 < topX) {
            j -= topX - i1;
            i1 = topX;
        }
        if (i1 + j > bottomX) {
            j = bottomX - i1;
        }
        int j1 = 256 - l;
        int k1 = (i >> 16 & 0xFF) * l;
        int l1 = (i >> 8 & 0xFF) * l;
        int i2 = (i & 0xFF) * l;
        int i3 = i1 + k * width;
        for (int j3 = 0; j3 < j; ++j3) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea.pixels[i3++] = k3;
        }
    }

    public static void drawLineVertical(int heights, int color, int yPos, int xPos) {
        if (xPos < topX || xPos >= bottomX) {
            return;
        }
        if (heights < topY) {
            yPos -= topY - heights;
            heights = topY;
        }
        if (heights + yPos > bottomY) {
            yPos = bottomY - heights;
        }
        int j1 = xPos + heights * width;
        for (int k1 = 0; k1 < yPos; ++k1) {
            if (j1 + k1 * width >= pixels.length) continue;
            DrawingArea.pixels[j1 + k1 * DrawingArea.width] = color;
        }
    }

    protected static void drawVLine(int i, int j, int k, int l, int i1) {
        if (j < topX || j >= bottomX) {
            return;
        }
        if (l < topY) {
            i1 -= topY - l;
            l = topY;
        }
        if (l + i1 > bottomY) {
            i1 = bottomY - l;
        }
        int j1 = 256 - k;
        int k1 = (i >> 16 & 0xFF) * k;
        int l1 = (i >> 8 & 0xFF) * k;
        int i2 = (i & 0xFF) * k;
        int i3 = j + l * width;
        for (int j3 = 0; j3 < i1; ++j3) {
            int k3;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            DrawingArea.pixels[i3] = k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            i3 += width;
        }
    }

    public static void fillCircle(int posX, int posY, int radius, int colour, int alpha) {
        int max;
        int dest_intensity = 256 - alpha;
        int src_red = (colour >> 16 & 0xFF) * alpha;
        int src_green = (colour >> 8 & 0xFF) * alpha;
        int src_blue = (colour & 0xFF) * alpha;
        int radiusPixels = posY - radius;
        if (radiusPixels < 0) {
            radiusPixels = 0;
        }
        if ((max = posY + radius) >= height) {
            max = height - 1;
        }
        for (int y = radiusPixels; y <= max; ++y) {
            int maxPixelX;
            int beginYPos = y - posY;
            int heighestXPos = (int)Math.sqrt(radius * radius - beginYPos * beginYPos);
            int x = posX - heighestXPos;
            if (x < 0) {
                x = 0;
            }
            if ((maxPixelX = posX + heighestXPos) >= width) {
                maxPixelX = width - 1;
            }
            int pixel_offset = x + y * width;
            for (int pixelX = x; pixelX <= maxPixelX; ++pixelX) {
                int dest_red = (pixels[pixel_offset] >> 16 & 0xFF) * dest_intensity;
                int dest_green = (pixels[pixel_offset] >> 8 & 0xFF) * dest_intensity;
                int dest_blue = (pixels[pixel_offset] & 0xFF) * dest_intensity;
                int result_rgb = (src_red + dest_red >> 8 << 16) + (src_green + dest_green >> 8 << 8) + (src_blue + dest_blue >> 8);
                DrawingArea.pixels[pixel_offset++] = result_rgb;
            }
        }
    }

    public static void drawAlphaFilledPixels(int xPos, int yPos, int pixelWidth, int pixelHeight, int color, int alpha) {
        if (xPos < topX) {
            pixelWidth -= topX - xPos;
            xPos = topX;
        }
        if (yPos < topY) {
            pixelHeight -= topY - yPos;
            yPos = topY;
        }
        if (xPos + pixelWidth > bottomX) {
            pixelWidth = bottomX - xPos;
        }
        if (yPos + pixelHeight > bottomY) {
            pixelHeight = bottomY - yPos;
        }
        color = ((color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((color & 0xFF00) * alpha >> 8 & 0xFF00);
        int k1 = 256 - alpha;
        int l1 = width - pixelWidth;
        int i2 = xPos + yPos * width;
        for (int j2 = 0; j2 < pixelHeight; ++j2) {
            for (int k2 = -pixelWidth; k2 < 0; ++k2) {
                int l2 = pixels[i2];
                l2 = ((l2 & 0xFF00FF) * k1 >> 8 & 0xFF00FF) + ((l2 & 0xFF00) * k1 >> 8 & 0xFF00);
                DrawingArea.pixels[i2++] = color + l2;
            }
            i2 += l1;
        }
    }
}

