/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Stream;

final class Envelope {
    private int segmentCount;
    private int[] segmentDuration;
    private int[] segmentPeak;
    int anInt538;
    int anInt539;
    int form;
    private int checkpoint;
    private int segmentPtr;
    private int step;
    private int amplitude;
    private int tick;

    public void decode(Stream stream) {
        this.form = stream.readUnsignedByte();
        this.anInt538 = stream.readDWord();
        this.anInt539 = stream.readDWord();
        this.decodeSegments(stream);
    }

    public void decodeSegments(Stream stream) {
        this.segmentCount = stream.readUnsignedByte();
        this.segmentDuration = new int[this.segmentCount];
        this.segmentPeak = new int[this.segmentCount];
        for (int i = 0; i < this.segmentCount; ++i) {
            this.segmentDuration[i] = stream.readUnsignedWord();
            this.segmentPeak[i] = stream.readUnsignedWord();
        }
    }

    void resetValues() {
        this.checkpoint = 0;
        this.segmentPtr = 0;
        this.step = 0;
        this.amplitude = 0;
        this.tick = 0;
    }

    int evaluate(int i) {
        if (this.tick >= this.checkpoint) {
            this.amplitude = this.segmentPeak[this.segmentPtr++] << 15;
            if (this.segmentPtr >= this.segmentCount) {
                this.segmentPtr = this.segmentCount - 1;
            }
            this.checkpoint = (int)((double)this.segmentDuration[this.segmentPtr] / 65536.0 * (double)i);
            if (this.checkpoint > this.tick) {
                this.step = ((this.segmentPeak[this.segmentPtr] << 15) - this.amplitude) / (this.checkpoint - this.tick);
            }
        }
        this.amplitude += this.step;
        ++this.tick;
        return this.amplitude - this.step >> 15;
    }
}

