/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.RSInterface;
import com.teragard.Sprite;
import com.teragard.SpriteLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceExporter {
    public static void exportAll(String outputPath) throws IOException {
        InterfaceExporter.exportAll(new File(outputPath));
    }

    public static void exportAll(File outputFile) throws IOException {
        if (RSInterface.interfaceCache == null) {
            System.out.println("[InterfaceExporter] No interfaces loaded");
            return;
        }
        System.out.println("[InterfaceExporter] Exporting interfaces to: " + outputFile.getAbsolutePath());
        ArrayList<Map<String, Object>> interfaces = new ArrayList<Map<String, Object>>();
        int exported = 0;
        for (int i = 0; i < RSInterface.interfaceCache.length; ++i) {
            RSInterface rsi = RSInterface.interfaceCache[i];
            if (rsi == null) continue;
            Map<String, Object> data = InterfaceExporter.exportInterface(rsi);
            interfaces.add(data);
            ++exported;
        }
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write("[\n");
            boolean first = true;
            for (Map map : interfaces) {
                if (!first) {
                    writer.write(",\n");
                }
                first = false;
                InterfaceExporter.writeJsonObject(writer, map, 1);
            }
            writer.write("\n]");
        }
        System.out.println("[InterfaceExporter] Exported " + exported + " interfaces");
    }

    private static Map<String, Object> exportInterface(RSInterface rsi) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", rsi.id);
        data.put("parentID", rsi.parentID);
        data.put("type", rsi.type);
        data.put("atActionType", rsi.atActionType);
        data.put("contentType", rsi.contentType);
        data.put("width", rsi.width);
        data.put("height", rsi.height);
        data.put("opacity", rsi.opacity & 0xFF);
        data.put("hoverType", rsi.hoverType);
        data.put("scrollMax", rsi.scrollMax);
        data.put("scrollPosition", rsi.scrollPosition);
        data.put("interfaceShown", rsi.interfaceShown);
        data.put("hidden", !rsi.interfaceShown);
        data.put("disabledSpriteId", InterfaceExporter.resolveSpriteId(rsi.disabledSpriteId, rsi.disabledSprite));
        data.put("enabledSpriteId", InterfaceExporter.resolveSpriteId(rsi.enabledSpriteId, rsi.enabledSprite));
        data.put("disabledSpriteName", InterfaceExporter.resolveSpriteNameRef(rsi.disabledSpriteName, rsi.disabledSprite));
        data.put("enabledSpriteName", InterfaceExporter.resolveSpriteNameRef(rsi.enabledSpriteName, rsi.enabledSprite));
        data.put("message", rsi.message != null ? rsi.message : "");
        data.put("enabledMessage", rsi.enabledMessage != null ? rsi.enabledMessage : "");
        data.put("centerText", rsi.centerText);
        data.put("shadowed", rsi.shadowed);
        data.put("disabledColor", rsi.disabledColor);
        data.put("enabledColor", rsi.enabledColor);
        data.put("disabledMouseOverColor", rsi.disabledMouseOverColor);
        data.put("enabledMouseOverColor", rsi.enabledMouseOverColor);
        data.put("filled", rsi.filled);
        data.put("mediaType", rsi.mediaType);
        data.put("mediaID", rsi.mediaID);
        data.put("modelZoom", rsi.modelZoom);
        data.put("modelRotationX", rsi.modelRotation1);
        data.put("modelRotationY", rsi.modelRotation2);
        data.put("disabledAnimationId", rsi.disabledAnimationId);
        data.put("enabledAnimationId", rsi.enabledAnimationId);
        if (rsi.children != null && rsi.children.length > 0) {
            data.put("children", InterfaceExporter.toList(rsi.children));
            data.put("childX", InterfaceExporter.toList(rsi.childX));
            data.put("childY", InterfaceExporter.toList(rsi.childY));
        }
        data.put("isInventoryInterface", rsi.isInventoryInterface);
        data.put("usableItemInterface", rsi.usableItemInterface);
        data.put("invSpritePadX", rsi.invSpritePadX);
        data.put("invSpritePadY", rsi.invSpritePadY);
        data.put("dragDeletes", rsi.dragDeletes);
        data.put("deleteOnDrag", rsi.deleteOnDrag2);
        if (rsi.spritesX != null && rsi.spritesX.length > 0) {
            data.put("spritesX", InterfaceExporter.toList(rsi.spritesX));
            data.put("spritesY", InterfaceExporter.toList(rsi.spritesY));
        }
        if (rsi.actions != null) {
            data.put("actions", InterfaceExporter.toStringList(rsi.actions));
        }
        data.put("tooltip", rsi.tooltip != null ? rsi.tooltip : "");
        data.put("spellName", rsi.spellName != null ? rsi.spellName : "");
        data.put("selectedActionName", rsi.selectedActionName != null ? rsi.selectedActionName : "");
        data.put("spellUsableOn", rsi.spellUsableOn);
        if (rsi.valueCompareType != null && rsi.valueCompareType.length > 0) {
            data.put("valueCompareType", InterfaceExporter.toList(rsi.valueCompareType));
            data.put("requiredValues", InterfaceExporter.toList(rsi.requiredValues));
        }
        if (rsi.valueIndexArray != null && rsi.valueIndexArray.length > 0) {
            ArrayList<List<Integer>> valueArrays = new ArrayList<List<Integer>>();
            for (int[] arr : rsi.valueIndexArray) {
                valueArrays.add(InterfaceExporter.toList(arr));
            }
            data.put("valueIndexArray", valueArrays);
        }
        return data;
    }

    private static String resolveSpriteNameRef(String explicitName, Sprite sprite) {
        if (explicitName != null && !explicitName.isEmpty()) {
            return explicitName;
        }
        if (sprite != null && sprite.sourceRef != null && !sprite.sourceRef.isEmpty()) {
            return sprite.sourceRef;
        }
        return "";
    }

    private static int resolveSpriteId(int storedId, Sprite sprite) {
        if (storedId > 0) {
            return storedId;
        }
        if (sprite == null) {
            return -1;
        }
        if (SpriteLoader.sprites != null) {
            for (int i = 0; i < SpriteLoader.sprites.length; ++i) {
                if (SpriteLoader.sprites[i] != sprite) continue;
                return i;
            }
        }
        return -1;
    }

    private static List<Integer> toList(int[] arr) {
        if (arr == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int v : arr) {
            list.add(v);
        }
        return list;
    }

    private static List<String> toStringList(String[] arr) {
        if (arr == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr) {
            list.add(s);
        }
        return list;
    }

    private static void writeJsonObject(FileWriter writer, Map<String, Object> obj, int indent) throws IOException {
        String indentStr = "  ".repeat(indent);
        String indentStrInner = "  ".repeat(indent + 1);
        writer.write("{\n");
        boolean first = true;
        for (Map.Entry<String, Object> entry : obj.entrySet()) {
            if (!first) {
                writer.write(",\n");
            }
            first = false;
            writer.write(indentStrInner + "\"" + entry.getKey() + "\": ");
            InterfaceExporter.writeJsonValue(writer, entry.getValue(), indent + 1);
        }
        writer.write("\n" + indentStr + "}");
    }

    private static void writeJsonValue(FileWriter writer, Object value, int indent) throws IOException {
        if (value == null) {
            writer.write("null");
        } else if (value instanceof String) {
            writer.write("\"" + InterfaceExporter.escapeJson((String)value) + "\"");
        } else if (value instanceof Number) {
            writer.write(value.toString());
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof List) {
            InterfaceExporter.writeJsonArray(writer, (List)value, indent);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            InterfaceExporter.writeJsonObject(writer, map, indent);
        } else {
            writer.write("\"" + InterfaceExporter.escapeJson(value.toString()) + "\"");
        }
    }

    private static void writeJsonArray(FileWriter writer, List<?> arr, int indent) throws IOException {
        if (arr.isEmpty()) {
            writer.write("[]");
            return;
        }
        if (!arr.isEmpty() && arr.get(0) instanceof List) {
            writer.write("[\n");
            String indentStr = "  ".repeat(indent + 1);
            boolean first = true;
            for (Object item : arr) {
                if (!first) {
                    writer.write(",\n");
                }
                first = false;
                writer.write(indentStr);
                InterfaceExporter.writeJsonValue(writer, item, indent + 1);
            }
            writer.write("\n" + "  ".repeat(indent) + "]");
        } else {
            writer.write("[");
            boolean first = true;
            for (Object item : arr) {
                if (!first) {
                    writer.write(", ");
                }
                first = false;
                InterfaceExporter.writeJsonValue(writer, item, indent);
            }
            writer.write("]");
        }
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

