/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.CustomItemLoader;
import com.teragard.DrawingArea;
import com.teragard.ItemDef_Jarrod_1;
import com.teragard.MemCache;
import com.teragard.Model;
import com.teragard.Rasterizer;
import com.teragard.Sprite;
import com.teragard.Stream;
import com.teragard.signlink;
import java.awt.Color;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public final class ItemDef {
    private static int[] prices;
    public static Color clorDefcode;
    public int[] clorDefcodeTo = new int[]{0};
    public int colourRedefine = 0;
    public int colourRedefine2 = 0;
    public int colourRedefine3 = 0;
    private static List<Integer> untradeableItems;
    int[] originalModelColor;
    public static final int[] UNTRADEABLE_ITEMS;
    public byte femaleYOffset;
    public int value;
    public int[] editedModelColor;
    public int id = -1;
    public static MemCache spriteCache;
    public static MemCache modelCache;
    public int[] newModelColor;
    public boolean membersObject;
    public int femaleEquip3;
    public int certTemplateID;
    public int femaleEquip2;
    public int maleEquip1;
    public int maleDialogueModel;
    public int sizeX;
    public String[] groundActions;
    public int modelOffset1;
    public String name;
    public static ItemDef[] cache;
    public int femaleDialogueModel;
    public int modelID;
    public int[] modelIDs;
    public int maleDialogue;
    public boolean stackable;
    public String description;
    public int certID;
    public static int cacheIndex;
    public int modelZoom;
    public static Stream stream;
    public int lightness;
    public int maleEquip3;
    public int maleEquip2;
    public String[] actions;
    public int rotationY;
    public int sizeZ;
    public int sizeY;
    public int[] stackIDs;
    public int modelOffsetY;
    public static int[] streamIndices;
    public int shadow;
    public int femaleDialogue;
    public int rotationX;
    public int femaleEquip1;
    public int[] stackAmounts;
    public int team;
    public static int totalItems;
    public static int additionalItems;
    public int modelOffsetX;
    public byte maleYOffset;
    public byte maleXOffset;
    public int lendID;
    public int lentItemID;
    public boolean untradeable;

    public static void defaultConfig(ItemDef itemDef, int groundModel, int maleModel, String name) {
        ItemDef.defaultConfig(itemDef, groundModel, maleModel, maleModel, name);
    }

    public static void defaultConfig(ItemDef itemDef, int groundModel, int maleModel, int femaleModel, String name) {
        itemDef.modelID = groundModel;
        itemDef.maleEquip1 = maleModel;
        itemDef.femaleEquip2 = femaleModel;
        itemDef.name = name;
        itemDef.description = "It's an " + itemDef.name;
        itemDef.modelZoom = 1500;
        itemDef.modelOffset1 = 0;
        itemDef.rotationY = 900;
        itemDef.rotationX = 1200;
        itemDef.groundActions = new String[5];
        itemDef.groundActions[2] = "Take";
        itemDef.stackable = false;
    }

    public static void applyTexturing(Model model, int id) {
        switch (id) {
            case 15332: 
            case 15333: 
            case 15334: 
            case 15335: 
            case 20456: {
                model.setTexture(52);
            }
            case 20500: 
            case 20501: 
            case 20502: {
                model.setTexture(55, 4018);
                model.setTexture(55, 3761);
                model.setTexture(55, 3756);
                model.setTexture(55, 3503);
                model.setTexture(55, 3994);
                model.setTexture(55, 4000);
                model.setTexture(55, 4008);
                break;
            }
            case 4456: {
                model.setTexture(50);
                break;
            }
            case 3815: {
                model.setTexture(50);
                model.setTexture(60, 4018);
                model.setTexture(55, 3761);
                model.setTexture(55, 3756);
                model.setTexture(55, 3503);
                model.setTexture(55, 3994);
                model.setTexture(55, 4000);
                model.setTexture(55, 4008);
                break;
            }
            case 3999: 
            case 21000: {
                model.setTexture(59);
                model.setTexture(55, 4018);
                model.setTexture(55, 3761);
                model.setTexture(55, 3756);
                model.setTexture(55, 3503);
                model.setTexture(55, 3994);
                model.setTexture(55, 4000);
                model.setTexture(55, 4008);
                break;
            }
            case 3642: 
            case 20951: {
                model.setTexture(55);
                model.setTexture(55, 4018);
                model.setTexture(55, 3761);
                model.setTexture(55, 3756);
                model.setTexture(55, 3503);
                model.setTexture(55, 3994);
                model.setTexture(55, 4000);
                model.setTexture(55, 4008);
                break;
            }
            case 20455: {
                model.setTexture(53);
                model.setTexture(55, 4018);
                break;
            }
            case 9706: 
            case 20450: {
                model.setTexture(59);
                model.setTexture(55, 4018);
                break;
            }
            case 979: 
            case 980: 
            case 2548: {
                break;
            }
            case 20503: {
                model.setTexture(66, 1, 5000, 16);
                break;
            }
            case 21013: {
                model.setTexture(55, 4018);
                model.setTexture(55, 3761);
                model.setTexture(55, 3756);
                model.setTexture(55, 3503);
                model.setTexture(55, 3994);
                model.setTexture(55, 4000);
                model.setTexture(55, 4008);
                break;
            }
            case 1017: 
            case 15084: {
                model.setTexture(52);
                break;
            }
            case 20079: {
                model.setTexture(59, 3500, 4318);
                break;
            }
            case 20084: 
            case 20085: {
                model.setTexture(59);
                break;
            }
            case 20081: 
            case 20082: 
            case 20083: {
                model.setTexture(59, 1000, 55000);
                break;
            }
            case 8839: 
            case 8840: {
                model.setTexture(59, 31, 100);
                break;
            }
            case 8842: {
                model.setTexture(59);
                break;
            }
            case 19787: 
            case 19788: {
                model.setTexture(53, 31, 150);
                model.setTexture(53, 500, 10000);
                break;
            }
            case 14008: 
            case 14009: 
            case 14010: {
                model.setTexture(16, 30, 75, 66);
                break;
            }
            case 21063: {
                model.setTexture(16, 1, 10000, 66);
                break;
            }
            case 21064: 
            case 21065: 
            case 21066: {
                model.setTexture(66, 800, 935, 16);
                break;
            }
            case 11663: 
            case 11664: 
            case 11665: {
                model.setTexture(59, 31, 10000000);
                break;
            }
            case 21056: 
            case 21057: 
            case 21058: {
                model.setTexture(53, 31, 10000000);
                break;
            }
            case 8841: 
            case 21059: {
                model.setTexture(53);
                break;
            }
            case 20550: {
                model.setTexture(65, 31, 10000000);
                break;
            }
            case 20453: {
                model.setTexture(55);
                break;
            }
            case 3682: 
            case 20251: 
            case 20252: 
            case 20253: 
            case 20254: 
            case 20255: 
            case 20256: 
            case 20257: 
            case 20258: {
                model.setTexture();
                break;
            }
            case 20112: 
            case 20113: 
            case 20114: 
            case 20451: {
                model.setTexture(52, 0, 10000000);
                break;
            }
            case 20452: {
                model.setTexture(60);
                break;
            }
            case 20012: {
                model.setTexture(57, 10, 100);
                break;
            }
            case 20010: 
            case 20011: {
                model.setTexture(57, 30, 55);
                break;
            }
            case 20019: 
            case 20020: {
                model.setTexture(57);
                break;
            }
            case 455: 
            case 19903: {
                model.setTexture(69);
                break;
            }
            case 19904: {
                model.setTexture(60);
                break;
            }
            case 19905: {
                model.setTexture(52);
                break;
            }
            case 20095: 
            case 20096: 
            case 20097: 
            case 20098: 
            case 20099: 
            case 20100: 
            case 20101: {
                model.setTexture(59);
                break;
            }
            case 17849: {
                model.setTexture(55);
                break;
            }
            case 13655: {
                model.setTexture(70, 97000);
                break;
            }
            case 6102: {
                model.setTexture(55, 50, 34000);
                break;
            }
            case 300: 
            case 13199: 
            case 13206: 
            case 13207: 
            case 21060: {
                model.setTexture(66);
                break;
            }
            case 299: 
            case 882: 
            case 884: 
            case 886: 
            case 888: 
            case 890: {
                model.setTexture(19, 0, 20562);
                model.setTexture(70, 20563, 300000);
                break;
            }
            case 2996: 
            case 20454: {
                model.setTexture(19, 0, 20562);
                model.setTexture(70, 20563, 300000);
            }
        }
    }

    public static void nullLoader() {
        modelCache = null;
        spriteCache = null;
        streamIndices = null;
        cache = null;
        stream = null;
    }

    public boolean dialogueModelFetched(int j) {
        int k = this.maleDialogue;
        int l = this.maleDialogueModel;
        if (j == 1) {
            k = this.femaleDialogue;
            l = this.femaleDialogueModel;
        }
        if (k == -1) {
            return true;
        }
        boolean flag = true;
        if (!Model.modelIsFetched(k)) {
            flag = false;
        }
        if (l != -1 && !Model.modelIsFetched(l)) {
            flag = false;
        }
        return flag;
    }

    public Model getDialogueModel(int gender) {
        int k = this.maleDialogue;
        int l = this.maleDialogueModel;
        if (gender == 1) {
            k = this.femaleDialogue;
            l = this.femaleDialogueModel;
        }
        if (k == -1) {
            return null;
        }
        Model model = Model.fetchModel(k);
        if (l != -1) {
            Model model_1 = Model.fetchModel(l);
            Model[] models = new Model[]{model, model_1};
            model = new Model(2, models);
        }
        if (this.editedModelColor != null) {
            for (int i1 = 0; i1 < this.editedModelColor.length; ++i1) {
                model.recolour(this.editedModelColor[i1], this.newModelColor[i1]);
            }
        }
        if (this.colourRedefine > 0) {
            model.method1337(this.colourRedefine);
        }
        if (this.colourRedefine2 != 0) {
            model.method1338(this.colourRedefine2);
        }
        if (this.colourRedefine3 != 0) {
            model.method1339(this.colourRedefine3);
        }
        ItemDef.applyTexturing(model, this.id);
        return model;
    }

    public boolean equipModelFetched(int gender) {
        int fistModel = this.maleEquip1;
        int secondModel = this.maleEquip2;
        int thirdModel = this.maleEquip3;
        if (gender == 1) {
            fistModel = this.femaleEquip1;
            secondModel = this.femaleEquip2;
            thirdModel = this.femaleEquip3;
        }
        if (fistModel == -1) {
            return true;
        }
        boolean flag = true;
        if (!Model.modelIsFetched(fistModel)) {
            flag = false;
        }
        if (secondModel != -1 && !Model.modelIsFetched(secondModel)) {
            flag = false;
        }
        if (thirdModel != -1 && !Model.modelIsFetched(thirdModel)) {
            flag = false;
        }
        return flag;
    }

    public Model getEquipModel(int gender) {
        int j = this.maleEquip1;
        int k = this.maleEquip2;
        int l = this.maleEquip3;
        if (gender == 1) {
            j = this.femaleEquip1;
            k = this.femaleEquip2;
            l = this.femaleEquip3;
        }
        if (j == -1) {
            return null;
        }
        Model model = Model.fetchModel(j);
        if (k != -1) {
            if (l != -1) {
                Model model_1 = Model.fetchModel(k);
                Model model_3 = Model.fetchModel(l);
                Model[] model_1s = new Model[]{model, model_1, model_3};
                model = new Model(3, model_1s);
            } else {
                Model model_2 = Model.fetchModel(k);
                Model[] models = new Model[]{model, model_2};
                model = new Model(2, models);
            }
        }
        if (gender == 0 && this.maleYOffset != 0) {
            model.translate(0, this.maleYOffset, 0);
        } else if (gender == 1 && this.femaleYOffset != 0) {
            model.translate(0, this.femaleYOffset, 0);
        }
        if (this.editedModelColor != null) {
            for (int i1 = 0; i1 < this.editedModelColor.length; ++i1) {
                model.recolour(this.editedModelColor[i1], this.newModelColor[i1]);
            }
        }
        if (this.colourRedefine > 0) {
            model.method1337(this.colourRedefine);
        }
        if (this.colourRedefine2 != 0) {
            model.method1338(this.colourRedefine2);
        }
        if (this.colourRedefine3 != 0) {
            model.method1339(this.colourRedefine3);
        }
        ItemDef.applyTexturing(model, this.id);
        return model;
    }

    public void setDefaults() {
        this.untradeable = false;
        this.modelID = 0;
        this.modelIDs = null;
        this.name = null;
        this.description = null;
        this.editedModelColor = null;
        this.newModelColor = null;
        clorDefcode = null;
        this.clorDefcodeTo = null;
        this.modelZoom = 2000;
        this.rotationY = 0;
        this.rotationX = 0;
        this.modelOffsetX = 0;
        this.modelOffset1 = 0;
        this.modelOffsetY = 0;
        this.stackable = false;
        this.value = 0;
        this.membersObject = false;
        this.groundActions = null;
        this.actions = null;
        this.maleEquip1 = -1;
        this.maleEquip2 = -1;
        this.maleYOffset = 0;
        this.maleXOffset = 0;
        this.femaleEquip1 = -1;
        this.femaleEquip2 = -1;
        this.femaleYOffset = 0;
        this.maleEquip3 = -1;
        this.femaleEquip3 = -1;
        this.maleDialogue = -1;
        this.maleDialogueModel = -1;
        this.femaleDialogue = -1;
        this.femaleDialogueModel = -1;
        this.stackIDs = null;
        this.stackAmounts = null;
        this.certID = -1;
        this.certTemplateID = -1;
        this.sizeX = 128;
        this.sizeY = 128;
        this.sizeZ = 128;
        this.shadow = 0;
        this.lightness = 0;
        this.team = 0;
        this.lendID = -1;
        this.lentItemID = -1;
        this.colourRedefine = 0;
        this.colourRedefine2 = 0;
        this.colourRedefine3 = 0;
    }

    public static void unpackConfig(CacheArchive streamLoader) {
        stream = new Stream(streamLoader.getDataForName("obj.dat"));
        Stream stream = new Stream(streamLoader.getDataForName("obj.idx"));
        totalItems = stream.readUnsignedWord();
        additionalItems = 11015;
        streamIndices = new int[totalItems + additionalItems];
        int i = 2;
        for (int j = 0; j < totalItems; ++j) {
            ItemDef.streamIndices[j] = i;
            i += stream.readUnsignedWord();
        }
        cache = new ItemDef[10];
        for (int k = 0; k < 10; ++k) {
            ItemDef.cache[k] = new ItemDef();
        }
        ItemDef.setSettings();
        CustomItemLoader.load();
    }

    public static ItemDef copyRotations(ItemDef itemDef, int id) {
        ItemDef itemDef2 = ItemDef.forID(id);
        itemDef.modelOffsetY = itemDef2.modelOffsetY;
        itemDef.modelOffsetX = itemDef2.modelOffsetX;
        itemDef.modelOffsetY = itemDef2.modelOffsetY;
        itemDef.modelOffset1 = itemDef2.modelOffset1;
        itemDef.modelZoom = itemDef2.modelZoom;
        itemDef.rotationX = itemDef2.rotationX;
        itemDef.rotationY = itemDef2.rotationY;
        return itemDef;
    }

    public static String ucFirst(String str) {
        if (((String)(str = ((String)str).toLowerCase().replaceAll("_", " "))).length() <= 1) {
            return ((String)str).toUpperCase();
        }
        str = ((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1);
        return str;
    }

    public static ItemDef forID(int i) {
        for (int j = 0; j < 10; ++j) {
            if (ItemDef.cache[j].id != i) continue;
            return cache[j];
        }
        cacheIndex = (cacheIndex + 1) % 10;
        ItemDef itemDef = cache[cacheIndex];
        if (i >= streamIndices.length) {
            itemDef.id = i;
            itemDef.setDefaults();
            if (CustomItemLoader.hasCustomItem(i)) {
                CustomItemLoader.applyToItemDef(itemDef, i);
                return itemDef;
            }
            return ItemDef_Jarrod_1.forDef(itemDef, i);
        }
        ItemDef.stream.currentOffset = streamIndices[i];
        itemDef.id = i;
        itemDef.setDefaults();
        itemDef.readValues(stream);
        if (itemDef.certTemplateID != -1) {
            itemDef.toNote();
        }
        if (itemDef.lentItemID != -1) {
            itemDef.toLend();
        }
        if (itemDef.id == i && itemDef.editedModelColor == null) {
            itemDef.editedModelColor = new int[1];
            itemDef.newModelColor = new int[1];
            itemDef.editedModelColor[0] = 0;
            itemDef.newModelColor[0] = 1;
        }
        if (untradeableItems.contains(itemDef.id)) {
            itemDef.untradeable = true;
        }
        itemDef.value = prices[itemDef.id];
        CustomItemLoader.applyStackableOverride(itemDef);
        if (CustomItemLoader.hasCustomItem(i)) {
            CustomItemLoader.applyToItemDef(itemDef, i);
            return itemDef;
        }
        return ItemDef_Jarrod_1.forDef(itemDef, i);
    }

    private void readValues(Stream stream) {
        int i;
        block0: while ((i = stream.readUnsignedByte()) != 0) {
            if (i == 1) {
                this.modelID = stream.readUnsignedWord();
                continue;
            }
            if (i == 2) {
                this.name = stream.readString();
                continue;
            }
            if (i == 3) {
                this.description = stream.readString();
                continue;
            }
            if (i == 4) {
                this.modelZoom = stream.readUnsignedWord();
                continue;
            }
            if (i == 5) {
                this.rotationY = stream.readUnsignedWord();
                continue;
            }
            if (i == 6) {
                this.rotationX = stream.readUnsignedWord();
                continue;
            }
            if (i == 7) {
                this.modelOffset1 = stream.readUnsignedWord();
                if (this.modelOffset1 <= Short.MAX_VALUE) continue;
                this.modelOffset1 -= 65536;
                continue;
            }
            if (i == 8) {
                this.modelOffsetY = stream.readUnsignedWord();
                if (this.modelOffsetY <= Short.MAX_VALUE) continue;
                this.modelOffsetY -= 65536;
                continue;
            }
            if (i == 10) {
                stream.readUnsignedWord();
                continue;
            }
            if (i == 11) {
                this.stackable = true;
                continue;
            }
            if (i == 12) {
                this.value = stream.readUnsignedWord();
                continue;
            }
            if (i == 16) {
                this.membersObject = true;
                continue;
            }
            if (i == 23) {
                this.maleEquip1 = stream.readUnsignedWord();
                this.maleYOffset = stream.readSignedByte();
                continue;
            }
            if (i == 24) {
                this.maleEquip2 = stream.readUnsignedWord();
                continue;
            }
            if (i == 25) {
                this.femaleEquip1 = stream.readUnsignedWord();
                this.femaleYOffset = stream.readSignedByte();
                continue;
            }
            if (i == 26) {
                this.femaleEquip2 = stream.readUnsignedWord();
                continue;
            }
            if (i >= 30 && i < 35) {
                if (this.groundActions == null) {
                    this.groundActions = new String[5];
                }
                this.groundActions[i - 30] = stream.readString();
                if (!this.groundActions[i - 30].equalsIgnoreCase("hidden")) continue;
                this.groundActions[i - 30] = null;
                continue;
            }
            if (i >= 35 && i < 40) {
                if (this.actions == null) {
                    this.actions = new String[5];
                }
                this.actions[i - 35] = stream.readString();
                if (!this.actions[i - 35].equalsIgnoreCase("null")) continue;
                this.actions[i - 35] = null;
                continue;
            }
            if (i == 40) {
                int j = stream.readUnsignedByte();
                this.editedModelColor = new int[j];
                this.newModelColor = new int[j];
                int k = 0;
                while (true) {
                    if (k >= j) continue block0;
                    this.editedModelColor[k] = stream.readUnsignedWord();
                    this.newModelColor[k] = stream.readUnsignedWord();
                    ++k;
                }
            }
            if (i == 78) {
                this.maleEquip3 = stream.readUnsignedWord();
                continue;
            }
            if (i == 79) {
                this.femaleEquip3 = stream.readUnsignedWord();
                continue;
            }
            if (i == 90) {
                this.maleDialogue = stream.readUnsignedWord();
                continue;
            }
            if (i == 91) {
                this.femaleDialogue = stream.readUnsignedWord();
                continue;
            }
            if (i == 92) {
                this.maleDialogueModel = stream.readUnsignedWord();
                continue;
            }
            if (i == 93) {
                this.femaleDialogueModel = stream.readUnsignedWord();
                continue;
            }
            if (i == 95) {
                this.modelOffsetX = stream.readUnsignedWord();
                continue;
            }
            if (i == 97) {
                this.certID = stream.readUnsignedWord();
                continue;
            }
            if (i == 98) {
                this.certTemplateID = stream.readUnsignedWord();
                continue;
            }
            if (i >= 100 && i < 110) {
                if (this.stackIDs == null) {
                    this.stackIDs = new int[10];
                    this.stackAmounts = new int[10];
                }
                this.stackIDs[i - 100] = stream.readUnsignedWord();
                this.stackAmounts[i - 100] = stream.readUnsignedWord();
                continue;
            }
            if (i == 110) {
                this.sizeX = stream.readUnsignedWord();
                continue;
            }
            if (i == 111) {
                this.sizeY = stream.readUnsignedWord();
                continue;
            }
            if (i == 112) {
                this.sizeZ = stream.readUnsignedWord();
                continue;
            }
            if (i == 113) {
                this.shadow = stream.readSignedByte();
                continue;
            }
            if (i == 114) {
                this.lightness = stream.readSignedByte() * 5;
                continue;
            }
            if (i == 115) {
                this.team = stream.readUnsignedByte();
                continue;
            }
            if (i == 116) {
                this.lendID = stream.readUnsignedWord();
                continue;
            }
            if (i != 117) continue;
            this.lentItemID = stream.readUnsignedWord();
        }
        return;
    }

    public static void setSettings() {
        try {
            prices = new int[35000];
            int index = 0;
            for (String line : Files.readAllLines(Paths.get(signlink.findcachedir() + "data/data.txt", new String[0]), Charset.defaultCharset())) {
                ItemDef.prices[index] = Integer.parseInt(line);
                ++index;
            }
            for (Object i : (Object)UNTRADEABLE_ITEMS) {
                untradeableItems.add((int)i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toNote() {
        ItemDef itemDef = ItemDef.forID(this.certTemplateID);
        this.modelID = itemDef.modelID;
        this.modelZoom = itemDef.modelZoom;
        this.rotationY = itemDef.rotationY;
        this.rotationX = itemDef.rotationX;
        this.modelOffsetX = itemDef.modelOffsetX;
        this.modelOffset1 = itemDef.modelOffset1;
        this.modelOffsetY = itemDef.modelOffsetY;
        this.editedModelColor = itemDef.editedModelColor;
        this.newModelColor = itemDef.newModelColor;
        ItemDef itemDef_1 = ItemDef.forID(this.certID);
        this.name = itemDef_1.name;
        this.membersObject = itemDef_1.membersObject;
        this.value = itemDef_1.value;
        String s = "a";
        char c = itemDef_1.name.charAt(0);
        if (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U') {
            s = "an";
        }
        this.description = "Swap this note at any bank for " + s + " " + itemDef_1.name + ".";
        this.stackable = true;
    }

    private void toLend() {
        ItemDef itemDef = ItemDef.forID(this.lentItemID);
        this.actions = new String[5];
        this.modelID = itemDef.modelID;
        this.modelOffset1 = itemDef.modelOffset1;
        this.rotationX = itemDef.rotationX;
        this.modelOffsetY = itemDef.modelOffsetY;
        this.modelZoom = itemDef.modelZoom;
        this.rotationY = itemDef.rotationY;
        this.modelOffsetX = itemDef.modelOffsetX;
        this.value = 0;
        ItemDef itemDef_1 = ItemDef.forID(this.lendID);
        this.maleDialogueModel = itemDef_1.maleDialogueModel;
        this.editedModelColor = itemDef_1.editedModelColor;
        this.clorDefcodeTo = itemDef_1.clorDefcodeTo;
        this.maleEquip3 = itemDef_1.maleEquip3;
        this.maleEquip2 = itemDef_1.maleEquip2;
        this.femaleDialogueModel = itemDef_1.femaleDialogueModel;
        this.maleDialogue = itemDef_1.maleDialogue;
        this.groundActions = itemDef_1.groundActions;
        this.maleEquip1 = itemDef_1.maleEquip1;
        this.name = itemDef_1.name;
        this.femaleEquip1 = itemDef_1.femaleEquip1;
        this.membersObject = itemDef_1.membersObject;
        this.femaleDialogue = itemDef_1.femaleDialogue;
        this.femaleEquip2 = itemDef_1.femaleEquip2;
        this.femaleEquip3 = itemDef_1.femaleEquip3;
        this.newModelColor = itemDef_1.newModelColor;
        this.team = itemDef_1.team;
        if (itemDef_1.actions != null) {
            for (int i_33_ = 0; i_33_ < 4; ++i_33_) {
                this.actions[i_33_] = itemDef_1.actions[i_33_];
            }
        }
        this.actions[4] = "@mag@Discard";
    }

    public static Sprite getSprite(int i, int j, int k, int zoom) {
        int j6;
        int l5;
        Model model;
        if (k == 0 && zoom != -1) {
            Sprite sprite = (Sprite)spriteCache.get(i);
            if (sprite != null && sprite.maxHeight != j && sprite.maxHeight != -1) {
                sprite.unlink();
                sprite = null;
            }
            if (sprite != null) {
                return sprite;
            }
        }
        ItemDef itemDef = ItemDef.forID(i);
        if (itemDef.stackIDs == null) {
            j = -1;
        }
        if (j > 1) {
            int i1 = -1;
            for (int j1 = 0; j1 < 10; ++j1) {
                if (j < itemDef.stackAmounts[j1] || itemDef.stackAmounts[j1] == 0) continue;
                i1 = itemDef.stackIDs[j1];
            }
            if (i1 != -1) {
                itemDef = ItemDef.forID(i1);
            }
        }
        if ((model = itemDef.getItemModelFinalised(1)) == null) {
            return null;
        }
        Sprite sprite = null;
        if (itemDef.certTemplateID != -1 && (sprite = ItemDef.getSprite(itemDef.certID, 10, -1)) == null) {
            return null;
        }
        if (itemDef.lendID != -1 && (sprite = ItemDef.getSprite(itemDef.lendID, 50, 0)) == null) {
            return null;
        }
        Sprite sprite2 = new Sprite(32, 32);
        int k1 = Rasterizer.center_x;
        int l1 = Rasterizer.center_y;
        int[] ai = Rasterizer.lineOffsets;
        int[] ai1 = DrawingArea.pixels;
        int i2 = DrawingArea.width;
        int j2 = DrawingArea.height;
        int k2 = DrawingArea.topX;
        int l2 = DrawingArea.bottomX;
        int i3 = DrawingArea.topY;
        int j3 = DrawingArea.bottomY;
        Rasterizer.notTextured = false;
        DrawingArea.initDrawingArea(32, 32, sprite2.myPixels);
        DrawingArea.drawPixels(32, 0, 0, 0, 32);
        Rasterizer.setDefaultBounds();
        int k3 = itemDef.modelZoom;
        if (zoom != -1 && zoom != 0) {
            k3 = itemDef.modelZoom * 100 / zoom;
        }
        if (k == -1) {
            k3 = (int)((double)k3 * 1.5);
        }
        if (k > 0) {
            k3 = (int)((double)k3 * 1.04);
        }
        int l3 = Rasterizer.SINE[itemDef.rotationY] * k3 >> 16;
        int i4 = Rasterizer.COSINE[itemDef.rotationY] * k3 >> 16;
        model.renderSingle(itemDef.rotationX, itemDef.modelOffsetX, itemDef.rotationY, itemDef.modelOffset1, l3 + model.modelHeight / 2 + itemDef.modelOffsetY, i4 + itemDef.modelOffsetY);
        for (int i5 = 31; i5 >= 0; --i5) {
            for (int j4 = 31; j4 >= 0; --j4) {
                if (sprite2.myPixels[i5 + j4 * 32] != 0) continue;
                if (i5 > 0 && sprite2.myPixels[i5 - 1 + j4 * 32] > 1) {
                    sprite2.myPixels[i5 + j4 * 32] = 1;
                    continue;
                }
                if (j4 > 0 && sprite2.myPixels[i5 + (j4 - 1) * 32] > 1) {
                    sprite2.myPixels[i5 + j4 * 32] = 1;
                    continue;
                }
                if (i5 < 31 && sprite2.myPixels[i5 + 1 + j4 * 32] > 1) {
                    sprite2.myPixels[i5 + j4 * 32] = 1;
                    continue;
                }
                if (j4 >= 31 || sprite2.myPixels[i5 + (j4 + 1) * 32] <= 1) continue;
                sprite2.myPixels[i5 + j4 * 32] = 1;
            }
        }
        if (k > 0) {
            for (int j5 = 31; j5 >= 0; --j5) {
                for (int k4 = 31; k4 >= 0; --k4) {
                    if (sprite2.myPixels[j5 + k4 * 32] != 0) continue;
                    if (j5 > 0 && sprite2.myPixels[j5 - 1 + k4 * 32] == 1) {
                        sprite2.myPixels[j5 + k4 * 32] = k;
                        continue;
                    }
                    if (k4 > 0 && sprite2.myPixels[j5 + (k4 - 1) * 32] == 1) {
                        sprite2.myPixels[j5 + k4 * 32] = k;
                        continue;
                    }
                    if (j5 < 31 && sprite2.myPixels[j5 + 1 + k4 * 32] == 1) {
                        sprite2.myPixels[j5 + k4 * 32] = k;
                        continue;
                    }
                    if (k4 >= 31 || sprite2.myPixels[j5 + (k4 + 1) * 32] != 1) continue;
                    sprite2.myPixels[j5 + k4 * 32] = k;
                }
            }
        } else if (k == 0) {
            for (int k5 = 31; k5 >= 0; --k5) {
                for (int l4 = 31; l4 >= 0; --l4) {
                    if (sprite2.myPixels[k5 + l4 * 32] != 0 || k5 <= 0 || l4 <= 0 || sprite2.myPixels[k5 - 1 + (l4 - 1) * 32] <= 0) continue;
                    sprite2.myPixels[k5 + l4 * 32] = 0x302020;
                }
            }
        }
        if (itemDef.certTemplateID != -1) {
            l5 = sprite.maxWidth;
            j6 = sprite.maxHeight;
            sprite.maxWidth = 32;
            sprite.maxHeight = 32;
            sprite.drawSprite(0, 0);
            sprite.maxWidth = l5;
            sprite.maxHeight = j6;
        }
        if (itemDef.lendID != -1) {
            l5 = sprite.maxWidth;
            j6 = sprite.maxHeight;
            sprite.maxWidth = 32;
            sprite.maxHeight = 32;
            sprite.drawSprite(0, 0);
            sprite.maxWidth = l5;
            sprite.maxHeight = j6;
        }
        if (k == 0) {
            spriteCache.put(sprite2, i);
        }
        DrawingArea.initDrawingArea(j2, i2, ai1);
        DrawingArea.setDrawingArea(j3, k2, l2, i3);
        Rasterizer.center_x = k1;
        Rasterizer.center_y = l1;
        Rasterizer.lineOffsets = ai;
        Rasterizer.notTextured = true;
        sprite2.maxWidth = itemDef.stackable ? 33 : 32;
        sprite2.maxHeight = j;
        return sprite2;
    }

    public static void printItem(int mobId) {
        ItemDef dump = ItemDef.forID(mobId);
        if (dump.name != null) {
            System.out.println("Dumping: " + dump.name);
        } else {
            System.out.println("MobDefinition.get(" + mobId + ").name == null");
        }
        System.out.println("Male Model1: " + dump.maleEquip1);
        System.out.println("Male Model2: " + dump.maleEquip2);
        System.out.println("Male Model3: " + dump.maleEquip3);
        System.out.println("Female Model1: " + dump.femaleEquip1);
        System.out.println("Female Model2: " + dump.femaleEquip2);
        System.out.println("Female Model3: " + dump.femaleEquip3);
    }

    public static Sprite getSprite(int i, int j, int k) {
        int j6;
        int l5;
        Model model;
        ItemDef itemDef = ItemDef.forID(i);
        if (itemDef.stackIDs == null) {
            j = -1;
        }
        if (j > 1) {
            int i1 = -1;
            for (int j1 = 0; j1 < 10; ++j1) {
                if (j < itemDef.stackAmounts[j1] || itemDef.stackAmounts[j1] == 0) continue;
                i1 = itemDef.stackIDs[j1];
            }
            if (i1 != -1) {
                itemDef = ItemDef.forID(i1);
            }
        }
        if ((model = itemDef.getItemModelFinalised(1)) == null) {
            return null;
        }
        Sprite sprite = null;
        if (itemDef.certTemplateID != -1 && (sprite = ItemDef.getSprite(itemDef.certID, 10, -1)) == null) {
            return null;
        }
        if (itemDef.lentItemID != -1 && (sprite = ItemDef.getSprite(itemDef.lendID, 50, 0)) == null) {
            return null;
        }
        Sprite sprite2 = new Sprite(32, 32);
        int k1 = Rasterizer.center_x;
        int l1 = Rasterizer.center_y;
        int[] ai = Rasterizer.lineOffsets;
        int[] ai1 = DrawingArea.pixels;
        int i2 = DrawingArea.width;
        int j2 = DrawingArea.height;
        int k2 = DrawingArea.topX;
        int l2 = DrawingArea.bottomX;
        int i3 = DrawingArea.topY;
        int j3 = DrawingArea.bottomY;
        Rasterizer.notTextured = false;
        DrawingArea.initDrawingArea(32, 32, sprite2.myPixels);
        DrawingArea.drawPixels(32, 0, 0, 0, 32);
        Rasterizer.setDefaultBounds();
        int k3 = itemDef.modelZoom;
        if (k == -1) {
            k3 = (int)((double)k3 * 1.5);
        }
        if (k > 0) {
            k3 = (int)((double)k3 * 1.04);
        }
        int l3 = Rasterizer.SINE[itemDef.rotationY] * k3 >> 16;
        int i4 = Rasterizer.COSINE[itemDef.rotationY] * k3 >> 16;
        model.renderSingle(itemDef.rotationX, itemDef.modelOffsetX, itemDef.rotationY, itemDef.modelOffset1, l3 + model.modelHeight / 2 + itemDef.modelOffsetY, i4 + itemDef.modelOffsetY);
        for (int i5 = 31; i5 >= 0; --i5) {
            for (int j4 = 31; j4 >= 0; --j4) {
                if (sprite2.myPixels[i5 + j4 * 32] != 0) continue;
                if (i5 > 0 && sprite2.myPixels[i5 - 1 + j4 * 32] > 1) {
                    sprite2.myPixels[i5 + j4 * 32] = 1;
                    continue;
                }
                if (j4 > 0 && sprite2.myPixels[i5 + (j4 - 1) * 32] > 1) {
                    sprite2.myPixels[i5 + j4 * 32] = 1;
                    continue;
                }
                if (i5 < 31 && sprite2.myPixels[i5 + 1 + j4 * 32] > 1) {
                    sprite2.myPixels[i5 + j4 * 32] = 1;
                    continue;
                }
                if (j4 >= 31 || sprite2.myPixels[i5 + (j4 + 1) * 32] <= 1) continue;
                sprite2.myPixels[i5 + j4 * 32] = 1;
            }
        }
        if (k > 0) {
            for (int j5 = 31; j5 >= 0; --j5) {
                for (int k4 = 31; k4 >= 0; --k4) {
                    if (sprite2.myPixels[j5 + k4 * 32] != 0) continue;
                    if (j5 > 0 && sprite2.myPixels[j5 - 1 + k4 * 32] == 1) {
                        sprite2.myPixels[j5 + k4 * 32] = k;
                        continue;
                    }
                    if (k4 > 0 && sprite2.myPixels[j5 + (k4 - 1) * 32] == 1) {
                        sprite2.myPixels[j5 + k4 * 32] = k;
                        continue;
                    }
                    if (j5 < 31 && sprite2.myPixels[j5 + 1 + k4 * 32] == 1) {
                        sprite2.myPixels[j5 + k4 * 32] = k;
                        continue;
                    }
                    if (k4 >= 31 || sprite2.myPixels[j5 + (k4 + 1) * 32] != 1) continue;
                    sprite2.myPixels[j5 + k4 * 32] = k;
                }
            }
        } else if (k == 0) {
            for (int k5 = 31; k5 >= 0; --k5) {
                for (int l4 = 31; l4 >= 0; --l4) {
                    if (sprite2.myPixels[k5 + l4 * 32] != 0 || k5 <= 0 || l4 <= 0 || sprite2.myPixels[k5 - 1 + (l4 - 1) * 32] <= 0) continue;
                    sprite2.myPixels[k5 + l4 * 32] = 0x302020;
                }
            }
        }
        if (itemDef.certTemplateID != -1) {
            l5 = sprite.maxWidth;
            j6 = sprite.maxHeight;
            sprite.maxWidth = 32;
            sprite.maxHeight = 32;
            sprite.drawSprite(0, 0);
            sprite.maxWidth = l5;
            sprite.maxHeight = j6;
        }
        if (itemDef.lentItemID != -1) {
            l5 = sprite.maxWidth;
            j6 = sprite.maxHeight;
            sprite.maxWidth = 32;
            sprite.maxHeight = 32;
            sprite.drawSprite(0, 0);
            sprite.maxWidth = l5;
            sprite.maxHeight = j6;
        }
        if (k == 0) {
            spriteCache.put(sprite2, i);
        }
        DrawingArea.initDrawingArea(j2, i2, ai1);
        DrawingArea.setDrawingArea(j3, k2, l2, i3);
        Rasterizer.center_x = k1;
        Rasterizer.center_y = l1;
        Rasterizer.lineOffsets = ai;
        Rasterizer.notTextured = true;
        sprite2.maxWidth = itemDef.stackable ? 33 : 32;
        sprite2.maxHeight = j;
        return sprite2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Model getItemModelFinalised(int amount) {
        Model model;
        if (this.stackIDs != null && amount > 1) {
            int stackId = -1;
            for (int k = 0; k < 10; ++k) {
                if (amount < this.stackAmounts[k] || this.stackAmounts[k] == 0) continue;
                stackId = this.stackIDs[k];
            }
            if (stackId != -1) {
                return ItemDef.forID(stackId).getItemModelFinalised(1);
            }
        }
        if ((model = (Model)modelCache.get(this.id)) != null) {
            return model;
        }
        if (this.modelIDs != null && this.modelIDs.length > 0) {
            Model[] models = new Model[this.modelIDs.length];
            int modelCount = 0;
            for (int i = 0; i < this.modelIDs.length; ++i) {
                Model subModel = Model.fetchModel(this.modelIDs[i]);
                if (subModel == null) continue;
                models[modelCount++] = subModel;
            }
            if (modelCount <= 0) return null;
            Model[] finalModels = new Model[modelCount];
            System.arraycopy(models, 0, finalModels, 0, modelCount);
            model = new Model(modelCount, finalModels);
        } else {
            model = Model.fetchModel(this.modelID);
            if (model == null) {
                return null;
            }
        }
        if (this.sizeX != 128 || this.sizeY != 128 || this.sizeZ != 128) {
            model.scaleT(this.sizeX, this.sizeZ, this.sizeY);
        }
        if (this.editedModelColor != null && this.newModelColor != null) {
            int colorLen = Math.min(this.editedModelColor.length, this.newModelColor.length);
            for (int l = 0; l < colorLen; ++l) {
                model.recolour(this.editedModelColor[l], this.newModelColor[l]);
            }
        }
        if (this.colourRedefine > 0) {
            model.method1337(this.colourRedefine);
        }
        if (this.colourRedefine2 != 0) {
            model.method1338(this.colourRedefine2);
        }
        if (this.colourRedefine3 != 0) {
            model.method1339(this.colourRedefine3);
        }
        modelCache.put(model, this.id);
        ItemDef.applyTexturing(model, this.id);
        model.light(64 + this.shadow, 768 + this.lightness, -50, -10, -50, true);
        model.rendersWithinOneTile = true;
        modelCache.put(model, this.id);
        return model;
    }

    public static String itemModels(int itemID) {
        int inv = ItemDef.forID((int)itemID).modelID;
        int male = ItemDef.forID((int)itemID).maleEquip1;
        int female = ItemDef.forID((int)itemID).femaleEquip1;
        String name = ItemDef.forID((int)itemID).name;
        return "<col=225>" + name + "</col> (<col=800000000>" + itemID + "</col>) - [inv: <col=800000000>" + inv + "</col>] - [male: <col=800000000>" + male + "</col>] - [female: <col=800000000>" + female + "</col>]";
    }

    public Model getItemModel(int i) {
        Model model;
        if (this.stackIDs != null && i > 1) {
            int j = -1;
            for (int k = 0; k < 10; ++k) {
                if (i < this.stackAmounts[k] || this.stackAmounts[k] == 0) continue;
                j = this.stackIDs[k];
            }
            if (j != -1) {
                return ItemDef.forID(j).getItemModel(1);
            }
        }
        if ((model = Model.fetchModel(this.modelID)) == null) {
            return null;
        }
        if (this.editedModelColor != null) {
            for (int l = 0; l < this.editedModelColor.length; ++l) {
                model.recolour(this.editedModelColor[l], this.newModelColor[l]);
            }
        }
        if (this.colourRedefine > 0) {
            model.method1337(this.colourRedefine);
        }
        if (this.colourRedefine2 != 0) {
            model.method1338(this.colourRedefine2);
        }
        if (this.colourRedefine3 != 0) {
            model.method1339(this.colourRedefine3);
        }
        ItemDef.applyTexturing(model, this.id);
        return model;
    }

    static {
        untradeableItems = new ArrayList<Integer>();
        UNTRADEABLE_ITEMS = new int[]{13661, 13262, 6529, 6950, 1464, 2996, 2677, 2678, 2679, 2680, 2682, 2683, 2684, 2685, 2686, 2687, 2688, 2689, 2690, 6570, 12158, 12159, 12160, 12163, 12161, 12162, 19143, 19149, 19146, 19157, 19162, 19152, 4155, 8850, 10551, 8839, 8840, 8842, 11663, 11664, 11665, 3842, 3844, 3840, 8844, 8845, 8846, 8847, 8848, 8849, 8850, 10551, 7462, 7461, 7460, 7459, 7458, 7457, 7456, 7455, 7454, 7453, 8839, 8840, 8842, 11663, 11664, 11665, 10499, 9748, 9754, 9751, 9769, 9757, 9760, 9763, 9802, 9808, 9784, 9799, 9805, 9781, 9796, 9793, 9775, 9772, 9778, 9787, 9811, 9766, 9749, 9755, 9752, 9770, 9758, 9761, 9764, 9803, 9809, 9785, 9800, 9806, 9782, 9797, 9794, 9776, 9773, 9779, 9788, 9812, 9767, 9747, 9753, 9750, 9768, 9756, 9759, 9762, 9801, 9807, 9783, 9798, 9804, 9780, 9795, 9792, 9774, 9771, 9777, 9786, 9810, 9765, 9948, 9949, 9950, 12169, 12170, 12171, 20671, 14641, 14642, 6188, 10954, 10956, 10958, 3057, 3058, 3059, 3060, 3061, 7594, 7592, 7593, 7595, 7596, 14076, 14077, 14081, 10840, 10836, 6858, 6859, 10837, 10838, 10839, 9925, 9924, 9923, 9922, 9921, 4084, 4565, 20046, 20044, 20045, 1050, 14595, 14603, 14602, 14605, 11789, 19708, 19706, 19707, 4860, 4866, 4872, 4878, 4884, 4896, 4890, 4896, 4902, 4932, 4938, 4944, 4950, 4908, 4914, 4920, 4926, 4956, 4926, 4968, 4994, 4980, 4986, 4992, 4998, 18778, 18779, 18780, 18781, 13450, 13444, 13405, 15502, 10548, 10549, 10550, 10551, 10555, 10552, 10553, 2412, 2413, 2414, 20747, 18365, 18373, 18371, 15246, 12964, 12971, 12978, 14017, 757, 8851, 13855, 13848, 13857, 13856, 13854, 13853, 13852, 13851, 13850, 5509, 13653, 14021, 14020, 19111, 14019, 14022, 19785, 19786, 18782, 18351, 18349, 18353, 18357, 18355, 18359, 18335, 9148, 9149, 9150, 9151, 9152, 9153, 9154, 3078, 3079, 3080, 3081, 3086, 3087, 3076, 3289, 3290, 3291, 3292, 3293, 3294, 1120};
        spriteCache = new MemCache(100);
        modelCache = new MemCache(50);
    }

    public static enum CustomItems {
        RED_WINGS(19709, 48334, 48334, 48334, false),
        ELITE_CROSSBOW(9185, 48353, 48354, 48354, true),
        ELITE_MAGE_BOOK(3842, 48361, 48362, 48362, false),
        ELITE_MAGE_WAND(6914, 48363, 48364, 48364, true),
        LIGHT_BLUE_WINGS(19709, 48375, 48375, 48375, false),
        GODSTONE_SHIELD(8714, 13086, 13087, 13087, false),
        BLOODY_DREADFUL_SHIELD(8714, 13701, 13700, 13700, false),
        JUGGERNAUT_RING(18907, 47762, -1, false),
        ANCIENT_AXES(4747, 95150, 95151, 95151, false),
        QUEST_CAPE(19709, 27657, 27656, 27656, false),
        GEMSTONE_SWORD(18351, 82966, 82967, 82967, false),
        MALEVOLENT_SHIELD(8714, 48394, 48395, 48395, false),
        NINJA_THROWING_KNIFE(5698, 48396, 48397, 48397, false),
        RAINBOW_SPIRIT_SHIELD(5698, 80010, 80011, 80011, false),
        STRIPED_WHIP(18351, 80028, 80029, 80029, true),
        BLUE_DREADFUL_SHIELD(8714, 80031, 80030, 80030, false),
        IRON_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{33, 0, 0, 0}),
        DARK_BLUE_DREADFUL_SHIELD(8714, 16065, false),
        BLADED_SHIELD(8714, 19550, true),
        RING_OF_RICHES(18907, 68824, -1, false),
        TENACIOUS_RING(6737, 68825, -1, false),
        BLUE_OBBY_SHIELD(8714, 30001, 30000, false),
        GREEN_OBBY_SHIELD(8714, 30003, 30002, false),
        CREATURE_WHIP(4151, 4185, 4186, true),
        GOLD_DREADFUL_SHIELD(8714, 55028, 55027, false),
        MACHINED_CLAWS(14484, 62937, 62936, false),
        PURPLE_SPIRIT_SHIELD(5698, 87654, 87653, false),
        RELIGIOUS_SWORD(18351, 86044, true),
        ANGELIC_PLATELEGS(14010, 86065, 86062, false),
        ANGELIC_PLATEBODY(14009, 86067, 86063, false),
        ILLUMINNATION_HELM(14008, 86066, 86064, false),
        MINIGUN(5698, 74119, true),
        RAINBOW_WINGS(19709, 23231, 23232, false),
        GOBLIN_MASK(14010, 28666, 28553, false),
        WHITE_WINGS(19709, 45000, false),
        ROYAL_THROWING_AXE(1377, 72044, true),
        RAY_GUN(5698, 74114, false),
        GHOSTLY_SWORDS(18351, 75058, 75059, true),
        PINK_WINGS(19709, 75860, 75859, false),
        DARK_RED_WINGS(19709, 75861, 75862, false),
        BLACK_WINGS(19709, 75863, 75864, false),
        FIERY_WINGS(19709, 75865, 75866, false),
        RAINBOW_WHIP(18351, 78101, true),
        ICY_CROSSBOW(9185, 79411, true),
        CHILLER_SWORD(18351, 79413, true),
        RED_SPIRIT_SHIELD(8714, 80004, false),
        GOLD_SPIRIT_SHIELD(8714, 80007, false),
        TOY_CROSSBOW(9185, 90009, 90009, true),
        AMERICAN_PARTYHAT(1048, 74006, 74006, 74007, false),
        TECHTONIC_ROBE_BOTTOM(18937, 90025, 90023, false),
        TECHTONIC_ROBE_TOP(18938, 90020, 90022, false),
        TECHTONIC_HELM(18939, 90019, 90017, false),
        SIRENIC_PLATELEGS(18940, 90032, 90034, false),
        SIRENIC_PLATEBODY(18941, 90029, 90031, false),
        SIRENIC_FULL_HELM(18942, 90028, 90026, false),
        MALEVOLENT_PLATELEGS(18943, 90043, 90041, false),
        MALEVOLENT_PLATEBODY(18944, 90040, 90038, false),
        MALEVOLENT_HELM(18945, 90037, 90035, false),
        DRAGONBONE_KITESHIELD(8714, 90045, 90044, 90044, false),
        ARMADYL_CROSSBOW(18357, 90047, 90046, 90046, true),
        DRAGON_BOOTS(11732, 90049, 90049, 90049, false),
        SKY_TORVA_HELM(14008, 100, 100, 101, false),
        PAPER_SACK(1048, 10031, 10031, 10031, false),
        COLORFUL_WINGS(19709, 10094, 10094, 10093, false),
        ROYAL_CAPE(19709, 1015, 1015, 1017, false),
        SKY_TORVA_PLATEBODY(14009, 102, 102, 103, false),
        SKY_TORVA_WINGS(19709, 104, 104, 105, false),
        SKY_TORVA_BOOTS(11732, 95133, 95133, 95144, false),
        SKY_TORVA_GLOVES(1059, 95131, 95131, 95132, false),
        SKY_BRUTAL_WHIP(18351, 95129, 95129, 95130, true),
        GOLDEN_DEATH_CAPE(19709, 11112, 11112, 11112, false),
        ONE_GLOVE(1059, 11114, 11114, 11114, false),
        ONE_LEGS(14010, 11115, 11115, 11115, false),
        ONE_CAPE(19709, 11118, 11118, 11118, false),
        SKY_TORVA_PLATELEGS(14010, 95127, 95127, 95128, false),
        ANIMAL_HELM(14008, 12276, 12276, 15002, false),
        ANIMAL_BODY(14009, 12278, 12278, 15004, false),
        ANIMAL_BOW(861, 12323, 12316, 12316, true),
        HUGE_BIRD_WINGS(19709, 12542, 12542, 12542, false),
        SPARTA_BOOTS(11732, 13565, 13565, 13565, false),
        BLUE_DONATOR_CAPE(19709, 13955, 13955, 13956, false),
        RED_DONATOR_CAPE(19709, 13957, 13957, 13958, false),
        DOUBLE_ENDED_DILDO(18351, 14053, 14053, 14052, true),
        FIERY_BOW(861, 14680, 14680, 14679, true),
        ANIMAL_LEGS(14010, 15005, 15005, 15005, false),
        ORNAMENTAL_PLATE(14009, 15042, 15042, 82947, false),
        ORNAMENTAL_PLATELEGS(14010, 15044, 15044, 15043, false),
        ORNAMENTAL_BOOTS(11732, 15046, 15046, 15045, false),
        ORNAMENTAL_GLOVES(1059, 15049, 15049, 15047, false),
        GREEN_DONATOR_CAPE(19709, 16020, 16020, 16021, false),
        DONATOR_SHIELD(8714, 16034, 16034, 16035, false),
        COLORFUL_SCARF(1725, 16829, 16829, 16830, false),
        COLORFUL_HELM(18945, 19993, 19993, 19993, false),
        COLORFUL_PLATE(14009, 19995, 19995, 19995, false),
        COLORFUL_PLATELEGS(14010, 19996, 19996, 19996, false),
        PINK_DILDO(18351, 20, 20, 20, true),
        ORNAMENTAL_HELM(14008, 2035, 2035, 2036, false),
        INFERNAL_SWORD(18351, 95125, 95125, 95125, true),
        PURPLE_GLASS_WINGS(19709, 23060, 23060, 23061, false),
        RAINBOW_CAPE(19709, 23234, 23234, 23235, false),
        STACKED_AXE(18351, 24092, 24092, 24091, true),
        DOOM_BLADE(18351, 95126, 95126, 95126, true),
        POOL_CUE(18351, 26096, 26096, 26097, true),
        GREEN_CROWN(1048, 27222, 27222, 27221, false),
        RED_CROWN(1048, 27232, 27232, 27231, false),
        PURPLE_CROWN(1048, 27242, 27242, 27241, false),
        COLORFUL_LANCE(18351, 27274, 27274, 27275, true),
        WINGED_DONATOR_CAPE(19709, 27830, 27830, 27831, false),
        DEVIL_TAIL(14010, 27864, 27864, 27863, false),
        DEVIL_HORNS(1048, 27874, 27874, 27873, false),
        PINK_TOP_HAT(1048, 27888, 27888, 27887, false),
        RED_WINGED_CAPE(19709, 27896, 27896, 27897, false),
        GUITAR(18351, 49026, 49026, 49026, true),
        JESTER_SWORD(18351, 49101, 49101, 49102, true),
        NOOB_GODSWORD(18351, 5000, 5000, 5001, true),
        FORGOTTEN_LONGSWORD(18351, 5002, 5002, 5003, true),
        ROYAL_BLADE(18351, 50065, 50065, 50066, true),
        AKIMBO_DAGGERS(4747, 50134, 50134, 50135, true),
        FLESH_LONGSWORD(18351, 50224, 50224, 50223, true),
        ARMADYL_LONGSWORD(18351, 50227, 50227, 50226, true),
        DRAGONBONE_SCIMITAR(18351, 50228, 50228, 50228, true),
        TEST_SCIMITAR(18351, 50941, 50941, 50942, true),
        DRAGONBONE_CAPE(19709, 50947, 50947, 50946, false),
        BLAZED_DEATH_CAPE(19709, 5167, 5167, 5166, false),
        BLUE_DEATH_CAPE(19709, 5168, 5169, 5169, false),
        BUMBLE_PLATEBODY(18944, 54171, 54171, 56539, false),
        BUMBLE_PLATELEGS(18943, 54012, 54012, 55818, false),
        BUMBLE_SHIELD(8714, 54445, 54445, 56975, false),
        STRIPED_PARTYHAT(1048, 58001, 58001, 58000, false),
        MULTICOLORED_PARTYHAT(1048, 58005, 58005, 58004, false),
        COLORFUL_SANTA_HAT(1050, 58013, 58013, 58012, false),
        GOLD_TRIMMED_WINGS(19709, 58025, 58025, 58024, false),
        PURPLE_WINGS(19709, 58028, 58028, 58027, false),
        RASTA_WINGS(19709, 58034, 58034, 58033, false),
        COLORFUL_WHIP(18351, 58051, 58051, 58050, true),
        GOLDEN_CLAWS(14484, 62000, 62000, 62001, true),
        SPARTA_PLATEBODY(18944, 62767, 62767, 90052, false),
        SPARTA_HELM(18945, 62771, 62771, 62770, false),
        SPARTA_PLATELEGS(18943, 62773, 62773, 62772, false),
        SPARTA_SHIELD(8714, 62775, 62775, 62774, false),
        TALIS_SWORD(18351, 62769, 62769, 62788, true),
        GRIM_PLATEBODY(18944, 62832, 62832, 62831, false),
        GRIM_PLATELEGS(18943, 62833, 62833, 62930, false),
        GRIM_HELM(18945, 62835, 62835, 62834, false),
        GRIM_BOOTS(11732, 62837, 62837, 62836, false),
        GRIM_GLOVES(1059, 62839, 62839, 62838, false),
        METALIC_PLATEBODY(18944, 62847, 62847, 62846, false),
        METALIC_PLATELEGS(18943, 62841, 62841, 62840, false),
        METALIC_HELM(18945, 62849, 62849, 62848, false),
        CARVED_PLATEBODY(18944, 62853, 62853, 62852, false),
        CARVED_PLATELEGS(18943, 62855, 62855, 62854, false),
        CARVED_HELM(18945, 62857, 62857, 62856, false),
        BLUE_GLASS_WINGS(19709, 64057, 64057, 64058, false),
        GREEN_GLASS_WINGS(19709, 64059, 64059, 64060, false),
        RED_GLASS_WINGS(19709, 64061, 64061, 64062, false),
        YELLOW_GLASS_WINGS(19709, 64063, 64063, 64064, false),
        BLACK_GLASS_WINGS(19709, 64065, 64065, 64066, false),
        GODLY_WINGS(19709, 665, 665, 666, false),
        BLING_CHAIN(19709, 68989, 68989, 68990, false),
        SUPERMAN_LEGS(18943, 71959, 71959, 71958, false),
        SUPERMAN_BODY(18944, 71962, 71962, 71960, false),
        SUPERMAN_BOOTS(11732, 71961, 71961, 71961, false),
        AMERICAN_PARTYHAT_V2(1048, 74006, 74006, 74007, false),
        RETRO_PARTYHAT(1048, 74009, 74009, 74008, false),
        STRIPED_PARTYHAT_V2(1048, 74011, 74011, 74010, false),
        ZOMBIE_PARTYHAT(1048, 74014, 74014, 74015, false),
        SUPERMAN_CAPE(19709, 75072, 75072, 75072, false),
        ICY_KATANA(18351, 75500, 75500, 75500, true),
        PISTOL(9185, 75501, 75501, 75502, true),
        GOOGLE_CHROME_SWORD(18351, 75878, 75878, 75878, true),
        COLORFUL_SHIELD(8714, 7772, 7772, 7772, false),
        DEVIL_CAPE(19709, 81, 81, 80, false),
        ONE_HELM(19709, 82948, 82948, 82948, false),
        ONE_PLATEBODY(18944, 82949, 82949, 82949, false),
        TRON_SHIELD(8714, 82990, 82990, 82991, false),
        LEGACY_SHIELD(8714, 82992, 82992, 82993, false),
        GRIM_SHIELD(8714, 82994, 82994, 82995, false),
        STRIPED_WINGS(19709, 83010, 83010, 83011, false),
        ANGELIC_WINGS(19709, 83012, 83012, 83013, false),
        ENERGY_SWORD(18351, 8393, 8393, 8393, true),
        COLORFUL_PARTYHAT(1048, 9001, 9001, 9000, false),
        ZARYTE_BOW(861, 62692, 62750, 62750, true),
        BRONZE_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{6028, 0, 0, 0}),
        STEEL_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{61, 0, 0, 0}),
        BLACK_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{3, 0, 0, 0}),
        MITHRIL_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{43297, 0, 0, 0}),
        ADAMANT_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{21662, 0, 0, 0}),
        RUNE_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{36252, 0, 0, 0}),
        BARROWS_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{10388, 0, 0, 0}),
        LIME_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{17350, 0, 0, 0}),
        LAVA_PARTYHAT(1038, new int[]{926, 0, 0, 0}, new int[]{6073, 0, 0, 0}),
        MADARA_HELMET(18945, 65533, 65534, 65534, false);

        private int copy;
        private int inventory;
        private int female;
        private int male;
        private boolean weapon;
        private int[] editedModelColor;
        private int[] originalModelColor;
        private boolean copyDef;

        private CustomItems(int copy, int model, boolean weapon) {
            this.setCopy(copy);
            this.setInventory(model);
            this.setFemale(model);
            this.setMale(model);
            this.setWeapon(weapon);
        }

        private CustomItems(int copy, int inventory, int wield, boolean weapon) {
            this.setCopy(copy);
            this.setInventory(inventory);
            this.setFemale(wield);
            this.setMale(wield);
            this.setWeapon(weapon);
        }

        private CustomItems(int copy, int inventory, int female, int male, boolean weapon) {
            this.setCopy(copy);
            this.setInventory(inventory);
            this.setFemale(female);
            this.setMale(male);
            this.setWeapon(weapon);
        }

        private CustomItems(int copy, int[] editedModelColor, int[] originalModelColor) {
            this.setCopyDef(true);
            this.setCopy(copy);
            this.editedModelColor = editedModelColor;
            this.originalModelColor = originalModelColor;
        }

        public int getCopy() {
            return this.copy;
        }

        public void setCopy(int copy) {
            this.copy = copy;
        }

        public int getInventory() {
            return this.inventory;
        }

        public void setInventory(int inventory) {
            this.inventory = inventory;
        }

        public int getFemale() {
            return this.female;
        }

        public void setFemale(int female) {
            this.female = female;
        }

        public int getMale() {
            return this.male;
        }

        public void setMale(int male) {
            this.male = male;
        }

        public boolean isWeapon() {
            return this.weapon;
        }

        public void setWeapon(boolean weapon) {
            this.weapon = weapon;
        }

        public int[] getEditedModelColor() {
            return this.editedModelColor;
        }

        public void setEditedModelColor(int[] editedModelColor) {
            this.editedModelColor = editedModelColor;
        }

        public int[] getOriginalModelColor() {
            return this.originalModelColor;
        }

        public void setOriginalModelColor(int[] originalModelColor) {
            this.originalModelColor = originalModelColor;
        }

        public boolean isCopyDef() {
            return this.copyDef;
        }

        public void setCopyDef(boolean copyDef) {
            this.copyDef = copyDef;
        }
    }
}

