/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import java.awt.Color;

public class JagexColor {
    public static final int[] hsl2rgb;
    public static final int[] map;

    public static void main(String[] args) throws Exception {
        int rgb = hsl2rgb[926];
        System.out.println(String.format("%02x%02x%02x", rgb & 0xFF, rgb >> 8 & 0xFF, rgb >> 16 & 0xFF));
    }

    public static int toHSB(int red, int green, int blue) {
        float[] HSB = Color.RGBtoHSB(red, green, blue, null);
        int hue = (int)(HSB[0] * 63.0f);
        int saturation = (int)(HSB[1] * 7.0f);
        int brightness = (int)(HSB[2] * 127.0f);
        return (hue << 10) + (saturation << 7) + brightness;
    }

    public static int toRGB(int hsb) {
        int hue = hsb >> 10 & 0x3F;
        int saturation = hsb >> 7 & 7;
        int brightness = hsb & 0x7F;
        return Color.HSBtoRGB((float)hue / 63.0f, (float)saturation / 7.0f, (float)brightness / 127.0f);
    }

    public static int fromHEX(String hex) {
        int[] rgb = JagexColor.hex2Rgb(hex);
        return JagexColor.fromRGB(rgb[0], rgb[1], rgb[2]);
    }

    public static int fromRGB(Color color) {
        return JagexColor.fromRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int fromRGB(int red, int green, int blue) {
        return JagexColor.fromRGB((red << 16) + (green << 8) + blue);
    }

    public static int fromRGB(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        rgb = (blue << 16) + (green << 8) + red & 0xFFFF;
        for (int i = 0; i < hsl2rgb.length; ++i) {
            if (hsl2rgb[i] != rgb) continue;
            return map[i] & 0xFFFF;
        }
        return -1;
    }

    public static int fromHSL(int color) {
        int rgb = hsl2rgb[color & 0xFFFF];
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return (blue << 16) + (green << 8) + red;
    }

    public static int[] hex2Rgb(String color) {
        int hex = Integer.parseInt(color, 16);
        int red = (hex & 0xFF0000) >> 16;
        int green = (hex & 0xFF00) >> 8;
        int blue = hex & 0xFF;
        return new int[]{red, green, blue};
    }

    static {
        int i1;
        map = new int[65536];
        hsl2rgb = map;
        int[] out = map;
        double d = 0.7;
        int i = 0;
        for (i1 = 0; i1 != 512; ++i1) {
            float f = ((float)(i1 >> 3) / 64.0f + 0.0078125f) * 360.0f;
            float f1 = 0.0625f + (float)(7 & i1) / 8.0f;
            for (int i2 = 0; i2 != 128; ++i2) {
                float f2 = (float)i2 / 128.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = f / 60.0f;
                int i3 = (int)f6;
                int i4 = i3 % 6;
                float f7 = f6 - (float)i3;
                float f8 = f2 * (-f1 + 1.0f);
                float f9 = f2 * (-(f7 * f1) + 1.0f);
                float f10 = (1.0f - f1 * (-f7 + 1.0f)) * f2;
                if (i4 == 0) {
                    f3 = f2;
                    f5 = f8;
                    f4 = f10;
                } else if (i4 == 1) {
                    f5 = f8;
                    f3 = f9;
                    f4 = f2;
                } else if (i4 == 2) {
                    f3 = f8;
                    f4 = f2;
                    f5 = f10;
                } else if (i4 == 3) {
                    f4 = f9;
                    f3 = f8;
                    f5 = f2;
                } else if (i4 == 4) {
                    f5 = f2;
                    f3 = f10;
                    f4 = f8;
                } else {
                    f4 = f8;
                    f5 = f9;
                    f3 = f2;
                }
                out[i++] = (int)((float)Math.pow(f3, d) * 256.0f) << 16 | (int)((float)Math.pow(f4, d) * 256.0f) << 8 | (int)((float)Math.pow(f5, d) * 256.0f);
            }
        }
        for (i1 = 0; i1 < map.length; ++i1) {
            int index = i1 & 0xFFFF;
            if (index >= hsl2rgb.length) continue;
            JagexColor.map[index] = i1;
        }
    }
}

