/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Animable;
import com.teragard.Client;
import com.teragard.Configuration;
import com.teragard.Decompressor;
import com.teragard.DrawingArea;
import com.teragard.FrameReader;
import com.teragard.ModelHeader;
import com.teragard.NPCDef;
import com.teragard.OnDemandFetcherParent;
import com.teragard.Particle;
import com.teragard.ParticleAttachment;
import com.teragard.ParticleDefinition;
import com.teragard.ParticleVector;
import com.teragard.Rasterizer;
import com.teragard.SkinList;
import com.teragard.Stream;
import com.teragard.VertexNormal;
import com.teragard.WorldController;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class Model
extends Animable {
    public static int MAX_POLYGON = 50000;
    private static boolean upscaled = true;
    private static int[] OFFSETS_512_334 = null;
    private static int[] OFFSETS_765_503 = null;
    public static boolean[] newmodel;
    public static String ccString;
    public static String xxString;
    public static String vvString;
    public static String aString9_9;
    public static int anInt1620;
    public static Model entityModelDesc;
    protected static int[] anIntArray1622;
    protected static int[] anIntArray1623;
    protected static int[] anIntArray1624;
    protected static int[] anIntArray1625;
    static ModelHeader[] modelHeader;
    static OnDemandFetcherParent resourceManager;
    static Decompressor modelCacheIndex;
    static Decompressor highModelCacheIndex;
    static Set<Integer> loggedFailedHighModels;
    static boolean[] hasAnEdgeToRestrict;
    static boolean[] outOfReach;
    static int[] projected_vertex_x;
    static int[] projected_vertex_y;
    static int[] projected_vertex_z;
    static int[] anIntArray1667;
    static int[] camera_vertex_y;
    static int[] camera_vertex_x;
    static int[] camera_vertex_z;
    static int[] depthListIndices;
    static int[][] faceLists;
    static int[] anIntArray1673;
    static int[][] anIntArrayArray1674;
    static int[] anIntArray1675;
    static int[] anIntArray1676;
    static int[] anIntArray1677;
    static int[] anIntArray1678;
    static int[] anIntArray1679;
    static int[] anIntArray1680;
    static int[] anIntArray1638;
    static int anInt1681;
    static int anInt1682;
    static int anInt1683;
    public static boolean objectExists;
    public static int[] lineOffsets;
    public static int currentCursorX;
    public static int currentCursorY;
    public static int objectsRendered;
    public static int[] objectsInCurrentRegion;
    public static int[] mapObjectIds;
    public static int[] SINE;
    public static int[] COSINE;
    static int[] hsl2rgb;
    static int[] lightDecay;
    private int lastRenderedRotation = 0;
    private int renderAtPointX;
    public int renderAtPointZ = 0;
    public int renderAtPointY = 0;
    public int[] verticesParticle;
    private boolean filtered = false;
    private boolean aBoolean1618;
    public int numberOfVerticeCoordinates;
    public int[] verticesXCoordinate;
    public int[] verticesYCoordinate;
    public int[] verticesZCoordinate;
    public int numberOfTriangleFaces;
    public int[] face_a;
    public int[] face_b;
    public int[] face_c;
    public int[] face_shade_a;
    public int[] face_shade_b;
    public int[] face_shade_c;
    public int[] face_render_type;
    public int[] face_render_priorities;
    public int[] face_alpha;
    public int[] face_color;
    public int face_priority;
    public int numberOfTexturesFaces;
    public int[] textures_face_a;
    public int[] textures_face_b;
    public int[] textures_face_c;
    public int anInt1646;
    public int anInt1647;
    public int anInt1648;
    public int anInt1649;
    public int anInt1650;
    public int anInt1651;
    public int diagonal3D;
    public int anInt1653;
    public int myPriority;
    public int[] vertexVSkin;
    public int[] triangleTSkin;
    public int[][] vertexSkin;
    public int[][] triangleSkin;
    public boolean rendersWithinOneTile;
    VertexNormal[] vertexNormalOffset;

    public static Model fetchModel(int j) {
        if (modelHeader == null) {
            return null;
        }
        if (j == 0) {
            return null;
        }
        if (j >= modelHeader.length) {
            System.out.println("[Model] fetchModel: model ID " + j + " exceeds modelHeader array size " + modelHeader.length);
            return null;
        }
        ModelHeader class21 = modelHeader[j];
        if (class21 == null) {
            block14: {
                if (j > 65535 && highModelCacheIndex != null) {
                    try {
                        byte[] data = highModelCacheIndex.get(j);
                        if (data != null && data.length > 0) {
                            if (data.length > 2 && (data[0] & 0xFF) == 31 && (data[1] & 0xFF) == 139 && (data = Model.decompressGzip(data)) == null) {
                                if (!loggedFailedHighModels.contains(j)) {
                                    loggedFailedHighModels.add(j);
                                    System.out.println("[Model] High model " + j + ": GZIP decompression failed");
                                }
                                resourceManager.get(j);
                                return null;
                            }
                            Model.readFirstModelData(data, j);
                            class21 = modelHeader[j];
                            if (class21 == null) break block14;
                            try {
                                return new Model(j);
                            }
                            catch (Exception modelEx) {
                                Model.modelHeader[j] = null;
                                if (!loggedFailedHighModels.contains(j)) {
                                    loggedFailedHighModels.add(j);
                                    System.out.println("[Model] High model " + j + ": corrupt data - " + modelEx.getClass().getSimpleName());
                                }
                                break block14;
                            }
                        }
                        if (!loggedFailedHighModels.contains(j)) {
                            loggedFailedHighModels.add(j);
                            System.out.println("[Model] High model " + j + ": not found in cache");
                        }
                    }
                    catch (Exception e) {
                        if (loggedFailedHighModels.contains(j)) break block14;
                        loggedFailedHighModels.add(j);
                        System.out.println("[Model] High model " + j + " exception: " + e.getClass().getSimpleName());
                    }
                }
            }
            resourceManager.get(j);
            return null;
        }
        return new Model(j);
    }

    private static byte[] decompressGzip(byte[] compressed) {
        try {
            int len;
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
            GZIPInputStream gzis = new GZIPInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = gzis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            gzis.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] getOffsets(int j, int k) {
        if (j == 512 && k == 334 && OFFSETS_512_334 != null) {
            return OFFSETS_512_334;
        }
        if (j == 766 && k == 503 && OFFSETS_765_503 != null) {
            return OFFSETS_765_503;
        }
        int[] t = new int[k];
        for (int l = 0; l < k; ++l) {
            t[l] = j * l;
        }
        if (j == 512 && k == 334) {
            OFFSETS_512_334 = t;
        }
        if (j == 766 && k == 503) {
            OFFSETS_765_503 = t;
        }
        return t;
    }

    public static void initialise(int i, OnDemandFetcherParent onDemandFetcher) {
        modelHeader = new ModelHeader[150000];
        newmodel = new boolean[150000];
        resourceManager = onDemandFetcher;
    }

    public static int method481(int i, int j, int k) {
        if (i == 65535) {
            return 0;
        }
        if ((k & 2) == 2) {
            if (j < 0) {
                j = 0;
            } else if (j > 127) {
                j = 127;
            }
            j = 127 - j;
            return j;
        }
        if ((j = j * (i & 0x7F) >> 7) < 2) {
            j = 2;
        } else if (j > 126) {
            j = 126;
        }
        return (i & 0xFF80) + j;
    }

    public static boolean modelIsFetched(int i) {
        if (modelHeader == null) {
            return false;
        }
        ModelHeader class21 = modelHeader[i];
        if (class21 == null) {
            if (modelCacheIndex != null) {
                try {
                    byte[] data = modelCacheIndex.get(i);
                    if (data != null && data.length > 0) {
                        Model.readFirstModelData(data, i);
                        if (modelHeader[i] != null) {
                            return true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            resourceManager.get(i);
            return false;
        }
        return true;
    }

    public static void nullLoader() {
        modelHeader = null;
        hasAnEdgeToRestrict = null;
        outOfReach = null;
        projected_vertex_y = null;
        anIntArray1667 = null;
        camera_vertex_y = null;
        camera_vertex_x = null;
        camera_vertex_z = null;
        depthListIndices = null;
        faceLists = null;
        anIntArray1673 = null;
        anIntArrayArray1674 = null;
        anIntArray1675 = null;
        anIntArray1676 = null;
        anIntArray1677 = null;
        SINE = null;
        COSINE = null;
        hsl2rgb = null;
        lightDecay = null;
    }

    public static void readFirstModelData(byte[] abyte0, int j) {
        try {
            int l2;
            if (abyte0 == null) {
                ModelHeader class21 = Model.modelHeader[j] = new ModelHeader();
                class21.verticeCount = 0;
                class21.triangleCount = 0;
                class21.texturedTriangleCount = 0;
                return;
            }
            Stream stream = new Stream(abyte0);
            stream.currentOffset = abyte0.length - 18;
            ModelHeader class21_1 = Model.modelHeader[j] = new ModelHeader();
            class21_1.modelData = abyte0;
            class21_1.verticeCount = stream.readUnsignedWord();
            class21_1.triangleCount = stream.readUnsignedWord();
            class21_1.texturedTriangleCount = stream.readUnsignedByte();
            int k = stream.readUnsignedByte();
            int l = stream.readUnsignedByte();
            int i1 = stream.readUnsignedByte();
            int j1 = stream.readUnsignedByte();
            int k1 = stream.readUnsignedByte();
            int l1 = stream.readUnsignedWord();
            int i2 = stream.readUnsignedWord();
            int j2 = stream.readUnsignedWord();
            int k2 = stream.readUnsignedWord();
            class21_1.verticesModOffset = l2 = 0;
            class21_1.triMeshLinkOffset = l2 += class21_1.verticeCount;
            class21_1.facePriorityBasePos = l2 += class21_1.triangleCount;
            if (l == 255) {
                l2 += class21_1.triangleCount;
            } else {
                class21_1.facePriorityBasePos = -l - 1;
            }
            class21_1.tskinBasepos = l2;
            if (j1 == 1) {
                l2 += class21_1.triangleCount;
            } else {
                class21_1.tskinBasepos = -1;
            }
            class21_1.drawTypeBasePos = l2;
            if (k == 1) {
                l2 += class21_1.triangleCount;
            } else {
                class21_1.drawTypeBasePos = -1;
            }
            class21_1.vskinBasePos = l2;
            if (k1 == 1) {
                l2 += class21_1.verticeCount;
            } else {
                class21_1.vskinBasePos = -1;
            }
            class21_1.alphaBasepos = l2;
            if (i1 == 1) {
                l2 += class21_1.triangleCount;
            } else {
                class21_1.alphaBasepos = -1;
            }
            class21_1.triVPointOffset = l2;
            class21_1.triColourOffset = l2 += k2;
            class21_1.textureInfoBasePos = l2 += class21_1.triangleCount * 2;
            class21_1.verticesXOffset = l2 += class21_1.texturedTriangleCount * 6;
            class21_1.verticesYOffset = l2 += l1;
            class21_1.verticesZOffset = l2 += i2;
            l2 += j2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removeFromHeader(int j) {
        Model.modelHeader[j] = null;
    }

    public Model() {
    }

    private Model(boolean flag) {
        this.aBoolean1618 = true;
        this.rendersWithinOneTile = false;
    }

    public Model(boolean flag, boolean flag1, boolean flag2, Model model) {
        this.aBoolean1618 = true;
        this.rendersWithinOneTile = false;
        ++anInt1620;
        this.numberOfVerticeCoordinates = model.numberOfVerticeCoordinates;
        this.numberOfTriangleFaces = model.numberOfTriangleFaces;
        this.numberOfTexturesFaces = model.numberOfTexturesFaces;
        if (flag2) {
            this.verticesParticle = model.verticesParticle;
            this.verticesXCoordinate = model.verticesXCoordinate;
            this.verticesYCoordinate = model.verticesYCoordinate;
            this.verticesZCoordinate = model.verticesZCoordinate;
        } else {
            this.verticesParticle = new int[this.numberOfVerticeCoordinates];
            this.verticesXCoordinate = new int[this.numberOfVerticeCoordinates];
            this.verticesYCoordinate = new int[this.numberOfVerticeCoordinates];
            this.verticesZCoordinate = new int[this.numberOfVerticeCoordinates];
            for (int j = 0; j < this.numberOfVerticeCoordinates; ++j) {
                this.verticesParticle[j] = model.verticesParticle[j];
                this.verticesXCoordinate[j] = model.verticesXCoordinate[j];
                this.verticesYCoordinate[j] = model.verticesYCoordinate[j];
                this.verticesZCoordinate[j] = model.verticesZCoordinate[j];
            }
        }
        if (flag) {
            this.face_color = model.face_color;
        } else {
            this.face_color = new int[this.numberOfTriangleFaces];
            for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
                this.face_color[k] = model.face_color[k];
            }
        }
        if (flag1) {
            this.face_alpha = model.face_alpha;
        } else {
            this.face_alpha = new int[this.numberOfTriangleFaces];
            if (model.face_alpha == null) {
                for (int l = 0; l < this.numberOfTriangleFaces; ++l) {
                    this.face_alpha[l] = 0;
                }
            } else {
                for (int i1 = 0; i1 < this.numberOfTriangleFaces; ++i1) {
                    this.face_alpha[i1] = model.face_alpha[i1];
                }
            }
        }
        this.vertexVSkin = model.vertexVSkin;
        this.triangleTSkin = model.triangleTSkin;
        this.face_render_type = model.face_render_type;
        this.face_a = model.face_a;
        this.face_b = model.face_b;
        this.face_c = model.face_c;
        this.face_render_priorities = model.face_render_priorities;
        this.face_priority = model.face_priority;
        this.textures_face_a = model.textures_face_a;
        this.textures_face_b = model.textures_face_b;
        this.textures_face_c = model.textures_face_c;
    }

    public Model(boolean flag, boolean flag1, Model model) {
        this.aBoolean1618 = true;
        this.rendersWithinOneTile = false;
        ++anInt1620;
        this.numberOfVerticeCoordinates = model.numberOfVerticeCoordinates;
        this.numberOfTriangleFaces = model.numberOfTriangleFaces;
        this.numberOfTexturesFaces = model.numberOfTexturesFaces;
        if (flag) {
            this.verticesYCoordinate = new int[this.numberOfVerticeCoordinates];
            for (int j = 0; j < this.numberOfVerticeCoordinates; ++j) {
                this.verticesYCoordinate[j] = model.verticesYCoordinate[j];
            }
        } else {
            this.verticesYCoordinate = model.verticesYCoordinate;
        }
        if (flag1) {
            this.face_shade_a = new int[this.numberOfTriangleFaces];
            this.face_shade_b = new int[this.numberOfTriangleFaces];
            this.face_shade_c = new int[this.numberOfTriangleFaces];
            for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
                this.face_shade_a[k] = model.face_shade_a[k];
                this.face_shade_b[k] = model.face_shade_b[k];
                this.face_shade_c[k] = model.face_shade_c[k];
            }
            this.face_render_type = new int[this.numberOfTriangleFaces];
            if (model.face_render_type == null) {
                for (int l = 0; l < this.numberOfTriangleFaces; ++l) {
                    this.face_render_type[l] = 0;
                }
            } else {
                for (int i1 = 0; i1 < this.numberOfTriangleFaces; ++i1) {
                    this.face_render_type[i1] = model.face_render_type[i1];
                }
            }
            this.vertexNormals = new VertexNormal[this.numberOfVerticeCoordinates];
            for (int j1 = 0; j1 < this.numberOfVerticeCoordinates; ++j1) {
                VertexNormal vertNormal = this.vertexNormals[j1] = new VertexNormal();
                VertexNormal class33_1 = model.vertexNormals[j1];
                vertNormal.anInt602 = class33_1.anInt602;
                vertNormal.anInt603 = class33_1.anInt603;
                vertNormal.anInt604 = class33_1.anInt604;
                vertNormal.anInt605 = class33_1.anInt605;
            }
            this.vertexNormalOffset = model.vertexNormalOffset;
        } else {
            this.face_shade_a = model.face_shade_a;
            this.face_shade_b = model.face_shade_b;
            this.face_shade_c = model.face_shade_c;
            this.face_render_type = model.face_render_type;
        }
        this.verticesParticle = model.verticesParticle;
        this.verticesXCoordinate = model.verticesXCoordinate;
        this.verticesZCoordinate = model.verticesZCoordinate;
        this.face_color = model.face_color;
        this.face_alpha = model.face_alpha;
        this.face_render_priorities = model.face_render_priorities;
        this.face_priority = model.face_priority;
        this.face_a = model.face_a;
        this.face_b = model.face_b;
        this.face_c = model.face_c;
        this.textures_face_a = model.textures_face_a;
        this.textures_face_b = model.textures_face_b;
        this.textures_face_c = model.textures_face_c;
        this.modelHeight = model.modelHeight;
        this.anInt1650 = model.anInt1650;
        this.anInt1653 = model.anInt1653;
        this.diagonal3D = model.diagonal3D;
        this.anInt1646 = model.anInt1646;
        this.anInt1648 = model.anInt1648;
        this.anInt1649 = model.anInt1649;
        this.anInt1647 = model.anInt1647;
    }

    public Model(int modelId) {
        int[][] attachments;
        int i;
        byte[] is = Model.modelHeader[modelId].modelData;
        if (is[is.length - 1] == -1 && is[is.length - 2] == -1) {
            this.read622Model(is, modelId);
        } else {
            this.readOldModel(modelId);
        }
        int[] newBoots = new int[]{29249, 29254, 29250, 94427, 29255, 29252, 29253, 19855};
        int[] priorityFix = new int[]{94415, 96114, 95120, 90707, 90639, 90671, 90641, 90643, 90645, 90647, 95120, 90509, 90508, 94065, 91709, 94130, 94128, 94132, 94063, 94097, 94466, 94099, 94101, 91702, 90616, 3490, 7626, 9844, 8773, 6532, 6423, 94700, 94318, 94549, 94551, 94553, 94073, 91752, 91818, 91820, 91822, 94434, 95003, 94190, 96203, 96211, 84537, 84535, 84533, 84539, 94069, 98744, 84541, 84543, 84545, 95119, 72040, 72042, 72046, 72038, 72037, 71064, 83365, 83100, 72035, 72033, 72031, 72029, 72027, 72026, 72024, 74491, 95128};
        int[] arrayOfInt1 = newBoots;
        int j = newBoots.length;
        for (i = 0; i < j; ++i) {
            if (modelId != (i = arrayOfInt1[i])) continue;
            for (j = 0; j < this.face_render_priorities.length; ++j) {
                this.face_render_priorities[j] = 10;
            }
        }
        if (newmodel[modelId]) {
            if (Configuration.upscaling) {
                this.scale2(32, 32, 32);
            }
            if (modelId != 74011) {
                this.recolour(0, 255);
            }
            if (this.face_render_priorities != null) {
                for (j = 0; j < this.face_render_priorities.length; ++j) {
                    this.face_render_priorities[j] = 10;
                }
            }
        }
        if (this.face_render_priorities == null) {
            this.face_render_priorities = new int[this.numberOfTriangleFaces];
        }
        for (i = 0; i < this.face_render_priorities.length; ++i) {
            this.face_render_priorities[i] = 10;
        }
        if (modelId == 48841 || modelId == 48825 || modelId == 48817 || modelId == 48802 || modelId == 48840 || modelId == 45536 || modelId == 38284 || modelId == 45522 || modelId == 45517 || modelId == 45514 || modelId == 45490 || modelId == 48790 || modelId == 59583) {
            this.scaleT(32, 32, 32);
            this.translate(0, 6, 0);
        }
        if (modelId == 65478) {
            this.scaleT(32, 32, 32);
            this.translate(0, 0, 0);
        }
        if ((attachments = ParticleAttachment.getAttachments(modelId)) != null) {
            for (int n = 0; n < attachments.length; ++n) {
                int z;
                int[] attach = attachments[n];
                if (attach[0] == -1) {
                    for (z = 0; z < this.face_a.length; ++z) {
                        this.verticesParticle[this.face_a[z]] = attach[1] + 1;
                    }
                    continue;
                }
                if (attach[0] == -2) {
                    for (z = 0; z < this.face_b.length; ++z) {
                        this.verticesParticle[this.face_b[z]] = attach[1] + 1;
                    }
                    continue;
                }
                if (attach[0] == -3) {
                    for (z = 0; z < this.face_c.length; ++z) {
                        this.verticesParticle[this.face_c[z]] = attach[1] + 1;
                    }
                    continue;
                }
                if (attach[0] == -4) {
                    for (z = 0; z < this.face_a.length; ++z) {
                        this.verticesParticle[this.face_a[z]] = attach[1] + 1;
                    }
                    for (z = 0; z < this.face_b.length; ++z) {
                        this.verticesParticle[this.face_b[z]] = attach[1] + 1;
                    }
                    for (z = 0; z < this.face_c.length; ++z) {
                        this.verticesParticle[this.face_c[z]] = attach[1] + 1;
                    }
                    continue;
                }
                this.verticesParticle[attach[0]] = attach[1] + 1;
            }
        }
    }

    public Model(int i, Model[] amodel) {
        this.aBoolean1618 = true;
        this.rendersWithinOneTile = false;
        ++anInt1620;
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        this.numberOfVerticeCoordinates = 0;
        this.numberOfTriangleFaces = 0;
        this.numberOfTexturesFaces = 0;
        this.face_priority = -1;
        for (int k = 0; k < i; ++k) {
            Model model = amodel[k];
            if (model == null) continue;
            this.numberOfVerticeCoordinates += model.numberOfVerticeCoordinates;
            this.numberOfTriangleFaces += model.numberOfTriangleFaces;
            this.numberOfTexturesFaces += model.numberOfTexturesFaces;
            flag |= model.face_render_type != null;
            if (model.face_render_priorities != null) {
                flag1 = true;
            } else {
                if (this.face_priority == -1) {
                    this.face_priority = model.face_priority;
                }
                if (this.face_priority != model.face_priority) {
                    flag1 = true;
                }
            }
            flag2 |= model.face_alpha != null;
            flag3 |= model.triangleTSkin != null;
        }
        this.verticesParticle = new int[this.numberOfVerticeCoordinates];
        this.verticesXCoordinate = new int[this.numberOfVerticeCoordinates];
        this.verticesYCoordinate = new int[this.numberOfVerticeCoordinates];
        this.verticesZCoordinate = new int[this.numberOfVerticeCoordinates];
        this.vertexVSkin = new int[this.numberOfVerticeCoordinates];
        this.face_a = new int[this.numberOfTriangleFaces];
        this.face_b = new int[this.numberOfTriangleFaces];
        this.face_c = new int[this.numberOfTriangleFaces];
        this.textures_face_a = new int[this.numberOfTexturesFaces];
        this.textures_face_b = new int[this.numberOfTexturesFaces];
        this.textures_face_c = new int[this.numberOfTexturesFaces];
        if (flag) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (flag1) {
            this.face_render_priorities = new int[this.numberOfTriangleFaces];
        }
        if (flag2) {
            this.face_alpha = new int[this.numberOfTriangleFaces];
        }
        if (flag3) {
            this.triangleTSkin = new int[this.numberOfTriangleFaces];
        }
        this.face_color = new int[this.numberOfTriangleFaces];
        this.numberOfVerticeCoordinates = 0;
        this.numberOfTriangleFaces = 0;
        this.numberOfTexturesFaces = 0;
        int l = 0;
        for (int i1 = 0; i1 < i; ++i1) {
            Model model_1 = amodel[i1];
            if (model_1 == null) continue;
            for (int j1 = 0; j1 < model_1.numberOfTriangleFaces; ++j1) {
                if (flag) {
                    if (model_1.face_render_type == null) {
                        this.face_render_type[this.numberOfTriangleFaces] = 0;
                    } else {
                        int k1 = model_1.face_render_type[j1];
                        if ((k1 & 2) == 2) {
                            k1 += l << 2;
                        }
                        this.face_render_type[this.numberOfTriangleFaces] = k1;
                    }
                }
                if (flag1) {
                    this.face_render_priorities[this.numberOfTriangleFaces] = model_1.face_render_priorities == null ? model_1.face_priority : model_1.face_render_priorities[j1];
                }
                if (flag2) {
                    this.face_alpha[this.numberOfTriangleFaces] = model_1.face_alpha == null ? 0 : model_1.face_alpha[j1];
                }
                if (flag3 && model_1.triangleTSkin != null) {
                    this.triangleTSkin[this.numberOfTriangleFaces] = model_1.triangleTSkin[j1];
                }
                this.face_color[this.numberOfTriangleFaces] = model_1.face_color[j1];
                this.face_a[this.numberOfTriangleFaces] = this.method465(model_1, model_1.face_a[j1]);
                this.face_b[this.numberOfTriangleFaces] = this.method465(model_1, model_1.face_b[j1]);
                this.face_c[this.numberOfTriangleFaces] = this.method465(model_1, model_1.face_c[j1]);
                ++this.numberOfTriangleFaces;
            }
            for (int l1 = 0; l1 < model_1.numberOfTexturesFaces; ++l1) {
                this.textures_face_a[this.numberOfTexturesFaces] = this.method465(model_1, model_1.textures_face_a[l1]);
                this.textures_face_b[this.numberOfTexturesFaces] = this.method465(model_1, model_1.textures_face_b[l1]);
                this.textures_face_c[this.numberOfTexturesFaces] = this.method465(model_1, model_1.textures_face_c[l1]);
                ++this.numberOfTexturesFaces;
            }
            l += model_1.numberOfTexturesFaces;
        }
    }

    public Model(Model[] amodel) {
        int i = 2;
        this.aBoolean1618 = true;
        this.rendersWithinOneTile = false;
        ++anInt1620;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        this.numberOfVerticeCoordinates = 0;
        this.numberOfTriangleFaces = 0;
        this.numberOfTexturesFaces = 0;
        this.face_priority = -1;
        for (int k = 0; k < i; ++k) {
            Model model = amodel[k];
            if (model == null) continue;
            this.numberOfVerticeCoordinates += model.numberOfVerticeCoordinates;
            this.numberOfTriangleFaces += model.numberOfTriangleFaces;
            this.numberOfTexturesFaces += model.numberOfTexturesFaces;
            flag1 |= model.face_render_type != null;
            if (model.face_render_priorities != null) {
                flag2 = true;
            } else {
                if (this.face_priority == -1) {
                    this.face_priority = model.face_priority;
                }
                if (this.face_priority != model.face_priority) {
                    flag2 = true;
                }
            }
            flag3 |= model.face_alpha != null;
            flag4 |= model.face_color != null;
        }
        this.verticesParticle = new int[this.numberOfVerticeCoordinates];
        this.verticesXCoordinate = new int[this.numberOfVerticeCoordinates];
        this.verticesYCoordinate = new int[this.numberOfVerticeCoordinates];
        this.verticesZCoordinate = new int[this.numberOfVerticeCoordinates];
        this.face_a = new int[this.numberOfTriangleFaces];
        this.face_b = new int[this.numberOfTriangleFaces];
        this.face_c = new int[this.numberOfTriangleFaces];
        this.face_shade_a = new int[this.numberOfTriangleFaces];
        this.face_shade_b = new int[this.numberOfTriangleFaces];
        this.face_shade_c = new int[this.numberOfTriangleFaces];
        this.textures_face_a = new int[this.numberOfTexturesFaces];
        this.textures_face_b = new int[this.numberOfTexturesFaces];
        this.textures_face_c = new int[this.numberOfTexturesFaces];
        if (flag1) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (flag2) {
            this.face_render_priorities = new int[this.numberOfTriangleFaces];
        }
        if (flag3) {
            this.face_alpha = new int[this.numberOfTriangleFaces];
        }
        if (flag4) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.numberOfVerticeCoordinates = 0;
        this.numberOfTriangleFaces = 0;
        this.numberOfTexturesFaces = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < i; ++j1) {
            Model model_1 = amodel[j1];
            if (model_1 == null) continue;
            int k1 = this.numberOfVerticeCoordinates;
            for (int l1 = 0; l1 < model_1.numberOfVerticeCoordinates; ++l1) {
                this.verticesParticle[this.numberOfVerticeCoordinates] = model_1.verticesParticle[l1];
                this.verticesXCoordinate[this.numberOfVerticeCoordinates] = model_1.verticesXCoordinate[l1];
                this.verticesYCoordinate[this.numberOfVerticeCoordinates] = model_1.verticesYCoordinate[l1];
                this.verticesZCoordinate[this.numberOfVerticeCoordinates] = model_1.verticesZCoordinate[l1];
                ++this.numberOfVerticeCoordinates;
            }
            for (int i2 = 0; i2 < model_1.numberOfTriangleFaces; ++i2) {
                this.face_a[this.numberOfTriangleFaces] = model_1.face_a[i2] + k1;
                this.face_b[this.numberOfTriangleFaces] = model_1.face_b[i2] + k1;
                this.face_c[this.numberOfTriangleFaces] = model_1.face_c[i2] + k1;
                this.face_shade_a[this.numberOfTriangleFaces] = model_1.face_shade_a[i2];
                this.face_shade_b[this.numberOfTriangleFaces] = model_1.face_shade_b[i2];
                this.face_shade_c[this.numberOfTriangleFaces] = model_1.face_shade_c[i2];
                if (flag1) {
                    if (model_1.face_render_type == null) {
                        this.face_render_type[this.numberOfTriangleFaces] = 0;
                    } else {
                        int j2 = model_1.face_render_type[i2];
                        if ((j2 & 2) == 2) {
                            j2 += i1 << 2;
                        }
                        this.face_render_type[this.numberOfTriangleFaces] = j2;
                    }
                }
                if (flag2) {
                    this.face_render_priorities[this.numberOfTriangleFaces] = model_1.face_render_priorities == null ? model_1.face_priority : model_1.face_render_priorities[i2];
                }
                if (flag3) {
                    this.face_alpha[this.numberOfTriangleFaces] = model_1.face_alpha == null ? 0 : model_1.face_alpha[i2];
                }
                if (flag4 && model_1.face_color != null) {
                    this.face_color[this.numberOfTriangleFaces] = model_1.face_color[i2];
                }
                ++this.numberOfTriangleFaces;
            }
            for (int k2 = 0; k2 < model_1.numberOfTexturesFaces; ++k2) {
                this.textures_face_a[this.numberOfTexturesFaces] = model_1.textures_face_a[k2] + k1;
                this.textures_face_b[this.numberOfTexturesFaces] = model_1.textures_face_b[k2] + k1;
                this.textures_face_c[this.numberOfTexturesFaces] = model_1.textures_face_c[k2] + k1;
                ++this.numberOfTexturesFaces;
            }
            i1 += model_1.numberOfTexturesFaces;
        }
        this.calculateDiagonals();
    }

    public void applyTransform(int i) {
        if (this.vertexSkin == null) {
            return;
        }
        if (i == -1) {
            return;
        }
        FrameReader class36 = FrameReader.forID(i);
        if (class36 == null) {
            return;
        }
        SkinList class18 = class36.mySkinList;
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        for (int k = 0; k < class36.stepCount; ++k) {
            int l = class36.opCodeLinkTable[k];
            this.method472(class18.opcodes[l], class18.skinList[l], class36.xOffset[k], class36.yOffset[k], class36.zOffset[k]);
        }
    }

    public void mixTransform(int[] ai, int j, int k) {
        if (k == -1) {
            return;
        }
        if (ai == null || j == -1) {
            this.applyTransform(k);
            return;
        }
        FrameReader class36 = FrameReader.forID(k);
        if (class36 == null) {
            return;
        }
        FrameReader class36_1 = FrameReader.forID(j);
        if (class36_1 == null) {
            this.applyTransform(k);
            return;
        }
        SkinList class18 = class36.mySkinList;
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        int l = 0;
        int i1 = ai[l++];
        for (int j1 = 0; j1 < class36.stepCount; ++j1) {
            int k1 = class36.opCodeLinkTable[j1];
            while (k1 > i1) {
                i1 = ai[l++];
            }
            if (k1 == i1 && class18.opcodes[k1] != 0) continue;
            this.method472(class18.opcodes[k1], class18.skinList[k1], class36.xOffset[j1], class36.yOffset[j1], class36.zOffset[j1]);
        }
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        l = 0;
        i1 = ai[l++];
        for (int l1 = 0; l1 < class36_1.stepCount; ++l1) {
            int i2 = class36_1.opCodeLinkTable[l1];
            while (i2 > i1) {
                i1 = ai[l++];
            }
            if (i2 != i1 && class18.opcodes[i2] != 0) continue;
            this.method472(class18.opcodes[i2], class18.skinList[i2], class36_1.xOffset[l1], class36_1.yOffset[l1], class36_1.zOffset[l1]);
        }
    }

    public void applyTransform(int firstFrame, int nextFrame, int end, int cycle) {
        try {
            if (this.vertexSkin != null && firstFrame != -1) {
                FrameReader currentAnimation = FrameReader.forID(firstFrame);
                SkinList list1 = currentAnimation.mySkinList;
                anInt1681 = 0;
                anInt1682 = 0;
                anInt1683 = 0;
                FrameReader nextAnimation = null;
                SkinList list2 = null;
                if (nextFrame != -1) {
                    nextAnimation = FrameReader.forID(nextFrame);
                    if (nextAnimation.mySkinList != list1) {
                        nextAnimation = null;
                    }
                    list2 = nextAnimation.mySkinList;
                }
                if (nextAnimation == null || list2 == null) {
                    for (int i_263_ = 0; i_263_ < currentAnimation.stepCount; ++i_263_) {
                        int i_264_ = currentAnimation.opCodeLinkTable[i_263_];
                        this.method472(list1.opcodes[i_264_], list1.skinList[i_264_], currentAnimation.xOffset[i_263_], currentAnimation.yOffset[i_263_], currentAnimation.zOffset[i_263_]);
                    }
                } else {
                    for (int i1 = 0; i1 < currentAnimation.stepCount; ++i1) {
                        int n1 = currentAnimation.opCodeLinkTable[i1];
                        int opcode = list1.opcodes[n1];
                        int[] skin = list1.skinList[n1];
                        int x = currentAnimation.xOffset[i1];
                        int y = currentAnimation.yOffset[i1];
                        int z = currentAnimation.zOffset[i1];
                        boolean found = false;
                        for (int i2 = 0; i2 < nextAnimation.stepCount; ++i2) {
                            int n2 = nextAnimation.opCodeLinkTable[i2];
                            if (!list2.skinList[n2].equals(skin)) continue;
                            if (opcode != 2) {
                                x += (nextAnimation.xOffset[i2] - x) * cycle / end;
                                y += (nextAnimation.yOffset[i2] - y) * cycle / end;
                                z += (nextAnimation.zOffset[i2] - z) * cycle / end;
                            } else {
                                int dx = nextAnimation.xOffset[i2] - (x &= 0x7FF) & 0x7FF;
                                int dy = nextAnimation.yOffset[i2] - (y &= 0x7FF) & 0x7FF;
                                int dz = nextAnimation.zOffset[i2] - (z &= 0x7FF) & 0x7FF;
                                if (dx >= 1024) {
                                    dx -= 2048;
                                }
                                if (dy >= 1024) {
                                    dy -= 2048;
                                }
                                if (dz >= 1024) {
                                    dz -= 2048;
                                }
                                x = x + dx * cycle / end & 0x7FF;
                                y = y + dy * cycle / end & 0x7FF;
                                z = z + dz * cycle / end & 0x7FF;
                            }
                            found = true;
                            break;
                        }
                        if (!found) {
                            if (opcode != 3 && opcode != 2) {
                                x = x * (end - cycle) / end;
                                y = y * (end - cycle) / end;
                                z = z * (end - cycle) / end;
                            } else if (opcode == 3) {
                                x = (x * (end - cycle) + (cycle << 7)) / end;
                                y = (y * (end - cycle) + (cycle << 7)) / end;
                                z = (z * (end - cycle) + (cycle << 7)) / end;
                            } else {
                                int dx = -(x &= 0x7FF) & 0x7FF;
                                int dy = -(y &= 0x7FF) & 0x7FF;
                                int dz = -(z &= 0x7FF) & 0x7FF;
                                if (dx >= 1024) {
                                    dx -= 2048;
                                }
                                if (dy >= 1024) {
                                    dy -= 2048;
                                }
                                if (dz >= 1024) {
                                    dz -= 2048;
                                }
                                x = x + dx * cycle / end & 0x7FF;
                                y = y + dy * cycle / end & 0x7FF;
                                z = z + dz * cycle / end & 0x7FF;
                            }
                        }
                        this.method472(opcode, skin, x, y, z);
                    }
                }
            }
        }
        catch (Exception e) {
            this.applyTransform(firstFrame);
        }
    }

    public void applyTransform_2(int i, int frame2) {
        FrameReader fr;
        if (this.vertexSkin == null) {
            return;
        }
        if (i == -1) {
            return;
        }
        FrameReader class36 = FrameReader.forID(i);
        if (class36 == null) {
            return;
        }
        FrameReader class36_1 = FrameReader.forID(frame2);
        class36 = fr = FrameReader.getTween(class36, class36_1);
        SkinList class18 = class36.mySkinList;
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        for (int k = 0; k < class36.stepCount; ++k) {
            int l = class36.opCodeLinkTable[k];
            this.method472(class18.opcodes[l], class18.skinList[l], class36.xOffset[k], class36.yOffset[k], class36.zOffset[k]);
        }
    }

    public void calcDiagonalsAndStats(int i) {
        this.modelHeight = 0;
        this.anInt1650 = 0;
        this.anInt1651 = 0;
        this.anInt1646 = 999999;
        this.anInt1647 = -999999;
        this.anInt1648 = -99999;
        this.anInt1649 = 99999;
        for (int j = 0; j < this.numberOfVerticeCoordinates; ++j) {
            int j1;
            int k = this.verticesXCoordinate[j];
            int l = this.verticesYCoordinate[j];
            int i1 = this.verticesZCoordinate[j];
            if (k < this.anInt1646) {
                this.anInt1646 = k;
            }
            if (k > this.anInt1647) {
                this.anInt1647 = k;
            }
            if (i1 < this.anInt1649) {
                this.anInt1649 = i1;
            }
            if (i1 > this.anInt1648) {
                this.anInt1648 = i1;
            }
            if (-l > this.modelHeight) {
                this.modelHeight = -l;
            }
            if (l > this.anInt1651) {
                this.anInt1651 = l;
            }
            if ((j1 = k * k + i1 * i1) <= this.anInt1650) continue;
            this.anInt1650 = j1;
        }
        this.anInt1650 = (int)Math.sqrt(this.anInt1650);
        this.anInt1653 = (int)Math.sqrt(this.anInt1650 * this.anInt1650 + this.modelHeight * this.modelHeight);
        if (i != 21073) {
            return;
        }
        this.diagonal3D = this.anInt1653 + (int)Math.sqrt(this.anInt1650 * this.anInt1650 + this.anInt1651 * this.anInt1651);
    }

    public void calculateDiagonals() {
        this.modelHeight = 0;
        this.anInt1650 = 0;
        this.anInt1651 = 0;
        for (int i = 0; i < this.numberOfVerticeCoordinates; ++i) {
            int i1;
            int j = this.verticesXCoordinate[i];
            int k = this.verticesYCoordinate[i];
            int l = this.verticesZCoordinate[i];
            if (-k > this.modelHeight) {
                this.modelHeight = -k;
            }
            if (k > this.anInt1651) {
                this.anInt1651 = k;
            }
            if ((i1 = j * j + l * l) <= this.anInt1650) continue;
            this.anInt1650 = i1;
        }
        this.anInt1650 = (int)(Math.sqrt(this.anInt1650) + 0.99);
        this.anInt1653 = (int)(Math.sqrt(this.anInt1650 * this.anInt1650 + this.modelHeight * this.modelHeight) + 0.99);
        this.diagonal3D = this.anInt1653 + (int)(Math.sqrt(this.anInt1650 * this.anInt1650 + this.anInt1651 * this.anInt1651) + 0.99);
    }

    public void createBones() {
        if (this.vertexVSkin != null) {
            int[] ai = new int[256];
            int j = 0;
            for (int l = 0; l < this.numberOfVerticeCoordinates; ++l) {
                int j1;
                int n = j1 = this.vertexVSkin[l];
                ai[n] = ai[n] + 1;
                if (j1 <= j) continue;
                j = j1;
            }
            this.vertexSkin = null;
            this.vertexSkin = new int[j + 1][];
            for (int k1 = 0; k1 <= j; ++k1) {
                this.vertexSkin[k1] = new int[ai[k1]];
                ai[k1] = 0;
            }
            int j2 = 0;
            while (j2 < this.numberOfVerticeCoordinates) {
                int l2;
                int n = l2 = this.vertexVSkin[j2];
                int n2 = ai[n];
                ai[n] = n2 + 1;
                this.vertexSkin[l2][n2] = j2++;
            }
            this.vertexVSkin = null;
            ai = null;
        }
        if (this.triangleTSkin != null) {
            int[] ai1 = new int[256];
            int k = 0;
            for (int i1 = 0; i1 < this.numberOfTriangleFaces; ++i1) {
                int l1;
                int n = l1 = this.triangleTSkin[i1];
                ai1[n] = ai1[n] + 1;
                if (l1 <= k) continue;
                k = l1;
            }
            this.triangleSkin = null;
            this.triangleSkin = new int[k + 1][];
            for (int i2 = 0; i2 <= k; ++i2) {
                this.triangleSkin[i2] = new int[ai1[i2]];
                ai1[i2] = 0;
            }
            int k2 = 0;
            while (k2 < this.numberOfTriangleFaces) {
                int i3;
                int n = i3 = this.triangleTSkin[k2];
                int n3 = ai1[n];
                ai1[n] = n3 + 1;
                this.triangleSkin[i3][n3] = k2++;
            }
            this.triangleTSkin = null;
            Object var1_1 = null;
        }
    }

    private final boolean cursorOn(int cursorX, int cursorY, int proj_vertex_yA, int proj_vertex_yB, int proj_vertex_yC, int proj_vertex_xA, int proj_vertex_xB, int proj_vertex_xC) {
        if (cursorY < proj_vertex_yA && cursorY < proj_vertex_yB && cursorY < proj_vertex_yC) {
            return false;
        }
        if (cursorY > proj_vertex_yA && cursorY > proj_vertex_yB && cursorY > proj_vertex_yC) {
            return false;
        }
        if (cursorX < proj_vertex_xA && cursorX < proj_vertex_xB && cursorX < proj_vertex_xC) {
            return false;
        }
        return cursorX <= proj_vertex_xA || cursorX <= proj_vertex_xB || cursorX <= proj_vertex_xC;
    }

    public void filterTriangles() {
        for (int triangleId = 0; triangleId < this.numberOfTriangleFaces; ++triangleId) {
            int l = this.face_a[triangleId];
            int k1 = this.face_b[triangleId];
            int j2_ = this.face_c[triangleId];
            boolean b = true;
            for (int triId = 0; triId < this.numberOfTriangleFaces; ++triId) {
                if (triId == triangleId) continue;
                if (this.face_a[triId] == l) {
                    b = false;
                    break;
                }
                if (this.face_b[triId] == k1) {
                    b = false;
                    break;
                }
                if (this.face_c[triId] != j2_) continue;
                b = false;
                break;
            }
            if (!b || this.face_render_type == null) continue;
            this.face_alpha[triangleId] = 255;
        }
    }

    public void light(int i, int j, int k, int l, int i1, boolean flag) {
        try {
            int j1 = (int)Math.sqrt(k * k + l * l + i1 * i1);
            int k1 = j * j1 >> 8;
            if (this.face_shade_a == null) {
                this.face_shade_a = new int[this.numberOfTriangleFaces];
                this.face_shade_b = new int[this.numberOfTriangleFaces];
                this.face_shade_c = new int[this.numberOfTriangleFaces];
            }
            if (this.vertexNormals == null) {
                this.vertexNormals = new VertexNormal[this.numberOfVerticeCoordinates];
                for (int l1 = 0; l1 < this.numberOfVerticeCoordinates; ++l1) {
                    this.vertexNormals[l1] = new VertexNormal();
                }
            }
            for (int i2 = 0; i2 < this.numberOfTriangleFaces; ++i2) {
                int j5;
                if (this.face_color != null && this.face_alpha != null && (this.face_color[i2] == 65535 || this.face_color[i2] == 1 || this.face_color[i2] == 16705 || this.face_color[i2] == 255)) {
                    this.face_alpha[i2] = 255;
                }
                int j2 = this.face_a[i2];
                int l2 = this.face_b[i2];
                int i3 = this.face_c[i2];
                int j3 = this.verticesXCoordinate[l2] - this.verticesXCoordinate[j2];
                int k3 = this.verticesYCoordinate[l2] - this.verticesYCoordinate[j2];
                int l3 = this.verticesZCoordinate[l2] - this.verticesZCoordinate[j2];
                int i4 = this.verticesXCoordinate[i3] - this.verticesXCoordinate[j2];
                int j4 = this.verticesYCoordinate[i3] - this.verticesYCoordinate[j2];
                int k4 = this.verticesZCoordinate[i3] - this.verticesZCoordinate[j2];
                int l4 = k3 * k4 - j4 * l3;
                int i5 = l3 * i4 - k4 * j3;
                for (j5 = j3 * j4 - i4 * k3; l4 > 8192 || i5 > 8192 || j5 > 8192 || l4 < -8192 || i5 < -8192 || j5 < -8192; l4 >>= 1, i5 >>= 1, j5 >>= 1) {
                }
                int k5 = (int)Math.sqrt(l4 * l4 + i5 * i5 + j5 * j5);
                if (k5 <= 0) {
                    k5 = 1;
                }
                l4 = l4 * 256 / k5;
                i5 = i5 * 256 / k5;
                j5 = j5 * 256 / k5;
                if (this.face_render_type == null || (this.face_render_type[i2] & 1) == 0) {
                    VertexNormal vNormal = this.vertexNormals[j2];
                    vNormal.anInt602 += l4;
                    vNormal.anInt603 += i5;
                    vNormal.anInt604 += j5;
                    ++vNormal.anInt605;
                    vNormal = this.vertexNormals[l2];
                    vNormal.anInt602 += l4;
                    vNormal.anInt603 += i5;
                    vNormal.anInt604 += j5;
                    ++vNormal.anInt605;
                    vNormal = this.vertexNormals[i3];
                    vNormal.anInt602 += l4;
                    vNormal.anInt603 += i5;
                    vNormal.anInt604 += j5;
                    ++vNormal.anInt605;
                    vNormal = null;
                    continue;
                }
                int l5 = i + (k * l4 + l * i5 + i1 * j5) / (k1 + k1 / 2);
                this.face_shade_a[i2] = Model.method481(this.face_color[i2], l5, this.face_render_type[i2]);
            }
            if (flag) {
                this.method480(i, k1, k, l, i1);
            } else {
                this.vertexNormalOffset = new VertexNormal[this.numberOfVerticeCoordinates];
                for (int k2 = 0; k2 < this.numberOfVerticeCoordinates; ++k2) {
                    VertexNormal vNormal = this.vertexNormals[k2];
                    this.vertexNormalOffset[k2] = new VertexNormal();
                    this.vertexNormalOffset[k2].anInt602 = vNormal.anInt602;
                    this.vertexNormalOffset[k2].anInt603 = vNormal.anInt603;
                    this.vertexNormalOffset[k2].anInt604 = vNormal.anInt604;
                    this.vertexNormalOffset[k2].anInt605 = vNormal.anInt605;
                }
            }
            if (flag) {
                this.calculateDiagonals();
                return;
            }
            this.calcDiagonalsAndStats(21073);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void method464(Model model, boolean flag) {
        this.numberOfVerticeCoordinates = model.numberOfVerticeCoordinates;
        this.numberOfTriangleFaces = model.numberOfTriangleFaces;
        this.numberOfTexturesFaces = model.numberOfTexturesFaces;
        if (anIntArray1622.length < this.numberOfVerticeCoordinates) {
            anIntArray1622 = new int[this.numberOfVerticeCoordinates + 10000];
            anIntArray1623 = new int[this.numberOfVerticeCoordinates + 10000];
            anIntArray1624 = new int[this.numberOfVerticeCoordinates + 10000];
        }
        this.verticesParticle = new int[this.numberOfVerticeCoordinates];
        this.verticesXCoordinate = anIntArray1622;
        this.verticesYCoordinate = anIntArray1623;
        this.verticesZCoordinate = anIntArray1624;
        for (int k = 0; k < this.numberOfVerticeCoordinates; ++k) {
            this.verticesParticle[k] = model.verticesParticle[k];
            this.verticesXCoordinate[k] = model.verticesXCoordinate[k];
            this.verticesYCoordinate[k] = model.verticesYCoordinate[k];
            this.verticesZCoordinate[k] = model.verticesZCoordinate[k];
        }
        if (flag) {
            this.face_alpha = model.face_alpha;
        } else {
            if (anIntArray1625.length < this.numberOfTriangleFaces) {
                anIntArray1625 = new int[this.numberOfTriangleFaces + 100];
            }
            this.face_alpha = anIntArray1625;
            if (model.face_alpha == null) {
                for (int l = 0; l < this.numberOfTriangleFaces; ++l) {
                    this.face_alpha[l] = 0;
                }
            } else {
                for (int i1 = 0; i1 < this.numberOfTriangleFaces; ++i1) {
                    this.face_alpha[i1] = model.face_alpha[i1];
                }
            }
        }
        this.face_render_type = model.face_render_type;
        this.face_color = model.face_color;
        this.face_render_priorities = model.face_render_priorities;
        this.face_priority = model.face_priority;
        this.triangleSkin = model.triangleSkin;
        this.vertexSkin = model.vertexSkin;
        this.face_a = model.face_a;
        this.face_b = model.face_b;
        this.face_c = model.face_c;
        this.face_shade_a = model.face_shade_a;
        this.face_shade_b = model.face_shade_b;
        this.face_shade_c = model.face_shade_c;
        this.textures_face_a = model.textures_face_a;
        this.textures_face_b = model.textures_face_b;
        this.textures_face_c = model.textures_face_c;
    }

    private final int method465(Model model, int i) {
        int j = -1;
        int var4 = model.verticesParticle[i];
        int k = model.verticesXCoordinate[i];
        int l = model.verticesYCoordinate[i];
        int i1 = model.verticesZCoordinate[i];
        for (int j1 = 0; j1 < this.numberOfVerticeCoordinates; ++j1) {
            if (k != this.verticesXCoordinate[j1] || l != this.verticesYCoordinate[j1] || i1 != this.verticesZCoordinate[j1]) continue;
            j = j1;
            break;
        }
        if (j == -1) {
            this.verticesParticle[this.numberOfVerticeCoordinates] = var4;
            this.verticesXCoordinate[this.numberOfVerticeCoordinates] = k;
            this.verticesYCoordinate[this.numberOfVerticeCoordinates] = l;
            this.verticesZCoordinate[this.numberOfVerticeCoordinates] = i1;
            if (model.vertexVSkin != null) {
                this.vertexVSkin[this.numberOfVerticeCoordinates] = model.vertexVSkin[i];
            }
            j = this.numberOfVerticeCoordinates++;
        }
        return j;
    }

    public void method1337(int j) {
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            this.face_color[k] = j;
        }
    }

    public void method1333(int j, int modelId, int npcId) {
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            for (int i = 0; i < NPCDef.forID((int)npcId).models.length; ++i) {
                if (modelId != NPCDef.forID((int)npcId).models[i]) continue;
                this.face_color[k] = j;
            }
        }
    }

    public void method1338(int j) {
        j += 100;
        int kcolor = 0;
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            kcolor = this.face_color[k];
            if (k + j < 0) continue;
            this.face_color[k] = kcolor + j;
        }
    }

    public void method1339(int j) {
        ++j;
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            if (k + j < 0) continue;
            this.face_color[k] = k + j;
        }
    }

    public void method471(int[] ai, int j, int k) {
        if (k == -1) {
            return;
        }
        if (ai == null || j == -1) {
            this.applyTransform(k);
            return;
        }
        FrameReader class36 = FrameReader.forID(k);
        if (class36 == null) {
            return;
        }
        FrameReader class36_1 = FrameReader.forID(j);
        if (class36_1 == null) {
            this.applyTransform(k);
            return;
        }
        SkinList class18 = class36.mySkinList;
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        int l = 0;
        int i1 = ai[l++];
        for (int j1 = 0; j1 < class36.stepCount; ++j1) {
            int k1 = class36.opCodeLinkTable[j1];
            while (k1 > i1) {
                i1 = ai[l++];
            }
            if (k1 == i1 && class18.opcodes[k1] != 0) continue;
            this.method472(class18.opcodes[k1], class18.skinList[k1], class36.xOffset[j1], class36.yOffset[j1], class36.zOffset[j1]);
        }
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        l = 0;
        i1 = ai[l++];
        try {
            for (int l1 = 0; l1 < class36_1.stepCount; ++l1) {
                int i2 = class36_1.opCodeLinkTable[l1];
                while (i2 > i1) {
                    i1 = ai[l++];
                }
                if (i2 != i1 && class18.opcodes[i2] != 0) continue;
                this.method472(class18.opcodes[i2], class18.skinList[i2], class36_1.xOffset[l1], class36_1.yOffset[l1], class36_1.zOffset[l1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method471_2(int[] mixingData, int j, int frameId, int frameId2) {
        FrameReader tween;
        if (frameId == -1) {
            return;
        }
        if (mixingData == null || j == -1) {
            this.applyTransform(frameId);
            return;
        }
        FrameReader class36 = FrameReader.forID(frameId);
        if (class36 == null) {
            return;
        }
        FrameReader class36_1 = FrameReader.forID(j);
        if (class36_1 == null) {
            this.applyTransform(frameId);
            return;
        }
        FrameReader fr = FrameReader.forID(frameId2);
        class36 = tween = FrameReader.getTween(class36_1, fr);
        SkinList class18 = class36.mySkinList;
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        int l = 0;
        int i1 = mixingData[l++];
        for (int j1 = 0; j1 < class36.stepCount; ++j1) {
            int k1 = class36.opCodeLinkTable[j1];
            while (k1 > i1) {
                i1 = mixingData[l++];
            }
            if (k1 == i1 && class18.opcodes[k1] != 0) continue;
            this.method472(class18.opcodes[k1], class18.skinList[k1], class36.xOffset[j1], class36.yOffset[j1], class36.zOffset[j1]);
        }
        anInt1681 = 0;
        anInt1682 = 0;
        anInt1683 = 0;
        l = 0;
        i1 = mixingData[l++];
        for (int l1 = 0; l1 < class36_1.stepCount; ++l1) {
            int i2 = class36_1.opCodeLinkTable[l1];
            while (i2 > i1) {
                i1 = mixingData[l++];
            }
            if (i2 != i1 && class18.opcodes[i2] != 0) continue;
            this.method472(class18.opcodes[i2], class18.skinList[i2], class36_1.xOffset[l1], class36_1.yOffset[l1], class36_1.zOffset[l1]);
        }
    }

    private void method472(int animationType, int[] skin, int xOffset, int yOffset, int zOffset) {
        if (skin == null || this.vertexSkin == null) {
            return;
        }
        int i1 = skin.length;
        if (animationType == 0) {
            int j1 = 0;
            anInt1681 = 0;
            anInt1682 = 0;
            anInt1683 = 0;
            for (int k2 = 0; k2 < i1; ++k2) {
                int[] ai5;
                int l3 = skin[k2];
                if (l3 >= this.vertexSkin.length || (ai5 = this.vertexSkin[l3]) == null) continue;
                for (int i5 = 0; i5 < ai5.length; ++i5) {
                    int j6 = ai5[i5];
                    anInt1681 += this.verticesXCoordinate[j6];
                    anInt1682 += this.verticesYCoordinate[j6];
                    anInt1683 += this.verticesZCoordinate[j6];
                    ++j1;
                }
            }
            if (j1 > 0) {
                anInt1681 = anInt1681 / j1 + xOffset;
                anInt1682 = anInt1682 / j1 + yOffset;
                anInt1683 = anInt1683 / j1 + zOffset;
                return;
            }
            anInt1681 = xOffset;
            anInt1682 = yOffset;
            anInt1683 = zOffset;
            return;
        }
        if (animationType == 1) {
            for (int k1 = 0; k1 < i1; ++k1) {
                int l2 = skin[k1];
                if (l2 >= this.vertexSkin.length) continue;
                int[] ai1 = this.vertexSkin[l2];
                for (int i4 = 0; i4 < ai1.length; ++i4) {
                    int j5;
                    int n = j5 = ai1[i4];
                    this.verticesXCoordinate[n] = this.verticesXCoordinate[n] + xOffset;
                    int n2 = j5;
                    this.verticesYCoordinate[n2] = this.verticesYCoordinate[n2] + yOffset;
                    int n3 = j5;
                    this.verticesZCoordinate[n3] = this.verticesZCoordinate[n3] + zOffset;
                }
            }
            return;
        }
        if (animationType == 2) {
            for (int l1 = 0; l1 < i1; ++l1) {
                int i3 = skin[l1];
                if (i3 >= this.vertexSkin.length) continue;
                int[] ai2 = this.vertexSkin[i3];
                for (int j4 = 0; j4 < ai2.length; ++j4) {
                    int k5;
                    int n = k5 = ai2[j4];
                    this.verticesXCoordinate[n] = this.verticesXCoordinate[n] - anInt1681;
                    int n4 = k5;
                    this.verticesYCoordinate[n4] = this.verticesYCoordinate[n4] - anInt1682;
                    int n5 = k5;
                    this.verticesZCoordinate[n5] = this.verticesZCoordinate[n5] - anInt1683;
                    if (zOffset != 0) {
                        int j7 = SINE[zOffset];
                        int i8 = COSINE[zOffset];
                        int l8 = this.verticesYCoordinate[k5] * j7 + this.verticesXCoordinate[k5] * i8 >> 16;
                        this.verticesYCoordinate[k5] = this.verticesYCoordinate[k5] * i8 - this.verticesXCoordinate[k5] * j7 >> 16;
                        this.verticesXCoordinate[k5] = l8;
                    }
                    if (xOffset != 0) {
                        int k7 = SINE[xOffset];
                        int j8 = COSINE[xOffset];
                        int i9 = this.verticesYCoordinate[k5] * j8 - this.verticesZCoordinate[k5] * k7 >> 16;
                        this.verticesZCoordinate[k5] = this.verticesYCoordinate[k5] * k7 + this.verticesZCoordinate[k5] * j8 >> 16;
                        this.verticesYCoordinate[k5] = i9;
                    }
                    if (yOffset != 0) {
                        int l7 = SINE[yOffset];
                        int k8 = COSINE[yOffset];
                        int j9 = this.verticesZCoordinate[k5] * l7 + this.verticesXCoordinate[k5] * k8 >> 16;
                        this.verticesZCoordinate[k5] = this.verticesZCoordinate[k5] * k8 - this.verticesXCoordinate[k5] * l7 >> 16;
                        this.verticesXCoordinate[k5] = j9;
                    }
                    int n6 = k5;
                    this.verticesXCoordinate[n6] = this.verticesXCoordinate[n6] + anInt1681;
                    int n7 = k5;
                    this.verticesYCoordinate[n7] = this.verticesYCoordinate[n7] + anInt1682;
                    int n8 = k5;
                    this.verticesZCoordinate[n8] = this.verticesZCoordinate[n8] + anInt1683;
                }
            }
            return;
        }
        if (animationType == 3) {
            for (int i2 = 0; i2 < i1; ++i2) {
                int j3 = skin[i2];
                if (j3 >= this.vertexSkin.length) continue;
                int[] ai3 = this.vertexSkin[j3];
                for (int k4 = 0; k4 < ai3.length; ++k4) {
                    int l5;
                    int n = l5 = ai3[k4];
                    this.verticesXCoordinate[n] = this.verticesXCoordinate[n] - anInt1681;
                    int n9 = l5;
                    this.verticesYCoordinate[n9] = this.verticesYCoordinate[n9] - anInt1682;
                    int n10 = l5;
                    this.verticesZCoordinate[n10] = this.verticesZCoordinate[n10] - anInt1683;
                    this.verticesXCoordinate[l5] = this.verticesXCoordinate[l5] * xOffset / 128;
                    this.verticesYCoordinate[l5] = this.verticesYCoordinate[l5] * yOffset / 128;
                    this.verticesZCoordinate[l5] = this.verticesZCoordinate[l5] * zOffset / 128;
                    int n11 = l5;
                    this.verticesXCoordinate[n11] = this.verticesXCoordinate[n11] + anInt1681;
                    int n12 = l5;
                    this.verticesYCoordinate[n12] = this.verticesYCoordinate[n12] + anInt1682;
                    int n13 = l5;
                    this.verticesZCoordinate[n13] = this.verticesZCoordinate[n13] + anInt1683;
                }
            }
            return;
        }
        if (animationType == 5 && this.triangleSkin != null && this.face_alpha != null) {
            for (int j2 = 0; j2 < i1; ++j2) {
                int k3 = skin[j2];
                if (k3 >= this.triangleSkin.length) continue;
                int[] ai4 = this.triangleSkin[k3];
                for (int l4 = 0; l4 < ai4.length; ++l4) {
                    int i6;
                    int n = i6 = ai4[l4];
                    this.face_alpha[n] = this.face_alpha[n] + xOffset * 8;
                    if (this.face_alpha[i6] < 0) {
                        this.face_alpha[i6] = 0;
                    }
                    if (this.face_alpha[i6] <= 255) continue;
                    this.face_alpha[i6] = 255;
                }
            }
        }
    }

    public void method480(int i, int j, int k, int l, int i1) {
        for (int j1 = 0; j1 < this.numberOfTriangleFaces; ++j1) {
            int k1 = this.face_a[j1];
            int i2 = this.face_b[j1];
            int j2 = this.face_c[j1];
            if (this.face_render_type == null) {
                int i3 = this.face_color[j1];
                VertexNormal class33 = this.vertexNormals[k1];
                int k2 = i + (k * class33.anInt602 + l * class33.anInt603 + i1 * class33.anInt604) / (j * class33.anInt605);
                this.face_shade_a[j1] = Model.method481(i3, k2, 0);
                class33 = this.vertexNormals[i2];
                k2 = i + (k * class33.anInt602 + l * class33.anInt603 + i1 * class33.anInt604) / (j * class33.anInt605);
                this.face_shade_b[j1] = Model.method481(i3, k2, 0);
                class33 = this.vertexNormals[j2];
                k2 = i + (k * class33.anInt602 + l * class33.anInt603 + i1 * class33.anInt604) / (j * class33.anInt605);
                this.face_shade_c[j1] = Model.method481(i3, k2, 0);
                continue;
            }
            if ((this.face_render_type[j1] & 1) != 0) continue;
            int j3 = this.face_color[j1];
            int k3 = this.face_render_type[j1];
            VertexNormal class33_1 = this.vertexNormals[k1];
            int l2 = i + (k * class33_1.anInt602 + l * class33_1.anInt603 + i1 * class33_1.anInt604) / (j * class33_1.anInt605);
            this.face_shade_a[j1] = Model.method481(j3, l2, k3);
            class33_1 = this.vertexNormals[i2];
            l2 = i + (k * class33_1.anInt602 + l * class33_1.anInt603 + i1 * class33_1.anInt604) / (j * class33_1.anInt605);
            this.face_shade_b[j1] = Model.method481(j3, l2, k3);
            class33_1 = this.vertexNormals[j2];
            l2 = i + (k * class33_1.anInt602 + l * class33_1.anInt603 + i1 * class33_1.anInt604) / (j * class33_1.anInt605);
            this.face_shade_c[j1] = Model.method481(j3, l2, k3);
        }
        this.vertexNormals = null;
        this.vertexNormalOffset = null;
        this.vertexVSkin = null;
        this.triangleTSkin = null;
        if (this.face_render_type != null) {
            for (int l1 = 0; l1 < this.numberOfTriangleFaces; ++l1) {
                if ((this.face_render_type[l1] & 2) != 2) continue;
                return;
            }
        }
    }

    public void mirrorModel() {
        for (int j = 0; j < this.numberOfVerticeCoordinates; ++j) {
            this.verticesZCoordinate[j] = -this.verticesZCoordinate[j];
        }
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            int l = this.face_a[k];
            this.face_a[k] = this.face_c[k];
            this.face_c[k] = l;
        }
    }

    public void normalise() {
        this.modelHeight = 0;
        this.anInt1651 = 0;
        for (int i = 0; i < this.numberOfVerticeCoordinates; ++i) {
            int j = this.verticesYCoordinate[i];
            if (-j > this.modelHeight) {
                this.modelHeight = -j;
            }
            if (j <= this.anInt1651) continue;
            this.anInt1651 = j;
        }
        this.anInt1653 = (int)(Math.sqrt(this.anInt1650 * this.anInt1650 + this.modelHeight * this.modelHeight) + 0.99);
        this.diagonal3D = this.anInt1653 + (int)(Math.sqrt(this.anInt1650 * this.anInt1650 + this.anInt1651 * this.anInt1651) + 0.99);
    }

    private final void rasterise(int i) {
        if (outOfReach[i]) {
            this.reduce(i);
            return;
        }
        int j = this.face_a[i];
        int k = this.face_b[i];
        int l = this.face_c[i];
        Rasterizer.restrict_edges = hasAnEdgeToRestrict[i];
        Rasterizer.alpha = this.face_alpha == null ? 0 : this.face_alpha[i];
        int i1 = this.face_render_type == null ? 0 : this.face_render_type[i] & 3;
        if (i1 == 0) {
            Rasterizer.drawDepthShadedTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], projected_vertex_z[j], projected_vertex_z[k], projected_vertex_z[l], this.face_shade_a[i], this.face_shade_b[i], this.face_shade_c[i]);
            return;
        }
        if (i1 == 1) {
            Rasterizer.drawDepthFlatTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], projected_vertex_z[j], projected_vertex_z[k], projected_vertex_z[l], hsl2rgb[this.face_shade_a[i]]);
            return;
        }
        if (i1 == 2) {
            int j1 = this.face_render_type[i] >> 2;
            int l1 = this.textures_face_a[j1];
            int j2 = this.textures_face_b[j1];
            int l2 = this.textures_face_c[j1];
            if (Client.getOption("hd_tex")) {
                Rasterizer.drawTexturedTriangle_model(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], projected_vertex_z[j], projected_vertex_z[k], projected_vertex_z[l], this.face_shade_a[i], this.face_shade_b[i], this.face_shade_c[i], camera_vertex_y[l1], camera_vertex_y[j2], camera_vertex_y[l2], camera_vertex_x[l1], camera_vertex_x[j2], camera_vertex_x[l2], camera_vertex_z[l1], camera_vertex_z[j2], camera_vertex_z[l2], this.face_color[i], this.face_color[i], false, false);
            } else {
                Rasterizer.drawDepthTexturedTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], projected_vertex_z[j], projected_vertex_z[k], projected_vertex_z[l], this.face_shade_a[i], this.face_shade_b[i], this.face_shade_c[i], camera_vertex_y[l1], camera_vertex_y[j2], camera_vertex_y[l2], camera_vertex_x[l1], camera_vertex_x[j2], camera_vertex_x[l2], camera_vertex_z[l1], camera_vertex_z[j2], camera_vertex_z[l2], this.face_color[i]);
            }
            return;
        }
        if (i1 == 3) {
            int k1 = this.face_render_type[i] >> 2;
            int i2 = this.textures_face_a[k1];
            int k2 = this.textures_face_b[k1];
            int i3 = this.textures_face_c[k1];
            if (Client.getOption("hd_tex")) {
                Rasterizer.drawTexturedTriangle_model(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], projected_vertex_z[j], projected_vertex_z[k], projected_vertex_z[l], this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[i2], camera_vertex_y[k2], camera_vertex_y[i3], camera_vertex_x[i2], camera_vertex_x[k2], camera_vertex_x[i3], camera_vertex_z[i2], camera_vertex_z[k2], camera_vertex_z[i3], this.face_color[i], this.face_color[i], false, false);
            } else {
                Rasterizer.drawDepthTexturedTriangle(projected_vertex_y[j], projected_vertex_y[k], projected_vertex_y[l], projected_vertex_x[j], projected_vertex_x[k], projected_vertex_x[l], projected_vertex_z[j], projected_vertex_z[k], projected_vertex_z[l], this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[i2], camera_vertex_y[k2], camera_vertex_y[i3], camera_vertex_x[i2], camera_vertex_x[k2], camera_vertex_x[i3], camera_vertex_z[i2], camera_vertex_z[k2], camera_vertex_z[i3], this.face_color[i]);
            }
        }
    }

    public void read525Model(byte[] abyte0, int modelID) {
        int k5;
        Stream nc1 = new Stream(abyte0);
        Stream nc2 = new Stream(abyte0);
        Stream nc3 = new Stream(abyte0);
        Stream nc4 = new Stream(abyte0);
        Stream nc5 = new Stream(abyte0);
        Stream nc6 = new Stream(abyte0);
        Stream nc7 = new Stream(abyte0);
        nc1.currentOffset = abyte0.length - 23;
        int numVertices = nc1.readUnsignedWord();
        int numTriangles = nc1.readUnsignedWord();
        int numTexTriangles = nc1.readUnsignedByte();
        ModelHeader ModelDef_1 = Model.modelHeader[modelID] = new ModelHeader();
        ModelDef_1.modelData = abyte0;
        ModelDef_1.verticeCount = numVertices;
        ModelDef_1.triangleCount = numTriangles;
        ModelDef_1.texturedTriangleCount = numTexTriangles;
        int l1 = nc1.readUnsignedByte();
        boolean bool = ~(1 & l1) == -2;
        boolean bool_78_ = ~(l1 & 2) == -3;
        int i2 = nc1.readUnsignedByte();
        int j2 = nc1.readUnsignedByte();
        int k2 = nc1.readUnsignedByte();
        int l2 = nc1.readUnsignedByte();
        int i3 = nc1.readUnsignedByte();
        int j3 = nc1.readUnsignedWord();
        int k3 = nc1.readUnsignedWord();
        int l3 = nc1.readUnsignedWord();
        int i4 = nc1.readUnsignedWord();
        int j4 = nc1.readUnsignedWord();
        int k4 = 0;
        int l4 = 0;
        int i5 = 0;
        int v = 0;
        int hb = 0;
        int P = 0;
        byte G = 0;
        byte[] x = null;
        byte[] O = null;
        byte[] J = null;
        byte[] F = null;
        byte[] cb = null;
        byte[] gb = null;
        byte[] lb = null;
        Object ab = null;
        int[] kb = null;
        int[] y = null;
        int[] N = null;
        short[] D = null;
        int[] triangleColours2 = new int[numTriangles];
        if (numTexTriangles > 0) {
            O = new byte[numTexTriangles];
            nc1.currentOffset = 0;
            for (int j5 = 0; j5 < numTexTriangles; ++j5) {
                O[j5] = nc1.readSignedByte();
                byte byte0 = O[j5];
                if (byte0 == 0) {
                    ++k4;
                }
                if (byte0 >= 1 && byte0 <= 3) {
                    ++l4;
                }
                if (byte0 != 2) continue;
                ++i5;
            }
        }
        int l5 = k5 = numTexTriangles;
        int i6 = k5 += numVertices;
        if (l1 == 1) {
            k5 += numTriangles;
        }
        int j6 = k5;
        int k6 = k5 += numTriangles;
        if (i2 == 255) {
            k5 += numTriangles;
        }
        int l6 = k5;
        if (k2 == 1) {
            k5 += numTriangles;
        }
        int i7 = k5;
        if (i3 == 1) {
            k5 += numVertices;
        }
        int j7 = k5;
        if (j2 == 1) {
            k5 += numTriangles;
        }
        int k7 = k5;
        int l7 = k5 += i4;
        if (l2 == 1) {
            k5 += numTriangles * 2;
        }
        int i8 = k5;
        int j8 = k5 += j4;
        int k8 = k5 += numTriangles * 2;
        int l8 = k5 += j3;
        int i9 = k5 += k3;
        int j9 = k5 += l3;
        int k9 = k5 += k4 * 6;
        int l9 = k5 += l4 * 6;
        int i10 = k5 += l4 * 6;
        int j10 = k5 += l4;
        int k10 = k5 += l4;
        k5 += l4 + i5 * 2;
        v = numVertices;
        hb = numTriangles;
        P = numTexTriangles;
        this.verticesParticle = new int[numVertices];
        int[] vertexX = new int[numVertices];
        int[] vertexY = new int[numVertices];
        int[] vertexZ = new int[numVertices];
        int[] facePoint1 = new int[numTriangles];
        int[] facePoint2 = new int[numTriangles];
        int[] facePoint3 = new int[numTriangles];
        this.vertexVSkin = new int[numVertices];
        this.face_render_type = new int[numTriangles];
        this.face_render_priorities = new int[numTriangles];
        this.face_alpha = new int[numTriangles];
        this.triangleTSkin = new int[numTriangles];
        if (i3 == 1) {
            this.vertexVSkin = new int[numVertices];
        }
        if (bool) {
            this.face_render_type = new int[numTriangles];
        }
        if (i2 == 255) {
            this.face_render_priorities = new int[numTriangles];
        } else {
            G = (byte)i2;
        }
        if (j2 == 1) {
            this.face_alpha = new int[numTriangles];
        }
        if (k2 == 1) {
            this.triangleTSkin = new int[numTriangles];
        }
        if (l2 == 1) {
            D = new short[numTriangles];
        }
        if (l2 == 1 && numTexTriangles > 0) {
            x = new byte[numTriangles];
        }
        triangleColours2 = new int[numTriangles];
        int i_115_ = k5;
        int[] texTrianglesPoint1 = null;
        int[] texTrianglesPoint2 = null;
        int[] texTrianglesPoint3 = null;
        if (numTexTriangles > 0) {
            texTrianglesPoint1 = new int[numTexTriangles];
            texTrianglesPoint2 = new int[numTexTriangles];
            texTrianglesPoint3 = new int[numTexTriangles];
            if (l4 > 0) {
                kb = new int[l4];
                N = new int[l4];
                y = new int[l4];
                gb = new byte[l4];
                lb = new byte[l4];
                F = new byte[l4];
            }
            if (i5 > 0) {
                cb = new byte[i5];
                J = new byte[i5];
            }
        }
        nc1.currentOffset = l5;
        nc2.currentOffset = k8;
        nc3.currentOffset = l8;
        nc4.currentOffset = i9;
        nc5.currentOffset = i7;
        int l10 = 0;
        int i11 = 0;
        int j11 = 0;
        for (int k11 = 0; k11 < numVertices; ++k11) {
            int l11 = nc1.readUnsignedByte();
            int j12 = 0;
            if ((l11 & 1) != 0) {
                j12 = nc2.method421();
            }
            int l12 = 0;
            if ((l11 & 2) != 0) {
                l12 = nc3.method421();
            }
            int j13 = 0;
            if ((l11 & 4) != 0) {
                j13 = nc4.method421();
            }
            vertexX[k11] = l10 + j12;
            vertexY[k11] = i11 + l12;
            vertexZ[k11] = j11 + j13;
            l10 = vertexX[k11];
            i11 = vertexY[k11];
            j11 = vertexZ[k11];
            if (this.vertexVSkin == null) continue;
            this.vertexVSkin[k11] = nc5.readUnsignedByte();
        }
        nc1.currentOffset = j8;
        nc2.currentOffset = i6;
        nc3.currentOffset = k6;
        nc4.currentOffset = j7;
        nc5.currentOffset = l6;
        nc6.currentOffset = l7;
        nc7.currentOffset = i8;
        for (int i12 = 0; i12 < numTriangles; ++i12) {
            triangleColours2[i12] = nc1.readUnsignedWord();
            if (l1 == 1) {
                this.face_render_type[i12] = nc2.readSignedByte();
                if (this.face_render_type[i12] == 2) {
                    triangleColours2[i12] = 65535;
                }
                this.face_render_type[i12] = 0;
            }
            if (i2 == 255) {
                this.face_render_priorities[i12] = nc3.readSignedByte();
            }
            if (j2 == 1) {
                this.face_alpha[i12] = nc4.readSignedByte();
                if (this.face_alpha[i12] < 0) {
                    this.face_alpha[i12] = 256 + this.face_alpha[i12];
                }
            }
            if (k2 == 1) {
                this.triangleTSkin[i12] = nc5.readUnsignedByte();
            }
            if (l2 == 1) {
                D[i12] = (short)(nc6.readUnsignedWord() - 1);
            }
            if (x == null) continue;
            x[i12] = D[i12] != -1 ? (int)(nc7.readUnsignedByte() - 1) : -1;
        }
        nc1.currentOffset = k7;
        nc2.currentOffset = j6;
        int k12 = 0;
        int i13 = 0;
        int k13 = 0;
        int l13 = 0;
        for (int i14 = 0; i14 < numTriangles; ++i14) {
            int j14 = nc2.readUnsignedByte();
            if (j14 == 1) {
                l13 = k12 = nc1.method421() + l13;
                l13 = i13 = nc1.method421() + l13;
                l13 = k13 = nc1.method421() + l13;
                facePoint1[i14] = k12;
                facePoint2[i14] = i13;
                facePoint3[i14] = k13;
            }
            if (j14 == 2) {
                i13 = k13;
                l13 = k13 = nc1.method421() + l13;
                facePoint1[i14] = k12;
                facePoint2[i14] = i13;
                facePoint3[i14] = k13;
            }
            if (j14 == 3) {
                k12 = k13;
                l13 = k13 = nc1.method421() + l13;
                facePoint1[i14] = k12;
                facePoint2[i14] = i13;
                facePoint3[i14] = k13;
            }
            if (j14 != 4) continue;
            int l14 = k12;
            k12 = i13;
            i13 = l14;
            l13 = k13 = nc1.method421() + l13;
            facePoint1[i14] = k12;
            facePoint2[i14] = i13;
            facePoint3[i14] = k13;
        }
        nc1.currentOffset = j9;
        nc2.currentOffset = k9;
        nc3.currentOffset = l9;
        nc4.currentOffset = i10;
        nc5.currentOffset = j10;
        nc6.currentOffset = k10;
        for (int k14 = 0; k14 < numTexTriangles; ++k14) {
            int i15 = O[k14] & 0xFF;
            if (i15 == 0) {
                texTrianglesPoint1[k14] = nc1.readUnsignedWord();
                texTrianglesPoint2[k14] = nc1.readUnsignedWord();
                texTrianglesPoint3[k14] = nc1.readUnsignedWord();
            }
            if (i15 == 1) {
                texTrianglesPoint1[k14] = nc2.readUnsignedWord();
                texTrianglesPoint2[k14] = nc2.readUnsignedWord();
                texTrianglesPoint3[k14] = nc2.readUnsignedWord();
                kb[k14] = nc3.readUnsignedWord();
                N[k14] = nc3.readUnsignedWord();
                y[k14] = nc3.readUnsignedWord();
                gb[k14] = nc4.readSignedByte();
                lb[k14] = nc5.readSignedByte();
                F[k14] = nc6.readSignedByte();
            }
            if (i15 == 2) {
                texTrianglesPoint1[k14] = nc2.readUnsignedWord();
                texTrianglesPoint2[k14] = nc2.readUnsignedWord();
                texTrianglesPoint3[k14] = nc2.readUnsignedWord();
                kb[k14] = nc3.readUnsignedWord();
                N[k14] = nc3.readUnsignedWord();
                y[k14] = nc3.readUnsignedWord();
                gb[k14] = nc4.readSignedByte();
                lb[k14] = nc5.readSignedByte();
                F[k14] = nc6.readSignedByte();
                cb[k14] = nc6.readSignedByte();
                J[k14] = nc6.readSignedByte();
            }
            if (i15 != 3) continue;
            texTrianglesPoint1[k14] = nc2.readUnsignedWord();
            texTrianglesPoint2[k14] = nc2.readUnsignedWord();
            texTrianglesPoint3[k14] = nc2.readUnsignedWord();
            kb[k14] = nc3.readUnsignedWord();
            N[k14] = nc3.readUnsignedWord();
            y[k14] = nc3.readUnsignedWord();
            gb[k14] = nc4.readSignedByte();
            lb[k14] = nc5.readSignedByte();
            F[k14] = nc6.readSignedByte();
        }
        if (i2 != 255) {
            for (int i12 = 0; i12 < numTriangles; ++i12) {
                this.face_render_priorities[i12] = i2;
            }
        }
        this.face_color = triangleColours2;
        this.numberOfVerticeCoordinates = numVertices;
        this.numberOfTriangleFaces = numTriangles;
        this.verticesXCoordinate = vertexX;
        this.verticesYCoordinate = vertexY;
        this.verticesZCoordinate = vertexZ;
        this.face_a = facePoint1;
        this.face_b = facePoint2;
        this.face_c = facePoint3;
        this.filterTriangles();
    }

    public void read622Model(byte[] abyte0, int modelID) {
        int k5;
        boolean bool_26_;
        Stream nc1 = new Stream(abyte0);
        Stream nc2 = new Stream(abyte0);
        Stream nc3 = new Stream(abyte0);
        Stream nc4 = new Stream(abyte0);
        Stream nc5 = new Stream(abyte0);
        Stream nc6 = new Stream(abyte0);
        Stream nc7 = new Stream(abyte0);
        nc1.currentOffset = abyte0.length - 23;
        int numVertices = nc1.readUnsignedWord();
        int numTriangles = nc1.readUnsignedWord();
        int numTexTriangles = nc1.readUnsignedByte();
        ModelHeader ModelDef_1 = Model.modelHeader[modelID] = new ModelHeader();
        ModelDef_1.modelData = abyte0;
        ModelDef_1.verticeCount = numVertices;
        ModelDef_1.triangleCount = numTriangles;
        ModelDef_1.texturedTriangleCount = numTexTriangles;
        int l1 = nc1.readUnsignedByte();
        boolean bool = ~(1 & l1) == -2;
        boolean bool_78_ = ~(l1 & 2) == -3;
        boolean bool_25_ = (4 & l1) == 4;
        boolean bl = bool_26_ = (8 & l1) == 8;
        if (!bool_26_) {
            this.read525Model(abyte0, modelID);
            return;
        }
        int newformat = 0;
        if (bool_26_) {
            nc1.currentOffset -= 7;
            newformat = nc1.readUnsignedByte();
            nc1.currentOffset += 6;
        }
        if (newformat == 15) {
            Model.newmodel[modelID] = true;
        }
        int i2 = nc1.readUnsignedByte();
        int j2 = nc1.readUnsignedByte();
        int k2 = nc1.readUnsignedByte();
        int l2 = nc1.readUnsignedByte();
        int i3 = nc1.readUnsignedByte();
        int j3 = nc1.readUnsignedWord();
        int k3 = nc1.readUnsignedWord();
        int l3 = nc1.readUnsignedWord();
        int i4 = nc1.readUnsignedWord();
        int j4 = nc1.readUnsignedWord();
        int k4 = 0;
        int l4 = 0;
        int i5 = 0;
        int v = 0;
        int hb = 0;
        int P = 0;
        byte G = 0;
        byte[] x = null;
        byte[] O = null;
        byte[] J = null;
        byte[] F = null;
        byte[] cb = null;
        byte[] gb = null;
        byte[] lb = null;
        Object ab = null;
        int[] kb = null;
        int[] y = null;
        int[] N = null;
        short[] D = null;
        int[] triangleColours2 = new int[numTriangles];
        if (numTexTriangles > 0) {
            O = new byte[numTexTriangles];
            nc1.currentOffset = 0;
            for (int j5 = 0; j5 < numTexTriangles; ++j5) {
                O[j5] = nc1.readSignedByte();
                byte byte0 = O[j5];
                if (byte0 == 0) {
                    ++k4;
                }
                if (byte0 >= 1 && byte0 <= 3) {
                    ++l4;
                }
                if (byte0 != 2) continue;
                ++i5;
            }
        }
        int l5 = k5 = numTexTriangles;
        int i6 = k5 += numVertices;
        if (bool) {
            k5 += numTriangles;
        }
        if (l1 == 1) {
            k5 += numTriangles;
        }
        int j6 = k5;
        int k6 = k5 += numTriangles;
        if (i2 == 255) {
            k5 += numTriangles;
        }
        int l6 = k5;
        if (k2 == 1) {
            k5 += numTriangles;
        }
        int i7 = k5;
        if (i3 == 1) {
            k5 += numVertices;
        }
        int j7 = k5;
        if (j2 == 1) {
            k5 += numTriangles;
        }
        int k7 = k5;
        int l7 = k5 += i4;
        if (l2 == 1) {
            k5 += numTriangles * 2;
        }
        int i8 = k5;
        int j8 = k5 += j4;
        int k8 = k5 += numTriangles * 2;
        int l8 = k5 += j3;
        int i9 = k5 += k3;
        int j9 = k5 += l3;
        int k9 = k5 += k4 * 6;
        k5 += l4 * 6;
        int i_59_ = 6;
        if (newformat != 14) {
            if (newformat >= 15) {
                i_59_ = 9;
            }
        } else {
            i_59_ = 7;
        }
        int l9 = k5;
        int i10 = k5 += i_59_ * l4;
        int j10 = k5 += l4;
        int k10 = k5 += l4;
        k5 += l4 + i5 * 2;
        v = numVertices;
        hb = numTriangles;
        P = numTexTriangles;
        this.verticesParticle = new int[numVertices];
        int[] vertexX = new int[numVertices];
        int[] vertexY = new int[numVertices];
        int[] vertexZ = new int[numVertices];
        int[] facePoint1 = new int[numTriangles];
        int[] facePoint2 = new int[numTriangles];
        int[] facePoint3 = new int[numTriangles];
        this.vertexVSkin = new int[numVertices];
        this.face_render_type = new int[numTriangles];
        this.face_render_priorities = new int[numTriangles];
        this.face_alpha = new int[numTriangles];
        this.triangleTSkin = new int[numTriangles];
        if (i3 == 1) {
            this.vertexVSkin = new int[numVertices];
        }
        if (bool) {
            this.face_render_type = new int[numTriangles];
        }
        if (i2 == 255) {
            this.face_render_priorities = new int[numTriangles];
        } else {
            G = (byte)i2;
        }
        if (j2 == 1) {
            this.face_alpha = new int[numTriangles];
        }
        if (k2 == 1) {
            this.triangleTSkin = new int[numTriangles];
        }
        if (l2 == 1) {
            D = new short[numTriangles];
        }
        if (l2 == 1 && numTexTriangles > 0) {
            x = new byte[numTriangles];
        }
        triangleColours2 = new int[numTriangles];
        int i_115_ = k5;
        int[] texTrianglesPoint1 = null;
        int[] texTrianglesPoint2 = null;
        int[] texTrianglesPoint3 = null;
        if (numTexTriangles > 0) {
            texTrianglesPoint1 = new int[numTexTriangles];
            texTrianglesPoint2 = new int[numTexTriangles];
            texTrianglesPoint3 = new int[numTexTriangles];
            if (l4 > 0) {
                kb = new int[l4];
                N = new int[l4];
                y = new int[l4];
                gb = new byte[l4];
                lb = new byte[l4];
                F = new byte[l4];
            }
            if (i5 > 0) {
                cb = new byte[i5];
                J = new byte[i5];
            }
        }
        nc1.currentOffset = l5;
        nc2.currentOffset = k8;
        nc3.currentOffset = l8;
        nc4.currentOffset = i9;
        nc5.currentOffset = i7;
        int l10 = 0;
        int i11 = 0;
        int j11 = 0;
        for (int k11 = 0; k11 < numVertices; ++k11) {
            int l11 = nc1.readUnsignedByte();
            int j12 = 0;
            if ((l11 & 1) != 0) {
                j12 = nc2.method421();
            }
            int l12 = 0;
            if ((l11 & 2) != 0) {
                l12 = nc3.method421();
            }
            int j13 = 0;
            if ((l11 & 4) != 0) {
                j13 = nc4.method421();
            }
            vertexX[k11] = l10 + j12;
            vertexY[k11] = i11 + l12;
            vertexZ[k11] = j11 + j13;
            l10 = vertexX[k11];
            i11 = vertexY[k11];
            j11 = vertexZ[k11];
            if (this.vertexVSkin == null) continue;
            this.vertexVSkin[k11] = nc5.readUnsignedByte();
        }
        nc1.currentOffset = j8;
        nc2.currentOffset = i6;
        nc3.currentOffset = k6;
        nc4.currentOffset = j7;
        nc5.currentOffset = l6;
        nc6.currentOffset = l7;
        nc7.currentOffset = i8;
        for (int i12 = 0; i12 < numTriangles; ++i12) {
            triangleColours2[i12] = nc1.readUnsignedWord();
            if (l1 == 1) {
                this.face_render_type[i12] = nc2.readSignedByte();
                if (this.face_render_type[i12] == 2) {
                    triangleColours2[i12] = 65535;
                }
                this.face_render_type[i12] = 0;
            }
            if (i2 == 255) {
                this.face_render_priorities[i12] = nc3.readSignedByte();
            }
            if (j2 == 1) {
                this.face_alpha[i12] = nc4.readSignedByte();
                if (this.face_alpha[i12] < 0) {
                    this.face_alpha[i12] = 256 + this.face_alpha[i12];
                }
            }
            if (k2 == 1) {
                this.triangleTSkin[i12] = nc5.readUnsignedByte();
            }
            if (l2 == 1) {
                D[i12] = (short)(nc6.readUnsignedWord() - 1);
            }
            if (x == null) continue;
            x[i12] = D[i12] != -1 ? (int)(nc7.readUnsignedByte() - 1) : -1;
        }
        nc1.currentOffset = k7;
        nc2.currentOffset = j6;
        int point1 = 0;
        int point2 = 0;
        int point3 = 0;
        int offset = 0;
        for (int i14 = 0; i14 < numTriangles; ++i14) {
            int triangleType = nc2.readUnsignedByte();
            if (triangleType == 1) {
                offset = point1 = nc1.method421() + offset;
                offset = point2 = nc1.method421() + offset;
                offset = point3 = nc1.method421() + offset;
                facePoint1[i14] = point1;
                facePoint2[i14] = point2;
                facePoint3[i14] = point3;
            }
            if (triangleType == 2) {
                point2 = point3;
                offset = point3 = nc1.method421() + offset;
                facePoint1[i14] = point1;
                facePoint2[i14] = point2;
                facePoint3[i14] = point3;
            }
            if (triangleType == 3) {
                point1 = point3;
                offset = point3 = nc1.method421() + offset;
                facePoint1[i14] = point1;
                facePoint2[i14] = point2;
                facePoint3[i14] = point3;
            }
            if (triangleType != 4) continue;
            int pointOffset = point1;
            point1 = point2;
            point2 = pointOffset;
            offset = point3 = nc1.method421() + offset;
            facePoint1[i14] = point1;
            facePoint2[i14] = point2;
            facePoint3[i14] = point3;
        }
        nc1.currentOffset = j9;
        nc2.currentOffset = k9;
        nc3.currentOffset = l9;
        nc4.currentOffset = i10;
        nc5.currentOffset = j10;
        nc6.currentOffset = k10;
        for (int k14 = 0; k14 < numTexTriangles; ++k14) {
            int i15 = O[k14] & 0xFF;
            if (i15 == 0) {
                texTrianglesPoint1[k14] = nc1.readUnsignedWord();
                texTrianglesPoint2[k14] = nc1.readUnsignedWord();
                texTrianglesPoint3[k14] = nc1.readUnsignedWord();
            }
            if (i15 == 1) {
                texTrianglesPoint1[k14] = nc2.readUnsignedWord();
                texTrianglesPoint2[k14] = nc2.readUnsignedWord();
                texTrianglesPoint3[k14] = nc2.readUnsignedWord();
                if (newformat < 15) {
                    kb[k14] = nc3.readUnsignedWord();
                    N[k14] = newformat >= 14 ? nc3.v(-1) : nc3.readUnsignedWord();
                    y[k14] = nc3.readUnsignedWord();
                } else {
                    kb[k14] = nc3.v(-1);
                    N[k14] = nc3.v(-1);
                    y[k14] = nc3.v(-1);
                }
                gb[k14] = nc4.readSignedByte();
                lb[k14] = nc5.readSignedByte();
                F[k14] = nc6.readSignedByte();
            }
            if (i15 == 2) {
                texTrianglesPoint1[k14] = nc2.readUnsignedWord();
                texTrianglesPoint2[k14] = nc2.readUnsignedWord();
                texTrianglesPoint3[k14] = nc2.readUnsignedWord();
                if (newformat >= 15) {
                    kb[k14] = nc3.v(-1);
                    N[k14] = nc3.v(-1);
                    y[k14] = nc3.v(-1);
                } else {
                    kb[k14] = nc3.readUnsignedWord();
                    N[k14] = newformat < 14 ? nc3.readUnsignedWord() : nc3.v(-1);
                    y[k14] = nc3.readUnsignedWord();
                }
                gb[k14] = nc4.readSignedByte();
                lb[k14] = nc5.readSignedByte();
                F[k14] = nc6.readSignedByte();
                cb[k14] = nc6.readSignedByte();
                J[k14] = nc6.readSignedByte();
            }
            if (i15 != 3) continue;
            texTrianglesPoint1[k14] = nc2.readUnsignedWord();
            texTrianglesPoint2[k14] = nc2.readUnsignedWord();
            texTrianglesPoint3[k14] = nc2.readUnsignedWord();
            if (newformat < 15) {
                kb[k14] = nc3.readUnsignedWord();
                N[k14] = newformat < 14 ? nc3.readUnsignedWord() : nc3.v(-1);
                y[k14] = nc3.readUnsignedWord();
            } else {
                kb[k14] = nc3.v(-1);
                N[k14] = nc3.v(-1);
                y[k14] = nc3.v(-1);
            }
            gb[k14] = nc4.readSignedByte();
            lb[k14] = nc5.readSignedByte();
            F[k14] = nc6.readSignedByte();
        }
        if (i2 != 255) {
            for (int i12 = 0; i12 < numTriangles; ++i12) {
                this.face_render_priorities[i12] = i2;
            }
        }
        this.face_color = triangleColours2;
        this.numberOfVerticeCoordinates = numVertices;
        this.numberOfTriangleFaces = numTriangles;
        this.verticesXCoordinate = vertexX;
        this.verticesYCoordinate = vertexY;
        this.verticesZCoordinate = vertexZ;
        this.face_a = facePoint1;
        this.face_b = facePoint2;
        this.face_c = facePoint3;
        this.filterTriangles();
    }

    private void readOldModel(int i) {
        int j = -870;
        this.aBoolean1618 = true;
        this.rendersWithinOneTile = false;
        ++anInt1620;
        ModelHeader header = modelHeader[i];
        this.numberOfVerticeCoordinates = header.verticeCount;
        this.numberOfTriangleFaces = header.triangleCount;
        this.numberOfTexturesFaces = header.texturedTriangleCount;
        this.verticesParticle = new int[this.numberOfVerticeCoordinates];
        this.verticesXCoordinate = new int[this.numberOfVerticeCoordinates];
        this.verticesYCoordinate = new int[this.numberOfVerticeCoordinates];
        this.verticesZCoordinate = new int[this.numberOfVerticeCoordinates];
        this.face_a = new int[this.numberOfTriangleFaces];
        this.face_b = new int[this.numberOfTriangleFaces];
        while (j >= 0) {
            this.aBoolean1618 = !this.aBoolean1618;
        }
        this.face_c = new int[this.numberOfTriangleFaces];
        this.textures_face_a = new int[this.numberOfTexturesFaces];
        this.textures_face_b = new int[this.numberOfTexturesFaces];
        this.textures_face_c = new int[this.numberOfTexturesFaces];
        if (header.vskinBasePos >= 0) {
            this.vertexVSkin = new int[this.numberOfVerticeCoordinates];
        }
        if (header.drawTypeBasePos >= 0) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (header.facePriorityBasePos >= 0) {
            this.face_render_priorities = new int[this.numberOfTriangleFaces];
        } else {
            this.face_priority = -header.facePriorityBasePos - 1;
        }
        if (header.alphaBasepos >= 0) {
            this.face_alpha = new int[this.numberOfTriangleFaces];
        }
        if (header.tskinBasepos >= 0) {
            this.triangleTSkin = new int[this.numberOfTriangleFaces];
        }
        this.face_color = new int[this.numberOfTriangleFaces];
        Stream stream = new Stream(header.modelData);
        stream.currentOffset = header.verticesModOffset;
        Stream stream_1 = new Stream(header.modelData);
        stream_1.currentOffset = header.verticesXOffset;
        Stream stream_2 = new Stream(header.modelData);
        stream_2.currentOffset = header.verticesYOffset;
        Stream stream_3 = new Stream(header.modelData);
        stream_3.currentOffset = header.verticesZOffset;
        Stream stream_4 = new Stream(header.modelData);
        stream_4.currentOffset = header.vskinBasePos;
        int k = 0;
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < this.numberOfVerticeCoordinates; ++j1) {
            int k1 = stream.readUnsignedByte();
            int i2 = 0;
            if ((k1 & 1) != 0) {
                i2 = stream_1.method421();
            }
            int k2 = 0;
            if ((k1 & 2) != 0) {
                k2 = stream_2.method421();
            }
            int i3 = 0;
            if ((k1 & 4) != 0) {
                i3 = stream_3.method421();
            }
            this.verticesXCoordinate[j1] = k + i2;
            this.verticesYCoordinate[j1] = l + k2;
            this.verticesZCoordinate[j1] = i1 + i3;
            k = this.verticesXCoordinate[j1];
            l = this.verticesYCoordinate[j1];
            i1 = this.verticesZCoordinate[j1];
            if (this.vertexVSkin == null) continue;
            this.vertexVSkin[j1] = stream_4.readUnsignedByte();
        }
        stream.currentOffset = header.triColourOffset;
        stream_1.currentOffset = header.drawTypeBasePos;
        stream_2.currentOffset = header.facePriorityBasePos;
        stream_3.currentOffset = header.alphaBasepos;
        stream_4.currentOffset = header.tskinBasepos;
        for (int l1 = 0; l1 < this.numberOfTriangleFaces; ++l1) {
            this.face_color[l1] = stream.readUnsignedWord();
            if (this.face_render_type != null) {
                this.face_render_type[l1] = stream_1.readUnsignedByte();
            }
            if (this.face_render_priorities != null) {
                this.face_render_priorities[l1] = stream_2.readUnsignedByte();
            }
            if (this.face_alpha != null) {
                this.face_alpha[l1] = stream_3.readUnsignedByte();
            }
            if (this.triangleTSkin == null) continue;
            this.triangleTSkin[l1] = stream_4.readUnsignedByte();
        }
        if (this.face_alpha == null) {
            this.face_alpha = new int[this.numberOfTriangleFaces];
        }
        stream.currentOffset = header.triVPointOffset;
        stream_1.currentOffset = header.triMeshLinkOffset;
        int j2 = 0;
        int l2 = 0;
        int j3 = 0;
        int k3 = 0;
        for (int l3 = 0; l3 < this.numberOfTriangleFaces; ++l3) {
            int i4 = stream_1.readUnsignedByte();
            if (i4 == 1) {
                k3 = j2 = stream.method421() + k3;
                k3 = l2 = stream.method421() + k3;
                k3 = j3 = stream.method421() + k3;
                this.face_a[l3] = j2;
                this.face_b[l3] = l2;
                this.face_c[l3] = j3;
            }
            if (i4 == 2) {
                l2 = j3;
                k3 = j3 = stream.method421() + k3;
                this.face_a[l3] = j2;
                this.face_b[l3] = l2;
                this.face_c[l3] = j3;
            }
            if (i4 == 3) {
                j2 = j3;
                k3 = j3 = stream.method421() + k3;
                this.face_a[l3] = j2;
                this.face_b[l3] = l2;
                this.face_c[l3] = j3;
            }
            if (i4 != 4) continue;
            int k4 = j2;
            j2 = l2;
            l2 = k4;
            k3 = j3 = stream.method421() + k3;
            this.face_a[l3] = j2;
            this.face_b[l3] = l2;
            this.face_c[l3] = j3;
        }
        stream.currentOffset = header.textureInfoBasePos;
        for (int j4 = 0; j4 < this.numberOfTexturesFaces; ++j4) {
            this.textures_face_a[j4] = stream.readUnsignedWord();
            this.textures_face_b[j4] = stream.readUnsignedWord();
            this.textures_face_c[j4] = stream.readUnsignedWord();
        }
    }

    public void forceRecolour(int i, int j) {
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            this.face_color[k] = j;
        }
    }

    public void recolour(int itemId, int editedColor, int originalColor) {
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            if (this.face_color[k] != editedColor) continue;
            this.face_color[k] = originalColor;
        }
    }

    public void recolour(int i, int j) {
        for (int k = 0; k < this.numberOfTriangleFaces; ++k) {
            if (this.face_color[k] != i) continue;
            this.face_color[k] = j;
        }
    }

    public void recolour2(Color i, int j) {
        if (i == Color.decode("#7A7A7A")) {
            this.setTexture(j);
        }
    }

    private final void reduce(int i) {
        if (this.face_color != null && this.face_color[i] == 65535) {
            return;
        }
        int j = Rasterizer.center_x;
        int k = Rasterizer.center_y;
        int l = 0;
        int i1 = this.face_a[i];
        int j1 = this.face_b[i];
        int k1 = this.face_c[i];
        int l1 = camera_vertex_z[i1];
        int i2 = camera_vertex_z[j1];
        int j2 = camera_vertex_z[k1];
        if (l1 >= 50) {
            Model.anIntArray1678[l] = projected_vertex_x[i1];
            Model.anIntArray1679[l] = projected_vertex_y[i1];
            Model.anIntArray1680[l++] = this.face_shade_a[i];
        } else {
            int k2 = camera_vertex_y[i1];
            int k3 = camera_vertex_x[i1];
            int k4 = this.face_shade_a[i];
            if (j2 >= 50) {
                int k5 = (50 - l1) * lightDecay[j2 - l1];
                Model.anIntArray1678[l] = j + (k2 + ((camera_vertex_y[k1] - k2) * k5 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1679[l] = k + (k3 + ((camera_vertex_x[k1] - k3) * k5 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1680[l++] = k4 + ((this.face_shade_c[i] - k4) * k5 >> 16);
            }
            if (i2 >= 50) {
                int l5 = (50 - l1) * lightDecay[i2 - l1];
                Model.anIntArray1678[l] = j + (k2 + ((camera_vertex_y[j1] - k2) * l5 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1679[l] = k + (k3 + ((camera_vertex_x[j1] - k3) * l5 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1680[l++] = k4 + ((this.face_shade_b[i] - k4) * l5 >> 16);
            }
        }
        if (i2 >= 50) {
            Model.anIntArray1678[l] = projected_vertex_x[j1];
            Model.anIntArray1679[l] = projected_vertex_y[j1];
            Model.anIntArray1680[l++] = this.face_shade_b[i];
        } else {
            int l2 = camera_vertex_y[j1];
            int l3 = camera_vertex_x[j1];
            int l4 = this.face_shade_b[i];
            if (l1 >= 50) {
                int i6 = (50 - i2) * lightDecay[l1 - i2];
                Model.anIntArray1678[l] = j + (l2 + ((camera_vertex_y[i1] - l2) * i6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1679[l] = k + (l3 + ((camera_vertex_x[i1] - l3) * i6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1680[l++] = l4 + ((this.face_shade_a[i] - l4) * i6 >> 16);
            }
            if (j2 >= 50) {
                int j6 = (50 - i2) * lightDecay[j2 - i2];
                Model.anIntArray1678[l] = j + (l2 + ((camera_vertex_y[k1] - l2) * j6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1679[l] = k + (l3 + ((camera_vertex_x[k1] - l3) * j6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1680[l++] = l4 + ((this.face_shade_c[i] - l4) * j6 >> 16);
            }
        }
        if (j2 >= 50) {
            Model.anIntArray1678[l] = projected_vertex_x[k1];
            Model.anIntArray1679[l] = projected_vertex_y[k1];
            Model.anIntArray1680[l++] = this.face_shade_c[i];
        } else {
            int i3 = camera_vertex_y[k1];
            int i4 = camera_vertex_x[k1];
            int i5 = this.face_shade_c[i];
            if (i2 >= 50) {
                int k6 = (50 - j2) * lightDecay[i2 - j2];
                Model.anIntArray1678[l] = j + (i3 + ((camera_vertex_y[j1] - i3) * k6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1679[l] = k + (i4 + ((camera_vertex_x[j1] - i4) * k6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1680[l++] = i5 + ((this.face_shade_b[i] - i5) * k6 >> 16);
            }
            if (l1 >= 50) {
                int l6 = (50 - j2) * lightDecay[l1 - j2];
                Model.anIntArray1678[l] = j + (i3 + ((camera_vertex_y[i1] - i3) * l6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1679[l] = k + (i4 + ((camera_vertex_x[i1] - i4) * l6 >> 16)) * WorldController.focalLength / 50;
                Model.anIntArray1680[l++] = i5 + ((this.face_shade_a[i] - i5) * l6 >> 16);
            }
        }
        int j3 = anIntArray1678[0];
        int j4 = anIntArray1678[1];
        int j5 = anIntArray1678[2];
        int i7 = anIntArray1679[0];
        int j7 = anIntArray1679[1];
        int k7 = anIntArray1679[2];
        if ((j3 - j4) * (k7 - j7) - (i7 - j7) * (j5 - j4) > 0) {
            Rasterizer.restrict_edges = false;
            if (l == 3) {
                int l7;
                if (j3 < 0 || j4 < 0 || j5 < 0 || j3 > DrawingArea.viewportRX || j4 > DrawingArea.viewportRX || j5 > DrawingArea.viewportRX) {
                    Rasterizer.restrict_edges = true;
                }
                if ((l7 = this.face_render_type == null ? 0 : this.face_render_type[i] & 3) == 0) {
                    Rasterizer.drawShadedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2]);
                } else if (l7 == 1) {
                    Rasterizer.drawFlatTriangle(i7, j7, k7, j3, j4, j5, hsl2rgb[this.face_shade_a[i]]);
                } else if (l7 == 2) {
                    int j8 = this.face_render_type[i] >> 2;
                    int k9 = this.textures_face_a[j8];
                    int k10 = this.textures_face_b[j8];
                    int k11 = this.textures_face_c[j8];
                    if (Client.getOption("hd_tex")) {
                        Rasterizer.drawTexturedTriangle_model(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2], camera_vertex_y[k9], camera_vertex_y[k10], camera_vertex_y[k11], projected_vertex_z[k9], projected_vertex_z[k10], projected_vertex_z[k11], camera_vertex_x[k9], camera_vertex_x[k10], camera_vertex_x[k11], camera_vertex_z[k9], camera_vertex_z[k10], camera_vertex_z[k11], this.face_color[i], this.face_color[i], false, false);
                    } else {
                        Rasterizer.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2], camera_vertex_y[k9], camera_vertex_y[k10], camera_vertex_y[k11], camera_vertex_x[k9], camera_vertex_x[k10], camera_vertex_x[k11], camera_vertex_z[k9], camera_vertex_z[k10], camera_vertex_z[k11], this.face_color[i]);
                    }
                } else if (l7 == 3) {
                    int k8 = this.face_render_type[i] >> 2;
                    int l9 = this.textures_face_a[k8];
                    int l10 = this.textures_face_b[k8];
                    int l11 = this.textures_face_c[k8];
                    if (Client.getOption("hd_tex")) {
                        Rasterizer.drawTexturedTriangle_model(i7, j7, k7, j3, j4, j5, -1, -1, -1, this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[l9], camera_vertex_y[l10], camera_vertex_y[l11], camera_vertex_x[l9], camera_vertex_x[l10], camera_vertex_x[l11], camera_vertex_z[l9], camera_vertex_z[l10], camera_vertex_z[l11], this.face_color[i], this.face_color[i], false, false);
                    } else {
                        Rasterizer.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[l9], camera_vertex_y[l10], camera_vertex_y[l11], camera_vertex_x[l9], camera_vertex_x[l10], camera_vertex_x[l11], camera_vertex_z[l9], camera_vertex_z[l10], camera_vertex_z[l11], this.face_color[i]);
                    }
                }
            }
            if (l == 4) {
                int i8;
                if (j3 < 0 || j4 < 0 || j5 < 0 || j3 > DrawingArea.viewportRX || j4 > DrawingArea.viewportRX || j5 > DrawingArea.viewportRX || anIntArray1678[3] < 0 || anIntArray1678[3] > DrawingArea.viewportRX) {
                    Rasterizer.restrict_edges = true;
                }
                if ((i8 = this.face_render_type == null ? 0 : this.face_render_type[i] & 3) == 0) {
                    Rasterizer.drawShadedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2]);
                    Rasterizer.drawShadedTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], anIntArray1680[0], anIntArray1680[2], anIntArray1680[3]);
                    return;
                }
                if (i8 == 1) {
                    int l8 = hsl2rgb[this.face_shade_a[i]];
                    Rasterizer.drawFlatTriangle(i7, j7, k7, j3, j4, j5, l8);
                    Rasterizer.drawFlatTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], l8);
                    return;
                }
                if (i8 == 2) {
                    int i9 = this.face_render_type[i] >> 2;
                    int i10 = this.textures_face_a[i9];
                    int i11 = this.textures_face_b[i9];
                    int i12 = this.textures_face_c[i9];
                    if (Client.getOption("hd_tex")) {
                        Rasterizer.drawTexturedTriangle_model(i7, j7, k7, j3, j4, j5, -1, -1, -1, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2], camera_vertex_y[i10], camera_vertex_y[i11], camera_vertex_y[i12], camera_vertex_x[i10], camera_vertex_x[i11], camera_vertex_x[i12], camera_vertex_z[i10], camera_vertex_z[i11], camera_vertex_z[i12], this.face_color[i], this.face_color[i], false, false);
                        Rasterizer.drawTexturedTriangle_model(i7, k7, anIntArray1679[3], j3, j5, -1, -1, -1, anIntArray1678[3], anIntArray1680[0], anIntArray1680[2], anIntArray1680[3], camera_vertex_y[i10], camera_vertex_y[i11], camera_vertex_y[i12], camera_vertex_x[i10], camera_vertex_x[i11], camera_vertex_x[i12], camera_vertex_z[i10], camera_vertex_z[i11], camera_vertex_z[i12], this.face_color[i], this.face_color[i], false, false);
                    } else {
                        Rasterizer.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, anIntArray1680[0], anIntArray1680[1], anIntArray1680[2], camera_vertex_y[i10], camera_vertex_y[i11], camera_vertex_y[i12], camera_vertex_x[i10], camera_vertex_x[i11], camera_vertex_x[i12], camera_vertex_z[i10], camera_vertex_z[i11], camera_vertex_z[i12], this.face_color[i]);
                        Rasterizer.drawTexturedTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], anIntArray1680[0], anIntArray1680[2], anIntArray1680[3], camera_vertex_y[i10], camera_vertex_y[i11], camera_vertex_y[i12], camera_vertex_x[i10], camera_vertex_x[i11], camera_vertex_x[i12], camera_vertex_z[i10], camera_vertex_z[i11], camera_vertex_z[i12], this.face_color[i]);
                    }
                    return;
                }
                if (i8 == 3) {
                    int j9 = this.face_render_type[i] >> 2;
                    int j10 = this.textures_face_a[j9];
                    int j11 = this.textures_face_b[j9];
                    int j12 = this.textures_face_c[j9];
                    if (Client.getOption("hd_tex")) {
                        Rasterizer.drawTexturedTriangle_model(i7, j7, k7, j3, j4, j5, -1, -1, -1, this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[j10], camera_vertex_y[j11], camera_vertex_y[j12], camera_vertex_x[j10], camera_vertex_x[j11], camera_vertex_x[j12], camera_vertex_z[j10], camera_vertex_z[j11], camera_vertex_z[j12], this.face_color[i], this.face_color[i], false, false);
                        Rasterizer.drawTexturedTriangle_model(i7, k7, anIntArray1679[3], j3, j5, -1, -1, -1, anIntArray1678[3], this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[j10], camera_vertex_y[j11], camera_vertex_y[j12], camera_vertex_x[j10], camera_vertex_x[j11], camera_vertex_x[j12], camera_vertex_z[j10], camera_vertex_z[j11], camera_vertex_z[j12], this.face_color[i], this.face_color[i], false, false);
                    } else {
                        Rasterizer.drawTexturedTriangle(i7, j7, k7, j3, j4, j5, this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[j10], camera_vertex_y[j11], camera_vertex_y[j12], camera_vertex_x[j10], camera_vertex_x[j11], camera_vertex_x[j12], camera_vertex_z[j10], camera_vertex_z[j11], camera_vertex_z[j12], this.face_color[i]);
                        Rasterizer.drawTexturedTriangle(i7, k7, anIntArray1679[3], j3, j5, anIntArray1678[3], this.face_shade_a[i], this.face_shade_a[i], this.face_shade_a[i], camera_vertex_y[j10], camera_vertex_y[j11], camera_vertex_y[j12], camera_vertex_x[j10], camera_vertex_x[j11], camera_vertex_x[j12], camera_vertex_z[j10], camera_vertex_z[j11], camera_vertex_z[j12], this.face_color[i]);
                    }
                }
            }
        }
    }

    @Override
    public void renderAtPoint(int i, int j, int k, int l, int i1, int j1, int k1, int l1, int i2, int id) {
        this.renderAtPointX = j1 + Client.instance.xCameraPos;
        this.renderAtPointY = l1 + Client.instance.yCameraPos;
        this.renderAtPointZ = k1 + Client.instance.zCameraPos;
        this.lastRenderedRotation = i;
        int j2 = l1 * i1 - j1 * l >> 16;
        int k2 = k1 * j + j2 * k >> 16;
        int l2 = this.anInt1650 * k >> 16;
        int i3 = k2 + l2;
        if (i3 <= 50 || k2 >= 3500) {
            return;
        }
        int j3 = l1 * l + j1 * i1 >> 16;
        int k3 = (j3 - this.anInt1650) * WorldController.focalLength;
        if (k3 / i3 >= DrawingArea.viewport_centerX) {
            return;
        }
        int l3 = (j3 + this.anInt1650) * WorldController.focalLength;
        if (l3 / i3 <= -DrawingArea.viewport_centerX) {
            return;
        }
        int i4 = k1 * k - j2 * j >> 16;
        int j4 = this.anInt1650 * j >> 16;
        int k4 = (i4 + j4) * WorldController.focalLength;
        if (k4 / i3 <= -DrawingArea.viewport_centerY) {
            return;
        }
        int l4 = j4 + (this.modelHeight * k >> 16);
        int i5 = (i4 - l4) * WorldController.focalLength;
        if (i5 / i3 >= DrawingArea.viewport_centerY) {
            return;
        }
        int j5 = l2 + (this.modelHeight * j >> 16);
        boolean flag = false;
        if (k2 - j5 <= 50) {
            flag = true;
        }
        boolean flag1 = false;
        if (i2 > 0 && objectExists) {
            int k5 = k2 - l2;
            if (k5 <= 50) {
                k5 = 50;
            }
            if (j3 > 0) {
                k3 /= i3;
                l3 /= k5;
            } else {
                l3 /= i3;
                k3 /= k5;
            }
            if (i4 > 0) {
                i5 /= i3;
                k4 /= k5;
            } else {
                k4 /= i3;
                i5 /= k5;
            }
            int i6 = currentCursorX - Rasterizer.center_x;
            int k6 = currentCursorY - Rasterizer.center_y;
            if (i6 > k3 && i6 < l3 && k6 > i5 && k6 < k4) {
                if (this.rendersWithinOneTile) {
                    Model.mapObjectIds[Model.objectsRendered] = id;
                    Model.objectsInCurrentRegion[Model.objectsRendered++] = i2;
                } else {
                    flag1 = true;
                }
            }
        }
        int l5 = Rasterizer.center_x;
        int j6 = Rasterizer.center_y;
        int l6 = 0;
        int i7 = 0;
        if (i != 0) {
            l6 = SINE[i];
            i7 = COSINE[i];
        }
        for (int j7 = 0; j7 < this.numberOfVerticeCoordinates; ++j7) {
            int k7 = this.verticesXCoordinate[j7];
            int l7 = this.verticesYCoordinate[j7];
            int i8 = this.verticesZCoordinate[j7];
            if (i != 0) {
                int j8 = i8 * l6 + k7 * i7 >> 16;
                i8 = i8 * i7 - k7 * l6 >> 16;
                k7 = j8;
            }
            int k8 = (i8 += l1) * l + (k7 += j1) * i1 >> 16;
            i8 = i8 * i1 - k7 * l >> 16;
            k7 = k8;
            k8 = (l7 += k1) * k - i8 * j >> 16;
            i8 = l7 * j + i8 * k >> 16;
            l7 = k8;
            Model.anIntArray1667[j7] = i8 - k2;
            if (i8 >= 50) {
                Model.projected_vertex_x[j7] = l5 + k7 * WorldController.focalLength / i8;
                Model.projected_vertex_y[j7] = j6 + l7 * WorldController.focalLength / i8;
                Model.projected_vertex_z[j7] = i8;
            } else {
                Model.projected_vertex_x[j7] = -5000;
                flag = true;
            }
            if (!flag && this.numberOfTexturesFaces <= 0) continue;
            Model.camera_vertex_y[j7] = k7;
            Model.camera_vertex_x[j7] = l7;
            Model.camera_vertex_z[j7] = i8;
        }
        try {
            this.translateToScreen(flag, flag1, i2, id);
            return;
        }
        catch (Exception _ex) {
            return;
        }
    }

    public void renderSingle(int rotation_2, int offsetX, int rotation_1, int offsetY, int zoom_sine, int zoom_cosine) {
        try {
            int i = 0;
            int base_draw_x = Rasterizer.center_x;
            int base_draw_y = Rasterizer.center_y;
            int base_sine = SINE[i];
            int base_cosine = COSINE[i];
            int rot_2_sine = SINE[rotation_2];
            int rot_2_cosine = COSINE[rotation_2];
            int offsetX_sine = SINE[offsetX];
            int offsetX_cosine = COSINE[offsetX];
            int rot_1_sine = SINE[rotation_1];
            int rot_1_cosine = COSINE[rotation_1];
            int calculated_zoom = zoom_sine * rot_1_sine + zoom_cosine * rot_1_cosine >> 16;
            for (int vertexId = 0; vertexId < this.numberOfVerticeCoordinates; ++vertexId) {
                int baseVertexX = this.verticesXCoordinate[vertexId];
                int baseVertexY = this.verticesYCoordinate[vertexId];
                int baseVertexZ = this.verticesZCoordinate[vertexId];
                if (offsetX != 0) {
                    int calculatedVertexX = baseVertexY * offsetX_sine + baseVertexX * offsetX_cosine >> 16;
                    baseVertexY = baseVertexY * offsetX_cosine - baseVertexX * offsetX_sine >> 16;
                    baseVertexX = calculatedVertexX;
                }
                if (i != 0) {
                    int calculatedVertexY = baseVertexY * base_cosine - baseVertexZ * base_sine >> 16;
                    baseVertexZ = baseVertexY * base_sine + baseVertexZ * base_cosine >> 16;
                    baseVertexY = calculatedVertexY;
                }
                if (rotation_2 != 0) {
                    int calculatedVertexZ = baseVertexZ * rot_2_sine + baseVertexX * rot_2_cosine >> 16;
                    baseVertexZ = baseVertexZ * rot_2_cosine - baseVertexX * rot_2_sine >> 16;
                    baseVertexX = calculatedVertexZ;
                }
                int j6 = (baseVertexY += zoom_sine) * rot_1_cosine - (baseVertexZ += zoom_cosine) * rot_1_sine >> 16;
                baseVertexZ = baseVertexY * rot_1_sine + baseVertexZ * rot_1_cosine >> 16;
                baseVertexY = j6;
                Model.anIntArray1667[vertexId] = baseVertexZ - calculated_zoom;
                Model.projected_vertex_x[vertexId] = base_draw_x + ((baseVertexX += offsetY) << 9) / baseVertexZ;
                Model.projected_vertex_y[vertexId] = base_draw_y + (baseVertexY << 9) / baseVertexZ;
                Model.projected_vertex_z[vertexId] = baseVertexZ;
                if (this.numberOfTexturesFaces <= 0) continue;
                Model.camera_vertex_y[vertexId] = baseVertexX;
                Model.camera_vertex_x[vertexId] = baseVertexY;
                Model.camera_vertex_z[vertexId] = baseVertexZ;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.translateToScreen(false, false, 0, -1);
            return;
        }
        catch (Exception _ex) {
            return;
        }
    }

    public void reset() {
        this.verticesXCoordinate = null;
        this.verticesYCoordinate = null;
        this.verticesZCoordinate = null;
        this.face_a = null;
        this.face_b = null;
        this.face_c = null;
        this.face_shade_a = null;
        this.face_shade_b = null;
        this.face_shade_c = null;
        this.face_render_type = null;
        this.face_render_priorities = null;
        this.face_alpha = null;
        this.face_color = null;
        this.textures_face_c = null;
        this.textures_face_b = null;
        this.textures_face_a = null;
        this.vertexVSkin = null;
        this.triangleTSkin = null;
        this.vertexSkin = null;
        this.triangleSkin = null;
        this.vertexNormalOffset = null;
    }

    public void rotateBy90() {
        for (int j = 0; j < this.numberOfVerticeCoordinates; ++j) {
            int k = this.verticesXCoordinate[j];
            this.verticesXCoordinate[j] = this.verticesZCoordinate[j];
            this.verticesZCoordinate[j] = -k;
        }
    }

    public void rotateX(int i) {
        int k = SINE[i];
        int l = COSINE[i];
        for (int i1 = 0; i1 < this.numberOfVerticeCoordinates; ++i1) {
            int j1 = this.verticesYCoordinate[i1] * l - this.verticesZCoordinate[i1] * k >> 16;
            this.verticesZCoordinate[i1] = this.verticesYCoordinate[i1] * k + this.verticesZCoordinate[i1] * l >> 16;
            this.verticesYCoordinate[i1] = j1;
        }
    }

    public void scale2(int i, int j, int k) {
        for (int i1 = 0; i1 < this.numberOfVerticeCoordinates; ++i1) {
            this.verticesXCoordinate[i1] = this.verticesXCoordinate[i1] * i >> 7;
            this.verticesYCoordinate[i1] = this.verticesYCoordinate[i1] * j >> 7;
            this.verticesZCoordinate[i1] = this.verticesZCoordinate[i1] * k >> 7;
        }
    }

    public void scaleT(int i, int j, int l) {
        for (int i1 = 0; i1 < this.numberOfVerticeCoordinates; ++i1) {
            this.verticesXCoordinate[i1] = this.verticesXCoordinate[i1] * i / 128;
            this.verticesYCoordinate[i1] = this.verticesYCoordinate[i1] * l / 128;
            this.verticesZCoordinate[i1] = this.verticesZCoordinate[i1] * j / 128;
        }
    }

    public void setTexture(int tex, int fromColor) {
        int set2 = 0;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        int assigned = 0;
        this.face_priority = 10;
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            if (this.face_color[i] != fromColor) continue;
            this.face_priority = 10;
            this.face_color[i] = tex;
            this.face_render_type[i] = 3 + set2;
            set2 += 4;
            this.textures_face_a[assigned] = this.face_a[i];
            this.textures_face_b[assigned] = this.face_b[i];
            this.textures_face_c[assigned] = this.face_c[i];
            ++assigned;
        }
    }

    public void setTexture(int tex, int fromColor, int toColor) {
        int foundAmt = 0;
        int set2 = 0;
        for (int i = 0; i < this.face_color.length; ++i) {
            if (this.face_color[i] < fromColor || this.face_color[i] > toColor) continue;
            ++foundAmt;
        }
        if (foundAmt == 0) {
            return;
        }
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        this.face_priority = 10;
        int assigned = 0;
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            if (this.face_color[i] < fromColor || this.face_color[i] > toColor) continue;
            this.face_priority = 10;
            this.face_color[i] = tex;
            this.face_render_type[i] = 3 + set2;
            set2 += 4;
            this.textures_face_a[assigned] = this.face_a[i];
            this.textures_face_b[assigned] = this.face_b[i];
            this.textures_face_c[assigned] = this.face_c[i];
            ++assigned;
        }
    }

    public void setTexture2(int fromColor, int tex) {
        int foundAmt = 0;
        for (int i = 0; i < this.face_color.length; ++i) {
            if (fromColor != this.face_color[i]) continue;
            ++foundAmt;
        }
        if (foundAmt == 0) {
            return;
        }
        int set2 = 0;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        this.face_priority = 10;
        int assigned = 0;
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            if (this.face_color[i] < fromColor) continue;
            this.face_priority = 10;
            this.face_color[i] = tex;
            this.face_render_type[i] = 3 + set2;
            set2 += 4;
            this.textures_face_a[assigned] = this.face_a[i];
            this.textures_face_b[assigned] = this.face_b[i];
            this.textures_face_c[assigned] = this.face_c[i];
            ++assigned;
        }
    }

    public void setTexture(int tex, int fromColor, int toColor, int tex2) {
        int set2 = 0;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        this.face_priority = 10;
        int assigned = 0;
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            if (this.face_color[i] >= fromColor && this.face_color[i] <= toColor) {
                this.face_priority = 10;
                this.face_color[i] = tex;
            } else {
                this.face_color[i] = tex2;
            }
            this.face_render_type[i] = 3 + set2;
            set2 += 4;
            this.textures_face_a[assigned] = this.face_a[i];
            this.textures_face_b[assigned] = this.face_b[i];
            this.textures_face_c[assigned] = this.face_c[i];
            ++assigned;
        }
    }

    public void setTexture(int tex) {
        int set2 = 0;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        this.face_priority = 10;
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            this.face_priority = 10;
            this.face_color[i] = tex;
            this.face_render_type[i] = 3 + set2;
            set2 += 4;
            this.textures_face_a[i] = this.face_a[i];
            this.textures_face_b[i] = this.face_b[i];
            this.textures_face_c[i] = this.face_c[i];
        }
    }

    public void setInstanceTicket(int tex) {
        int set2 = 0;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        this.face_priority = 10;
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            this.face_priority = 10;
            this.face_render_type[i] = 3 + set2;
            set2 += 4;
            this.textures_face_a[i] = this.face_a[i] + 5;
            this.textures_face_b[i] = this.face_b[i] + 15;
            this.textures_face_c[i] = this.face_c[i] + 25;
            this.face_color[i] = tex;
        }
    }

    public void setTexture() {
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        int set2 = 0;
        this.numberOfTexturesFaces = this.numberOfTriangleFaces;
        if (this.face_render_type == null) {
            this.face_render_type = new int[this.numberOfTriangleFaces];
        }
        if (this.face_color == null) {
            this.face_color = new int[this.numberOfTriangleFaces];
        }
        this.textures_face_a = new int[this.numberOfTriangleFaces];
        this.textures_face_b = new int[this.numberOfTriangleFaces];
        this.textures_face_c = new int[this.numberOfTriangleFaces];
        for (int i = 0; i < this.numberOfTriangleFaces; ++i) {
            this.face_priority = 10;
            this.face_render_type[i] = 2 + set2;
            set2 += 4;
            this.textures_face_a[i] = this.face_a[i];
            this.textures_face_b[i] = this.face_b[i];
            this.textures_face_c[i] = this.face_c[i];
        }
    }

    public void translate(int i, int j, int l) {
        int i1 = 0;
        while (i1 < this.numberOfVerticeCoordinates) {
            int n = i1;
            this.verticesXCoordinate[n] = this.verticesXCoordinate[n] + i;
            int n2 = i1;
            this.verticesYCoordinate[n2] = this.verticesYCoordinate[n2] + j;
            int n3 = i1++;
            this.verticesZCoordinate[n3] = this.verticesZCoordinate[n3] + l;
        }
    }

    private final void translateToScreen(boolean flag, boolean needAddToSelectedObjects, int i, int id) {
        for (int j = 0; j < this.diagonal3D; ++j) {
            Model.depthListIndices[j] = 0;
        }
        for (int triangleId = 0; triangleId < this.numberOfTriangleFaces; ++triangleId) {
            int k5;
            if (this.face_render_type != null && this.face_render_type[triangleId] == -1 || this.face_alpha != null && this.face_alpha[triangleId] >= 255) continue;
            int face_a_pos = this.face_a[triangleId];
            int face_b_pos = this.face_b[triangleId];
            int face_c_pos = this.face_c[triangleId];
            int vertexXA = projected_vertex_x[face_a_pos];
            int vertexXB = projected_vertex_x[face_b_pos];
            int vertexXC = projected_vertex_x[face_c_pos];
            if (flag && (vertexXA == -5000 || vertexXB == -5000 || vertexXC == -5000)) {
                int j5;
                Model.outOfReach[triangleId] = true;
                int n = j5 = (anIntArray1667[face_a_pos] + anIntArray1667[face_b_pos] + anIntArray1667[face_c_pos]) / 3 + this.anInt1653;
                int n2 = depthListIndices[n];
                depthListIndices[n] = n2 + 1;
                Model.faceLists[j5][n2] = triangleId;
                continue;
            }
            if (needAddToSelectedObjects && this.cursorOn(currentCursorX, currentCursorY, projected_vertex_y[face_a_pos], projected_vertex_y[face_b_pos], projected_vertex_y[face_c_pos], vertexXA, vertexXB, vertexXC)) {
                Model.mapObjectIds[Model.objectsRendered] = id;
                Model.objectsInCurrentRegion[Model.objectsRendered++] = i;
                needAddToSelectedObjects = false;
            }
            if ((vertexXA - vertexXB) * (projected_vertex_y[face_c_pos] - projected_vertex_y[face_b_pos]) - (projected_vertex_y[face_a_pos] - projected_vertex_y[face_b_pos]) * (vertexXC - vertexXB) <= 0) continue;
            Model.outOfReach[triangleId] = false;
            Model.hasAnEdgeToRestrict[triangleId] = vertexXA < 0 || vertexXB < 0 || vertexXC < 0 || vertexXA > DrawingArea.viewportRX || vertexXB > DrawingArea.viewportRX || vertexXC > DrawingArea.viewportRX;
            int n = k5 = (anIntArray1667[face_a_pos] + anIntArray1667[face_b_pos] + anIntArray1667[face_c_pos]) / 3 + this.anInt1653;
            int n3 = depthListIndices[n];
            depthListIndices[n] = n3 + 1;
            Model.faceLists[k5][n3] = triangleId;
        }
        if (this.face_render_priorities == null) {
            for (int i1 = this.diagonal3D - 1; i1 >= 0; --i1) {
                int l1 = depthListIndices[i1];
                if (l1 <= 0) continue;
                int[] ai = faceLists[i1];
                for (int j3 = 0; j3 < l1; ++j3) {
                    this.rasterise(ai[j3]);
                }
            }
            return;
        }
        for (int j1 = 0; j1 < 12; ++j1) {
            Model.anIntArray1673[j1] = 0;
            Model.anIntArray1677[j1] = 0;
        }
        for (int i2 = this.diagonal3D - 1; i2 >= 0; --i2) {
            int k2 = depthListIndices[i2];
            if (k2 <= 0) continue;
            int[] ai1 = faceLists[i2];
            for (int i4 = 0; i4 < k2; ++i4) {
                int l5;
                int l4 = ai1[i4];
                int n = l5 = this.face_render_priorities[l4];
                anIntArray1673[n] = anIntArray1673[n] + 1;
                Model.anIntArrayArray1674[l5][j6] = l4;
                if (l5 < 10) {
                    int n4 = l5;
                    anIntArray1677[n4] = anIntArray1677[n4] + i2;
                    continue;
                }
                if (l5 == 10) {
                    Model.anIntArray1675[j6] = i2;
                    continue;
                }
                Model.anIntArray1676[j6] = i2;
            }
        }
        int l2 = 0;
        if (anIntArray1673[1] > 0 || anIntArray1673[2] > 0) {
            l2 = (anIntArray1677[1] + anIntArray1677[2]) / (anIntArray1673[1] + anIntArray1673[2]);
        }
        int k3 = 0;
        if (anIntArray1673[3] > 0 || anIntArray1673[4] > 0) {
            k3 = (anIntArray1677[3] + anIntArray1677[4]) / (anIntArray1673[3] + anIntArray1673[4]);
        }
        int j4 = 0;
        if (anIntArray1673[6] > 0 || anIntArray1673[8] > 0) {
            j4 = (anIntArray1677[6] + anIntArray1677[8]) / (anIntArray1673[6] + anIntArray1673[8]);
        }
        int i6 = 0;
        int k6 = anIntArray1673[10];
        int[] ai2 = anIntArrayArray1674[10];
        int[] ai3 = anIntArray1675;
        if (i6 == k6) {
            i6 = 0;
            k6 = anIntArray1673[11];
            ai2 = anIntArrayArray1674[11];
            ai3 = anIntArray1676;
        }
        int i5 = i6 < k6 ? ai3[i6] : -1000;
        for (int l6 = 0; l6 < 10; ++l6) {
            while (l6 == 0 && i5 > l2) {
                this.rasterise(ai2[i6++]);
                if (i6 == k6 && ai2 != anIntArrayArray1674[11]) {
                    i6 = 0;
                    k6 = anIntArray1673[11];
                    ai2 = anIntArrayArray1674[11];
                    ai3 = anIntArray1676;
                }
                if (i6 < k6) {
                    i5 = ai3[i6];
                    continue;
                }
                i5 = -1000;
            }
            while (l6 == 3 && i5 > k3) {
                this.rasterise(ai2[i6++]);
                if (i6 == k6 && ai2 != anIntArrayArray1674[11]) {
                    i6 = 0;
                    k6 = anIntArray1673[11];
                    ai2 = anIntArrayArray1674[11];
                    ai3 = anIntArray1676;
                }
                if (i6 < k6) {
                    i5 = ai3[i6];
                    continue;
                }
                i5 = -1000;
            }
            while (l6 == 5 && i5 > j4) {
                this.rasterise(ai2[i6++]);
                if (i6 == k6 && ai2 != anIntArrayArray1674[11]) {
                    i6 = 0;
                    k6 = anIntArray1673[11];
                    ai2 = anIntArrayArray1674[11];
                    ai3 = anIntArray1676;
                }
                if (i6 < k6) {
                    i5 = ai3[i6];
                    continue;
                }
                i5 = -1000;
            }
            int i7 = anIntArray1673[l6];
            int[] ai4 = anIntArrayArray1674[l6];
            for (int j7 = 0; j7 < i7; ++j7) {
                this.rasterise(ai4[j7]);
            }
        }
        while (i5 != -1000) {
            this.rasterise(ai2[i6++]);
            if (i6 == k6 && ai2 != anIntArrayArray1674[11]) {
                i6 = 0;
                ai2 = anIntArrayArray1674[11];
                k6 = anIntArray1673[11];
                ai3 = anIntArray1676;
            }
            if (i6 < k6) {
                i5 = ai3[i6];
                continue;
            }
            i5 = -500;
        }
        for (int vertex = 0; vertex < this.numberOfVerticeCoordinates; ++vertex) {
            int pid = this.verticesParticle[vertex] - 1;
            if (pid < 0) continue;
            ParticleDefinition def = ParticleDefinition.cache[pid];
            int x = this.verticesXCoordinate[vertex];
            int y = this.verticesYCoordinate[vertex];
            int z = this.verticesXCoordinate[vertex];
            int depth = projected_vertex_z[vertex];
            if (this.lastRenderedRotation != 0) {
                int sine = SINE[this.lastRenderedRotation];
                int cosine = COSINE[this.lastRenderedRotation];
                int rotatedX = z * sine + x * cosine >> 16;
                z = z * cosine - x * sine >> 16;
                x = rotatedX;
            }
            ParticleVector pos = new ParticleVector(x += this.renderAtPointX, -y, z += this.renderAtPointY);
            for (int p = 0; p < def.getSpawnRate(); ++p) {
                Particle particle = new Particle(def, pos, depth, pid);
                Client.instance.addParticle(particle);
            }
        }
    }

    public void scale2(float npcSize) {
    }

    static {
        ccString = "Cla";
        xxString = "at Cl";
        vvString = "nt";
        aString9_9 = ccString + "n Ch" + xxString + "ie" + vvString + " ";
        entityModelDesc = new Model(true);
        anIntArray1622 = new int[3000];
        anIntArray1623 = new int[3000];
        anIntArray1624 = new int[3000];
        anIntArray1625 = new int[3000];
        loggedFailedHighModels = new HashSet<Integer>();
        hasAnEdgeToRestrict = new boolean[MAX_POLYGON];
        outOfReach = new boolean[MAX_POLYGON];
        projected_vertex_x = new int[MAX_POLYGON];
        projected_vertex_y = new int[MAX_POLYGON];
        projected_vertex_z = new int[MAX_POLYGON];
        anIntArray1667 = new int[MAX_POLYGON];
        camera_vertex_y = new int[MAX_POLYGON];
        camera_vertex_x = new int[MAX_POLYGON];
        camera_vertex_z = new int[MAX_POLYGON];
        depthListIndices = new int[10050];
        faceLists = new int[10050][512];
        anIntArray1673 = new int[12];
        anIntArrayArray1674 = new int[12][6000];
        anIntArray1675 = new int[6000];
        anIntArray1676 = new int[6000];
        anIntArray1677 = new int[12];
        anIntArray1678 = new int[10];
        anIntArray1679 = new int[10];
        anIntArray1680 = new int[10];
        anIntArray1638 = new int[10];
        objectsInCurrentRegion = new int[1000];
        mapObjectIds = new int[1000];
        SINE = Rasterizer.SINE;
        COSINE = Rasterizer.COSINE;
        hsl2rgb = Rasterizer.hsl2rgb;
        lightDecay = Rasterizer.light_decay;
    }
}

