/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ObjectDef;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ObjectDefinitionLoader {
    private static Map<Integer, JsonObjectDefinition> loadedDefinitions = new HashMap<Integer, JsonObjectDefinition>();
    private static boolean isLoaded = false;

    public static void load(String jsonPath) {
        if (isLoaded) {
            return;
        }
        try {
            if (!Files.exists(Paths.get(jsonPath, new String[0]), new LinkOption[0])) {
                System.out.println("[ObjectDefinitionLoader] No custom definitions file found at: " + jsonPath);
                isLoaded = true;
                return;
            }
            System.out.println("[ObjectDefinitionLoader] Loading definitions from: " + jsonPath);
            String content = new String(Files.readAllBytes(Paths.get(jsonPath, new String[0])));
            ObjectDefinitionLoader.parseJsonArray(content);
            isLoaded = true;
            System.out.println("[ObjectDefinitionLoader] Loaded " + loadedDefinitions.size() + " Object definitions");
        }
        catch (Exception e) {
            System.err.println("[ObjectDefinitionLoader] Failed to load definitions: " + e.getMessage());
            isLoaded = true;
        }
    }

    public static ObjectDef applyOverrides(ObjectDef objectDef, int id) {
        if (!isLoaded || !loadedDefinitions.containsKey(id)) {
            return objectDef;
        }
        JsonObjectDefinition json = loadedDefinitions.get(id);
        if (json.name != null) {
            objectDef.name = json.name;
        }
        if (json.objectModelIDs != null && json.objectModelIDs.length > 0) {
            objectDef.objectModelIDs = json.objectModelIDs;
        }
        if (json.actions != null) {
            objectDef.actions = new String[5];
            for (int i = 0; i < Math.min(json.actions.length, 5); ++i) {
                objectDef.actions[i] = json.actions[i];
            }
        }
        if (json.hasActions) {
            objectDef.hasActions = true;
        }
        if (json.sizeX > 0) {
            objectDef.sizeX = json.sizeX;
        }
        if (json.sizeY > 0) {
            objectDef.sizeY = json.sizeY;
        }
        return objectDef;
    }

    public static boolean hasOverride(int id) {
        return loadedDefinitions.containsKey(id);
    }

    public static int getDefinitionCount() {
        return loadedDefinitions.size();
    }

    private static void parseJsonArray(String json) {
        if ((json = json.trim()).startsWith("[")) {
            json = json.substring(1);
        }
        if (json.endsWith("]")) {
            json = json.substring(0, json.length() - 1);
        }
        int depth = 0;
        int objectStart = -1;
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                if (depth == 0) {
                    objectStart = i;
                }
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0 || objectStart < 0) continue;
            String objectJson = json.substring(objectStart, i + 1);
            JsonObjectDefinition def = ObjectDefinitionLoader.parseJsonObject(objectJson);
            if (def != null && def.id >= 0) {
                loadedDefinitions.put(def.id, def);
            }
            objectStart = -1;
        }
    }

    private static JsonObjectDefinition parseJsonObject(String json) {
        String[] parts;
        JsonObjectDefinition def = new JsonObjectDefinition();
        if ((json = json.trim()).startsWith("{")) {
            json = json.substring(1);
        }
        if (json.endsWith("}")) {
            json = json.substring(0, json.length() - 1);
        }
        for (String part : parts = ObjectDefinitionLoader.splitJsonPairs(json)) {
            int colonIndex;
            if ((part = part.trim()).isEmpty() || (colonIndex = part.indexOf(58)) < 0) continue;
            String key = part.substring(0, colonIndex).trim();
            String value = part.substring(colonIndex + 1).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            try {
                switch (key) {
                    case "id": {
                        def.id = Integer.parseInt(value);
                        break;
                    }
                    case "name": {
                        def.name = ObjectDefinitionLoader.parseStringValue(value);
                        break;
                    }
                    case "objectModelIDs": {
                        def.objectModelIDs = ObjectDefinitionLoader.parseIntArray(value);
                        break;
                    }
                    case "actions": {
                        def.actions = ObjectDefinitionLoader.parseStringArray(value);
                        break;
                    }
                    case "hasActions": {
                        def.hasActions = Boolean.parseBoolean(value);
                        break;
                    }
                    case "sizeX": {
                        def.sizeX = Integer.parseInt(value);
                        break;
                    }
                    case "sizeY": {
                        def.sizeY = Integer.parseInt(value);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private static String[] splitJsonPairs(String json) {
        ArrayList<String> pairs = new ArrayList<String>();
        int depth = 0;
        int start = 0;
        boolean inString = false;
        for (int i = 0; i < json.length(); ++i) {
            char prev;
            char c = json.charAt(i);
            char c2 = prev = i > 0 ? json.charAt(i - 1) : (char)'\u0000';
            if (c == '\"' && prev != '\\') {
                inString = !inString;
                continue;
            }
            if (inString) continue;
            if (c == '[' || c == '{') {
                ++depth;
                continue;
            }
            if (c == ']' || c == '}') {
                --depth;
                continue;
            }
            if (c != ',' || depth != 0) continue;
            pairs.add(json.substring(start, i));
            start = i + 1;
        }
        if (start < json.length()) {
            pairs.add(json.substring(start));
        }
        return pairs.toArray(new String[0]);
    }

    private static String parseStringValue(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value.replace("\\\"", "\"").replace("\\n", "\n").replace("\\\\", "\\");
    }

    private static String[] parseStringArray(String value) {
        if (!(value = value.trim()).startsWith("[") || !value.endsWith("]")) {
            return new String[0];
        }
        if ((value = value.substring(1, value.length() - 1)).isEmpty()) {
            return new String[0];
        }
        ArrayList<String> items = new ArrayList<String>();
        boolean inString = false;
        int start = 0;
        for (int i = 0; i < value.length(); ++i) {
            char prev;
            char c = value.charAt(i);
            char c2 = prev = i > 0 ? value.charAt(i - 1) : (char)'\u0000';
            if (c == '\"' && prev != '\\') {
                inString = !inString;
                continue;
            }
            if (c != ',' || inString) continue;
            String item = value.substring(start, i).trim();
            if (item.equals("null")) {
                items.add(null);
            } else {
                items.add(ObjectDefinitionLoader.parseStringValue(item));
            }
            start = i + 1;
        }
        if (start < value.length()) {
            String item = value.substring(start).trim();
            if (item.equals("null")) {
                items.add(null);
            } else {
                items.add(ObjectDefinitionLoader.parseStringValue(item));
            }
        }
        return items.toArray(new String[0]);
    }

    private static int[] parseIntArray(String value) {
        if (!(value = value.trim()).startsWith("[") || !value.endsWith("]")) {
            return new int[0];
        }
        if ((value = value.substring(1, value.length() - 1).trim()).isEmpty()) {
            return new int[0];
        }
        String[] parts = value.split(",");
        int[] result = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                result[i] = Integer.parseInt(parts[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                result[i] = 0;
            }
        }
        return result;
    }

    private static class JsonObjectDefinition {
        int id = -1;
        String name;
        int[] objectModelIDs;
        String[] actions;
        boolean hasActions = false;
        int sizeX = 0;
        int sizeY = 0;

        private JsonObjectDefinition() {
        }
    }
}

