/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.Client;
import com.teragard.Deque;
import com.teragard.FileOperations;
import com.teragard.OnDemandFetcherParent;
import com.teragard.OnDemandRequest;
import com.teragard.Queue;
import com.teragard.Stream;
import com.teragard.signlink;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;

public class OnDemandFetcher
extends OnDemandFetcherParent
implements Runnable {
    int[] cheapHaxValues = new int[]{3627, 3628, 3655, 3656, 3625, 3626, 3629, 3630, 4071, 4072, 5253, 1816, 1817, 3653, 3654, 4067, 4068, 3639, 3640, 1976, 1977, 3571, 3572, 5129, 5130, 2066, 2067, 3545, 3546, 3559, 3560, 3569, 3570, 3551, 3552, 3579, 3580, 3575, 3576, 1766, 1767, 3547, 3548, 3682, 3683, 3696, 3697, 3692, 3693, 4013, 4079, 4080, 4082, 3996, 4083, 4084, 4075, 4076, 3664, 3993, 3994, 3995, 4077, 4078, 4073, 4074, 4011, 4012, 3998, 3999, 4081};
    private int queueSize;
    private int totalFiles;
    private Deque requested = new Deque();
    private int filesToGet;
    public String statusString = "";
    private int writeLoopCycle;
    private long openSocketTime;
    private int[] objectMapIds;
    private byte[] ioBuffer;
    public int onDemandCycle;
    private byte[][] fileStatus2;
    private Client clientInstance;
    private Deque nodeList_1;
    private int completedSize;
    private int expectedSize;
    private int[] midiIndices;
    private int[] landscapeIds;
    private int filesLoaded;
    private boolean running = true;
    private OutputStream outputStream;
    private int[] regionIsMembers;
    private boolean waiting = false;
    private Deque zippedNodes;
    private byte[] gzipInputBuffer;
    private Queue queue;
    private InputStream inputStream;
    private Socket socket;
    private int[][] versions;
    private int extraFileCount;
    private int completedCount;
    private Deque receivedFilesList;
    private OnDemandRequest current;
    private Deque fetchFromCacheList;
    private int[] regionIds;
    private int loopCycle;
    private final int[][] crcs;
    private byte[] modelIndices;
    private final CRC32 crc32 = new CRC32();

    public void dumpMaps() {
        FileOutputStream fos;
        File map;
        byte[] abyte;
        int i;
        File folder = new File("C:/Users/te12ga8/map_dump/");
        folder.mkdir();
        for (i = 0; i < this.landscapeIds.length; ++i) {
            try {
                abyte = Client.getClient().cacheIndices[4].get(this.landscapeIds[i]);
                if (abyte == null) {
                    System.out.println("Couldn't fetch cached landscape: " + this.landscapeIds[i]);
                    continue;
                }
                map = new File(folder.getAbsolutePath() + System.getProperty("file.separator") + this.landscapeIds[i] + ".gz");
                fos = new FileOutputStream(map);
                fos.write(abyte);
                fos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < this.objectMapIds.length; ++i) {
            try {
                abyte = Client.getClient().cacheIndices[4].get(this.objectMapIds[i]);
                if (abyte == null) {
                    System.out.println("Couldn't fetch cached terrain: " + this.objectMapIds[i]);
                    continue;
                }
                map = new File(folder.getAbsolutePath() + System.getProperty("file.separator") + this.objectMapIds[i] + ".gz");
                fos = new FileOutputStream(map);
                fos.write(abyte);
                fos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean crcMatches(int expectedValue, byte[] crcData) {
        if (crcData == null || crcData.length < 2) {
            return false;
        }
        int length = crcData.length - 2;
        this.crc32.reset();
        this.crc32.update(crcData, 0, length);
        int crcValue = (int)this.crc32.getValue();
        return crcValue == expectedValue;
    }

    public void writeAll() {
        for (int i = 0; i < 6; ++i) {
            this.writeChecksumList(i);
            this.writeVersionList(i);
        }
    }

    public int getChecksum(int type, int id) {
        int crc = -1;
        byte[] data = this.clientInstance.cacheIndices[type + 1].get(id);
        if (data != null) {
            int length = data.length - 2;
            this.crc32.reset();
            this.crc32.update(data, 0, length);
            crc = (int)this.crc32.getValue();
        }
        return crc;
    }

    public int getVersion(int type, int id) {
        int version = -1;
        byte[] data = this.clientInstance.cacheIndices[type + 1].get(id);
        if (data != null) {
            int length = data.length - 2;
            version = ((data[length] & 0xFF) << 8) + (data[length + 1] & 0xFF);
        }
        return version;
    }

    public void writeChecksumList(int type) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(signlink.findcachedir() + type + "_crc.dat"));
            int total = 0;
            int index = 0;
            while ((long)index < this.clientInstance.cacheIndices[type + 1].getFileCount()) {
                out.writeInt(this.getChecksum(type, index));
                ++total;
                ++index;
            }
            System.out.println(type + "-" + total);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeVersionList(int type) {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(signlink.findcachedir() + type + "_version.dat"));
            int index = 0;
            while ((long)index < this.clientInstance.cacheIndices[type + 1].getFileCount()) {
                out.writeShort(this.getVersion(type, index));
                ++index;
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeDWord(DataOutputStream dos, int i) {
        try {
            dos.writeByte((byte)(i >> 24));
            dos.writeByte((byte)(i >> 16));
            dos.writeByte((byte)(i >> 8));
            dos.writeByte((byte)i);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readData() {
        try {
            int readAbleBytes = this.inputStream.available();
            if (this.expectedSize == 0 && readAbleBytes >= 10) {
                this.waiting = true;
                for (int k = 0; k < 10; k += this.inputStream.read(this.ioBuffer, k, 10 - k)) {
                }
                int receivedType = this.ioBuffer[0] & 0xFF;
                int receivedID = ((this.ioBuffer[1] & 0xFF) << 16) + ((this.ioBuffer[2] & 0xFF) << 8) + (this.ioBuffer[3] & 0xFF);
                int receivedSize = ((this.ioBuffer[4] & 0xFF) << 32) + ((this.ioBuffer[5] & 0xFF) << 16) + ((this.ioBuffer[6] & 0xFF) << 8) + (this.ioBuffer[7] & 0xFF);
                int chunkId = ((this.ioBuffer[8] & 0xFF) << 8) + (this.ioBuffer[9] & 0xFF);
                this.current = null;
                OnDemandRequest OnDemandRequest2 = (OnDemandRequest)this.requested.getFront();
                while (OnDemandRequest2 != null) {
                    if (OnDemandRequest2.dataType == receivedType && OnDemandRequest2.id == receivedID) {
                        this.current = OnDemandRequest2;
                    }
                    if (this.current != null) {
                        OnDemandRequest2.loopCycle = 0;
                    }
                    OnDemandRequest2 = (OnDemandRequest)this.requested.getNext();
                }
                if (this.current != null) {
                    this.loopCycle = 0;
                    if (receivedSize == 0) {
                        System.out.println("Rej: " + receivedType + "," + receivedID);
                        this.current.buffer = null;
                        if (this.current.isNotExtraFile) {
                            Deque deque = this.zippedNodes;
                            synchronized (deque) {
                                this.zippedNodes.insertBack(this.current);
                            }
                        } else {
                            this.current.unlink();
                        }
                        this.current = null;
                    } else {
                        if (this.current.buffer == null && chunkId == 0) {
                            this.current.buffer = new byte[receivedSize];
                        }
                        if (this.current.buffer == null && chunkId != 0) {
                            throw new IOException("missing start of file");
                        }
                    }
                }
                this.completedSize = chunkId * 500;
                this.expectedSize = 500;
                if (this.expectedSize > receivedSize - chunkId * 500) {
                    this.expectedSize = receivedSize - chunkId * 500;
                }
            }
            if (this.expectedSize > 0 && readAbleBytes >= this.expectedSize) {
                this.waiting = true;
                byte[] receivedData = this.ioBuffer;
                int tempCompSize = 0;
                if (this.current != null) {
                    receivedData = this.current.buffer;
                    tempCompSize = this.completedSize;
                }
                for (int dataReadIdx = 0; dataReadIdx < this.expectedSize; dataReadIdx += this.inputStream.read(receivedData, dataReadIdx + tempCompSize, this.expectedSize - dataReadIdx)) {
                }
                if (this.expectedSize + this.completedSize >= receivedData.length && this.current != null) {
                    this.clientInstance.cacheIndices[this.current.dataType + 1].put(receivedData.length, receivedData, this.current.id);
                    if (!this.current.isNotExtraFile && this.current.dataType == 3) {
                        this.current.isNotExtraFile = true;
                        this.current.dataType = 93;
                    }
                    if (this.current.isNotExtraFile) {
                        Deque deque = this.zippedNodes;
                        synchronized (deque) {
                            this.zippedNodes.insertBack(this.current);
                        }
                    } else {
                        this.current.unlink();
                    }
                }
                this.expectedSize = 0;
                return;
            }
        }
        catch (IOException ioexception) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.expectedSize = 0;
        }
    }

    public final void start(CacheArchive streamLoader, Client client) {
        for (int cachePtr = 0; cachePtr < 6; ++cachePtr) {
            byte[] crcFile = FileOperations.readFile(signlink.findcachedir() + "data/" + cachePtr + ".dat");
            int length = 0;
            length = crcFile.length / 4;
            Stream crcStream = new Stream(crcFile);
            this.crcs[cachePtr] = new int[length];
            this.fileStatus2[cachePtr] = new byte[length];
            for (int ptr = 0; ptr < length; ++ptr) {
                this.crcs[cachePtr][ptr] = crcStream.readDWord();
            }
        }
        byte[] modelIndex = streamLoader.getDataForName("map_index");
        Stream data = new Stream(modelIndex);
        int mapCount = data.readUnsignedWord();
        this.regionIds = new int[mapCount];
        this.landscapeIds = new int[mapCount];
        this.objectMapIds = new int[mapCount];
        this.regionIsMembers = new int[mapCount];
        int[] dntUse = new int[]{5181, 5182, 5183, 5184, 5180, 5179, 5175, 5176, 4014, 3997, 5314, 5315, 5172};
        for (int i2 = 0; i2 < mapCount; ++i2) {
            this.regionIds[i2] = data.readUnsignedWord();
            this.landscapeIds[i2] = data.readUnsignedWord();
            this.objectMapIds[i2] = data.readUnsignedWord();
            for (int i : dntUse) {
                if (this.landscapeIds[i2] == i) {
                    this.landscapeIds[i2] = -1;
                }
                if (this.objectMapIds[i2] != i) continue;
                this.objectMapIds[i2] = -1;
            }
        }
        this.regionIds[90] = 6457;
        this.landscapeIds[90] = 2300;
        this.objectMapIds[90] = 2301;
        int count = 70;
        this.regionIds[count] = 12701;
        this.objectMapIds[count] = 3209;
        this.landscapeIds[count++] = 3208;
        this.regionIds[count] = 12702;
        this.objectMapIds[count] = 3205;
        this.landscapeIds[count++] = 3204;
        this.regionIds[count] = 12703;
        this.objectMapIds[count] = 3213;
        this.landscapeIds[count++] = 3212;
        this.regionIds[count] = 12957;
        this.objectMapIds[count] = 3215;
        this.landscapeIds[count++] = 3214;
        this.regionIds[count] = 12958;
        this.objectMapIds[count] = 3211;
        this.landscapeIds[count++] = 3210;
        this.regionIds[count] = 12959;
        this.objectMapIds[count] = 3207;
        this.landscapeIds[count++] = 3206;
        this.regionIds[9] = 9043;
        this.landscapeIds[9] = 3018;
        this.objectMapIds[9] = 3019;
        this.regionIds[107] = 8751;
        this.landscapeIds[107] = 1946;
        this.objectMapIds[107] = 1947;
        this.regionIds[108] = 8752;
        this.landscapeIds[108] = 938;
        this.objectMapIds[108] = 939;
        this.regionIds[129] = 9007;
        this.landscapeIds[129] = 1938;
        this.objectMapIds[129] = 1939;
        this.regionIds[130] = 9008;
        this.landscapeIds[130] = 946;
        this.objectMapIds[130] = 947;
        this.regionIds[149] = 9263;
        this.landscapeIds[149] = 1210;
        this.objectMapIds[149] = 1211;
        this.regionIds[150] = 9264;
        this.landscapeIds[150] = 956;
        this.objectMapIds[150] = 957;
        this.regionIds[0] = 4883;
        this.landscapeIds[0] = 1984;
        this.objectMapIds[0] = 1985;
        this.regionIds[1] = 5139;
        this.landscapeIds[1] = 1988;
        this.objectMapIds[1] = 1989;
        this.regionIds[2] = 5140;
        this.landscapeIds[2] = 1986;
        this.objectMapIds[2] = 1987;
        modelIndex = streamLoader.getDataForName("model_index");
        int j1 = this.crcs[0].length;
        this.modelIndices = new byte[j1];
        for (int k1 = 0; k1 < j1; ++k1) {
            this.modelIndices[k1] = k1 < modelIndex.length ? modelIndex[k1] : (byte)0;
        }
        modelIndex = streamLoader.getDataForName("midi_index");
        data = new Stream(modelIndex);
        mapCount = modelIndex.length;
        this.midiIndices = new int[mapCount];
        for (int k2 = 0; k2 < mapCount; ++k2) {
            this.midiIndices[k2] = data.readUnsignedByte();
        }
        this.clientInstance = client;
        this.running = true;
        this.clientInstance.startRunnable(this, 2);
    }

    public int getImageCount() {
        return this.crcs[4].length;
    }

    public int getModelIndex(int id) {
        return this.modelIndices[id] & 0xFF;
    }

    public final void dispose() {
        this.running = false;
    }

    public final void fetchMaps(boolean isMember) {
        int length = this.regionIds.length;
        for (int mapPtr = 0; mapPtr < length; ++mapPtr) {
            if (!isMember && this.regionIsMembers[mapPtr] == 0 || this.objectMapIds[mapPtr] == -1 || this.landscapeIds[mapPtr] == -1 || Client.loggedIn) continue;
            this.fetchPriorityFile((byte)2, 3, this.objectMapIds[mapPtr]);
            this.fetchPriorityFile((byte)2, 3, this.landscapeIds[mapPtr]);
        }
    }

    public final int getVersionCount(int idx) {
        return this.versions[idx].length;
    }

    public final int getModelCount() {
        return 105534;
    }

    private final void closeRequest(OnDemandRequest OnDemandRequest2) {
        try {
            if (this.socket == null) {
                long l = System.currentTimeMillis();
                if (l - this.openSocketTime < 4000L) {
                    return;
                }
                this.openSocketTime = l;
                this.socket = this.clientInstance.openSocket(43597, "157.180.65.96");
                this.inputStream = this.socket.getInputStream();
                this.outputStream = this.socket.getOutputStream();
                this.outputStream.write(15);
                for (int j = 0; j < 8; ++j) {
                    this.inputStream.read();
                }
                this.loopCycle = 0;
            }
            this.ioBuffer[0] = (byte)OnDemandRequest2.dataType;
            this.ioBuffer[1] = (byte)(OnDemandRequest2.id >> 24);
            this.ioBuffer[2] = (byte)(OnDemandRequest2.id >> 16);
            this.ioBuffer[3] = (byte)(OnDemandRequest2.id >> 8);
            this.ioBuffer[4] = (byte)OnDemandRequest2.id;
            this.ioBuffer[5] = OnDemandRequest2.isNotExtraFile ? (byte)1 : (!Client.loggedIn ? (byte)1 : 0);
            this.outputStream.write(this.ioBuffer, 0, 6);
            this.writeLoopCycle = 0;
            return;
        }
        catch (IOException iOException) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            this.inputStream = null;
            this.outputStream = null;
            this.expectedSize = 0;
            return;
        }
    }

    public final int getAnimCount() {
        return 33568;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestFileData(int type, int id) {
        if (type < 0 || id < 0) {
            return;
        }
        Queue queue = this.queue;
        synchronized (queue) {
            OnDemandRequest OnDemandRequest_1 = (OnDemandRequest)this.queue.getFront();
            while (OnDemandRequest_1 != null) {
                if (OnDemandRequest_1.dataType == type && OnDemandRequest_1.id == id) {
                    return;
                }
                OnDemandRequest_1 = (OnDemandRequest)this.queue.getNext();
            }
            OnDemandRequest OnDemandRequest_2 = new OnDemandRequest();
            OnDemandRequest_2.dataType = type;
            OnDemandRequest_2.id = id;
            OnDemandRequest_2.isNotExtraFile = true;
            Deque deque = this.fetchFromCacheList;
            synchronized (deque) {
                this.fetchFromCacheList.insertBack(OnDemandRequest_2);
            }
            this.queue.insertBack(OnDemandRequest_2);
            this.queueSize = this.queue.getSize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public final void run() {
        try {
            while (this.running) {
                block19: {
                    block18: {
                        ++this.onDemandCycle;
                        int i = 20;
                        if (this.filesToGet == 0 && this.clientInstance.cacheIndices[0] != null) {
                            i = 50;
                        }
                        try {
                            Thread.sleep(i);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.waiting = true;
                        for (int ptr = 0; ptr < 100 && this.waiting; ++ptr) {
                            this.waiting = false;
                            this.checkReceived();
                            this.handleFailed();
                            if (this.extraFileCount == 0 && ptr >= 5) break;
                            this.getExtraFiles();
                            if (this.inputStream == null) continue;
                            this.readData();
                        }
                        boolean flag = false;
                        OnDemandRequest OnDemandRequest2 = (OnDemandRequest)this.requested.getFront();
                        while (OnDemandRequest2 != null) {
                            if (OnDemandRequest2.isNotExtraFile) {
                                flag = true;
                                ++OnDemandRequest2.loopCycle;
                                if (OnDemandRequest2.loopCycle > 50) {
                                    OnDemandRequest2.loopCycle = 0;
                                    this.closeRequest(OnDemandRequest2);
                                }
                            }
                            OnDemandRequest2 = (OnDemandRequest)this.requested.getNext();
                        }
                        if (!flag) {
                            OnDemandRequest OnDemandRequest_1 = (OnDemandRequest)this.requested.getFront();
                            while (OnDemandRequest_1 != null) {
                                flag = true;
                                ++OnDemandRequest_1.loopCycle;
                                if (OnDemandRequest_1.loopCycle > 50) {
                                    OnDemandRequest_1.loopCycle = 0;
                                    this.closeRequest(OnDemandRequest_1);
                                }
                                OnDemandRequest_1 = (OnDemandRequest)this.requested.getNext();
                            }
                        }
                        if (!flag) break block18;
                        ++this.loopCycle;
                        if (this.loopCycle > 750) {
                            try {
                                this.socket.close();
                            }
                            catch (Exception OnDemandRequest_1) {
                                // empty catch block
                            }
                            this.socket = null;
                            this.inputStream = null;
                            this.outputStream = null;
                            this.expectedSize = 0;
                            this.requested.popFront();
                        }
                        break block19;
                    }
                    this.loopCycle = 0;
                    this.statusString = "";
                }
                if (!Client.loggedIn || this.socket == null || this.outputStream == null || this.filesToGet <= 0 && this.clientInstance.cacheIndices[0] != null) continue;
                ++this.writeLoopCycle;
                if (this.writeLoopCycle <= 500) continue;
                this.writeLoopCycle = 0;
                this.ioBuffer[0] = 0;
                this.ioBuffer[1] = 0;
                this.ioBuffer[2] = 0;
                this.ioBuffer[3] = 0;
                this.ioBuffer[4] = 0;
                this.ioBuffer[5] = 10;
                try {
                    this.outputStream.write(this.ioBuffer, 0, 6);
                }
                catch (IOException _ex) {
                    this.loopCycle = 5000;
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("od_ex " + exception.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insertExtraFilesRequest(int fileId, int idx) {
        if (this.clientInstance.cacheIndices[0] == null) {
            return;
        }
        if (fileId >= this.fileStatus2[idx].length) {
            return;
        }
        if (this.fileStatus2[idx][fileId] == 0) {
            return;
        }
        if (this.filesToGet == 0) {
            return;
        }
        OnDemandRequest OnDemandRequest2 = new OnDemandRequest();
        OnDemandRequest2.dataType = idx;
        OnDemandRequest2.id = fileId;
        OnDemandRequest2.isNotExtraFile = false;
        Deque deque = this.nodeList_1;
        synchronized (deque) {
            this.nodeList_1.insertBack(OnDemandRequest2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OnDemandRequest getNextNode() {
        OnDemandRequest OnDemandRequest2;
        Object object = this.zippedNodes;
        synchronized (object) {
            OnDemandRequest2 = (OnDemandRequest)this.zippedNodes.popFront();
        }
        if (OnDemandRequest2 == null) {
            return null;
        }
        object = this.queue;
        synchronized (object) {
            OnDemandRequest2.unlinkQueue();
            this.queueSize = this.queue.getSize();
        }
        if (OnDemandRequest2.buffer == null) {
            return OnDemandRequest2;
        }
        int readData = 0;
        try {
            GZIPInputStream gzipinputstream = new GZIPInputStream(new ByteArrayInputStream(OnDemandRequest2.buffer));
            while (true) {
                if (readData >= this.gzipInputBuffer.length) {
                    System.out.println("File: " + OnDemandRequest2.id + " too large");
                    break;
                }
                int tempReadData = -1;
                try {
                    tempReadData = gzipinputstream.read(this.gzipInputBuffer, readData, this.gzipInputBuffer.length - readData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tempReadData != -1) {
                    readData += tempReadData;
                    continue;
                }
                break;
            }
        }
        catch (IOException _ex) {
            _ex.printStackTrace();
            throw new RuntimeException("error unzipping");
        }
        OnDemandRequest2.buffer = new byte[readData];
        for (int bufferPtr = 0; bufferPtr < readData; ++bufferPtr) {
            OnDemandRequest2.buffer[bufferPtr] = this.gzipInputBuffer[bufferPtr];
        }
        return OnDemandRequest2;
    }

    public final int getMapIdForRegions(int landscapeOrObject, int regionY, int regionX) {
        int regionId = (regionX << 8) + regionY;
        for (int j1 = 0; j1 < this.regionIds.length; ++j1) {
            if (this.regionIds[j1] != regionId) continue;
            if (landscapeOrObject == 0) {
                if (this.landscapeIds[j1] >= 3700 && this.landscapeIds[j1] <= 3840) {
                    return this.landscapeIds[j1];
                }
                for (int cheapHax : this.cheapHaxValues) {
                    if (this.landscapeIds[j1] != cheapHax) continue;
                    return this.landscapeIds[j1];
                }
                int mapNigga2 = this.landscapeIds[j1] > 3535 ? -1 : this.landscapeIds[j1];
                return mapNigga2;
            }
            if (this.objectMapIds[j1] >= 3700 && this.objectMapIds[j1] <= 3840) {
                return this.objectMapIds[j1];
            }
            for (int cheapHax : this.cheapHaxValues) {
                if (this.objectMapIds[j1] != cheapHax) continue;
                return this.objectMapIds[j1];
            }
            int mapNigga3 = this.objectMapIds[j1] > 3535 ? -1 : this.objectMapIds[j1];
            return mapNigga3;
        }
        return -1;
    }

    @Override
    public final void get(int idx) {
        this.requestFileData(0, idx);
    }

    public final void fetchPriorityFile(byte fileData, int idx, int fileId) {
        if (this.clientInstance.cacheIndices[0] == null) {
            return;
        }
        if (fileId >= this.crcs[idx].length) {
            return;
        }
        byte[] data = this.clientInstance.cacheIndices[idx + 1].get(fileId);
        if (this.crcMatches(this.crcs[idx][fileId], data)) {
            return;
        }
        this.fileStatus2[idx][fileId] = fileData;
        if (fileData > this.filesToGet) {
            this.filesToGet = fileData;
        }
        ++this.totalFiles;
    }

    public final boolean mapIsObjectMap(int obectMap) {
        for (int ptr = 0; ptr < this.regionIds.length; ++ptr) {
            if (this.objectMapIds[ptr] != obectMap) continue;
            return true;
        }
        return false;
    }

    private final void handleFailed() {
        this.extraFileCount = 0;
        this.completedCount = 0;
        OnDemandRequest OnDemandRequest2 = (OnDemandRequest)this.requested.getFront();
        while (OnDemandRequest2 != null) {
            if (OnDemandRequest2.isNotExtraFile) {
                ++this.extraFileCount;
            } else {
                ++this.completedCount;
            }
            OnDemandRequest2 = (OnDemandRequest)this.requested.getNext();
        }
        while (this.extraFileCount < 10) {
            OnDemandRequest OnDemandRequest_1 = null;
            OnDemandRequest_1 = (OnDemandRequest)this.receivedFilesList.popFront();
            if (OnDemandRequest_1 == null) break;
            try {
                if (this.fileStatus2[OnDemandRequest_1.dataType][OnDemandRequest_1.id] != 0) {
                    ++this.filesLoaded;
                }
                this.fileStatus2[OnDemandRequest_1.dataType][OnDemandRequest_1.id] = 0;
                this.requested.insertBack(OnDemandRequest_1);
                ++this.extraFileCount;
                this.closeRequest(OnDemandRequest_1);
                this.waiting = true;
            }
            catch (Exception e) {
                System.out.println(OnDemandRequest_1.dataType + " " + OnDemandRequest_1.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearExtraFilesList() {
        Deque deque = this.nodeList_1;
        synchronized (deque) {
            this.nodeList_1.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkReceived() {
        OnDemandRequest OnDemandRequest2;
        Deque deque = this.fetchFromCacheList;
        synchronized (deque) {
            OnDemandRequest2 = (OnDemandRequest)this.fetchFromCacheList.popFront();
        }
        while (OnDemandRequest2 != null) {
            this.waiting = true;
            byte[] data = null;
            if (this.clientInstance.cacheIndices[0] != null) {
                data = this.clientInstance.cacheIndices[OnDemandRequest2.dataType + 1].get(OnDemandRequest2.id);
            }
            Deque deque2 = this.fetchFromCacheList;
            synchronized (deque2) {
                if (data == null) {
                    this.receivedFilesList.insertBack(OnDemandRequest2);
                } else {
                    OnDemandRequest2.buffer = data;
                    Deque deque3 = this.zippedNodes;
                    synchronized (deque3) {
                        this.zippedNodes.insertBack(OnDemandRequest2);
                    }
                }
                OnDemandRequest2 = (OnDemandRequest)this.fetchFromCacheList.popFront();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getExtraFiles() {
        while (this.extraFileCount == 0 && this.completedCount < 10 && this.filesToGet != 0) {
            OnDemandRequest OnDemandRequest2;
            Deque deque = this.nodeList_1;
            synchronized (deque) {
                OnDemandRequest2 = (OnDemandRequest)this.nodeList_1.popFront();
            }
            while (OnDemandRequest2 != null) {
                if (this.fileStatus2[OnDemandRequest2.dataType][OnDemandRequest2.id] != 0) {
                    this.fileStatus2[OnDemandRequest2.dataType][OnDemandRequest2.id] = 0;
                    this.requested.insertBack(OnDemandRequest2);
                    this.closeRequest(OnDemandRequest2);
                    this.waiting = true;
                    if (this.filesLoaded < this.totalFiles) {
                        ++this.filesLoaded;
                    }
                    this.statusString = "Loading extra files - " + this.filesLoaded * 100 / this.totalFiles + "%";
                    System.out.println(this.statusString);
                    ++this.completedCount;
                    if (this.completedCount == 10) {
                        return;
                    }
                }
                deque = this.nodeList_1;
                synchronized (deque) {
                    OnDemandRequest2 = (OnDemandRequest)this.nodeList_1.popFront();
                }
            }
            for (int j = 0; j < 5; ++j) {
                byte[] fileData = this.fileStatus2[j];
                int k = fileData.length;
                for (int l = 0; l < k; ++l) {
                    if (fileData[l] != this.filesToGet) continue;
                    fileData[l] = 0;
                    OnDemandRequest OnDemandRequest_1 = new OnDemandRequest();
                    OnDemandRequest_1.dataType = j;
                    OnDemandRequest_1.id = l;
                    OnDemandRequest_1.isNotExtraFile = false;
                    this.requested.insertBack(OnDemandRequest_1);
                    this.closeRequest(OnDemandRequest_1);
                    this.waiting = true;
                    if (this.filesLoaded < this.totalFiles) {
                        ++this.filesLoaded;
                    }
                    this.statusString = "Loading extra files - " + this.filesLoaded * 100 / this.totalFiles + "%";
                    ++this.completedCount;
                    if (this.completedCount != 10) continue;
                    return;
                }
            }
            --this.filesToGet;
        }
    }

    public final boolean midiExists(int i) {
        return this.midiIndices[i] == 1;
    }

    public OnDemandFetcher() {
        this.ioBuffer = new byte[500];
        this.fileStatus2 = new byte[7][];
        this.nodeList_1 = new Deque();
        this.zippedNodes = new Deque();
        this.gzipInputBuffer = new byte[1000000];
        this.queue = new Queue();
        this.versions = new int[7][];
        this.receivedFilesList = new Deque();
        this.fetchFromCacheList = new Deque();
        this.crcs = new int[6][];
    }

    public int getRemaining() {
        return this.queueSize;
    }
}

