/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.DrawingArea;
import com.teragard.DrawingArea474;
import com.teragard.Sprite;
import com.teragard.SpriteLoader;
import com.teragard.Stream;
import java.awt.Color;

public class RSFontSystem
extends DrawingArea {
    public int baseCharacterHeight = 0;
    public int anInt4142;
    public int anInt4144;
    public int[] characterDrawYOffsets;
    public int[] characterHeights;
    public int[] characterDrawXOffsets;
    public int[] characterWidths;
    public int[] iconWidths;
    public byte[] aByteArray4151;
    public byte[][] fontPixels;
    public int[] characterScreenWidths;
    public static String aRSString_4135;
    public static String startTransparency;
    public static String startDefaultShadow;
    public static String endShadow;
    public static String endEffect;
    public static String aRSString_4143;
    public static String endStrikethrough;
    public static String aRSString_4147;
    public static String startColor;
    public static String lineBreak;
    public static String startStrikethrough;
    public static String endColor;
    public static String startImage;
    public static String endUnderline;
    public static String defaultStrikethrough;
    public static String startShadow;
    public static String startEffect;
    public static String aRSString_4162;
    public static String aRSString_4163;
    public static String endTransparency;
    public static String aRSString_4165;
    public static String startUnderline;
    public static String startDefaultUnderline;
    public static String aRSString_4169;
    public static String[] splitTextStrings;
    public static int defaultColor;
    public static int textShadowColor;
    public static int strikethroughColor;
    public static int defaultTransparency;
    public static int anInt4175;
    public static int underlineColor;
    public static int defaultShadow;
    public static int anInt4178;
    public static int transparency;
    public static int textColor;
    public static boolean SMILIES_TOGGLED;

    public RSFontSystem(boolean TypeFont, String s, CacheArchive archive) {
        try {
            int length = s.equals("regularhit") || s.equals("bighit") ? 58 : 256;
            this.fontPixels = new byte[length][];
            this.characterWidths = new int[length];
            this.characterHeights = new int[length];
            this.characterDrawXOffsets = new int[length];
            this.characterDrawYOffsets = new int[length];
            this.characterScreenWidths = new int[length];
            Stream stream = new Stream(archive.getDataForName(s + ".dat"));
            Stream stream_1 = new Stream(archive.getDataForName("index.dat"));
            stream_1.currentOffset = stream.readShort() + 4;
            int k = stream_1.readUByte();
            if (k > 0) {
                stream_1.currentOffset += 3 * (k - 1);
            }
            for (int l = 0; l < length; ++l) {
                this.characterDrawXOffsets[l] = stream_1.readUByte();
                this.characterDrawYOffsets[l] = stream_1.readUByte();
                int i1 = this.characterWidths[l] = stream_1.readShort();
                int j1 = this.characterHeights[l] = stream_1.readShort();
                int k1 = stream_1.readUByte();
                int l1 = i1 * j1;
                this.fontPixels[l] = new byte[l1];
                if (k1 == 0) {
                    for (int i2 = 0; i2 < l1; ++i2) {
                        this.fontPixels[l][i2] = stream.readByte();
                    }
                } else if (k1 == 1) {
                    for (int j2 = 0; j2 < i1; ++j2) {
                        for (int l2 = 0; l2 < j1; ++l2) {
                            this.fontPixels[l][j2 + l2 * i1] = stream.readByte();
                        }
                    }
                }
                if (j1 > this.baseCharacterHeight && l < 128) {
                    this.baseCharacterHeight = j1;
                }
                this.characterDrawXOffsets[l] = 1;
                this.characterScreenWidths[l] = i1 + 2;
                int k2 = 0;
                for (int i3 = j1 / 7; i3 < j1; ++i3) {
                    k2 += this.fontPixels[l][i3 * i1];
                }
                if (k2 <= j1 / 7) {
                    int n = l;
                    this.characterScreenWidths[n] = this.characterScreenWidths[n] - 1;
                    this.characterDrawXOffsets[l] = 0;
                }
                k2 = 0;
                for (int j3 = j1 / 7; j3 < j1; ++j3) {
                    k2 += this.fontPixels[l][i1 - 1 + j3 * i1];
                }
                if (k2 > j1 / 7) continue;
                int n = l;
                this.characterScreenWidths[n] = this.characterScreenWidths[n] - 1;
            }
            this.characterScreenWidths[32] = TypeFont ? this.characterScreenWidths[73] : this.characterScreenWidths[105];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawStringMoveY(String string, int drawX, int drawY, int color, int shadow, int randomMod, int randomMod2) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            double d = 7.0 - (double)randomMod2 / 8.0;
            if (d < 0.0) {
                d = 0.0;
            }
            int[] yOffset = new int[string.length()];
            for (int index = 0; index < string.length(); ++index) {
                yOffset[index] = (int)(Math.sin((double)index / 1.5 + (double)randomMod) * d);
            }
            this.drawBaseStringMoveXY(string, drawX - this.getTextWidth(string) / 2, drawY, null, yOffset);
        }
    }

    public int getCharacterWidth(int i) {
        return this.characterScreenWidths[i & 0xFF];
    }

    public void setDefaultTextEffectValues(int color, int shadow, int trans) {
        strikethroughColor = -1;
        underlineColor = -1;
        textShadowColor = defaultShadow = shadow;
        textColor = defaultColor = color;
        transparency = defaultTransparency = trans;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public void drawCenteredStringMoveXY(String string, int drawX, int drawY, int color, int shadow, int randomMod) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            int[] xMods = new int[string.length()];
            int[] yMods = new int[string.length()];
            for (int index = 0; index < string.length(); ++index) {
                xMods[index] = (int)(Math.sin((double)index / 5.0 + (double)randomMod / 5.0) * 5.0);
                yMods[index] = (int)(Math.sin((double)index / 3.0 + (double)randomMod / 5.0) * 5.0);
            }
            this.drawBaseStringMoveXY(string, drawX - this.getTextWidth(string) / 2, drawY, xMods, yMods);
        }
    }

    public void drawCenteredStringMoveY(String class100, int drawX, int drawY, int color, int shadow, int i_54_) {
        if (class100 != null) {
            this.setColorAndShadow(color, shadow);
            int[] yOffset = new int[class100.length()];
            for (int index = 0; index < class100.length(); ++index) {
                yOffset[index] = (int)(Math.sin((double)index / 2.0 + (double)i_54_ / 5.0) * 5.0);
            }
            this.drawBaseStringMoveXY(class100, drawX - this.getTextWidth(class100) / 2, drawY, null, yOffset);
        }
    }

    public void drawBasicString(String string, int drawX, int drawY) {
        drawY -= this.baseCharacterHeight;
        int startIndex = -1;
        for (int currentCharacter = 0; currentCharacter < string.length(); ++currentCharacter) {
            int character = string.charAt(currentCharacter);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                startIndex = currentCharacter;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effectString = string.substring(startIndex + 1, currentCharacter);
                startIndex = -1;
                if (effectString.equals(startEffect)) {
                    character = 60;
                } else if (effectString.equals(endEffect)) {
                    character = 62;
                } else if (effectString.equals(aRSString_4135)) {
                    character = 160;
                } else if (effectString.equals(aRSString_4162)) {
                    character = 173;
                } else if (effectString.equals(aRSString_4165)) {
                    character = 215;
                } else if (effectString.equals(aRSString_4147)) {
                    character = 128;
                } else if (effectString.equals(aRSString_4163)) {
                    character = 169;
                } else if (effectString.equals(aRSString_4169)) {
                    character = 174;
                } else {
                    if (effectString.startsWith(startImage)) {
                        try {
                            int imageId = Integer.valueOf(effectString.substring(4));
                            Sprite icon = SpriteLoader.sprites[679 + imageId];
                            int iconModY = icon.myHeight;
                            if (imageId >= 8) {
                                iconModY -= 2;
                            }
                            if (transparency == 256) {
                                icon.drawSprite(drawX, drawY + this.baseCharacterHeight - iconModY);
                            } else {
                                icon.drawSprite(drawX, drawY + this.baseCharacterHeight - iconModY, transparency);
                            }
                            drawX += icon.myWidth;
                        }
                        catch (Exception imageId) {}
                        continue;
                    }
                    this.setTextEffects(effectString);
                    continue;
                }
            }
            if (startIndex != -1) continue;
            int width = this.characterWidths[character];
            int height = this.characterHeights[character];
            if (character != 32) {
                if (transparency == 256) {
                    if (textShadowColor != -1) {
                        this.drawCharacter(character, drawX + this.characterDrawXOffsets[character] + 1, drawY + this.characterDrawYOffsets[character] + 1, width, height, textShadowColor, true);
                    }
                    this.drawCharacter(character, drawX + this.characterDrawXOffsets[character], drawY + this.characterDrawYOffsets[character], width, height, textColor, false);
                } else {
                    if (textShadowColor != -1) {
                        this.drawTransparentCharacter(character, drawX + this.characterDrawXOffsets[character] + 1, drawY + this.characterDrawYOffsets[character] + 1, width, height, textShadowColor, transparency, true);
                    }
                    this.drawTransparentCharacter(character, drawX + this.characterDrawXOffsets[character], drawY + this.characterDrawYOffsets[character], width, height, textColor, transparency, false);
                }
            } else if (anInt4178 > 0) {
                drawX += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int lineWidth = this.characterScreenWidths[character];
            if (strikethroughColor != -1) {
                DrawingArea474.drawHorizontalLine(drawX, drawY + (int)((double)this.baseCharacterHeight * 0.7), lineWidth, strikethroughColor);
            }
            if (underlineColor != -1) {
                DrawingArea474.drawHorizontalLine(drawX, drawY + this.baseCharacterHeight, lineWidth, underlineColor);
            }
            drawX += lineWidth;
        }
    }

    public void drawRAString(String string, int drawX, int drawY, int color, int shadow) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            this.drawBasicString(string, drawX - this.getTextWidth(string), drawY);
        }
    }

    public void drawBaseStringMoveXY(String string, int drawX, int drawY, int[] xModifier, int[] yModifier) {
        drawY -= this.baseCharacterHeight;
        int startIndex = -1;
        int modifierOffset = 0;
        for (int currentCharacter = 0; currentCharacter < string.length(); ++currentCharacter) {
            int character = string.charAt(currentCharacter);
            if (character == 60) {
                startIndex = currentCharacter;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effectString = string.substring(startIndex + 1, currentCharacter);
                startIndex = -1;
                if (effectString.equals(startEffect)) {
                    character = 60;
                } else if (effectString.equals(endEffect)) {
                    character = 62;
                } else if (effectString.equals(aRSString_4135)) {
                    character = 160;
                } else if (effectString.equals(aRSString_4162)) {
                    character = 173;
                } else if (effectString.equals(aRSString_4165)) {
                    character = 215;
                } else if (effectString.equals(aRSString_4147)) {
                    character = 128;
                } else if (effectString.equals(aRSString_4163)) {
                    character = 169;
                } else if (effectString.equals(aRSString_4169)) {
                    character = 174;
                } else {
                    if (effectString.startsWith(startImage)) {
                        try {
                            int xModI = xModifier != null ? xModifier[modifierOffset] : 0;
                            int yMod = yModifier != null ? yModifier[modifierOffset] : 0;
                            ++modifierOffset;
                            int iconId = Integer.valueOf(effectString.substring(4));
                            Sprite icon = SpriteLoader.sprites[679 + iconId];
                            int iconOffsetY = icon.myHeight;
                            if (transparency == 256) {
                                icon.drawSprite(drawX + xModI, drawY + this.baseCharacterHeight - iconOffsetY + yMod);
                            } else {
                                icon.drawSprite(drawX + xModI, drawY + this.baseCharacterHeight - iconOffsetY + yMod, transparency);
                            }
                            drawX += icon.myWidth;
                        }
                        catch (Exception xModI) {}
                        continue;
                    }
                    this.setTextEffects(effectString);
                    continue;
                }
            }
            if (startIndex != -1) continue;
            int width = this.characterWidths[character];
            int height = this.characterHeights[character];
            int xOff = xModifier != null ? xModifier[modifierOffset] : 0;
            int yOff = yModifier != null ? yModifier[modifierOffset] : 0;
            ++modifierOffset;
            if (character != 32) {
                if (transparency == 256) {
                    if (textShadowColor != -1) {
                        this.drawCharacter(character, drawX + this.characterDrawXOffsets[character] + 1 + xOff, drawY + this.characterDrawYOffsets[character] + 1 + yOff, width, height, textShadowColor, true);
                    }
                    this.drawCharacter(character, drawX + this.characterDrawXOffsets[character] + xOff, drawY + this.characterDrawYOffsets[character] + yOff, width, height, textColor, false);
                } else {
                    if (textShadowColor != -1) {
                        this.drawTransparentCharacter(character, drawX + this.characterDrawXOffsets[character] + 1 + xOff, drawY + this.characterDrawYOffsets[character] + 1 + yOff, width, height, textShadowColor, transparency, true);
                    }
                    this.drawTransparentCharacter(character, drawX + this.characterDrawXOffsets[character] + xOff, drawY + this.characterDrawYOffsets[character] + yOff, width, height, textColor, transparency, false);
                }
            } else if (anInt4178 > 0) {
                drawX += (anInt4175 += anInt4178) >> 8;
                anInt4175 &= 0xFF;
            }
            int i_109_ = this.characterScreenWidths[character];
            if (strikethroughColor != -1) {
                DrawingArea474.drawHorizontalLine(drawX, drawY + (int)((double)this.baseCharacterHeight * 0.7), i_109_, strikethroughColor);
            }
            if (underlineColor != -1) {
                DrawingArea474.drawHorizontalLine(drawX, drawY + this.baseCharacterHeight, i_109_, underlineColor);
            }
            drawX += i_109_;
        }
    }

    public void setTextEffects(String string) {
        try {
            if (string.startsWith(startColor)) {
                String color = string.substring(4);
                textColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(endColor)) {
                textColor = defaultColor;
            } else if (string.startsWith(startTransparency)) {
                transparency = Integer.valueOf(string.substring(6));
            } else if (string.equals(endTransparency)) {
                transparency = defaultTransparency;
            } else if (string.startsWith(startStrikethrough)) {
                String color = string.substring(4);
                strikethroughColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(defaultStrikethrough)) {
                strikethroughColor = 0x800000;
            } else if (string.equals(endStrikethrough)) {
                strikethroughColor = -1;
            } else if (string.startsWith(startUnderline)) {
                String color = string.substring(2);
                underlineColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(startDefaultUnderline)) {
                underlineColor = 0;
            } else if (string.equals(endUnderline)) {
                underlineColor = -1;
            } else if (string.startsWith(startShadow)) {
                String color = string.substring(5);
                textShadowColor = color.length() < 6 ? Color.decode(color).getRGB() : Integer.parseInt(color, 16);
            } else if (string.equals(startDefaultShadow)) {
                textShadowColor = 0;
            } else if (string.equals(endShadow)) {
                textShadowColor = defaultShadow;
            } else if (string.equals(lineBreak)) {
                this.setDefaultTextEffectValues(defaultColor, defaultShadow, defaultTransparency);
            }
        }
        catch (Exception exception) {}
    }

    public void setColorAndShadow(int color, int shadow) {
        strikethroughColor = -1;
        underlineColor = -1;
        textShadowColor = defaultShadow = shadow;
        textColor = defaultColor = color;
        defaultTransparency = 256;
        transparency = 256;
        anInt4178 = 0;
        anInt4175 = 0;
    }

    public int getTextWidth(String string) {
        if (string == null) {
            return 0;
        }
        int startIndex = -1;
        int finalWidth = 0;
        for (int currentCharacter = 0; currentCharacter < string.length(); ++currentCharacter) {
            int character = string.charAt(currentCharacter);
            if (character > 255) {
                character = 32;
            }
            if (character == 60) {
                startIndex = currentCharacter;
                continue;
            }
            if (character == 62 && startIndex != -1) {
                String effectString = string.substring(startIndex + 1, currentCharacter);
                startIndex = -1;
                if (effectString.equals(startEffect)) {
                    character = 60;
                } else if (effectString.equals(endEffect)) {
                    character = 62;
                } else if (effectString.equals(aRSString_4135)) {
                    character = 160;
                } else if (effectString.equals(aRSString_4162)) {
                    character = 173;
                } else if (effectString.equals(aRSString_4165)) {
                    character = 215;
                } else if (effectString.equals(aRSString_4147)) {
                    character = 128;
                } else if (effectString.equals(aRSString_4163)) {
                    character = 169;
                } else if (effectString.equals(aRSString_4169)) {
                    character = 174;
                } else {
                    if (!effectString.startsWith(startImage)) continue;
                    try {
                        int iconId = Integer.valueOf(effectString.substring(4));
                        finalWidth += SpriteLoader.sprites[679 + iconId].myWidth - 4;
                    }
                    catch (Exception exception) {}
                    continue;
                }
            }
            if (startIndex != -1) continue;
            finalWidth += this.characterScreenWidths[character];
        }
        return finalWidth;
    }

    public void drawBasicString(String string, int drawX, int drawY, int color, int shadow) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            this.drawBasicString(string, drawX, drawY);
        }
    }

    public void drawCenteredString(String string, int drawX, int drawY, int color, int shadow) {
        if (string != null) {
            this.setColorAndShadow(color, shadow);
            this.drawBasicString(string, drawX - this.getTextWidth(string) / 2, drawY);
        }
    }

    public static String replaceAllString(String strOrig, String strFind, String strReplace) {
        if (strOrig == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(strOrig);
        String toReplace = "";
        toReplace = strReplace == null ? "" : strReplace;
        for (int pos = strOrig.length(); pos > -1; pos -= strFind.length()) {
            if ((pos = strOrig.lastIndexOf(strFind, pos)) <= -1) continue;
            sb.replace(pos, pos + strFind.length(), toReplace);
        }
        return sb.toString();
    }

    private static String replace(String s, String from, String to) {
        if ((from == "=D" || from == "=d") && s.contains("col")) {
            return s;
        }
        return RSFontSystem.replaceAllString(s, from, to);
    }

    public static String handleOldSyntax(String text) {
        text = RSFontSystem.replace(text, "@red@", "<col=ff0000>");
        text = RSFontSystem.replace(text, "@gre@", "<col=65280>");
        text = RSFontSystem.replace(text, "@blu@", "<col=255>");
        text = RSFontSystem.replace(text, "@yel@", "<col=ffff00>");
        text = RSFontSystem.replace(text, "@cya@", "<col=65535>");
        text = RSFontSystem.replace(text, "@mag@", "<col=ff00ff>");
        text = RSFontSystem.replace(text, "@whi@", "<col=ffffff>");
        text = RSFontSystem.replace(text, "@lre@", "<col=ff9040>");
        text = RSFontSystem.replace(text, "@dre@", "<col=800000>");
        text = RSFontSystem.replace(text, "@bla@", "<col=0>");
        text = RSFontSystem.replace(text, "@or1@", "<col=ffb000>");
        text = RSFontSystem.replace(text, "@or2@", "<col=ff7000>");
        text = RSFontSystem.replace(text, "@or3@", "<col=ff3000>");
        text = RSFontSystem.replace(text, "@gr1@", "<col=c0ff00>");
        text = RSFontSystem.replace(text, "@gr2@", "<col=80ff00>");
        text = RSFontSystem.replace(text, "@gr3@", "<col=40ff00>");
        text = RSFontSystem.replace(text, "@cr1@", "<img=1>");
        text = RSFontSystem.replace(text, "@cr2@", "<img=2>");
        text = RSFontSystem.replace(text, "@cr3@", "<img=3>");
        text = RSFontSystem.replace(text, "@dev@", "<img=3>");
        text = RSFontSystem.replace(text, "@des@", "<img=4>");
        text = RSFontSystem.replace(text, "@vet@", "<img=5>");
        text = RSFontSystem.replace(text, "@don@", "<img=6>");
        text = RSFontSystem.replace(text, "@dn1@", "<img=910>");
        text = RSFontSystem.replace(text, "@dn2@", "<img=911>");
        text = RSFontSystem.replace(text, "@dn3@", "<img=912>");
        text = RSFontSystem.replace(text, "@dn4@", "<img=913>");
        text = RSFontSystem.replace(text, "@dn5@", "<img=914>");
        text = RSFontSystem.replace(text, "@dn6@", "<img=915>");
        text = RSFontSystem.replace(text, "@dn7@", "<img=916>");
        text = RSFontSystem.replace(text, "@st1@", "<img=917>");
        text = RSFontSystem.replace(text, "@st2@", "<img=918>");
        text = RSFontSystem.replace(text, "@st3@", "<img=919>");
        text = RSFontSystem.replace(text, "@st4@", "<img=920>");
        text = RSFontSystem.replace(text, "@st5@", "<img=921>");
        text = RSFontSystem.replace(text, "@st6@", "<img=922>");
        text = RSFontSystem.replace(text, "@st7@", "<img=924>");
        text = RSFontSystem.replace(text, "@yt1@", "<img=923>");
        text = RSFontSystem.replace(text, "@im1@", "<img=12>");
        text = RSFontSystem.replace(text, "@im2@", "<img=33>");
        text = RSFontSystem.replace(text, "@im3@", "<img=32>");
        if ((text = RSFontSystem.replace(text, "@or2@", "<col=ff7000>")) == null || SMILIES_TOGGLED) {
            // empty if block
        }
        return text;
    }

    public static void nullLoader() {
        startEffect = null;
        endEffect = null;
        aRSString_4135 = null;
        aRSString_4162 = null;
        aRSString_4165 = null;
        aRSString_4147 = null;
        aRSString_4163 = null;
        aRSString_4169 = null;
        startImage = null;
        lineBreak = null;
        startColor = null;
        endColor = null;
        startTransparency = null;
        endTransparency = null;
        startUnderline = null;
        startDefaultUnderline = null;
        endUnderline = null;
        startShadow = null;
        startDefaultShadow = null;
        endShadow = null;
        startStrikethrough = null;
        defaultStrikethrough = null;
        endStrikethrough = null;
        aRSString_4143 = null;
        splitTextStrings = null;
    }

    public static void createTransparentCharacterPixels(int[] is, byte[] is_0_, int i, int i_1_, int i_2_, int i_3_, int i_4_, int i_5_, int i_6_, int i_7_) {
        i = ((i & 0xFF00FF) * i_7_ & 0xFF00FF00) + ((i & 0xFF00) * i_7_ & 0xFF0000) >> 8;
        i_7_ = 256 - i_7_;
        for (int i_8_ = -i_4_; i_8_ < 0; ++i_8_) {
            for (int i_9_ = -i_3_; i_9_ < 0; ++i_9_) {
                if (is_0_[i_1_++] != 0) {
                    int i_10_ = is[i_2_];
                    is[i_2_++] = (((i_10_ & 0xFF00FF) * i_7_ & 0xFF00FF00) + ((i_10_ & 0xFF00) * i_7_ & 0xFF0000) >> 8) + i;
                    continue;
                }
                ++i_2_;
            }
            i_2_ += i_5_;
            i_1_ += i_6_;
        }
    }

    public void drawTransparentCharacter(int i, int i_11_, int i_12_, int i_13_, int i_14_, int i_15_, int i_16_, boolean bool) {
        int i_17_ = i_11_ + i_12_ * DrawingArea.width;
        int i_18_ = DrawingArea.width - i_13_;
        int i_19_ = 0;
        int i_20_ = 0;
        if (i_12_ < DrawingArea.topY) {
            int i_21_ = DrawingArea.topY - i_12_;
            i_14_ -= i_21_;
            i_12_ = DrawingArea.topY;
            i_20_ += i_21_ * i_13_;
            i_17_ += i_21_ * DrawingArea.width;
        }
        if (i_12_ + i_14_ > DrawingArea.bottomY) {
            i_14_ -= i_12_ + i_14_ - DrawingArea.bottomY;
        }
        if (i_11_ < DrawingArea.topX) {
            int i_22_ = DrawingArea.topX - i_11_;
            i_13_ -= i_22_;
            i_11_ = DrawingArea.topX;
            i_20_ += i_22_;
            i_17_ += i_22_;
            i_19_ += i_22_;
            i_18_ += i_22_;
        }
        if (i_11_ + i_13_ > DrawingArea.bottomX) {
            int i_23_ = i_11_ + i_13_ - DrawingArea.bottomX;
            i_13_ -= i_23_;
            i_19_ += i_23_;
            i_18_ += i_23_;
        }
        if (i_13_ > 0 && i_14_ > 0) {
            RSFontSystem.createTransparentCharacterPixels(DrawingArea.pixels, this.fontPixels[i], i_15_, i_20_, i_17_, i_13_, i_14_, i_18_, i_19_, i_16_);
        }
    }

    public static void createCharacterPixels(int[] is, byte[] is_24_, int i, int i_25_, int i_26_, int i_27_, int i_28_, int i_29_, int i_30_) {
        int i_31_ = -(i_27_ >> 2);
        i_27_ = -(i_27_ & 3);
        for (int i_32_ = -i_28_; i_32_ < 0; ++i_32_) {
            for (int i_33_ = i_31_; i_33_ < 0; ++i_33_) {
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                } else {
                    ++i_26_;
                }
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                    continue;
                }
                ++i_26_;
            }
            for (int i_34_ = i_27_; i_34_ < 0; ++i_34_) {
                if (is_24_[i_25_++] != 0) {
                    is[i_26_++] = i;
                    continue;
                }
                ++i_26_;
            }
            i_26_ += i_29_;
            i_25_ += i_30_;
        }
    }

    public void drawCharacter(int character, int i_35_, int i_36_, int i_37_, int i_38_, int i_39_, boolean bool) {
        int i_40_ = i_35_ + i_36_ * DrawingArea.width;
        int i_41_ = DrawingArea.width - i_37_;
        int i_42_ = 0;
        int i_43_ = 0;
        if (i_36_ < DrawingArea.topY) {
            int i_44_ = DrawingArea.topY - i_36_;
            i_38_ -= i_44_;
            i_36_ = DrawingArea.topY;
            i_43_ += i_44_ * i_37_;
            i_40_ += i_44_ * DrawingArea.width;
        }
        if (i_36_ + i_38_ > DrawingArea.bottomY) {
            i_38_ -= i_36_ + i_38_ - DrawingArea.bottomY;
        }
        if (i_35_ < DrawingArea.topX) {
            int i_45_ = DrawingArea.topX - i_35_;
            i_37_ -= i_45_;
            i_35_ = DrawingArea.topX;
            i_43_ += i_45_;
            i_40_ += i_45_;
            i_42_ += i_45_;
            i_41_ += i_45_;
        }
        if (i_35_ + i_37_ > DrawingArea.bottomX) {
            int i_46_ = i_35_ + i_37_ - DrawingArea.bottomX;
            i_37_ -= i_46_;
            i_42_ += i_46_;
            i_41_ += i_46_;
        }
        if (i_37_ > 0 && i_38_ > 0) {
            try {
                RSFontSystem.createCharacterPixels(DrawingArea.pixels, this.fontPixels[character], i_39_, i_43_, i_40_, i_37_, i_38_, i_41_, i_42_);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String removeColors(String text) {
        text = RSFontSystem.replace((String)text, "@red@", "");
        text = RSFontSystem.replace((String)text, "@gre@", "");
        text = RSFontSystem.replace((String)text, "@blu@", "");
        text = RSFontSystem.replace((String)text, "@yel@", "");
        text = RSFontSystem.replace((String)text, "@cya@", "");
        text = RSFontSystem.replace((String)text, "@mag@", "");
        text = RSFontSystem.replace((String)text, "@whi@", "");
        text = RSFontSystem.replace((String)text, "@lre@", "");
        text = RSFontSystem.replace((String)text, "@dre@", "");
        text = RSFontSystem.replace((String)text, "@bla@", "");
        text = RSFontSystem.replace((String)text, "@or1@", "");
        text = RSFontSystem.replace((String)text, "@or2@", "");
        text = RSFontSystem.replace((String)text, "@pr2@", "");
        text = RSFontSystem.replace((String)text, "@or3@", "");
        text = RSFontSystem.replace((String)text, "@gr1@", "");
        text = RSFontSystem.replace((String)text, "@gr2@", "");
        text = RSFontSystem.replace((String)text, "@gr3@", "");
        text = RSFontSystem.replace((String)text, "@cr1@", "");
        text = RSFontSystem.replace((String)text, "@cr2@", "");
        text = RSFontSystem.replace((String)text, "@cr3@", "");
        text = RSFontSystem.replace((String)text, "@dev@", "");
        text = RSFontSystem.replace((String)text, "@des@", "");
        text = RSFontSystem.replace((String)text, "@vet@", "");
        text = RSFontSystem.replace((String)text, "@don@", "");
        text = RSFontSystem.replace((String)text, "@or2@", "");
        text = RSFontSystem.replace((String)text, "@purp@", "");
        text = RSFontSystem.replace((String)text, "@vea@", "");
        text = RSFontSystem.replace((String)text, "@eas@", "");
        text = RSFontSystem.replace((String)text, "@med@", "");
        text = RSFontSystem.replace((String)text, "@har@", "");
        text = RSFontSystem.replace((String)text, "@vha@", "");
        text = RSFontSystem.replace((String)text, "@bl2@", "");
        text = RSFontSystem.replace((String)text, "@gry@", "");
        text = RSFontSystem.replace((String)text, "@pnk@", "");
        text = RSFontSystem.replace((String)text, "@pr3@", "");
        if ((text = RSFontSystem.replace((String)text, "@skb@", "")) != null) {
            while (((String)text).contains("<")) {
                if (!((String)text).contains("<")) continue;
                int index = ((String)text).indexOf("<");
                int index1 = ((String)text).indexOf(">");
                text = ((String)text).substring(0, index) + ((String)text).substring(index1 + 1);
            }
        }
        return text;
    }

    static {
        endShadow = "/shad";
        endStrikethrough = "/str";
        SMILIES_TOGGLED = true;
        startTransparency = "trans=";
        startStrikethrough = "str=";
        startDefaultShadow = "shad";
        startColor = "col=";
        lineBreak = "br";
        defaultStrikethrough = "str";
        endUnderline = "/u";
        startImage = "img=";
        startShadow = "shad=";
        startUnderline = "u=";
        endColor = "/col";
        startDefaultUnderline = "u";
        endTransparency = "/trans";
        aRSString_4143 = Integer.toString(100);
        aRSString_4135 = "nbsp";
        aRSString_4169 = "reg";
        aRSString_4165 = "times";
        aRSString_4162 = "shy";
        aRSString_4163 = "copy";
        endEffect = "gt";
        aRSString_4147 = "euro";
        startEffect = "lt";
        defaultTransparency = 256;
        defaultShadow = -1;
        anInt4175 = 0;
        textShadowColor = -1;
        textColor = 0;
        defaultColor = 0;
        strikethroughColor = -1;
        splitTextStrings = new String[100];
        underlineColor = -1;
        anInt4178 = 0;
        transparency = 256;
    }
}

