/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.RSInterface;
import com.teragard.SpriteLoader;
import com.teragard.TextDrawingArea;

public class RSInterfaceBuilder {
    public static final int TYPE_CONTAINER = 0;
    public static final int TYPE_UNKNOWN = 1;
    public static final int TYPE_INVENTORY = 2;
    public static final int TYPE_RECTANGLE = 3;
    public static final int TYPE_TEXT = 4;
    public static final int TYPE_SPRITE = 5;
    public static final int TYPE_MODEL = 6;
    public static final int TYPE_INVENTORY_TEXT = 7;
    public static final int TYPE_TOOLTIP = 8;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_BUTTON = 1;
    public static final int ACTION_SPELL = 2;
    public static final int ACTION_CLOSE = 3;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_SELECT_2 = 5;
    public static final int ACTION_CONTINUE = 6;
    private final RSInterface rsi = new RSInterface();
    private static RSInterface[] interfaceCache;

    private RSInterfaceBuilder(int id) {
        this.rsi.id = id;
        this.rsi.parentID = -1;
        if (interfaceCache != null && id >= 0 && id < interfaceCache.length) {
            RSInterfaceBuilder.interfaceCache[id] = this.rsi;
        }
    }

    public static void setInterfaceCache(RSInterface[] cache) {
        interfaceCache = cache;
    }

    public static RSInterface[] getInterfaceCache() {
        return interfaceCache;
    }

    public static RSInterfaceBuilder create(int id) {
        return new RSInterfaceBuilder(id);
    }

    public static RSInterfaceBuilder createTab(int id) {
        return new RSInterfaceBuilder(id).type(0);
    }

    public RSInterfaceBuilder type(int type) {
        this.rsi.type = type;
        return this;
    }

    public RSInterfaceBuilder parent(int parentId) {
        this.rsi.parentID = parentId;
        return this;
    }

    public RSInterfaceBuilder actionType(int actionType) {
        this.rsi.atActionType = actionType;
        return this;
    }

    public RSInterfaceBuilder contentType(int contentType) {
        this.rsi.contentType = contentType;
        return this;
    }

    public RSInterfaceBuilder size(int width, int height) {
        this.rsi.width = width;
        this.rsi.height = height;
        return this;
    }

    public RSInterfaceBuilder position(int x, int y) {
        this.rsi.x = x;
        this.rsi.y = y;
        return this;
    }

    public RSInterfaceBuilder scroll(int scrollMax) {
        this.rsi.scrollMax = scrollMax;
        return this;
    }

    public RSInterfaceBuilder shown(boolean shown) {
        this.rsi.interfaceShown = shown;
        return this;
    }

    public RSInterfaceBuilder opacity(int opacity) {
        this.rsi.opacity = (byte)opacity;
        return this;
    }

    public RSInterfaceBuilder transparent(boolean transparent) {
        this.rsi.drawsTransparent = transparent;
        return this;
    }

    public RSInterfaceBuilder children(int count) {
        this.rsi.children = new int[count];
        this.rsi.childX = new int[count];
        this.rsi.childY = new int[count];
        return this;
    }

    public RSInterfaceBuilder child(int index, int childId, int x, int y) {
        if (this.rsi.children == null) {
            throw new IllegalStateException("Must call children(count) before adding children");
        }
        this.rsi.children[index] = childId;
        this.rsi.childX[index] = x;
        this.rsi.childY[index] = y;
        return this;
    }

    public RSInterfaceBuilder sprite(int spriteId) {
        if (SpriteLoader.sprites != null && spriteId >= 0 && spriteId < SpriteLoader.sprites.length) {
            this.rsi.disabledSprite = SpriteLoader.sprites[spriteId];
            this.rsi.disabledSpriteId = spriteId;
        }
        return this;
    }

    public RSInterfaceBuilder sprites(int disabledId, int enabledId) {
        this.sprite(disabledId);
        if (SpriteLoader.sprites != null && enabledId >= 0 && enabledId < SpriteLoader.sprites.length) {
            this.rsi.enabledSprite = SpriteLoader.sprites[enabledId];
            this.rsi.enabledSpriteId = enabledId;
        }
        return this;
    }

    public RSInterfaceBuilder greyscale(boolean greyscale) {
        this.rsi.greyScale = greyscale;
        return this;
    }

    public RSInterfaceBuilder text(String message) {
        this.rsi.message = message;
        return this;
    }

    public RSInterfaceBuilder text(String message, TextDrawingArea font) {
        this.rsi.message = message;
        this.rsi.textDrawingAreas = font;
        return this;
    }

    public RSInterfaceBuilder enabledText(String message) {
        this.rsi.enabledMessage = message;
        return this;
    }

    public RSInterfaceBuilder centered(boolean centered) {
        this.rsi.centerText = centered;
        return this;
    }

    public RSInterfaceBuilder shadowed(boolean shadowed) {
        this.rsi.shadowed = shadowed;
        return this;
    }

    public RSInterfaceBuilder font(TextDrawingArea font) {
        this.rsi.textDrawingAreas = font;
        return this;
    }

    public RSInterfaceBuilder color(int color) {
        this.rsi.disabledColor = color;
        return this;
    }

    public RSInterfaceBuilder colors(int disabled, int enabled) {
        this.rsi.disabledColor = disabled;
        this.rsi.enabledColor = enabled;
        return this;
    }

    public RSInterfaceBuilder colors(int disabled, int enabled, int disabledHover, int enabledHover) {
        this.rsi.disabledColor = disabled;
        this.rsi.enabledColor = enabled;
        this.rsi.disabledMouseOverColor = disabledHover;
        this.rsi.enabledMouseOverColor = enabledHover;
        return this;
    }

    public RSInterfaceBuilder filled(boolean filled) {
        this.rsi.filled = filled;
        return this;
    }

    public RSInterfaceBuilder inventory(int cols, int rows, int padX, int padY) {
        this.rsi.width = cols;
        this.rsi.height = rows;
        this.rsi.inv = new int[cols * rows];
        this.rsi.invStackSizes = new int[cols * rows];
        this.rsi.invSpritePadX = padX;
        this.rsi.invSpritePadY = padY;
        this.rsi.isInventoryInterface = true;
        return this;
    }

    public RSInterfaceBuilder actions(String ... actions) {
        this.rsi.actions = new String[5];
        for (int i = 0; i < Math.min(actions.length, 5); ++i) {
            this.rsi.actions[i] = actions[i];
        }
        return this;
    }

    public RSInterfaceBuilder draggable(boolean dragDeletes) {
        this.rsi.dragDeletes = dragDeletes;
        return this;
    }

    public RSInterfaceBuilder usable(boolean usable) {
        this.rsi.usableItemInterface = usable;
        return this;
    }

    public RSInterfaceBuilder model(int mediaType, int mediaId) {
        this.rsi.mediaType = mediaType;
        this.rsi.mediaID = mediaId;
        return this;
    }

    public RSInterfaceBuilder zoom(int zoom) {
        this.rsi.modelZoom = zoom;
        return this;
    }

    public RSInterfaceBuilder rotation(int rotX, int rotY) {
        this.rsi.modelRotation1 = rotX;
        this.rsi.modelRotation2 = rotY;
        return this;
    }

    public RSInterfaceBuilder animation(int animId) {
        this.rsi.disabledAnimationId = animId;
        return this;
    }

    public RSInterfaceBuilder tooltip(String tooltip) {
        this.rsi.tooltip = tooltip;
        return this;
    }

    public RSInterfaceBuilder spell(String name, int usableOn) {
        this.rsi.spellName = name;
        this.rsi.spellUsableOn = usableOn;
        return this;
    }

    public RSInterfaceBuilder hoverType(int hoverType) {
        this.rsi.hoverType = hoverType;
        return this;
    }

    public RSInterfaceBuilder hoverChildren(int ... children) {
        if (children.length >= 1) {
            this.rsi.childToIntersect = children[0];
        }
        if (children.length >= 2) {
            this.rsi.childToIntersect2 = children[1];
        }
        if (children.length >= 3) {
            this.rsi.childToIntersect3 = children[2];
        }
        return this;
    }

    public RSInterfaceBuilder valueComparison(int[] types, int[] values) {
        this.rsi.valueCompareType = types;
        this.rsi.requiredValues = values;
        return this;
    }

    public RSInterface build() {
        return this.rsi;
    }

    public int buildAndGetId() {
        return this.rsi.id;
    }

    public static RSInterface sprite(int id, int spriteId) {
        return RSInterfaceBuilder.create(id).type(5).sprite(spriteId).build();
    }

    public static RSInterface text(int id, String message, TextDrawingArea font, int color) {
        return RSInterfaceBuilder.create(id).type(4).text(message, font).color(color).centered(true).shadowed(true).build();
    }

    public static RSInterface button(int id, int spriteId, String tooltip) {
        return RSInterfaceBuilder.create(id).type(5).actionType(1).sprite(spriteId).tooltip(tooltip).build();
    }

    public static RSInterface hoverButton(int id, int normalSprite, int hoverSprite, int width, int height, String tooltip) {
        RSInterface btn = RSInterfaceBuilder.create(id).type(5).actionType(1).sprites(normalSprite, hoverSprite).size(width, height).tooltip(tooltip).build();
        return btn;
    }

    public static RSInterface closeButton(int id, int normalSprite, int hoverSprite) {
        return RSInterfaceBuilder.hoverButton(id, normalSprite, hoverSprite, 21, 21, "Close");
    }

    public static RSInterface rectangle(int id, int width, int height, int color, boolean filled) {
        return RSInterfaceBuilder.create(id).type(3).size(width, height).color(color).filled(filled).build();
    }
}

