/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Stream;
import com.teragard.Synthesizer;

final class Sounds {
    private static byte[] fileData;
    public static final int[] anIntArray326;
    private static final Sounds[] soundCache;
    private static Stream outStream;
    private final Synthesizer[] samples = new Synthesizer[10];
    private int anInt330;
    private int anInt331;

    public static Stream fetchSoundData(int i, int j) {
        if (soundCache[j] != null) {
            Sounds sounds = soundCache[j];
            return sounds.pack(i);
        }
        return null;
    }

    public static void unpack(Stream stream) {
        fileData = new byte[441000];
        outStream = new Stream(fileData);
        Synthesizer.initialise();
        int j;
        while ((j = stream.readUnsignedWord()) != 65535) {
            Sounds.soundCache[j] = new Sounds();
            soundCache[j].decode(stream);
            Sounds.anIntArray326[j] = soundCache[j].method243();
        }
        return;
    }

    private Sounds() {
    }

    private void decode(Stream stream) {
        for (int i = 0; i < 10; ++i) {
            int j = stream.readUnsignedByte();
            if (j == 0) continue;
            --stream.currentOffset;
            this.samples[i] = new Synthesizer();
            this.samples[i].decode(stream);
        }
        this.anInt330 = stream.readUnsignedWord();
        this.anInt331 = stream.readUnsignedWord();
    }

    private int method243() {
        int j = 9999999;
        for (int k = 0; k < 10; ++k) {
            if (this.samples[k] == null || this.samples[k].remaining / 20 >= j) continue;
            j = this.samples[k].remaining / 20;
        }
        if (this.anInt330 < this.anInt331 && this.anInt330 / 20 < j) {
            j = this.anInt330 / 20;
        }
        if (j == 9999999 || j == 0) {
            return 0;
        }
        for (int l = 0; l < 10; ++l) {
            if (this.samples[l] == null) continue;
            this.samples[l].remaining -= j * 20;
        }
        if (this.anInt330 < this.anInt331) {
            this.anInt330 -= j * 20;
            this.anInt331 -= j * 20;
        }
        return j;
    }

    private Stream pack(int volume) {
        int k = this.encode(volume);
        Sounds.outStream.currentOffset = 0;
        outStream.writeDWord(1380533830);
        outStream.method403(36 + k);
        outStream.writeDWord(1463899717);
        outStream.writeDWord(1718449184);
        outStream.method403(16);
        outStream.method400(1);
        outStream.method400(1);
        outStream.method403(22050);
        outStream.method403(22050);
        outStream.method400(1);
        outStream.method400(8);
        outStream.writeDWord(1684108385);
        outStream.method403(k);
        Sounds.outStream.currentOffset += k;
        return outStream;
    }

    private int encode(int i) {
        int j = 0;
        for (int k = 0; k < 10; ++k) {
            if (this.samples[k] == null || this.samples[k].offset + this.samples[k].remaining <= j) continue;
            j = this.samples[k].offset + this.samples[k].remaining;
        }
        if (j == 0) {
            return 0;
        }
        int l = 22050 * j / 1000;
        int i1 = 22050 * this.anInt330 / 1000;
        int j1 = 22050 * this.anInt331 / 1000;
        if (i1 < 0 || i1 > l || j1 < 0 || j1 > l || i1 >= j1) {
            i = 0;
        }
        int k1 = l + (j1 - i1) * (i - 1);
        for (int l1 = 44; l1 < k1 + 44; ++l1) {
            Sounds.fileData[l1] = -128;
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.samples[i2] == null) continue;
            int j2 = this.samples[i2].offset * 22050 / 1000;
            int i3 = this.samples[i2].remaining * 22050 / 1000;
            int[] ai = this.samples[i2].synthesize(j2, this.samples[i2].offset);
            for (int l3 = 0; l3 < j2; ++l3) {
                int n = l3 + i3 + 44;
                fileData[n] = (byte)(fileData[n] + (byte)(ai[l3] >> 8));
            }
        }
        if (i > 1) {
            i1 += 44;
            j1 += 44;
            int k2 = (k1 += 44) - (l += 44);
            for (int j3 = l - 1; j3 >= j1; --j3) {
                Sounds.fileData[j3 + k2] = fileData[j3];
            }
            for (int k3 = 1; k3 < i; ++k3) {
                int l2 = (j1 - i1) * k3;
                System.arraycopy(fileData, i1, fileData, i1 + l2, j1 - i1);
            }
            k1 -= 44;
        }
        return k1;
    }

    static {
        anIntArray326 = new int[5000];
        soundCache = new Sounds[5000];
    }
}

