/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Envelope;
import com.teragard.Filter;
import com.teragard.Stream;

final class Synthesizer {
    private Envelope samp1;
    private Envelope samp2;
    private Envelope samp3;
    private Envelope samp4;
    private Envelope samp5;
    private Envelope samp6;
    private Envelope samp7;
    private Envelope samp8;
    private final int[] anIntArray106 = new int[5];
    private final int[] cents = new int[5];
    private final int[] anIntArray108 = new int[5];
    private int anInt109;
    private int gain = 100;
    private Filter filter;
    private Envelope envelope;
    int offset = 500;
    int remaining;
    private static int[] samples;
    private static int[] NOISE;
    private static int[] SINE;
    private static final int[] phase;
    private static final int[] anIntArray119;
    private static final int[] anIntArray120;
    private static final int[] anIntArray121;
    private static final int[] anIntArray122;

    public static void initialise() {
        NOISE = new int[32768];
        for (int i = 0; i < 32768; ++i) {
            Synthesizer.NOISE[i] = Math.random() > 0.5 ? 1 : -1;
        }
        SINE = new int[32768];
        for (int j = 0; j < 32768; ++j) {
            Synthesizer.SINE[j] = (int)(Math.sin((double)j / 5215.1903) * 16384.0);
        }
        samples = new int[220500];
    }

    public int[] synthesize(int sampleLength, int j) {
        for (int k = 0; k < sampleLength; ++k) {
            Synthesizer.samples[k] = 0;
        }
        if (j < 10) {
            return samples;
        }
        double rate = (double)sampleLength / ((double)j + 0.0);
        this.samp1.resetValues();
        this.samp2.resetValues();
        int l = 0;
        int i1 = 0;
        int j1 = 0;
        if (this.samp3 != null) {
            this.samp3.resetValues();
            this.samp4.resetValues();
            l = (int)((double)(this.samp3.anInt539 - this.samp3.anInt538) * 32.768 / rate);
            i1 = (int)((double)this.samp3.anInt538 * 32.768 / rate);
        }
        int k1 = 0;
        int l1 = 0;
        int i2 = 0;
        if (this.samp5 != null) {
            this.samp5.resetValues();
            this.samp6.resetValues();
            k1 = (int)((double)(this.samp5.anInt539 - this.samp5.anInt538) * 32.768 / rate);
            l1 = (int)((double)this.samp5.anInt538 * 32.768 / rate);
        }
        for (int j2 = 0; j2 < 5; ++j2) {
            if (this.anIntArray106[j2] == 0) continue;
            Synthesizer.phase[j2] = 0;
            Synthesizer.anIntArray119[j2] = (int)((double)this.anIntArray108[j2] * rate);
            Synthesizer.anIntArray120[j2] = (this.anIntArray106[j2] << 14) / 100;
            Synthesizer.anIntArray121[j2] = (int)((double)(this.samp1.anInt539 - this.samp1.anInt538) * 32.768 * Math.pow(1.0057929410678534, this.cents[j2]) / rate);
            Synthesizer.anIntArray122[j2] = (int)((double)this.samp1.anInt538 * 32.768 / rate);
        }
        for (int k2 = 0; k2 < sampleLength; ++k2) {
            int l2 = this.samp1.evaluate(sampleLength);
            int j4 = this.samp2.evaluate(sampleLength);
            if (this.samp3 != null) {
                int j5 = this.samp3.evaluate(sampleLength);
                int j6 = this.samp4.evaluate(sampleLength);
                l2 += this.evaluate(j6, j1, this.samp3.form) >> 1;
                j1 += (j5 * l >> 16) + i1;
            }
            if (this.samp5 != null) {
                int k5 = this.samp5.evaluate(sampleLength);
                int k6 = this.samp6.evaluate(sampleLength);
                j4 = j4 * ((this.evaluate(k6, i2, this.samp5.form) >> 1) + 32768) >> 15;
                i2 += (k5 * k1 >> 16) + l1;
            }
            for (int l5 = 0; l5 < 5; ++l5) {
                int l6;
                if (this.anIntArray106[l5] == 0 || (l6 = k2 + anIntArray119[l5]) >= sampleLength) continue;
                int n = l6;
                samples[n] = samples[n] + this.evaluate(j4 * anIntArray120[l5] >> 15, phase[l5], this.samp1.form);
                int n2 = l5;
                phase[n2] = phase[n2] + ((l2 * anIntArray121[l5] >> 16) + anIntArray122[l5]);
            }
        }
        if (this.samp7 != null) {
            this.samp7.resetValues();
            this.samp8.resetValues();
            int i3 = 0;
            boolean flag = false;
            boolean flag1 = true;
            for (int i7 = 0; i7 < sampleLength; ++i7) {
                int k7 = this.samp7.evaluate(sampleLength);
                int i8 = this.samp8.evaluate(sampleLength);
                int k4 = flag1 ? this.samp7.anInt538 + ((this.samp7.anInt539 - this.samp7.anInt538) * k7 >> 8) : this.samp7.anInt538 + ((this.samp7.anInt539 - this.samp7.anInt538) * i8 >> 8);
                if ((i3 += 256) >= k4) {
                    i3 = 0;
                    boolean bl = flag1 = !flag1;
                }
                if (!flag1) continue;
                Synthesizer.samples[i7] = 0;
            }
        }
        if (this.anInt109 > 0 && this.gain > 0) {
            int j3;
            for (int l4 = j3 = (int)((double)this.anInt109 * rate); l4 < sampleLength; ++l4) {
                int n = l4;
                samples[n] = samples[n] + samples[l4 - j3] * this.gain / 100;
            }
        }
        if (this.filter.anIntArray665[0] > 0 || this.filter.anIntArray665[1] > 0) {
            this.envelope.resetValues();
            int k3 = this.envelope.evaluate(sampleLength + 1);
            int i5 = this.filter.method544(0, (float)k3 / 65536.0f);
            int i6 = this.filter.method544(1, (float)k3 / 65536.0f);
            if (sampleLength >= i5 + i6) {
                int c;
                int j7 = 0;
                int l7 = i6;
                if (l7 > sampleLength - i5) {
                    l7 = sampleLength - i5;
                }
                while (j7 < l7) {
                    int j8 = (int)((long)samples[j7 + i5] * (long)Filter.inv_g0_fixedpt >> 16);
                    for (int k8 = 0; k8 < i5; ++k8) {
                        j8 += (int)((long)samples[j7 + i5 - 1 - k8] * (long)Filter.anIntArrayArray670[0][k8] >> 16);
                    }
                    for (int j9 = 0; j9 < j7; ++j9) {
                        j8 -= (int)((long)samples[j7 - 1 - j9] * (long)Filter.anIntArrayArray670[1][j9] >> 16);
                    }
                    Synthesizer.samples[j7] = j8;
                    k3 = this.envelope.evaluate(sampleLength + 1);
                    ++j7;
                }
                l7 = c = 128;
                while (true) {
                    if (l7 > sampleLength - i5) {
                        l7 = sampleLength - i5;
                    }
                    while (j7 < l7) {
                        int l8 = (int)((long)samples[j7 + i5] * (long)Filter.inv_g0_fixedpt >> 16);
                        for (int k9 = 0; k9 < i5; ++k9) {
                            l8 += (int)((long)samples[j7 + i5 - 1 - k9] * (long)Filter.anIntArrayArray670[0][k9] >> 16);
                        }
                        for (int i10 = 0; i10 < i6; ++i10) {
                            l8 -= (int)((long)samples[j7 - 1 - i10] * (long)Filter.anIntArrayArray670[1][i10] >> 16);
                        }
                        Synthesizer.samples[j7] = l8;
                        k3 = this.envelope.evaluate(sampleLength + 1);
                        ++j7;
                    }
                    if (j7 >= sampleLength - i5) break;
                    i5 = this.filter.method544(0, (float)k3 / 65536.0f);
                    i6 = this.filter.method544(1, (float)k3 / 65536.0f);
                    l7 += c;
                }
                while (j7 < sampleLength) {
                    int i9 = 0;
                    for (int l9 = j7 + i5 - sampleLength; l9 < i5; ++l9) {
                        i9 += (int)((long)samples[j7 + i5 - 1 - l9] * (long)Filter.anIntArrayArray670[0][l9] >> 16);
                    }
                    for (int j10 = 0; j10 < i6; ++j10) {
                        i9 -= (int)((long)samples[j7 - 1 - j10] * (long)Filter.anIntArrayArray670[1][j10] >> 16);
                    }
                    Synthesizer.samples[j7] = i9;
                    int n = this.envelope.evaluate(sampleLength + 1);
                    ++j7;
                }
            }
        }
        for (int i4 = 0; i4 < sampleLength; ++i4) {
            if (samples[i4] < Short.MIN_VALUE) {
                Synthesizer.samples[i4] = Short.MIN_VALUE;
            }
            if (samples[i4] <= Short.MAX_VALUE) continue;
            Synthesizer.samples[i4] = Short.MAX_VALUE;
        }
        return samples;
    }

    private int evaluate(int amplitude, int phase, int form) {
        if (form == 1) {
            if ((phase & Short.MAX_VALUE) < 16384) {
                return amplitude;
            }
            return -amplitude;
        }
        if (form == 2) {
            return SINE[phase & Short.MAX_VALUE] * amplitude >> 14;
        }
        if (form == 3) {
            return ((phase & Short.MAX_VALUE) * amplitude >> 14) - amplitude;
        }
        if (form == 4) {
            return NOISE[phase / 2607 & Short.MAX_VALUE] * amplitude;
        }
        return 0;
    }

    public void decode(Stream stream) {
        int k;
        this.samp1 = new Envelope();
        this.samp1.decode(stream);
        this.samp2 = new Envelope();
        this.samp2.decode(stream);
        int i = stream.readUnsignedByte();
        if (i != 0) {
            --stream.currentOffset;
            this.samp3 = new Envelope();
            this.samp3.decode(stream);
            this.samp4 = new Envelope();
            this.samp4.decode(stream);
        }
        if ((i = stream.readUnsignedByte()) != 0) {
            --stream.currentOffset;
            this.samp5 = new Envelope();
            this.samp5.decode(stream);
            this.samp6 = new Envelope();
            this.samp6.decode(stream);
        }
        if ((i = stream.readUnsignedByte()) != 0) {
            --stream.currentOffset;
            this.samp7 = new Envelope();
            this.samp7.decode(stream);
            this.samp8 = new Envelope();
            this.samp8.decode(stream);
        }
        for (int j = 0; j < 10 && (k = stream.method422()) != 0; ++j) {
            this.anIntArray106[j] = k;
            this.cents[j] = stream.method421();
            this.anIntArray108[j] = stream.method422();
        }
        this.anInt109 = stream.method422();
        this.gain = stream.method422();
        this.offset = stream.readUnsignedWord();
        this.remaining = stream.readUnsignedWord();
        this.filter = new Filter();
        this.envelope = new Envelope();
        this.filter.method545(stream, this.envelope);
    }

    static {
        phase = new int[5];
        anIntArray119 = new int[5];
        anIntArray120 = new int[5];
        anIntArray121 = new int[5];
        anIntArray122 = new int[5];
    }
}

