/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import java.util.Objects;

public abstract class Task {
    public static final Object DEFAULT_KEY = new Object();
    private int delay;
    private final boolean immediate;
    private int countdown;
    private boolean running = true;
    private Object key;

    public void setEventRunning(boolean running) {
        this.running = running;
    }

    public final Object getKey() {
        return Objects.requireNonNull(this.key);
    }

    public final Task bind(Object key) {
        this.key = Objects.requireNonNull(key);
        return this;
    }

    public Task() {
        this(1);
    }

    public Task(boolean immediate) {
        this(1, immediate);
    }

    public Task(int delay) {
        this(delay, false);
        this.bind(DEFAULT_KEY);
    }

    public Task(int delay, boolean immediate) {
        this.delay = delay;
        this.countdown = delay;
        this.immediate = immediate;
        this.bind(DEFAULT_KEY);
    }

    public Task(int delay, Object key, boolean immediate) {
        this.delay = delay;
        this.countdown = delay;
        this.immediate = immediate;
        this.bind(key);
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStopped() {
        return !this.running;
    }

    public boolean tick() {
        if (this.running && --this.countdown == 0) {
            this.execute();
            this.countdown = this.delay;
        }
        return this.running;
    }

    protected abstract void execute();

    public void setDelay(int delay) {
        if (delay > 0) {
            this.delay = delay;
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public void stop() {
        this.running = false;
    }
}

