/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Task;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class TaskManager
implements Runnable {
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final Queue<Task> pendingTasks = new LinkedList<Task>();
    private final List<Task> activeTasks = new LinkedList<Task>();

    public TaskManager() {
        this.service.scheduleAtFixedRate(this, 0L, 600L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        try {
            Task t;
            while ((t = this.pendingTasks.poll()) != null) {
                if (!t.isRunning()) continue;
                this.activeTasks.add(t);
            }
            Iterator<Task> it = this.activeTasks.iterator();
            while (it.hasNext()) {
                t = it.next();
                if (t.tick()) continue;
                it.remove();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void submit(Task task) {
        if (!task.isRunning()) {
            return;
        }
        if (task.isImmediate()) {
            task.execute();
        }
        this.pendingTasks.add(task);
    }
}

