/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ARGBTexture;
import com.teragard.AlphaPalettedTexture;
import com.teragard.Background;
import com.teragard.Client;
import com.teragard.PalettedTexture;
import com.teragard.RGBTexture;
import com.teragard.Rasterizer;
import com.teragard.Texture;
import com.teragard.TextureLoader317;
import com.teragard.TextureLoader667;

public class TextureAnimating {
    private static final int[] Animated_Textures = new int[]{65, 16, 53, 64, 57, 68, 50, 54, 53, 59, 52, 17, 69, 71, 70, 56, 55, 66, 67, 24, 60, 70, 34, 40, 1};
    private static byte[] pixels = new byte[16384];
    private static int[] hdPixels = new int[16384];

    public static void animateTexture() {
        try {
            if (!Rasterizer.lowMem) {
                for (int tex : Animated_Textures) {
                    if (Client.getOption("hd_tex")) {
                        int i2;
                        Object[] current;
                        int indexes;
                        Texture t = Texture.get(tex);
                        if (t instanceof RGBTexture) {
                            RGBTexture rgbT = (RGBTexture)t;
                            indexes = rgbT.width * rgbT.height - 1;
                            int noise = rgbT.width * Client.instance.cycleTimer * 2;
                            current = rgbT.pixels;
                            int[] next = hdPixels;
                            for (i2 = 0; i2 <= indexes; ++i2) {
                                next[i2] = current[i2 - noise & indexes];
                            }
                            rgbT.setPixels(next);
                            hdPixels = current;
                            TextureLoader667.resetTexture(tex);
                            continue;
                        }
                        if (t instanceof ARGBTexture) {
                            ARGBTexture rgbT = (ARGBTexture)t;
                            indexes = rgbT.width * rgbT.height - 1;
                            int noise = rgbT.width * Client.instance.cycleTimer * 2;
                            current = rgbT.pixels;
                            int[] next = hdPixels;
                            for (i2 = 0; i2 <= indexes; ++i2) {
                                next[i2] = current[i2 - noise & indexes];
                            }
                            rgbT.setPixels(next);
                            hdPixels = current;
                            TextureLoader667.resetTexture(tex);
                            continue;
                        }
                        if (!(t instanceof PalettedTexture) && !(t instanceof AlphaPalettedTexture)) continue;
                        PalettedTexture rgbT = (PalettedTexture)t;
                        indexes = rgbT.width * rgbT.height - 1;
                        int noise = rgbT.width * Client.instance.cycleTimer * 2;
                        current = rgbT.getIndices();
                        byte[] next = pixels;
                        for (i2 = 0; i2 <= indexes; ++i2) {
                            next[i2] = current[i2 - noise & indexes];
                        }
                        rgbT.setIndices(next);
                        pixels = (byte[])current;
                        TextureLoader667.resetTexture(tex);
                        continue;
                    }
                    Background background = TextureLoader317.textureImages[tex];
                    int indexes = background.imgWidth * background.imgHeight - 1;
                    int noise = background.imgWidth * Client.instance.cycleTimer * 1;
                    byte[] current = background.imgPixels;
                    byte[] next = pixels;
                    for (int i2 = 0; i2 <= indexes; ++i2) {
                        next[i2] = current[i2 - noise & indexes];
                    }
                    background.imgPixels = next;
                    pixels = current;
                    TextureLoader317.resetTexture(tex);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

