/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Animable;
import com.teragard.Client;
import com.teragard.Configuration;
import com.teragard.CullingCluster;
import com.teragard.Deque;
import com.teragard.DrawingArea;
import com.teragard.GroundDecoration;
import com.teragard.GroundItem;
import com.teragard.InteractableObject;
import com.teragard.Model;
import com.teragard.PlainTile;
import com.teragard.Rasterizer;
import com.teragard.ShapedTile;
import com.teragard.Tile;
import com.teragard.VertexNormal;
import com.teragard.WallDecoration;
import com.teragard.WallObject;

final class WorldController {
    public static boolean freeCameraRendering = false;
    private boolean hdMinimap = true;
    public boolean opaque_floor_texture = false;
    public static boolean lowMem = true;
    private final int zMapSize;
    private final int xMapSize;
    private final int yMapSize;
    private final int[][][] heightMap;
    private final Tile[][][] tileArray;
    private int currentHL;
    private int amountOfInteractableObjects;
    private final InteractableObject[] interactableObjectCache;
    private final int[][][] anIntArrayArrayArray445;
    private static int anInt446;
    private static int plane__;
    private static int anInt448;
    private static int anInt449;
    private static int anInt450;
    private static int anInt451;
    private static int anInt452;
    private static int xCamPosTile;
    private static int yCamPosTile;
    private static int xCamPos;
    private static int zCamPos;
    private static int yCamPos;
    private static int yCurveSin;
    private static int yCUrveCos;
    private static int xCurveSin;
    private static int xCurveCos;
    private static InteractableObject[] aClass28Array462;
    private static final int[] faceXoffset2;
    private static final int[] faceYOffset2;
    private static final int[] faceXOffset3;
    private static final int[] faceYOffset3;
    private static boolean isClicked;
    private static int clickX;
    private static int clickY;
    public static int clickedTileX;
    public static int clickedTileY;
    private static final int amountOfCullingClusters;
    private static int[] cullingClusterPointer;
    private static CullingCluster[][] cullingClusters;
    private static int processedClusterPtr;
    private static final CullingCluster[] processedClusters;
    private static Deque tileDeque;
    private static final int[] anIntArray478;
    private static final int[] anIntArray479;
    private static final int[] anIntArray480;
    private static final int[] anIntArray481;
    private static final int[] anIntArray482;
    private static final int[] anIntArray483;
    private static final int[] anIntArray484;
    private static final int[] textureRGBColour;
    private final int[] anIntArray486;
    private final int[] anIntArray487;
    private int anInt488;
    private final int[][] tileSHapePoints = new int[][]{new int[16], {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1}, {0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1}};
    private final int[][] tileShapeIndices = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {12, 8, 4, 0, 13, 9, 5, 1, 14, 10, 6, 2, 15, 11, 7, 3}, {15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}, {3, 7, 11, 15, 2, 6, 10, 14, 1, 5, 9, 13, 0, 4, 8, 12}};
    private static boolean[][][][] tile_visibility_maps;
    private static boolean[][] tile_visibility_map;
    private static int midX;
    private static int midY;
    private static int left;
    private static int top;
    private static int right;
    private static int bottom;
    public static int focalLength;

    public WorldController(int[][][] ai) {
        int height = 104;
        int width = 104;
        int depth = 4;
        this.interactableObjectCache = new InteractableObject[5000];
        this.anIntArray486 = new int[10000];
        this.anIntArray487 = new int[10000];
        this.zMapSize = depth;
        this.xMapSize = width;
        this.yMapSize = height;
        this.tileArray = new Tile[depth][width][height];
        this.anIntArrayArrayArray445 = new int[depth][width + 1][height + 1];
        this.heightMap = ai;
        this.initToNull();
    }

    public WallObject fetchWallObject(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.wallObject == null) {
            return null;
        }
        return tile.wallObject;
    }

    public WallDecoration fetchWallDecoration(int i, int j, int l) {
        Tile tile = this.tileArray[i][j][l];
        if (tile == null || tile.wallDecoration == null) {
            return null;
        }
        return tile.wallDecoration;
    }

    public InteractableObject fetchInteractableObject(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        for (int l = 0; l < tile.entityCount; ++l) {
            InteractableObject interactableObject = tile.interactableObjects[l];
            if (interactableObject.tileLeft != x || interactableObject.tileTop != y) continue;
            return interactableObject;
        }
        return null;
    }

    public GroundDecoration fetchGroundDecoration(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.groundDecoration == null) {
            return null;
        }
        return tile.groundDecoration;
    }

    public int fetchWallObjectNewUID(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.wallObject == null) {
            return 0;
        }
        return tile.wallObject.wallObjUID;
    }

    public int fetchWallDecorationNewUID(int i, int j, int l) {
        Tile tile = this.tileArray[i][j][l];
        if (tile == null || tile.wallDecoration == null) {
            return 0;
        }
        return tile.wallDecoration.wallDecorUID;
    }

    public int fetchObjectMeshNewUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return 0;
        }
        for (int l = 0; l < tile.entityCount; ++l) {
            InteractableObject interactableObject = tile.interactableObjects[l];
            if (interactableObject.tileLeft != x || interactableObject.tileTop != y) continue;
            return interactableObject.interactiveObjUID;
        }
        return 0;
    }

    public int fetchGroundDecorationNewUID(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.groundDecoration == null) {
            return 0;
        }
        return tile.groundDecoration.groundDecorUID;
    }

    public static void nullLoader() {
        aClass28Array462 = null;
        cullingClusterPointer = null;
        cullingClusters = null;
        tileDeque = null;
        tile_visibility_maps = null;
        tile_visibility_map = null;
    }

    public void initToNull() {
        for (int z = 0; z < this.zMapSize; ++z) {
            for (int x = 0; x < this.xMapSize; ++x) {
                for (int y = 0; y < this.yMapSize; ++y) {
                    this.tileArray[z][x][y] = null;
                }
            }
        }
        for (int l = 0; l < amountOfCullingClusters; ++l) {
            for (int j1 = 0; j1 < cullingClusterPointer[l]; ++j1) {
                WorldController.cullingClusters[l][j1] = null;
            }
            WorldController.cullingClusterPointer[l] = 0;
        }
        for (int k1 = 0; k1 < this.amountOfInteractableObjects; ++k1) {
            this.interactableObjectCache[k1] = null;
        }
        this.amountOfInteractableObjects = 0;
        for (int l1 = 0; l1 < aClass28Array462.length; ++l1) {
            WorldController.aClass28Array462[l1] = null;
        }
    }

    public void initTiles(int hl) {
        this.currentHL = hl;
        for (int k = 0; k < this.xMapSize; ++k) {
            for (int l = 0; l < this.yMapSize; ++l) {
                if (this.tileArray[hl][k][l] != null) continue;
                this.tileArray[hl][k][l] = new Tile(hl, k, l);
            }
        }
    }

    public void applyBridgeMode(int y, int x) {
        Tile tile = this.tileArray[0][x][y];
        for (int l = 0; l < 3; ++l) {
            this.tileArray[l][x][y] = this.tileArray[l + 1][x][y];
            Tile tile_ = this.tileArray[l][x][y];
            if (tile_ == null) continue;
            --tile_.tileZ;
            for (int entityPtr = 0; entityPtr < tile_.entityCount; ++entityPtr) {
                InteractableObject iObject = tile_.interactableObjects[entityPtr];
                if ((iObject.uid >> 29 & 3) != 2 || iObject.tileLeft != x || iObject.tileTop != y) continue;
                --iObject.zPos;
            }
        }
        if (this.tileArray[0][x][y] == null) {
            this.tileArray[0][x][y] = new Tile(0, x, y);
        }
        this.tileArray[0][x][y].tileBelowThisTile = tile;
        this.tileArray[3][x][y] = null;
    }

    public static void createCullingCluster(int id, int tileStartX, int worldEndZ, int tileEndX, int tileEndY, int worldStartZ, int tileStartY, int searchMask) {
        CullingCluster cluster = new CullingCluster();
        cluster.tileStartX = tileStartX / 128;
        cluster.tileEndX = tileEndX / 128;
        cluster.tileStartY = tileStartY / 128;
        cluster.tileEndY = tileEndY / 128;
        cluster.searchMask = searchMask;
        cluster.worldStartX = tileStartX;
        cluster.worldEndX = tileEndX;
        cluster.worldStartY = tileStartY;
        cluster.worldEndY = tileEndY;
        cluster.worldStartZ = worldStartZ;
        cluster.worldEndZ = worldEndZ;
        int n = id;
        int n2 = cullingClusterPointer[n];
        cullingClusterPointer[n] = n2 + 1;
        WorldController.cullingClusters[id][n2] = cluster;
    }

    public void setVisiblePlanesFor(int z, int x, int y, int logicHeight) {
        Tile tile = this.tileArray[z][x][y];
        if (tile != null) {
            this.tileArray[z][x][y].logicHeight = logicHeight;
        }
    }

    public void addTile(int plane, int x, int y, int shape, int rotation, int texture, int zA, int zB, int zD, int zC, int colourA, int colourB, int colourD, int colourC, int colourAA, int colourBA, int colourDA, int colourCA, int rgbColour, int rgbColour_, int color, int copy_texture, int copy_color, boolean tex) {
        if (shape == 434 && copy_texture != 24) {
            PlainTile tile_1 = new PlainTile(colourA, colourB, colourD, colourC, texture, rgbColour_, zA == zB && zA == zD && zA == zC, color, tex);
            for (int z = plane; z >= 0; --z) {
                if (this.tileArray[z][x][y] != null) continue;
                this.tileArray[z][x][y] = new Tile(z, x, y);
            }
            this.tileArray[plane][x][y].plainTile = tile_1;
            return;
        }
        if (shape == 0) {
            PlainTile tile = new PlainTile(colourA, colourB, colourD, colourC, -1, rgbColour, false, color, tex);
            for (int z = plane; z >= 0; --z) {
                if (this.tileArray[z][x][y] != null) continue;
                this.tileArray[z][x][y] = new Tile(z, x, y);
            }
            this.tileArray[plane][x][y].plainTile = tile;
            return;
        }
        if (shape == 1) {
            PlainTile tile_1 = new PlainTile(colourAA, colourBA, colourDA, colourCA, texture, rgbColour_, zA == zB && zA == zD && zA == zC, color, tex);
            for (int z = plane; z >= 0; --z) {
                if (this.tileArray[z][x][y] != null) continue;
                this.tileArray[z][x][y] = new Tile(z, x, y);
            }
            this.tileArray[plane][x][y].plainTile = tile_1;
            return;
        }
        ShapedTile shapedTile = new ShapedTile(y, colourAA, colourC, zD, texture, colourDA, rotation, colourA, rgbColour, colourD, zC, zB, zA, shape, colourCA, colourBA, colourB, x, rgbColour_, color, copy_texture, copy_color, tex);
        for (int z = plane; z >= 0; --z) {
            if (this.tileArray[z][x][y] != null) continue;
            this.tileArray[z][x][y] = new Tile(z, x, y);
        }
        this.tileArray[plane][x][y].shapedTile = shapedTile;
    }

    public void addGroundDecoration(int plane, int zPos, int yPos, Animable animable, byte byte0, int uid, int xPos, int groundDecorUID) {
        if (animable == null) {
            return;
        }
        GroundDecoration decoration = new GroundDecoration();
        decoration.node = animable;
        decoration.groundDecorUID = groundDecorUID;
        decoration.xPos = xPos * 128 + 64;
        decoration.yPos = yPos * 128 + 64;
        decoration.zPos = zPos;
        decoration.uid = uid;
        decoration.objConfig = byte0;
        if (this.tileArray[plane][xPos][yPos] == null) {
            this.tileArray[plane][xPos][yPos] = new Tile(plane, xPos, yPos);
        }
        this.tileArray[plane][xPos][yPos].groundDecoration = decoration;
    }

    public void addGroundItemTile(int xPos, int uid, Animable secondItem, int zPos, Animable thirdItem, Animable firstItem, int plane, int yPos) {
        GroundItem groundItem = new GroundItem();
        groundItem.firstGroundItem = firstItem;
        groundItem.xPos = xPos * 128 + 64;
        groundItem.yPos = yPos * 128 + 64;
        groundItem.zPos = zPos;
        groundItem.uid = uid;
        groundItem.secondGroundItem = secondItem;
        groundItem.thirdGroundItem = thirdItem;
        int isHighestPriority = 0;
        Tile tile = this.tileArray[plane][xPos][yPos];
        if (tile != null) {
            for (int k1 = 0; k1 < tile.entityCount; ++k1) {
                int tempInt;
                if (!(tile.interactableObjects[k1].node instanceof Model) || (tempInt = ((Model)tile.interactableObjects[k1].node).myPriority) <= isHighestPriority) continue;
                isHighestPriority = tempInt;
            }
        }
        groundItem.topItem = isHighestPriority;
        if (this.tileArray[plane][xPos][yPos] == null) {
            this.tileArray[plane][xPos][yPos] = new Tile(plane, xPos, yPos);
        }
        this.tileArray[plane][xPos][yPos].groundItem = groundItem;
    }

    public void addWallObject(int orientation, Animable node, int uid, int yPos, byte objConfig, int xPos, Animable node2, int zPos, int orientation_2, int plane, int wallObjUID) {
        if (node == null && node2 == null) {
            return;
        }
        WallObject wallObject = new WallObject();
        wallObject.uid = uid;
        wallObject.objConfig = objConfig;
        wallObject.xPos = xPos * 128 + 64;
        wallObject.yPos = yPos * 128 + 64;
        wallObject.zPos = zPos;
        wallObject.node1 = node;
        wallObject.node2 = node2;
        wallObject.wallObjUID = wallObjUID;
        wallObject.orientation = orientation;
        wallObject.orientation1 = orientation_2;
        for (int zPtr = plane; zPtr >= 0; --zPtr) {
            if (this.tileArray[zPtr][xPos][yPos] != null) continue;
            this.tileArray[zPtr][xPos][yPos] = new Tile(zPtr, xPos, yPos);
        }
        this.tileArray[plane][xPos][yPos].wallObject = wallObject;
    }

    public void addWallDecoration(int uid, int yPos, int rotation, int plane, int xOff, int zPos, Animable node, int xPos, byte config, int yOff, int configBits, int wallDecorUID) {
        if (node == null) {
            return;
        }
        WallDecoration dec = new WallDecoration();
        dec.uid = uid;
        dec.objConfig = config;
        dec.xPos = xPos * 128 + 64 + xOff;
        dec.yPos = yPos * 128 + 64 + yOff;
        dec.zPos = zPos;
        dec.node = node;
        dec.wallDecorUID = wallDecorUID;
        dec.configurationBits = configBits;
        dec.rotation = rotation;
        for (int zPtr = plane; zPtr >= 0; --zPtr) {
            if (this.tileArray[zPtr][xPos][yPos] != null) continue;
            this.tileArray[zPtr][xPos][yPos] = new Tile(zPtr, xPos, yPos);
        }
        this.tileArray[plane][xPos][yPos].wallDecoration = dec;
    }

    public boolean addInteractableEntity(int ui, byte config, int worldZ, int tileBottom, Animable node, int tileRight, int z, int rotation, int tileTop, int tileLeft, int interactiveUID) {
        if (node == null) {
            return true;
        }
        int worldX = tileLeft * 128 + 64 * tileRight;
        int worldY = tileTop * 128 + 64 * tileBottom;
        return this.addEntity(z, tileLeft, tileTop, tileRight, tileBottom, worldX, worldY, worldZ, node, rotation, false, ui, config, interactiveUID);
    }

    public boolean addMutipleTileEntity(int z, int rotation, int worldZ, int ui, int worldY, int j1, int worldX, Animable nodeToAdd, boolean flag) {
        if (nodeToAdd == null) {
            return true;
        }
        int tileLeft = worldX - j1;
        int tileTop = worldY - j1;
        int tileRight = worldX + j1;
        int tileBottom = worldY + j1;
        if (flag) {
            if (rotation > 640 && rotation < 1408) {
                tileBottom += 128;
            }
            if (rotation > 1152 && rotation < 1920) {
                tileRight += 128;
            }
            if (rotation > 1664 || rotation < 384) {
                tileTop -= 128;
            }
            if (rotation > 128 && rotation < 896) {
                tileLeft -= 128;
            }
        }
        return this.addEntity(z, tileLeft /= 128, tileTop /= 128, (tileRight /= 128) - tileLeft + 1, (tileBottom /= 128) - tileTop + 1, worldX, worldY, worldZ, nodeToAdd, rotation, true, ui, (byte)0, 0);
    }

    public boolean addSingleTileEntity(int z, int worldY, Animable node, int rotation, int tileBottom, int worldX, int worldZ, int tileLeft, int tileRight, int ui, int tileTop) {
        return node == null || this.addEntity(z, tileLeft, tileTop, tileRight - tileLeft + 1, tileBottom - tileTop + 1, worldX, worldY, worldZ, node, rotation, true, ui, (byte)0, 0);
    }

    private boolean addEntity(int z, int tileLeft, int tileTop, int tileRight, int tileBottom, int worldX, int worldY, int worldZ, Animable node, int rotation, boolean flag, int ui, byte objConf, int interactiveObjUID) {
        for (int _x = tileLeft; _x < tileLeft + tileRight; ++_x) {
            for (int _y = tileTop; _y < tileTop + tileBottom; ++_y) {
                if (_x < 0 || _y < 0 || _x >= this.xMapSize || _y >= this.yMapSize) {
                    return false;
                }
                Tile tile = this.tileArray[z][_x][_y];
                if (tile == null || tile.entityCount < 5) continue;
                return false;
            }
        }
        InteractableObject io = new InteractableObject();
        io.uid = ui;
        io.objConf = objConf;
        io.zPos = z;
        io.worldX = worldX;
        io.worldY = worldY;
        io.interactiveObjUID = interactiveObjUID;
        io.worldZ = worldZ;
        io.node = node;
        io.rotation = rotation;
        io.tileLeft = tileLeft;
        io.tileTop = tileTop;
        io.tileRight = tileLeft + tileRight - 1;
        io.tileBottom = tileTop + tileBottom - 1;
        for (int x = tileLeft; x < tileLeft + tileRight; ++x) {
            for (int y = tileTop; y < tileTop + tileBottom; ++y) {
                int position = 0;
                if (x > tileLeft) {
                    ++position;
                }
                if (x < tileLeft + tileRight - 1) {
                    position += 4;
                }
                if (y > tileTop) {
                    position += 8;
                }
                if (y < tileTop + tileBottom - 1) {
                    position += 2;
                }
                for (int zPtr = z; zPtr >= 0; --zPtr) {
                    if (this.tileArray[zPtr][x][y] != null) continue;
                    this.tileArray[zPtr][x][y] = new Tile(zPtr, x, y);
                }
                Tile tile = this.tileArray[z][x][y];
                tile.interactableObjects[tile.entityCount] = io;
                tile.anIntArray1319[tile.entityCount] = position;
                tile.anInt1320 |= position;
                ++tile.entityCount;
            }
        }
        if (flag) {
            this.interactableObjectCache[this.amountOfInteractableObjects++] = io;
        }
        return true;
    }

    public void clearInteractableObjects() {
        for (int i = 0; i < this.amountOfInteractableObjects; ++i) {
            InteractableObject iObject = this.interactableObjectCache[i];
            this.updateObjectEntities(iObject);
            this.interactableObjectCache[i] = null;
        }
        this.amountOfInteractableObjects = 0;
    }

    private void updateObjectEntities(InteractableObject iObject) {
        for (int j = iObject.tileLeft; j <= iObject.tileRight; ++j) {
            for (int k = iObject.tileTop; k <= iObject.tileBottom; ++k) {
                Tile tile = this.tileArray[iObject.zPos][j][k];
                if (tile == null) continue;
                for (int l = 0; l < tile.entityCount; ++l) {
                    if (tile.interactableObjects[l] != iObject) continue;
                    --tile.entityCount;
                    for (int entityPtr = l; entityPtr < tile.entityCount; ++entityPtr) {
                        tile.interactableObjects[entityPtr] = tile.interactableObjects[entityPtr + 1];
                        tile.anIntArray1319[entityPtr] = tile.anIntArray1319[entityPtr + 1];
                    }
                    tile.interactableObjects[tile.entityCount] = null;
                    break;
                }
                tile.anInt1320 = 0;
                for (int j1 = 0; j1 < tile.entityCount; ++j1) {
                    tile.anInt1320 |= tile.anIntArray1319[j1];
                }
            }
        }
    }

    public void moveWallDec(int y, int moveAmt, int x, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return;
        }
        WallDecoration wallDec = tile.wallDecoration;
        if (wallDec != null) {
            int xCoord = x * 128 + 64;
            int yCoord = y * 128 + 64;
            wallDec.xPos = xCoord + (wallDec.xPos - xCoord) * moveAmt / 16;
            wallDec.yPos = yCoord + (wallDec.yPos - yCoord) * moveAmt / 16;
        }
    }

    public void removeWallObject(int x, int y, int z) {
        Tile tile = this.tileArray[y][x][z];
        if (tile != null) {
            tile.wallObject = null;
        }
    }

    public void removeWallDecoration(int y, int z, int x) {
        Tile tile = this.tileArray[z][x][y];
        if (tile != null) {
            tile.wallDecoration = null;
        }
    }

    public void removeInteractableObject(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return;
        }
        for (int i = 0; i < tile.entityCount; ++i) {
            InteractableObject subObject = tile.interactableObjects[i];
            if ((subObject.uid >> 29 & 3) != 2 || subObject.tileLeft != x || subObject.tileTop != y) continue;
            this.updateObjectEntities(subObject);
            return;
        }
    }

    public void removeGroundDecoration(int z, int y, int x) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return;
        }
        tile.groundDecoration = null;
    }

    public void removeGroundItemFromTIle(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile != null) {
            tile.groundItem = null;
        }
    }

    public WallObject getWallObject(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        return tile.wallObject;
    }

    public WallDecoration getWallDecoration(int x, int y, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        return tile.wallDecoration;
    }

    public InteractableObject getInteractableObject(int x, int y, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        for (int l = 0; l < tile.entityCount; ++l) {
            InteractableObject subObject = tile.interactableObjects[l];
            if ((subObject.uid >> 29 & 3) != 2 || subObject.tileLeft != x || subObject.tileTop != y) continue;
            return subObject;
        }
        return null;
    }

    public GroundDecoration getGroundDecoration(int y, int x, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.groundDecoration == null) {
            return null;
        }
        return tile.groundDecoration;
    }

    public int getWallObjectUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.wallObject == null) {
            return 0;
        }
        return tile.wallObject.uid;
    }

    public int getWallDecorationUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.wallDecoration == null) {
            return 0;
        }
        return tile.wallDecoration.uid;
    }

    public int getInteractableObjectUID(int plane, int x, int y) {
        Tile tile = this.tileArray[plane][x][y];
        if (tile == null) {
            return 0;
        }
        for (int i = 0; i < tile.entityCount; ++i) {
            InteractableObject iObject = tile.interactableObjects[i];
            if (iObject.tileLeft != x || iObject.tileTop != y) continue;
            return iObject.uid;
        }
        return 0;
    }

    public int getGroundDecorationUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.groundDecoration == null) {
            return 0;
        }
        return tile.groundDecoration.uid;
    }

    public int getIDTagForXYZ(int z, int x, int y, int uidMatch) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return -1;
        }
        if (tile.wallObject != null && tile.wallObject.uid == uidMatch) {
            return tile.wallObject.objConfig & 0xFF;
        }
        if (tile.wallDecoration != null && tile.wallDecoration.uid == uidMatch) {
            return tile.wallDecoration.objConfig & 0xFF;
        }
        if (tile.groundDecoration != null && tile.groundDecoration.uid == uidMatch) {
            return tile.groundDecoration.objConfig & 0xFF;
        }
        for (int entityPtr = 0; entityPtr < tile.entityCount; ++entityPtr) {
            if (tile.interactableObjects[entityPtr].uid != uidMatch) continue;
            return tile.interactableObjects[entityPtr].objConf & 0xFF;
        }
        return -1;
    }

    public void shadeModels(int i, int k, int i1) {
        int j = 100;
        int l = 5500;
        int j1 = (int)Math.sqrt(k * k + i * i + i1 * i1);
        int k1 = l >> 4;
        for (int l1 = 0; l1 < this.zMapSize; ++l1) {
            for (int i2 = 0; i2 < this.xMapSize; ++i2) {
                for (int j2 = 0; j2 < this.yMapSize; ++j2) {
                    Tile class30_sub3 = this.tileArray[l1][i2][j2];
                    if (class30_sub3 == null) continue;
                    WallObject class10 = class30_sub3.wallObject;
                    if (class10 != null && class10.node1 != null && class10.node1.vertexNormals != null) {
                        this.mergeModels(l1, 1, 1, i2, j2, (Model)class10.node1);
                        if (class10.node2 != null && class10.node2.vertexNormals != null) {
                            this.mergeModels(l1, 1, 1, i2, j2, (Model)class10.node2);
                            this.renderModels((Model)class10.node1, (Model)class10.node2, 0, 0, 0, false);
                            ((Model)class10.node2).method480(j, k1, k, i, i1);
                        }
                        ((Model)class10.node1).method480(j, k1, k, i, i1);
                    }
                    for (int k2 = 0; k2 < class30_sub3.entityCount; ++k2) {
                        InteractableObject class28 = class30_sub3.interactableObjects[k2];
                        if (class28 == null || class28.node == null || class28.node.vertexNormals == null) continue;
                        this.mergeModels(l1, class28.tileRight - class28.tileLeft + 1, class28.tileBottom - class28.tileTop + 1, i2, j2, (Model)class28.node);
                        ((Model)class28.node).method480(j, k1, k, i, i1);
                    }
                    GroundDecoration class49 = class30_sub3.groundDecoration;
                    if (class49 == null || class49.node.vertexNormals == null) continue;
                    this.renderGrounDec(i2, l1, (Model)class49.node, j2);
                    ((Model)class49.node).method480(j, k1, k, i, i1);
                }
            }
        }
    }

    private void renderGrounDec(int i, int j, Model model, int k) {
        Tile class30_sub3_3;
        Tile class30_sub3_2;
        Tile class30_sub3_1;
        Tile class30_sub3;
        if (i < this.xMapSize && (class30_sub3 = this.tileArray[j][i + 1][k]) != null && class30_sub3.groundDecoration != null && class30_sub3.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3.groundDecoration.node, 128, 0, 0, true);
        }
        if (k < this.xMapSize && (class30_sub3_1 = this.tileArray[j][i][k + 1]) != null && class30_sub3_1.groundDecoration != null && class30_sub3_1.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3_1.groundDecoration.node, 0, 0, 128, true);
        }
        if (i < this.xMapSize && k < this.yMapSize && (class30_sub3_2 = this.tileArray[j][i + 1][k + 1]) != null && class30_sub3_2.groundDecoration != null && class30_sub3_2.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3_2.groundDecoration.node, 128, 0, 128, true);
        }
        if (i < this.xMapSize && k > 0 && (class30_sub3_3 = this.tileArray[j][i + 1][k - 1]) != null && class30_sub3_3.groundDecoration != null && class30_sub3_3.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3_3.groundDecoration.node, 128, 0, -128, true);
        }
    }

    private void mergeModels(int z, int j, int k, int x, int y, Model model) {
        boolean flag = true;
        int j1 = x;
        int k1 = x + j;
        int l1 = y - 1;
        int i2 = y + k;
        for (int j2 = z; j2 <= z + 1; ++j2) {
            if (j2 == this.zMapSize) continue;
            for (int k2 = j1; k2 <= k1; ++k2) {
                if (k2 < 0 || k2 >= this.xMapSize) continue;
                for (int l2 = l1; l2 <= i2; ++l2) {
                    Tile class30_sub3;
                    if (l2 < 0 || l2 >= this.yMapSize || flag && k2 < k1 && l2 < i2 && (l2 >= y || k2 == x) || (class30_sub3 = this.tileArray[j2][k2][l2]) == null) continue;
                    int i3 = (this.heightMap[j2][k2][l2] + this.heightMap[j2][k2 + 1][l2] + this.heightMap[j2][k2][l2 + 1] + this.heightMap[j2][k2 + 1][l2 + 1]) / 4 - (this.heightMap[z][x][y] + this.heightMap[z][x + 1][y] + this.heightMap[z][x][y + 1] + this.heightMap[z][x + 1][y + 1]) / 4;
                    WallObject class10 = class30_sub3.wallObject;
                    if (class10 != null && class10.node1 != null && class10.node1.vertexNormals != null) {
                        this.renderModels(model, (Model)class10.node1, (k2 - x) * 128 + (1 - j) * 64, i3, (l2 - y) * 128 + (1 - k) * 64, flag);
                    }
                    if (class10 != null && class10.node2 != null && class10.node2.vertexNormals != null) {
                        this.renderModels(model, (Model)class10.node2, (k2 - x) * 128 + (1 - j) * 64, i3, (l2 - y) * 128 + (1 - k) * 64, flag);
                    }
                    for (int j3 = 0; j3 < class30_sub3.entityCount; ++j3) {
                        InteractableObject class28 = class30_sub3.interactableObjects[j3];
                        if (class28 == null || class28.node == null || class28.node.vertexNormals == null) continue;
                        int k3 = class28.tileRight - class28.tileLeft + 1;
                        int l3 = class28.tileBottom - class28.tileTop + 1;
                        this.renderModels(model, (Model)class28.node, (class28.tileLeft - x) * 128 + (k3 - j) * 64, i3, (class28.tileTop - y) * 128 + (l3 - k) * 64, flag);
                    }
                }
            }
            --j1;
            flag = false;
        }
    }

    private void renderModels(Model model, Model model_1, int i, int j, int k, boolean flag) {
        ++this.anInt488;
        int l = 0;
        int[] ai = model_1.verticesXCoordinate;
        int amtOfVertices = model_1.numberOfVerticeCoordinates;
        for (int verticeId = 0; verticeId < model.numberOfVerticeCoordinates; ++verticeId) {
            int vertZ;
            int vertX;
            int vertY;
            VertexNormal vertexNormal = model.vertexNormals[verticeId];
            VertexNormal vertexNormalOff = model.vertexNormalOffset[verticeId];
            if (vertexNormalOff.anInt605 == 0 || (vertY = model.verticesYCoordinate[verticeId] - j) > model_1.anInt1651 || (vertX = model.verticesXCoordinate[verticeId] - i) < model_1.anInt1646 || vertX > model_1.anInt1647 || (vertZ = model.verticesZCoordinate[verticeId] - k) < model_1.anInt1649 || vertZ > model_1.anInt1648) continue;
            for (int vertId_1 = 0; vertId_1 < amtOfVertices; ++vertId_1) {
                VertexNormal class33_2 = model_1.vertexNormals[vertId_1];
                VertexNormal class33_3 = model_1.vertexNormalOffset[vertId_1];
                if (vertX != ai[vertId_1] || vertZ != model_1.verticesZCoordinate[vertId_1] || vertY != model_1.verticesYCoordinate[vertId_1] || class33_3.anInt605 == 0) continue;
                vertexNormal.anInt602 += class33_3.anInt602;
                vertexNormal.anInt603 += class33_3.anInt603;
                vertexNormal.anInt604 += class33_3.anInt604;
                vertexNormal.anInt605 += class33_3.anInt605;
                class33_2.anInt602 += vertexNormalOff.anInt602;
                class33_2.anInt603 += vertexNormalOff.anInt603;
                class33_2.anInt604 += vertexNormalOff.anInt604;
                class33_2.anInt605 += vertexNormalOff.anInt605;
                ++l;
                this.anIntArray486[verticeId] = this.anInt488;
                this.anIntArray487[vertId_1] = this.anInt488;
            }
        }
        if (l < 3 || !flag) {
            return;
        }
        for (int k1 = 0; k1 < model.numberOfTriangleFaces; ++k1) {
            if (this.anIntArray486[model.face_a[k1]] != this.anInt488 || this.anIntArray486[model.face_b[k1]] != this.anInt488 || this.anIntArray486[model.face_c[k1]] != this.anInt488) continue;
            model.face_render_type[k1] = -1;
        }
        for (int l1 = 0; l1 < model_1.numberOfTriangleFaces; ++l1) {
            if (this.anIntArray487[model_1.face_a[l1]] != this.anInt488 || this.anIntArray487[model_1.face_b[l1]] != this.anInt488 || this.anIntArray487[model_1.face_c[l1]] != this.anInt488) continue;
            model_1.face_render_type[l1] = -1;
        }
    }

    public void drawTileMinimap(int[] ai, int i, int k, int l, int i1) {
        int j = 512;
        Tile class30_sub3 = this.tileArray[k][l][i1];
        if (class30_sub3 == null) {
            return;
        }
        PlainTile class43 = class30_sub3.plainTile;
        if (class43 != null) {
            if (this.hdMinimap && class43.color1 != 12345678) {
                if (class43.anInt722 == 0) {
                    return;
                }
                int hs = class43.color1 & 0xFFFFFF80;
                int l1 = class43.color4 & 0x7F;
                int l2 = class43.color3 & 0x7F;
                int l3 = (class43.color1 & 0x7F) - l1;
                int l4 = (class43.color2 & 0x7F) - l2;
                l1 <<= 2;
                l2 <<= 2;
                for (int k1 = 0; k1 < 4; ++k1) {
                    if (!class43.textured) {
                        ai[i] = Rasterizer.hsl2rgb[hs | l1 >> 2];
                        ai[i + 1] = Rasterizer.hsl2rgb[hs | l1 * 3 + l2 >> 4];
                        ai[i + 2] = Rasterizer.hsl2rgb[hs | l1 + l2 >> 3];
                        ai[i + 3] = Rasterizer.hsl2rgb[hs | l1 + l2 * 3 >> 4];
                    } else {
                        int j1 = class43.anInt722;
                        int lig = 255 - ((l1 >> 1) * (l1 >> 1) >> 8);
                        ai[i] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                        lig = 255 - ((l1 * 3 + l2 >> 3) * (l1 * 3 + l2 >> 3) >> 8);
                        ai[i + 1] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                        lig = 255 - ((l1 + l2 >> 2) * (l1 + l2 >> 2) >> 8);
                        ai[i + 2] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                        lig = 255 - ((l1 + l2 * 3 >> 3) * (l1 + l2 * 3 >> 3) >> 8);
                        ai[i + 3] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    l1 += l3;
                    l2 += l4;
                    i += 512;
                }
                return;
            }
            int j1 = class43.anInt722;
            if (j1 == 0) {
                return;
            }
            for (int k1 = 0; k1 < 4; ++k1) {
                ai[i] = j1;
                ai[i + 1] = j1;
                ai[i + 2] = j1;
                ai[i + 3] = j1;
                i += 512;
            }
            return;
        }
        ShapedTile class40 = class30_sub3.shapedTile;
        if (class40 == null) {
            return;
        }
        int l1 = class40.shape;
        int i2 = class40.rotation;
        int j2 = class40.colourRGB;
        int k2 = class40.colourRGBA;
        int[] ai1 = this.tileSHapePoints[l1];
        int[] ai2 = this.tileShapeIndices[i2];
        int l2 = 0;
        if (this.hdMinimap && class40.color62 != 12345678) {
            int k1;
            int hs1 = class40.color62 & 0xFFFFFF80;
            int l11 = class40.color92 & 0x7F;
            int l21 = class40.color82 & 0x7F;
            int l31 = (class40.color62 & 0x7F) - l11;
            int l41 = (class40.color72 & 0x7F) - l21;
            l11 <<= 2;
            l21 <<= 2;
            for (k1 = 0; k1 < 4; ++k1) {
                if (!class40.textured) {
                    if (ai1[ai2[l2++]] != 0) {
                        ai[i] = Rasterizer.hsl2rgb[hs1 | l11 >> 2];
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        ai[i + 1] = Rasterizer.hsl2rgb[hs1 | l11 * 3 + l21 >> 4];
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        ai[i + 2] = Rasterizer.hsl2rgb[hs1 | l11 + l21 >> 3];
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        ai[i + 3] = Rasterizer.hsl2rgb[hs1 | l11 + l21 * 3 >> 4];
                    }
                } else {
                    int lig;
                    int j1 = k2;
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 >> 1) * (l11 >> 1) >> 8);
                        ai[i] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 * 3 + l21 >> 3) * (l11 * 3 + l21 >> 3) >> 8);
                        ai[i + 1] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 + l21 >> 2) * (l11 + l21 >> 2) >> 8);
                        ai[i + 2] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 + l21 * 3 >> 3) * (l11 + l21 * 3 >> 3) >> 8);
                        ai[i + 3] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                }
                l11 += l31;
                l21 += l41;
                i += 512;
            }
            if (j2 != 0 && class40.color61 != 12345678) {
                i -= 2048;
                l2 -= 16;
                hs1 = class40.color61 & 0xFFFFFF80;
                l11 = class40.color91 & 0x7F;
                l21 = class40.color81 & 0x7F;
                l31 = (class40.color61 & 0x7F) - l11;
                l41 = (class40.color71 & 0x7F) - l21;
                l11 <<= 2;
                l21 <<= 2;
                for (k1 = 0; k1 < 4; ++k1) {
                    if (ai1[ai2[l2++]] == 0) {
                        ai[i] = Rasterizer.hsl2rgb[hs1 | l11 >> 2];
                    }
                    if (ai1[ai2[l2++]] == 0) {
                        ai[i + 1] = Rasterizer.hsl2rgb[hs1 | l11 * 3 + l21 >> 4];
                    }
                    if (ai1[ai2[l2++]] == 0) {
                        ai[i + 2] = Rasterizer.hsl2rgb[hs1 | l11 + l21 >> 3];
                    }
                    if (ai1[ai2[l2++]] == 0) {
                        ai[i + 3] = Rasterizer.hsl2rgb[hs1 | l11 + l21 * 3 >> 4];
                    }
                    l11 += l31;
                    l21 += l41;
                    i += 512;
                }
            }
            return;
        }
        if (j2 != 0) {
            for (int i3 = 0; i3 < 4; ++i3) {
                ai[i] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                ai[i + 1] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                ai[i + 2] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                ai[i + 3] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                i += 512;
            }
            return;
        }
        for (int j3 = 0; j3 < 4; ++j3) {
            if (ai1[ai2[l2++]] != 0) {
                ai[i] = k2;
            }
            if (ai1[ai2[l2++]] != 0) {
                ai[i + 1] = k2;
            }
            if (ai1[ai2[l2++]] != 0) {
                ai[i + 2] = k2;
            }
            if (ai1[ai2[l2++]] != 0) {
                ai[i + 3] = k2;
            }
            i += 512;
        }
    }

    public static void setupViewport(int minZ, int maxZ, int width, int height, int[] ai) {
        left = 0;
        top = 0;
        right = width;
        bottom = height;
        midX = width / 2;
        midY = height / 2;
        boolean[][][][] isOnScreen = new boolean[9][32][53][53];
        for (int yAngle = 128; yAngle <= 384; yAngle += 32) {
            for (int xAngle = 0; xAngle < 2048; xAngle += 64) {
                yCurveSin = Model.SINE[yAngle];
                yCUrveCos = Model.COSINE[yAngle];
                xCurveSin = Model.SINE[xAngle];
                xCurveCos = Model.COSINE[xAngle];
                int l1 = (yAngle - 128) / 32;
                int j2 = xAngle / 64;
                for (int l2 = -26; l2 <= 26; ++l2) {
                    for (int j3 = -26; j3 <= 26; ++j3) {
                        int k3 = l2 * 128;
                        int i4 = j3 * 128;
                        boolean flag2 = false;
                        for (int k4 = -minZ; k4 <= maxZ; k4 += 128) {
                            if (!WorldController.isOnScreen(ai[l1] + k4, i4, k3)) continue;
                            flag2 = true;
                            break;
                        }
                        isOnScreen[l1][j2][l2 + 25 + 1][j3 + 25 + 1] = flag2;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 8; ++k1) {
            for (int i2 = 0; i2 < 32; ++i2) {
                for (int k2 = -25; k2 < 25; ++k2) {
                    for (int i3 = -25; i3 < 25; ++i3) {
                        boolean flag1 = false;
                        block9: for (int l3 = -1; l3 <= 1; ++l3) {
                            for (int j4 = -1; j4 <= 1; ++j4) {
                                if (isOnScreen[k1][i2][k2 + l3 + 25 + 1][i3 + j4 + 25 + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (isOnScreen[k1][(i2 + 1) % 31][k2 + l3 + 25 + 1][i3 + j4 + 25 + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (isOnScreen[k1 + 1][i2][k2 + l3 + 25 + 1][i3 + j4 + 25 + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (!isOnScreen[k1 + 1][(i2 + 1) % 31][k2 + l3 + 25 + 1][i3 + j4 + 25 + 1]) continue;
                                flag1 = true;
                                break block9;
                            }
                        }
                        WorldController.tile_visibility_maps[k1][i2][k2 + 25][i3 + 25] = flag1;
                    }
                }
            }
        }
    }

    private static boolean isOnScreen(int z, int y, int x) {
        int l = y * xCurveSin + x * xCurveCos >> 16;
        int i1 = y * xCurveCos - x * xCurveSin >> 16;
        int dist = z * yCurveSin + i1 * yCUrveCos >> 16;
        int k1 = z * yCUrveCos - i1 * yCurveSin >> 16;
        if (dist < 50 || dist > 4000) {
            return false;
        }
        int l1 = midX + l * focalLength / dist;
        int i2 = midY + k1 * focalLength / dist;
        return l1 >= left && l1 <= right && i2 >= top && i2 <= bottom;
    }

    public void request2DTrace(int x, int y) {
        isClicked = true;
        clickX = y;
        clickY = x;
        clickedTileX = -1;
        clickedTileY = -1;
    }

    public void render(int xCam, int yCam, int xCurve, int zCam, int plane, int yCurve) {
        Rasterizer.saveDepth = freeCameraRendering ? false : Client.getOption("fog_active") || Client.enableParticles;
        Rasterizer.clearDepthBuffer();
        if (xCam < 0) {
            xCam = 0;
        } else if (xCam >= this.xMapSize * 128) {
            xCam = this.xMapSize * 128 - 1;
        }
        if (yCam < 0) {
            yCam = 0;
        } else if (yCam >= this.yMapSize * 128) {
            yCam = this.yMapSize * 128 - 1;
        }
        ++anInt448;
        yCurveSin = Model.SINE[yCurve];
        yCUrveCos = Model.COSINE[yCurve];
        xCurveSin = Model.SINE[xCurve];
        xCurveCos = Model.COSINE[xCurve];
        int visMapY = (yCurve - 128) / 32;
        int visMapX = xCurve / 64;
        if (visMapY < 0) {
            visMapY = 0;
        }
        if (visMapY > 7) {
            visMapY = 7;
        }
        if (visMapX < 0) {
            visMapX = 0;
        }
        if (visMapX > 31) {
            visMapX = 31;
        }
        tile_visibility_map = tile_visibility_maps[visMapY][visMapX];
        xCamPos = xCam;
        zCamPos = zCam;
        yCamPos = yCam;
        xCamPosTile = xCam / 128;
        yCamPosTile = yCam / 128;
        plane__ = plane;
        int rd = 25;
        anInt449 = xCamPosTile - rd;
        if (anInt449 < 0) {
            anInt449 = 0;
        }
        if ((anInt451 = yCamPosTile - rd) < 0) {
            anInt451 = 0;
        }
        if ((anInt450 = xCamPosTile + rd) > this.xMapSize) {
            anInt450 = this.xMapSize;
        }
        if ((anInt452 = yCamPosTile + rd) > this.yMapSize) {
            anInt452 = this.yMapSize;
        }
        this.processCulling();
        anInt446 = 0;
        for (int k1 = this.currentHL; k1 < this.zMapSize; ++k1) {
            Tile[][] tiles = this.tileArray[k1];
            for (int x_ = anInt449; x_ < anInt450; ++x_) {
                for (int y_ = anInt451; y_ < anInt452; ++y_) {
                    Tile tile = tiles[x_][y_];
                    if (tile == null) continue;
                    if (freeCameraRendering) {
                        tile.aBoolean1322 = true;
                        tile.aBoolean1323 = true;
                        tile.aBoolean1324 = tile.entityCount > 0;
                        ++anInt446;
                        continue;
                    }
                    if (tile.logicHeight > plane || !tile_visibility_map[x_ - xCamPosTile + 25][y_ - yCamPosTile + 25] && this.heightMap[k1][x_][y_] - zCam < 2000) {
                        tile.aBoolean1322 = false;
                        tile.aBoolean1323 = false;
                        tile.anInt1325 = 0;
                        continue;
                    }
                    tile.aBoolean1322 = true;
                    tile.aBoolean1323 = true;
                    tile.aBoolean1324 = tile.entityCount > 0;
                    ++anInt446;
                }
            }
        }
        for (int l1 = this.currentHL; l1 < this.zMapSize; ++l1) {
            Tile[][] aclass30_sub3_1 = this.tileArray[l1];
            for (int l2 = -25; l2 <= 0; ++l2) {
                int i3 = xCamPosTile + l2;
                int k3 = xCamPosTile - l2;
                if (i3 < anInt449 && k3 >= anInt450) continue;
                for (int i4 = -25; i4 <= 0; ++i4) {
                    int k4 = yCamPosTile + i4;
                    int i5 = yCamPosTile - i4;
                    if (i3 >= anInt449) {
                        Tile class30_sub3_2;
                        Tile class30_sub3_1;
                        if (k4 >= anInt451 && (class30_sub3_1 = aclass30_sub3_1[i3][k4]) != null && class30_sub3_1.aBoolean1322) {
                            this.renderTile(class30_sub3_1, true);
                        }
                        if (i5 < anInt452 && (class30_sub3_2 = aclass30_sub3_1[i3][i5]) != null && class30_sub3_2.aBoolean1322) {
                            this.renderTile(class30_sub3_2, true);
                        }
                    }
                    if (k3 < anInt450) {
                        Tile class30_sub3_4;
                        Tile class30_sub3_3;
                        if (k4 >= anInt451 && (class30_sub3_3 = aclass30_sub3_1[k3][k4]) != null && class30_sub3_3.aBoolean1322) {
                            this.renderTile(class30_sub3_3, true);
                        }
                        if (i5 < anInt452 && (class30_sub3_4 = aclass30_sub3_1[k3][i5]) != null && class30_sub3_4.aBoolean1322) {
                            this.renderTile(class30_sub3_4, true);
                        }
                    }
                    if (anInt446 != 0) continue;
                    isClicked = false;
                    Rasterizer.drawFog(Configuration.FOG_BEGIN_DEPTH, Configuration.FOG_END_DEPTH, 0x66CCFF);
                    Rasterizer.saveDepth = false;
                    focalLength = 512;
                    return;
                }
            }
        }
        for (int j2 = this.currentHL; j2 < this.zMapSize; ++j2) {
            Tile[][] aclass30_sub3_2 = this.tileArray[j2];
            for (int j3 = -25; j3 <= 0; ++j3) {
                int l3 = xCamPosTile + j3;
                int j4 = xCamPosTile - j3;
                if (l3 < anInt449 && j4 >= anInt450) continue;
                for (int l4 = -25; l4 <= 0; ++l4) {
                    int j5 = yCamPosTile + l4;
                    int k5 = yCamPosTile - l4;
                    if (l3 >= anInt449) {
                        Tile class30_sub3_6;
                        Tile class30_sub3_5;
                        if (j5 >= anInt451 && (class30_sub3_5 = aclass30_sub3_2[l3][j5]) != null && class30_sub3_5.aBoolean1322) {
                            this.renderTile(class30_sub3_5, false);
                        }
                        if (k5 < anInt452 && (class30_sub3_6 = aclass30_sub3_2[l3][k5]) != null && class30_sub3_6.aBoolean1322) {
                            this.renderTile(class30_sub3_6, false);
                        }
                    }
                    if (j4 < anInt450) {
                        Tile tile;
                        Tile class30_sub3_7;
                        if (j5 >= anInt451 && (class30_sub3_7 = aclass30_sub3_2[j4][j5]) != null && class30_sub3_7.aBoolean1322) {
                            this.renderTile(class30_sub3_7, false);
                        }
                        if (k5 < anInt452 && (tile = aclass30_sub3_2[j4][k5]) != null && tile.aBoolean1322) {
                            this.renderTile(tile, false);
                        }
                    }
                    if (anInt446 != 0) continue;
                    isClicked = false;
                    Rasterizer.drawFog(Configuration.FOG_BEGIN_DEPTH, Configuration.FOG_END_DEPTH, 13156520);
                    Rasterizer.saveDepth = false;
                    focalLength = 512;
                    return;
                }
            }
        }
        isClicked = false;
        Rasterizer.drawFog(Configuration.FOG_BEGIN_DEPTH, Configuration.FOG_END_DEPTH, 13156520);
        Rasterizer.saveDepth = false;
        focalLength = 512;
    }

    private void renderTile(Tile mainTile, boolean flag) {
        tileDeque.insertBack(mainTile);
        Tile tempTile;
        while ((tempTile = (Tile)tileDeque.popFront()) != null) {
            Tile class30_sub3_16;
            Tile class30_sub3_15;
            Tile class30_sub3_14;
            Tile class30_sub3_13;
            Tile class30_sub3_12;
            Tile class30_sub3_11;
            Tile class30_sub3_10;
            Tile class30_sub3_9;
            Tile class30_sub3_8;
            if (!tempTile.aBoolean1323) continue;
            int i = tempTile.tileX;
            int j = tempTile.tileY;
            int k = tempTile.tileZ;
            int l = tempTile.plane;
            Tile[][] tiles = this.tileArray[k];
            if (tempTile.aBoolean1322) {
                int k4;
                if (flag) {
                    Tile class30_sub3_6;
                    Tile class30_sub3_5;
                    Tile tile;
                    if (k > 0 && (tile = this.tileArray[k - 1][i][j]) != null && tile.aBoolean1323 || i <= xCamPosTile && i > anInt449 && (tile = tiles[i - 1][j]) != null && tile.aBoolean1323 && (tile.aBoolean1322 || (tempTile.anInt1320 & 1) == 0) || i >= xCamPosTile && i < anInt450 - 1 && (tile = tiles[i + 1][j]) != null && tile.aBoolean1323 && (tile.aBoolean1322 || (tempTile.anInt1320 & 4) == 0) || j <= yCamPosTile && j > anInt451 && (class30_sub3_5 = tiles[i][j - 1]) != null && class30_sub3_5.aBoolean1323 && (class30_sub3_5.aBoolean1322 || (tempTile.anInt1320 & 8) == 0) || j >= yCamPosTile && j < anInt452 - 1 && (class30_sub3_6 = tiles[i][j + 1]) != null && class30_sub3_6.aBoolean1323 && (class30_sub3_6.aBoolean1322 || (tempTile.anInt1320 & 2) == 0)) {
                        continue;
                    }
                } else {
                    flag = true;
                }
                tempTile.aBoolean1322 = false;
                if (tempTile.tileBelowThisTile != null) {
                    WallObject wallObject;
                    Tile lowerTile = tempTile.tileBelowThisTile;
                    if (lowerTile.plainTile != null) {
                        if (!this.method320(0, i, j)) {
                            this.drawPlainTile(lowerTile.plainTile, 0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i, j);
                        }
                    } else if (lowerTile.shapedTile != null && !this.method320(0, i, j)) {
                        this.drawShapedTile(i, yCurveSin, xCurveSin, lowerTile.shapedTile, yCUrveCos, j, xCurveCos);
                    }
                    if ((wallObject = lowerTile.wallObject) != null) {
                        wallObject.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, wallObject.xPos - xCamPos, wallObject.zPos - zCamPos, wallObject.yPos - yCamPos, wallObject.uid, wallObject.wallObjUID);
                    }
                    for (int i2 = 0; i2 < lowerTile.entityCount; ++i2) {
                        InteractableObject iObject = lowerTile.interactableObjects[i2];
                        if (iObject == null) continue;
                        iObject.node.renderAtPoint(iObject.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, iObject.worldX - xCamPos, iObject.worldZ - zCamPos, iObject.worldY - yCamPos, iObject.uid, iObject.interactiveObjUID);
                    }
                }
                boolean flag1 = false;
                if (tempTile.plainTile != null) {
                    if (!this.method320(l, i, j)) {
                        flag1 = true;
                        this.drawPlainTile(tempTile.plainTile, l, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i, j);
                    }
                } else if (tempTile.shapedTile != null && !this.method320(l, i, j)) {
                    flag1 = true;
                    this.drawShapedTile(i, yCurveSin, xCurveSin, tempTile.shapedTile, yCUrveCos, j, xCurveCos);
                }
                int j1 = 0;
                int j2 = 0;
                WallObject class10_3 = tempTile.wallObject;
                WallDecoration class26_1 = tempTile.wallDecoration;
                if (class10_3 != null || class26_1 != null) {
                    if (xCamPosTile == i) {
                        ++j1;
                    } else if (xCamPosTile < i) {
                        j1 += 2;
                    }
                    if (yCamPosTile == j) {
                        j1 += 3;
                    } else if (yCamPosTile > j) {
                        j1 += 6;
                    }
                    j2 = anIntArray478[j1];
                    tempTile.anInt1328 = anIntArray480[j1];
                }
                if (class10_3 != null) {
                    if ((class10_3.orientation & anIntArray479[j1]) != 0) {
                        if (class10_3.orientation == 16) {
                            tempTile.anInt1325 = 3;
                            tempTile.anInt1326 = anIntArray481[j1];
                            tempTile.anInt1327 = 3 - tempTile.anInt1326;
                        } else if (class10_3.orientation == 32) {
                            tempTile.anInt1325 = 6;
                            tempTile.anInt1326 = anIntArray482[j1];
                            tempTile.anInt1327 = 6 - tempTile.anInt1326;
                        } else if (class10_3.orientation == 64) {
                            tempTile.anInt1325 = 12;
                            tempTile.anInt1326 = anIntArray483[j1];
                            tempTile.anInt1327 = 12 - tempTile.anInt1326;
                        } else {
                            tempTile.anInt1325 = 9;
                            tempTile.anInt1326 = anIntArray484[j1];
                            tempTile.anInt1327 = 9 - tempTile.anInt1326;
                        }
                    } else {
                        tempTile.anInt1325 = 0;
                    }
                    if ((class10_3.orientation & j2) != 0 && !this.method321(l, i, j, class10_3.orientation)) {
                        class10_3.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_3.xPos - xCamPos, class10_3.zPos - zCamPos, class10_3.yPos - yCamPos, class10_3.uid, class10_3.wallObjUID);
                    }
                    if ((class10_3.orientation1 & j2) != 0 && !this.method321(l, i, j, class10_3.orientation1)) {
                        class10_3.node2.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_3.xPos - xCamPos, class10_3.zPos - zCamPos, class10_3.yPos - yCamPos, class10_3.uid, class10_3.wallObjUID);
                    }
                }
                if (class26_1 != null && !this.method322(l, i, j, class26_1.node.modelHeight)) {
                    if ((class26_1.configurationBits & j2) != 0) {
                        class26_1.node.renderAtPoint(class26_1.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class26_1.xPos - xCamPos, class26_1.zPos - zCamPos, class26_1.yPos - yCamPos, class26_1.uid, class26_1.wallDecorUID);
                    } else if ((class26_1.configurationBits & 0x300) != 0) {
                        int j4 = class26_1.xPos - xCamPos;
                        int l5 = class26_1.zPos - zCamPos;
                        int k6 = class26_1.yPos - yCamPos;
                        int i8 = class26_1.rotation;
                        int k9 = i8 == 1 || i8 == 2 ? -j4 : j4;
                        int k10 = i8 == 2 || i8 == 3 ? -k6 : k6;
                        if ((class26_1.configurationBits & 0x100) != 0 && k10 < k9) {
                            int i11 = j4 + faceXoffset2[i8];
                            int k11 = k6 + faceYOffset2[i8];
                            class26_1.node.renderAtPoint(i8 * 512 + 256, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i11, l5, k11, class26_1.uid, class26_1.wallDecorUID);
                        }
                        if ((class26_1.configurationBits & 0x200) != 0 && k10 > k9) {
                            int j11 = j4 + faceXOffset3[i8];
                            int l11 = k6 + faceYOffset3[i8];
                            class26_1.node.renderAtPoint(i8 * 512 + 1280 & 0x7FF, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, j11, l5, l11, class26_1.uid, class26_1.wallDecorUID);
                        }
                    }
                }
                if (flag1) {
                    GroundItem object4_1;
                    GroundDecoration class49 = tempTile.groundDecoration;
                    if (class49 != null) {
                        class49.node.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class49.xPos - xCamPos, class49.zPos - zCamPos, class49.yPos - yCamPos, class49.uid, class49.groundDecorUID);
                    }
                    if ((object4_1 = tempTile.groundItem) != null && object4_1.topItem == 0) {
                        if (object4_1.secondGroundItem != null) {
                            object4_1.secondGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4_1.xPos - xCamPos, object4_1.zPos - zCamPos, object4_1.yPos - yCamPos, object4_1.uid, object4_1.newuid);
                        }
                        if (object4_1.thirdGroundItem != null) {
                            object4_1.thirdGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4_1.xPos - xCamPos, object4_1.zPos - zCamPos, object4_1.yPos - yCamPos, object4_1.uid, object4_1.newuid);
                        }
                        if (object4_1.firstGroundItem != null) {
                            object4_1.firstGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4_1.xPos - xCamPos, object4_1.zPos - zCamPos, object4_1.yPos - yCamPos, object4_1.uid, object4_1.newuid);
                        }
                    }
                }
                if ((k4 = tempTile.anInt1320) != 0) {
                    Tile class30_sub3_20;
                    Tile class30_sub3_19;
                    Tile class30_sub3_18;
                    Tile class30_sub3_17;
                    if (i < xCamPosTile && (k4 & 4) != 0 && (class30_sub3_17 = tiles[i + 1][j]) != null && class30_sub3_17.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_17);
                    }
                    if (j < yCamPosTile && (k4 & 2) != 0 && (class30_sub3_18 = tiles[i][j + 1]) != null && class30_sub3_18.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_18);
                    }
                    if (i > xCamPosTile && (k4 & 1) != 0 && (class30_sub3_19 = tiles[i - 1][j]) != null && class30_sub3_19.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_19);
                    }
                    if (j > yCamPosTile && (k4 & 8) != 0 && (class30_sub3_20 = tiles[i][j - 1]) != null && class30_sub3_20.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_20);
                    }
                }
            }
            if (tempTile.anInt1325 != 0) {
                boolean flag2 = true;
                for (int k1 = 0; k1 < tempTile.entityCount; ++k1) {
                    if (tempTile.interactableObjects[k1].height == anInt448 || (tempTile.anIntArray1319[k1] & tempTile.anInt1325) != tempTile.anInt1326) continue;
                    flag2 = false;
                    break;
                }
                if (flag2) {
                    WallObject class10_1 = tempTile.wallObject;
                    if (!this.method321(l, i, j, class10_1.orientation)) {
                        class10_1.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_1.xPos - xCamPos, class10_1.zPos - zCamPos, class10_1.yPos - yCamPos, class10_1.uid, class10_1.wallObjUID);
                    }
                    tempTile.anInt1325 = 0;
                }
            }
            if (tempTile.aBoolean1324) {
                try {
                    int i1 = tempTile.entityCount;
                    tempTile.aBoolean1324 = false;
                    int l1 = 0;
                    block5: for (int k2 = 0; k2 < i1; ++k2) {
                        int i7;
                        int j8;
                        InteractableObject class28_1 = tempTile.interactableObjects[k2];
                        if (class28_1.height == anInt448) continue;
                        for (int k3 = class28_1.tileLeft; k3 <= class28_1.tileRight; ++k3) {
                            for (int l4 = class28_1.tileTop; l4 <= class28_1.tileBottom; ++l4) {
                                Tile class30_sub3_21;
                                if (k3 < 0 || k3 >= tiles.length || l4 < 0 || l4 >= tiles[k3].length || (class30_sub3_21 = tiles[k3][l4]) == null) continue;
                                if (class30_sub3_21.aBoolean1322) {
                                    tempTile.aBoolean1324 = true;
                                    continue block5;
                                }
                                if (class30_sub3_21.anInt1325 == 0) continue;
                                int l6 = 0;
                                if (k3 > class28_1.tileLeft) {
                                    ++l6;
                                }
                                if (k3 < class28_1.tileRight) {
                                    l6 += 4;
                                }
                                if (l4 > class28_1.tileTop) {
                                    l6 += 8;
                                }
                                if (l4 < class28_1.tileBottom) {
                                    l6 += 2;
                                }
                                if ((l6 & class30_sub3_21.anInt1325) != tempTile.anInt1327) continue;
                                tempTile.aBoolean1324 = true;
                                continue block5;
                            }
                        }
                        WorldController.aClass28Array462[l1++] = class28_1;
                        int i6 = class28_1.tileRight - xCamPosTile;
                        int i5 = xCamPosTile - class28_1.tileLeft;
                        if (i6 > i5) {
                            i5 = i6;
                        }
                        class28_1.anInt527 = (j8 = class28_1.tileBottom - yCamPosTile) > (i7 = yCamPosTile - class28_1.tileTop) ? i5 + j8 : i5 + i7;
                    }
                    while (l1 > 0) {
                        int i3 = -50;
                        int l3 = -1;
                        for (int j5 = 0; j5 < l1; ++j5) {
                            int l10;
                            int l9;
                            int k8;
                            int j7;
                            InteractableObject class28_2 = aClass28Array462[j5];
                            if (class28_2.height == anInt448) continue;
                            if (class28_2.anInt527 > i3) {
                                i3 = class28_2.anInt527;
                                l3 = j5;
                                continue;
                            }
                            if (class28_2.anInt527 != i3 || (j7 = class28_2.worldX - xCamPos) * j7 + (k8 = class28_2.worldY - yCamPos) * k8 <= (l9 = WorldController.aClass28Array462[l3].worldX - xCamPos) * l9 + (l10 = WorldController.aClass28Array462[l3].worldY - yCamPos) * l10) continue;
                            l3 = j5;
                        }
                        if (l3 == -1) break;
                        InteractableObject class28_3 = aClass28Array462[l3];
                        class28_3.height = anInt448;
                        if (!this.method323(l, class28_3.tileLeft, class28_3.tileRight, class28_3.tileTop, class28_3.tileBottom, class28_3.node.modelHeight)) {
                            class28_3.node.renderAtPoint(class28_3.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class28_3.worldX - xCamPos, class28_3.worldZ - zCamPos, class28_3.worldY - yCamPos, class28_3.uid, class28_3.interactiveObjUID);
                        }
                        for (int k7 = class28_3.tileLeft; k7 <= class28_3.tileRight; ++k7) {
                            for (int l8 = class28_3.tileTop; l8 <= class28_3.tileBottom; ++l8) {
                                Tile class30_sub3_22 = tiles[k7][l8];
                                if (class30_sub3_22.anInt1325 != 0) {
                                    tileDeque.insertBack(class30_sub3_22);
                                    continue;
                                }
                                if (k7 == i && l8 == j || !class30_sub3_22.aBoolean1323) continue;
                                tileDeque.insertBack(class30_sub3_22);
                            }
                        }
                    }
                    if (tempTile.aBoolean1324) {
                        continue;
                    }
                }
                catch (Exception _ex) {
                    _ex.printStackTrace();
                    tempTile.aBoolean1324 = false;
                }
            }
            if (!tempTile.aBoolean1323 || tempTile.anInt1325 != 0 || i <= xCamPosTile && i > anInt449 && (class30_sub3_8 = tiles[i - 1][j]) != null && class30_sub3_8.aBoolean1323 || i >= xCamPosTile && i < anInt450 - 1 && (class30_sub3_9 = tiles[i + 1][j]) != null && class30_sub3_9.aBoolean1323 || j <= yCamPosTile && j > anInt451 && (class30_sub3_10 = tiles[i][j - 1]) != null && class30_sub3_10.aBoolean1323 || j >= yCamPosTile && j < anInt452 - 1 && (class30_sub3_11 = tiles[i][j + 1]) != null && class30_sub3_11.aBoolean1323) continue;
            tempTile.aBoolean1323 = false;
            --anInt446;
            GroundItem object4 = tempTile.groundItem;
            if (object4 != null && object4.topItem != 0) {
                if (object4.secondGroundItem != null) {
                    object4.secondGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4.xPos - xCamPos, object4.zPos - zCamPos - object4.topItem, object4.yPos - yCamPos, object4.uid, object4.newuid);
                }
                if (object4.thirdGroundItem != null) {
                    object4.thirdGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4.xPos - xCamPos, object4.zPos - zCamPos - object4.topItem, object4.yPos - yCamPos, object4.uid, object4.newuid);
                }
                if (object4.firstGroundItem != null) {
                    object4.firstGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4.xPos - xCamPos, object4.zPos - zCamPos - object4.topItem, object4.yPos - yCamPos, object4.uid, object4.newuid);
                }
            }
            if (tempTile.anInt1328 != 0) {
                WallObject class10_2;
                WallDecoration class26 = tempTile.wallDecoration;
                if (class26 != null && !this.method322(l, i, j, class26.node.modelHeight)) {
                    if ((class26.configurationBits & tempTile.anInt1328) != 0) {
                        class26.node.renderAtPoint(class26.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class26.xPos - xCamPos, class26.zPos - zCamPos, class26.yPos - yCamPos, class26.uid, class26.wallDecorUID);
                    } else if ((class26.configurationBits & 0x300) != 0) {
                        int l2 = class26.xPos - xCamPos;
                        int j3 = class26.zPos - zCamPos;
                        int i4 = class26.yPos - yCamPos;
                        int k5 = class26.rotation;
                        int j6 = k5 == 1 || k5 == 2 ? -l2 : l2;
                        int l7 = k5 == 2 || k5 == 3 ? -i4 : i4;
                        if ((class26.configurationBits & 0x100) != 0 && l7 >= j6) {
                            int i9 = l2 + faceXoffset2[k5];
                            int i10 = i4 + faceYOffset2[k5];
                            class26.node.renderAtPoint(k5 * 512 + 256, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i9, j3, i10, class26.uid, class26.wallDecorUID);
                        }
                        if ((class26.configurationBits & 0x200) != 0 && l7 <= j6) {
                            int j9 = l2 + faceXOffset3[k5];
                            int j10 = i4 + faceYOffset3[k5];
                            class26.node.renderAtPoint(k5 * 512 + 1280 & 0x7FF, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, j9, j3, j10, class26.uid, class26.wallDecorUID);
                        }
                    }
                }
                if ((class10_2 = tempTile.wallObject) != null) {
                    if ((class10_2.orientation1 & tempTile.anInt1328) != 0 && !this.method321(l, i, j, class10_2.orientation1)) {
                        class10_2.node2.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_2.xPos - xCamPos, class10_2.zPos - zCamPos, class10_2.yPos - yCamPos, class10_2.uid, class10_2.wallObjUID);
                    }
                    if ((class10_2.orientation & tempTile.anInt1328) != 0 && !this.method321(l, i, j, class10_2.orientation)) {
                        class10_2.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_2.xPos - xCamPos, class10_2.zPos - zCamPos, class10_2.yPos - yCamPos, class10_2.uid, class10_2.wallObjUID);
                    }
                }
            }
            if (k < this.zMapSize - 1 && (class30_sub3_12 = this.tileArray[k + 1][i][j]) != null && class30_sub3_12.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_12);
            }
            if (i < xCamPosTile && (class30_sub3_13 = tiles[i + 1][j]) != null && class30_sub3_13.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_13);
            }
            if (j < yCamPosTile && (class30_sub3_14 = tiles[i][j + 1]) != null && class30_sub3_14.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_14);
            }
            if (i > xCamPosTile && (class30_sub3_15 = tiles[i - 1][j]) != null && class30_sub3_15.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_15);
            }
            if (j <= yCamPosTile || (class30_sub3_16 = tiles[i][j - 1]) == null || !class30_sub3_16.aBoolean1323) continue;
            tileDeque.insertBack(class30_sub3_16);
        }
        return;
    }

    private void drawPlainTile(PlainTile pTile, int tZ, int j, int k, int xSin, int xCos, int tX, int tY) {
        int yC;
        int xD;
        int yB;
        int xC;
        int xA = xC = (tX << 7) - xCamPos;
        int yA = yB = (tY << 7) - yCamPos;
        int xB = xD = xA + 128;
        int yD = yC = yA + 128;
        int zA = this.heightMap[tZ][tX][tY] - zCamPos;
        int zB = this.heightMap[tZ][tX + 1][tY] - zCamPos;
        int zD = this.heightMap[tZ][tX + 1][tY + 1] - zCamPos;
        int zC = this.heightMap[tZ][tX][tY + 1] - zCamPos;
        int angle = yA * xSin + xA * xCos >> 16;
        yA = yA * xCos - xA * xSin >> 16;
        xA = angle;
        angle = zA * k - yA * j >> 16;
        yA = zA * j + yA * k >> 16;
        zA = angle;
        if (yA < 50) {
            return;
        }
        angle = yB * xSin + xB * xCos >> 16;
        yB = yB * xCos - xB * xSin >> 16;
        xB = angle;
        angle = zB * k - yB * j >> 16;
        yB = zB * j + yB * k >> 16;
        zB = angle;
        if (yB < 50) {
            return;
        }
        angle = yD * xSin + xD * xCos >> 16;
        yD = yD * xCos - xD * xSin >> 16;
        xD = angle;
        angle = zD * k - yD * j >> 16;
        yD = zD * j + yD * k >> 16;
        zD = angle;
        if (yD < 50) {
            return;
        }
        angle = yC * xSin + xC * xCos >> 16;
        yC = yC * xCos - xC * xSin >> 16;
        xC = angle;
        angle = zC * k - yC * j >> 16;
        yC = zC * j + yC * k >> 16;
        zC = angle;
        if (yC < 50) {
            return;
        }
        int screenXA = Rasterizer.center_x + xA * focalLength / yA;
        int screenYA = Rasterizer.center_y + zA * focalLength / yA;
        int screenXB = Rasterizer.center_x + xB * focalLength / yB;
        int screenYB = Rasterizer.center_y + zB * focalLength / yB;
        int screenXD = Rasterizer.center_x + xD * focalLength / yD;
        int screenYD = Rasterizer.center_y + zD * focalLength / yD;
        int screenXC = Rasterizer.center_x + xC * focalLength / yC;
        int screenYC = Rasterizer.center_y + zC * focalLength / yC;
        Rasterizer.alpha = 0;
        if ((screenXD - screenXC) * (screenYB - screenYC) - (screenYD - screenYC) * (screenXB - screenXC) > 0) {
            boolean bl = Rasterizer.restrict_edges = screenXD < 0 || screenXC < 0 || screenXB < 0 || screenXD > DrawingArea.viewportRX || screenXC > DrawingArea.viewportRX || screenXB > DrawingArea.viewportRX;
            if (isClicked && this.mouseWithinTriangle(clickX, clickY, screenYD, screenYC, screenYB, screenXD, screenXC, screenXB)) {
                clickedTileX = tX;
                clickedTileY = tY;
            }
            if (!Client.getOption("hd_tex")) {
                if (pTile.textureId == -1) {
                    if (pTile.colourD != 12345678) {
                        Rasterizer.drawDepthShadedTriangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, pTile.colourD, pTile.colourC, pTile.colourB);
                    }
                } else if (!lowMem) {
                    if (pTile.isFlat) {
                        Rasterizer.drawDepthTexturedTriangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, pTile.colourD, pTile.colourC, pTile.colourB, xA, xB, xC, zA, zB, zC, yA, yB, yC, pTile.textureId);
                    } else {
                        Rasterizer.drawDepthTexturedTriangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, pTile.colourD, pTile.colourC, pTile.colourB, xD, xC, xB, zD, zC, zB, yD, yC, yB, pTile.textureId);
                    }
                } else {
                    int i7 = textureRGBColour[pTile.textureId];
                    Rasterizer.drawDepthShadedTriangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, this.mixColour(i7, pTile.colourD), this.mixColour(i7, pTile.colourC), this.mixColour(i7, pTile.colourB));
                }
            } else if (pTile.textureId != -1) {
                if (pTile.isFlat && pTile.colourD != 12345678) {
                    Rasterizer.render_texture_triangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, pTile.colourD, pTile.colourC, pTile.colourB, xA, xB, xC, zA, zB, zC, yA, yB, yC, !lowMem || pTile.rgbColour == -1 ? pTile.textureId : -1, pTile.color, true, this.opaque_floor_texture, true);
                } else if (pTile.colourD != 12345678) {
                    Rasterizer.render_texture_triangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, pTile.colourD, pTile.colourC, pTile.colourB, xD, xC, xB, zD, zC, zB, yD, yC, yB, !lowMem || pTile.rgbColour == -1 ? pTile.textureId : -1, pTile.color, true, this.opaque_floor_texture, true);
                }
            } else if (pTile.colourD != 12345678) {
                Rasterizer.drawDepthShadedTriangle(screenYD, screenYC, screenYB, screenXD, screenXC, screenXB, yD, yC, yB, pTile.colourD, pTile.colourC, pTile.colourB);
            }
        }
        if ((screenXA - screenXB) * (screenYC - screenYB) - (screenYA - screenYB) * (screenXC - screenXB) > 0) {
            boolean bl = Rasterizer.restrict_edges = screenXA < 0 || screenXB < 0 || screenXC < 0 || screenXA > DrawingArea.viewportRX || screenXB > DrawingArea.viewportRX || screenXC > DrawingArea.viewportRX;
            if (isClicked && this.mouseWithinTriangle(clickX, clickY, screenYA, screenYB, screenYC, screenXA, screenXB, screenXC)) {
                clickedTileX = tX;
                clickedTileY = tY;
            }
            if (pTile.textureId == -1) {
                if (pTile.colourA != 12345678) {
                    Rasterizer.drawDepthShadedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, yA, yB, yC, pTile.colourA, pTile.colourB, pTile.colourC);
                }
            } else {
                if (!lowMem) {
                    if (Client.getOption("hd_tex") && pTile.colourA != 12345678) {
                        Rasterizer.render_texture_triangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, yA, yB, yC, pTile.colourA, pTile.colourB, pTile.colourC, xA, xB, xC, zA, zB, zC, yA, yB, yC, !lowMem || pTile.color == -1 ? pTile.textureId : -1, pTile.color, true, this.opaque_floor_texture, true);
                    } else if (pTile.colourA != 12345678) {
                        Rasterizer.drawDepthTexturedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, yA, yB, yC, pTile.colourA, pTile.colourB, pTile.colourC, xA, xB, xC, zA, zB, zC, yA, yB, yC, pTile.textureId);
                    }
                    return;
                }
                if (!Client.getOption("hd_tex")) {
                    int j7 = textureRGBColour[pTile.textureId];
                    Rasterizer.drawDepthShadedTriangle(screenYA, screenYB, screenYC, screenXA, screenXB, screenXC, yA, yB, yC, this.mixColour(j7, pTile.colourA), this.mixColour(j7, pTile.colourB), this.mixColour(j7, pTile.colourC));
                }
            }
        }
    }

    private void drawShapedTile(int i, int j, int k, ShapedTile sTile, int l, int i1, int j1) {
        int k1 = sTile.origVertexX.length;
        for (int l1 = 0; l1 < k1; ++l1) {
            int viewSpaceX = sTile.origVertexX[l1] - xCamPos;
            int viewSpaceY = sTile.origVertexY[l1] - zCamPos;
            int viewSpaceZ = sTile.origVertexZ[l1] - yCamPos;
            int viewSpaceDepth = viewSpaceZ * k + viewSpaceX * j1 >> 16;
            viewSpaceZ = viewSpaceZ * j1 - viewSpaceX * k >> 16;
            viewSpaceX = viewSpaceDepth;
            viewSpaceDepth = viewSpaceY * l - viewSpaceZ * j >> 16;
            viewSpaceZ = viewSpaceY * j + viewSpaceZ * l >> 16;
            viewSpaceY = viewSpaceDepth;
            if (viewSpaceZ < 50) {
                return;
            }
            if (sTile.triangleTexture != null) {
                ShapedTile.viewSpaceX[l1] = viewSpaceX;
                ShapedTile.viewSpaceY[l1] = viewSpaceY;
                ShapedTile.viewSpaceZ[l1] = viewSpaceZ;
            }
            ShapedTile.screenX[l1] = Rasterizer.center_x + viewSpaceX * focalLength / viewSpaceZ;
            ShapedTile.screenY[l1] = Rasterizer.center_y + viewSpaceY * focalLength / viewSpaceZ;
            ShapedTile.screenZ[l1] = viewSpaceZ;
        }
        Rasterizer.alpha = 0;
        k1 = sTile.triangleA.length;
        for (int j2 = 0; j2 < k1; ++j2) {
            int indexA = sTile.triangleA[j2];
            int indexB = sTile.triangleB[j2];
            int indexC = sTile.triangleC[j2];
            int sXA = ShapedTile.screenX[indexA];
            int sXB = ShapedTile.screenX[indexB];
            int sXC = ShapedTile.screenX[indexC];
            int sYA = ShapedTile.screenY[indexA];
            int sYB = ShapedTile.screenY[indexB];
            int sYC = ShapedTile.screenY[indexC];
            int sZA = ShapedTile.screenZ[indexA];
            int sZB = ShapedTile.screenZ[indexB];
            int sZC = ShapedTile.screenZ[indexC];
            if ((sXA - sXB) * (sYC - sYB) - (sYA - sYB) * (sXC - sXB) <= 0) continue;
            boolean bl = Rasterizer.restrict_edges = sXA < 0 || sXB < 0 || sXC < 0 || sXA > DrawingArea.viewportRX || sXB > DrawingArea.viewportRX || sXC > DrawingArea.viewportRX;
            if (isClicked && this.mouseWithinTriangle(clickX, clickY, sYA, sYB, sYC, sXA, sXB, sXC)) {
                clickedTileX = i;
                clickedTileY = i1;
            }
            if (Client.getOption("hd_tex")) {
                if (sTile.triangleTexture == null || sTile.triangleTexture[j2] == -1) {
                    if (sTile.triangleHslA[j2] == 12345678) continue;
                    Rasterizer.drawDepthShadedTriangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, sTile.triangleHslA[j2], sTile.triangleHslB[j2], sTile.triangleHslC[j2]);
                    continue;
                }
                if (sTile.flat && sTile.triangleHslA[j2] != 12345678) {
                    Rasterizer.render_texture_triangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, sTile.triangleHslA[j2], sTile.triangleHslB[j2], sTile.triangleHslC[j2], ShapedTile.viewSpaceX[0], ShapedTile.viewSpaceX[1], ShapedTile.viewSpaceX[3], ShapedTile.viewSpaceY[0], ShapedTile.viewSpaceY[1], ShapedTile.viewSpaceY[3], ShapedTile.viewSpaceZ[0], ShapedTile.viewSpaceZ[1], ShapedTile.viewSpaceZ[3], !lowMem || sTile.displayColor[j2] == -1 ? sTile.triangleTexture[j2] : -1, sTile.displayColor[j2], true, this.opaque_floor_texture, true);
                    continue;
                }
                if (sTile.triangleHslA[j2] == 12345678) continue;
                Rasterizer.render_texture_triangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, sTile.triangleHslA[j2], sTile.triangleHslB[j2], sTile.triangleHslC[j2], ShapedTile.viewSpaceX[indexA], ShapedTile.viewSpaceX[indexB], ShapedTile.viewSpaceX[indexC], ShapedTile.viewSpaceY[indexA], ShapedTile.viewSpaceY[indexB], ShapedTile.viewSpaceY[indexC], ShapedTile.viewSpaceZ[indexA], ShapedTile.viewSpaceZ[indexB], ShapedTile.viewSpaceZ[indexC], !lowMem || sTile.displayColor[j2] == -1 ? sTile.triangleTexture[j2] : -1, sTile.displayColor[j2], true, this.opaque_floor_texture, true);
                continue;
            }
            if (sTile.triangleTexture == null || sTile.triangleTexture[j2] == -1) {
                if (sTile.triangleHslA[j2] == 12345678) continue;
                Rasterizer.drawDepthShadedTriangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, sTile.triangleHslA[j2], sTile.triangleHslB[j2], sTile.triangleHslC[j2]);
                continue;
            }
            if (!lowMem) {
                if (sTile.flat) {
                    Rasterizer.drawDepthTexturedTriangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, sTile.triangleHslA[j2], sTile.triangleHslB[j2], sTile.triangleHslC[j2], ShapedTile.viewSpaceX[0], ShapedTile.viewSpaceX[1], ShapedTile.viewSpaceX[3], ShapedTile.viewSpaceY[0], ShapedTile.viewSpaceY[1], ShapedTile.viewSpaceY[3], ShapedTile.viewSpaceZ[0], ShapedTile.viewSpaceZ[1], ShapedTile.viewSpaceZ[3], sTile.triangleTexture[j2]);
                    continue;
                }
                Rasterizer.drawDepthTexturedTriangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, sTile.triangleHslA[j2], sTile.triangleHslB[j2], sTile.triangleHslC[j2], ShapedTile.viewSpaceX[indexA], ShapedTile.viewSpaceX[indexB], ShapedTile.viewSpaceX[indexC], ShapedTile.viewSpaceY[indexA], ShapedTile.viewSpaceY[indexB], ShapedTile.viewSpaceY[indexC], ShapedTile.viewSpaceZ[indexA], ShapedTile.viewSpaceZ[indexB], ShapedTile.viewSpaceZ[indexC], sTile.triangleTexture[j2]);
                continue;
            }
            int rgb = textureRGBColour[sTile.triangleTexture[j2]];
            Rasterizer.drawDepthShadedTriangle(sYA, sYB, sYC, sXA, sXB, sXC, sZA, sZB, sZC, this.mixColour(rgb, sTile.triangleHslA[j2]), this.mixColour(rgb, sTile.triangleHslB[j2]), this.mixColour(rgb, sTile.triangleHslC[j2]));
        }
    }

    private int mixColour(int colour1, int colour2) {
        colour2 = 127 - colour2;
        if ((colour2 = colour2 * (colour1 & 0x7F) / 160) < 2) {
            colour2 = 2;
        } else if (colour2 > 126) {
            colour2 = 126;
        }
        return (colour1 & 0xFF80) + colour2;
    }

    private boolean mouseWithinTriangle(int mouseX, int mouseY, int triangleYA, int triangleYB, int triangleYC, int triangleXA, int triangleXB, int triangleXC) {
        if (mouseY < triangleYA && mouseY < triangleYB && mouseY < triangleYC) {
            return false;
        }
        if (mouseY > triangleYA && mouseY > triangleYB && mouseY > triangleYC) {
            return false;
        }
        if (mouseX < triangleXA && mouseX < triangleXB && mouseX < triangleXC) {
            return false;
        }
        if (mouseX > triangleXA && mouseX > triangleXB && mouseX > triangleXC) {
            return false;
        }
        int i2 = (mouseY - triangleYA) * (triangleXB - triangleXA) - (mouseX - triangleXA) * (triangleYB - triangleYA);
        int j2 = (mouseY - triangleYC) * (triangleXA - triangleXC) - (mouseX - triangleXC) * (triangleYA - triangleYC);
        int k2 = (mouseY - triangleYB) * (triangleXC - triangleXB) - (mouseX - triangleXB) * (triangleYC - triangleYB);
        return i2 * k2 > 0 && k2 * j2 > 0;
    }

    private void processCulling() {
        int count = cullingClusterPointer[plane__];
        CullingCluster[] clusters = cullingClusters[plane__];
        processedClusterPtr = 0;
        for (int k = 0; k < count; ++k) {
            int xDistFromCamEnd;
            int yDistFromCamStartReal;
            int yDistFromCamEnd;
            int yDistFromCamStart;
            CullingCluster cluster = clusters[k];
            if (cluster.searchMask == 1) {
                int xDistFromCamStart = cluster.tileStartX - xCamPosTile + 25;
                if (xDistFromCamStart < 0 || xDistFromCamStart > 50) continue;
                yDistFromCamStart = cluster.tileStartY - yCamPosTile + 25;
                if (yDistFromCamStart < 0) {
                    yDistFromCamStart = 0;
                }
                if ((yDistFromCamEnd = cluster.tileEndY - yCamPosTile + 25) > 50) {
                    yDistFromCamEnd = 50;
                }
                boolean visisble = false;
                while (yDistFromCamStart <= yDistFromCamEnd) {
                    if (!tile_visibility_map[xDistFromCamStart][yDistFromCamStart++]) continue;
                    visisble = true;
                    break;
                }
                if (!visisble) continue;
                int xDistFromCamStartReal = xCamPos - cluster.worldStartX;
                if (xDistFromCamStartReal > 32) {
                    cluster.tileDistanceEnum = 1;
                } else {
                    if (xDistFromCamStartReal >= -32) continue;
                    cluster.tileDistanceEnum = 2;
                    xDistFromCamStartReal = -xDistFromCamStartReal;
                }
                cluster.worldDistanceFromCameraStartY = (cluster.worldStartY - yCamPos << 8) / xDistFromCamStartReal;
                cluster.worldDistanceFromCameraEndY = (cluster.worldEndY - yCamPos << 8) / xDistFromCamStartReal;
                cluster.worldDistanceFromCameraStartZ = (cluster.worldStartZ - zCamPos << 8) / xDistFromCamStartReal;
                cluster.worldDistanceFromCameraEndZ = (cluster.worldEndZ - zCamPos << 8) / xDistFromCamStartReal;
                WorldController.processedClusters[WorldController.processedClusterPtr++] = cluster;
                continue;
            }
            if (cluster.searchMask == 2) {
                int xDistFromCamEnd2;
                int yDIstFromCamStart = cluster.tileStartY - yCamPosTile + 25;
                if (yDIstFromCamStart < 0 || yDIstFromCamStart > 50) continue;
                int xDistFromCamStart = cluster.tileStartX - xCamPosTile + 25;
                if (xDistFromCamStart < 0) {
                    xDistFromCamStart = 0;
                }
                if ((xDistFromCamEnd2 = cluster.tileEndX - xCamPosTile + 25) > 50) {
                    xDistFromCamEnd2 = 50;
                }
                boolean visible = false;
                while (xDistFromCamStart <= xDistFromCamEnd2) {
                    if (!tile_visibility_map[xDistFromCamStart++][yDIstFromCamStart]) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                int yDistFromCamStartReal2 = yCamPos - cluster.worldStartY;
                if (yDistFromCamStartReal2 > 32) {
                    cluster.tileDistanceEnum = 3;
                } else {
                    if (yDistFromCamStartReal2 >= -32) continue;
                    cluster.tileDistanceEnum = 4;
                    yDistFromCamStartReal2 = -yDistFromCamStartReal2;
                }
                cluster.worldDistanceFromCameraStartX = (cluster.worldStartX - xCamPos << 8) / yDistFromCamStartReal2;
                cluster.worldDistanceFromCameraEndX = (cluster.worldEndX - xCamPos << 8) / yDistFromCamStartReal2;
                cluster.worldDistanceFromCameraStartZ = (cluster.worldStartZ - zCamPos << 8) / yDistFromCamStartReal2;
                cluster.worldDistanceFromCameraEndZ = (cluster.worldEndZ - zCamPos << 8) / yDistFromCamStartReal2;
                WorldController.processedClusters[WorldController.processedClusterPtr++] = cluster;
                continue;
            }
            if (cluster.searchMask != 4 || (yDistFromCamStartReal = cluster.worldStartZ - zCamPos) <= 128) continue;
            yDistFromCamStart = cluster.tileStartY - yCamPosTile + 25;
            if (yDistFromCamStart < 0) {
                yDistFromCamStart = 0;
            }
            if ((yDistFromCamEnd = cluster.tileEndY - yCamPosTile + 25) > 50) {
                yDistFromCamEnd = 50;
            }
            if (yDistFromCamStart > yDistFromCamEnd) continue;
            int xDistFromCamStart = cluster.tileStartX - xCamPosTile + 25;
            if (xDistFromCamStart < 0) {
                xDistFromCamStart = 0;
            }
            if ((xDistFromCamEnd = cluster.tileEndX - xCamPosTile + 25) > 50) {
                xDistFromCamEnd = 50;
            }
            boolean visisble = false;
            block3: for (int _x = xDistFromCamStart; _x <= xDistFromCamEnd; ++_x) {
                for (int _y = yDistFromCamStart; _y <= yDistFromCamEnd; ++_y) {
                    if (!tile_visibility_map[_x][_y]) continue;
                    visisble = true;
                    break block3;
                }
            }
            if (!visisble) continue;
            cluster.tileDistanceEnum = 5;
            cluster.worldDistanceFromCameraStartX = (cluster.worldStartX - xCamPos << 8) / yDistFromCamStartReal;
            cluster.worldDistanceFromCameraEndX = (cluster.worldEndX - xCamPos << 8) / yDistFromCamStartReal;
            cluster.worldDistanceFromCameraStartY = (cluster.worldStartY - yCamPos << 8) / yDistFromCamStartReal;
            cluster.worldDistanceFromCameraEndY = (cluster.worldEndY - yCamPos << 8) / yDistFromCamStartReal;
            WorldController.processedClusters[WorldController.processedClusterPtr++] = cluster;
        }
    }

    private boolean method320(int y, int x, int z) {
        int l = this.anIntArrayArrayArray445[y][x][z];
        if (l == -anInt448) {
            return false;
        }
        if (l == anInt448) {
            return true;
        }
        int i1 = x << 7;
        int j1 = z << 7;
        if (this.method324(i1 + 1, this.heightMap[y][x][z], j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[y][x + 1][z], j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[y][x + 1][z + 1], j1 + 128 - 1) && this.method324(i1 + 1, this.heightMap[y][x][z + 1], j1 + 128 - 1)) {
            this.anIntArrayArrayArray445[y][x][z] = anInt448;
            return true;
        }
        this.anIntArrayArrayArray445[y][x][z] = -anInt448;
        return false;
    }

    private boolean method321(int z, int x, int y, int l) {
        if (!this.method320(z, x, y)) {
            return false;
        }
        int i1 = x << 7;
        int j1 = y << 7;
        int k1 = this.heightMap[z][x][y] - 1;
        int l1 = k1 - 120;
        int i2 = k1 - 230;
        int j2 = k1 - 238;
        if (l < 16) {
            if (l == 1) {
                if (i1 > xCamPos) {
                    if (!this.method324(i1, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1) && this.method324(i1, i2, j1 + 128);
            }
            if (l == 2) {
                if (j1 < yCamPos) {
                    if (!this.method324(i1, k1, j1 + 128)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1, l1, j1 + 128)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1 + 128) && this.method324(i1 + 128, i2, j1 + 128);
            }
            if (l == 4) {
                if (i1 < xCamPos) {
                    if (!this.method324(i1 + 128, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1 + 128, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1 + 128, i2, j1) && this.method324(i1 + 128, i2, j1 + 128);
            }
            if (l == 8) {
                if (j1 > yCamPos) {
                    if (!this.method324(i1, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1) && this.method324(i1 + 128, i2, j1);
            }
        }
        if (!this.method324(i1 + 64, j2, j1 + 64)) {
            return false;
        }
        if (l == 16) {
            return this.method324(i1, i2, j1 + 128);
        }
        if (l == 32) {
            return this.method324(i1 + 128, i2, j1 + 128);
        }
        if (l == 64) {
            return this.method324(i1 + 128, i2, j1);
        }
        if (l == 128) {
            return this.method324(i1, i2, j1);
        }
        System.out.println("Warning unsupported wall type");
        return true;
    }

    private boolean method322(int i, int j, int k, int l) {
        if (!this.method320(i, j, k)) {
            return false;
        }
        int i1 = j << 7;
        int j1 = k << 7;
        return this.method324(i1 + 1, this.heightMap[i][j][k] - l, j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[i][j + 1][k] - l, j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[i][j + 1][k + 1] - l, j1 + 128 - 1) && this.method324(i1 + 1, this.heightMap[i][j][k + 1] - l, j1 + 128 - 1);
    }

    private boolean method323(int y, int x, int k, int z, int i1, int j1) {
        if (x == k && z == i1) {
            if (!this.method320(y, x, z)) {
                return false;
            }
            int k1 = x << 7;
            int i2 = z << 7;
            return this.method324(k1 + 1, this.heightMap[y][x][z] - j1, i2 + 1) && this.method324(k1 + 128 - 1, this.heightMap[y][x + 1][z] - j1, i2 + 1) && this.method324(k1 + 128 - 1, this.heightMap[y][x + 1][z + 1] - j1, i2 + 128 - 1) && this.method324(k1 + 1, this.heightMap[y][x][z + 1] - j1, i2 + 128 - 1);
        }
        for (int l1 = x; l1 <= k; ++l1) {
            for (int j2 = z; j2 <= i1; ++j2) {
                if (this.anIntArrayArrayArray445[y][l1][j2] != -anInt448) continue;
                return false;
            }
        }
        int k2 = (x << 7) + 1;
        int i3 = this.heightMap[y][x][z] - j1;
        int l2 = (z << 7) + 2;
        if (!this.method324(k2, i3, l2)) {
            return false;
        }
        int j3 = (k << 7) - 1;
        if (!this.method324(j3, i3, l2)) {
            return false;
        }
        int k3 = (i1 << 7) - 1;
        return this.method324(k2, i3, k3) && this.method324(j3, i3, k3);
    }

    private boolean method324(int x, int y, int z) {
        for (int l = 0; l < processedClusterPtr; ++l) {
            int i2;
            CullingCluster cluster = processedClusters[l];
            if (cluster.tileDistanceEnum == 1) {
                int i1 = cluster.worldStartX - x;
                if (i1 <= 0) continue;
                int j2 = cluster.worldStartY + (cluster.worldDistanceFromCameraStartY * i1 >> 8);
                int k3 = cluster.worldEndY + (cluster.worldDistanceFromCameraEndY * i1 >> 8);
                int l4 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * i1 >> 8);
                int i6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * i1 >> 8);
                if (z < j2 || z > k3 || y < l4 || y > i6) continue;
                return true;
            }
            if (cluster.tileDistanceEnum == 2) {
                int j1 = x - cluster.worldStartX;
                if (j1 <= 0) continue;
                int k2 = cluster.worldStartY + (cluster.worldDistanceFromCameraStartY * j1 >> 8);
                int l3 = cluster.worldEndY + (cluster.worldDistanceFromCameraEndY * j1 >> 8);
                int i5 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * j1 >> 8);
                int j6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * j1 >> 8);
                if (z < k2 || z > l3 || y < i5 || y > j6) continue;
                return true;
            }
            if (cluster.tileDistanceEnum == 3) {
                int k1 = cluster.worldStartY - z;
                if (k1 <= 0) continue;
                int l2 = cluster.worldStartX + (cluster.worldDistanceFromCameraStartX * k1 >> 8);
                int i4 = cluster.worldEndX + (cluster.worldDistanceFromCameraEndX * k1 >> 8);
                int j5 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * k1 >> 8);
                int k6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * k1 >> 8);
                if (x < l2 || x > i4 || y < j5 || y > k6) continue;
                return true;
            }
            if (cluster.tileDistanceEnum == 4) {
                int l1 = z - cluster.worldStartY;
                if (l1 <= 0) continue;
                int i3 = cluster.worldStartX + (cluster.worldDistanceFromCameraStartX * l1 >> 8);
                int j4 = cluster.worldEndX + (cluster.worldDistanceFromCameraEndX * l1 >> 8);
                int k5 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * l1 >> 8);
                int l6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * l1 >> 8);
                if (x < i3 || x > j4 || y < k5 || y > l6) continue;
                return true;
            }
            if (cluster.tileDistanceEnum != 5 || (i2 = y - cluster.worldStartZ) <= 0) continue;
            int j3 = cluster.worldStartX + (cluster.worldDistanceFromCameraStartX * i2 >> 8);
            int k4 = cluster.worldEndX + (cluster.worldDistanceFromCameraEndX * i2 >> 8);
            int l5 = cluster.worldStartY + (cluster.worldDistanceFromCameraStartY * i2 >> 8);
            int i7 = cluster.worldEndY + (cluster.worldDistanceFromCameraEndY * i2 >> 8);
            if (x < j3 || x > k4 || z < l5 || z > i7) continue;
            return true;
        }
        return false;
    }

    static {
        aClass28Array462 = new InteractableObject[100];
        faceXoffset2 = new int[]{53, -53, -53, 53};
        faceYOffset2 = new int[]{-53, -53, 53, 53};
        faceXOffset3 = new int[]{-45, 45, 45, -45};
        faceYOffset3 = new int[]{45, 45, -45, -45};
        clickedTileX = -1;
        clickedTileY = -1;
        processedClusters = new CullingCluster[500];
        tileDeque = new Deque();
        anIntArray478 = new int[]{19, 55, 38, 155, 255, 110, 137, 205, 76};
        anIntArray479 = new int[]{160, 192, 80, 96, 0, 144, 80, 48, 160};
        anIntArray480 = new int[]{76, 8, 137, 4, 0, 1, 38, 2, 19};
        anIntArray481 = new int[]{0, 0, 2, 0, 0, 2, 1, 1, 0};
        anIntArray482 = new int[]{2, 0, 0, 2, 0, 0, 0, 4, 4};
        anIntArray483 = new int[]{0, 4, 4, 8, 0, 0, 8, 0, 0};
        anIntArray484 = new int[]{1, 1, 0, 0, 0, 8, 0, 0, 8};
        textureRGBColour = new int[]{41, 39248, 41, 4643, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 43086, 41, 41, 41, 41, 41, 41, 41, 8602, 41, 28992, 41, 41, 41, 41, 41, 5056, 41, 41, 41, 7079, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 3131, 41, 41, 41};
        tile_visibility_maps = new boolean[8][32][51][51];
        focalLength = 512;
        amountOfCullingClusters = 4;
        cullingClusterPointer = new int[amountOfCullingClusters];
        cullingClusters = new CullingCluster[amountOfCullingClusters][500];
    }
}

