/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.components;

import com.teragard.RSInterface;
import com.teragard.RSInterfaceBuilder;

public class ButtonComponent {
    private final RSInterfaceBuilder mainBuilder;
    private RSInterfaceBuilder hoverBuilder;
    private RSInterfaceBuilder hoverImageBuilder;
    private int hoverId = -1;
    private int hoverImageId = -1;

    private ButtonComponent(int id) {
        this.mainBuilder = RSInterfaceBuilder.create(id).type(5).actionType(1);
    }

    private ButtonComponent(int id, int hoverId, int hoverImageId) {
        this(id);
        this.hoverId = hoverId;
        this.hoverImageId = hoverImageId;
        this.hoverBuilder = RSInterfaceBuilder.create(hoverId).type(5);
        this.hoverImageBuilder = RSInterfaceBuilder.create(hoverImageId).type(5);
    }

    public static ButtonComponent create(int id) {
        return new ButtonComponent(id);
    }

    public static ButtonComponent hover(int id, int hoverId, int hoverImageId) {
        return new ButtonComponent(id, hoverId, hoverImageId);
    }

    public ButtonComponent sprite(int spriteId) {
        this.mainBuilder.sprite(spriteId);
        return this;
    }

    public ButtonComponent sprites(int normalId, int hoverId) {
        this.mainBuilder.sprite(normalId);
        if (this.hoverBuilder != null) {
            this.hoverBuilder.sprite(hoverId);
        }
        if (this.hoverImageBuilder != null) {
            this.hoverImageBuilder.sprite(hoverId);
        }
        return this;
    }

    public ButtonComponent size(int width, int height) {
        this.mainBuilder.size(width, height);
        if (this.hoverBuilder != null) {
            this.hoverBuilder.size(width, height);
        }
        if (this.hoverImageBuilder != null) {
            this.hoverImageBuilder.size(width, height);
        }
        return this;
    }

    public ButtonComponent tooltip(String tooltip) {
        this.mainBuilder.tooltip(tooltip);
        return this;
    }

    public ButtonComponent actionType(int actionType) {
        this.mainBuilder.actionType(actionType);
        return this;
    }

    public ButtonComponent hoverType(int hoverType) {
        this.mainBuilder.hoverType(hoverType);
        return this;
    }

    public RSInterface build() {
        if (this.hoverId != -1) {
            this.mainBuilder.hoverChildren(this.hoverId);
            this.hoverBuilder.build();
            this.hoverImageBuilder.build();
        }
        return this.mainBuilder.build();
    }

    public int[] buildAll() {
        this.build();
        if (this.hoverId != -1) {
            return new int[]{this.mainBuilder.build().id, this.hoverId, this.hoverImageId};
        }
        return new int[]{this.mainBuilder.build().id};
    }

    public static RSInterface simple(int id, int spriteId, String tooltip) {
        return ButtonComponent.create(id).sprite(spriteId).tooltip(tooltip).build();
    }

    public static RSInterface close(int id, int hoverId, int hoverImageId, int normalSprite, int hoverSprite) {
        return ButtonComponent.hover(id, hoverId, hoverImageId).sprites(normalSprite, hoverSprite).size(21, 21).tooltip("Close").hoverType(250).actionType(3).build();
    }

    public static RSInterface close(int id, int hoverId, int hoverImageId) {
        return ButtonComponent.close(id, hoverId, hoverImageId, 740, 741);
    }

    public static RSInterface closeSmall(int id, int hoverId, int hoverImageId) {
        return ButtonComponent.close(id, hoverId, hoverImageId, 740, 741);
    }
}

