/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.components;

import com.teragard.RSInterface;
import com.teragard.RSInterfaceBuilder;

public class SpriteComponent {
    private final RSInterfaceBuilder builder;

    private SpriteComponent(int id) {
        this.builder = RSInterfaceBuilder.create(id).type(5);
    }

    public static SpriteComponent create(int id) {
        return new SpriteComponent(id);
    }

    public static SpriteComponent create(int id, int spriteId) {
        return new SpriteComponent(id).sprite(spriteId);
    }

    public SpriteComponent sprite(int spriteId) {
        this.builder.sprite(spriteId);
        return this;
    }

    public SpriteComponent sprites(int disabledId, int enabledId) {
        this.builder.sprites(disabledId, enabledId);
        return this;
    }

    public SpriteComponent size(int width, int height) {
        this.builder.size(width, height);
        return this;
    }

    public SpriteComponent greyscale() {
        this.builder.greyscale(true);
        return this;
    }

    public SpriteComponent transparent() {
        this.builder.transparent(true);
        return this;
    }

    public SpriteComponent opacity(int opacity) {
        this.builder.opacity(opacity);
        return this;
    }

    public RSInterface build() {
        return this.builder.build();
    }

    public static RSInterface simple(int id, int spriteId) {
        return SpriteComponent.create(id, spriteId).build();
    }

    public static RSInterface background(int id, int spriteId, int width, int height) {
        return SpriteComponent.create(id).sprite(spriteId).size(width, height).build();
    }
}

