/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.constants;

public class GameModeConstants {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_HARDCORE_IRONMAN = 1;
    public static final int MODE_IRONMAN = 2;
    public static final int MODE_ULTIMATE_IRONMAN = 3;
    public static final int SPRITE_HARDCORE_IRONMAN = 691;
    public static final int SPRITE_IRONMAN = 712;
    public static final int SPRITE_ULTIMATE_IRONMAN = 711;
    public static final String PREFIX_HARDCORE = "@im1@";
    public static final String PREFIX_IRONMAN = "@im2@";
    public static final String PREFIX_ULTIMATE = "@im3@";

    public static int getIronmanSprite(int ironmanMode) {
        switch (ironmanMode) {
            case 1: {
                return 691;
            }
            case 2: {
                return 712;
            }
            case 3: {
                return 711;
            }
        }
        return -1;
    }

    public static String getIronmanPrefix(int ironmanMode) {
        switch (ironmanMode) {
            case 1: {
                return PREFIX_HARDCORE;
            }
            case 2: {
                return PREFIX_IRONMAN;
            }
            case 3: {
                return PREFIX_ULTIMATE;
            }
        }
        return "";
    }

    public static int parseIronmanFromPrefix(String name) {
        if (name == null) {
            return 0;
        }
        if (name.contains(PREFIX_HARDCORE) || name.contains("@hci@")) {
            return 1;
        }
        if (name.contains(PREFIX_ULTIMATE) || name.contains("@uim@")) {
            return 3;
        }
        if (name.contains(PREFIX_IRONMAN) || name.contains("@im@")) {
            return 2;
        }
        return 0;
    }

    public static int getPrefixLength(String name, int ironmanMode) {
        if (name == null || ironmanMode == 0) {
            return 5;
        }
        if (name.contains("@im@")) {
            return 4;
        }
        return 5;
    }

    public static boolean isIronman(int ironmanMode) {
        return ironmanMode >= 1 && ironmanMode <= 3;
    }

    public static String getModeName(int ironmanMode) {
        switch (ironmanMode) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Hardcore Ironman";
            }
            case 2: {
                return "Ironman";
            }
            case 3: {
                return "Ultimate Ironman";
            }
        }
        return "Unknown";
    }
}

