/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.managers;

import com.teragard.FileOperations;
import com.teragard.RSFontSystem;
import com.teragard.RSInterface;
import com.teragard.SoundPlayer;
import com.teragard.signlink;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;

public class SettingsManager {
    private static SettingsManager instance;
    private final Map<String, Boolean> options = new HashMap<String, Boolean>();
    public static final String OPT_HD_TEX = "hd_tex";
    public static final String OPT_TOOLTIP_HOVER = "tooltip_hover";
    public static final String OPT_OLD_HITS = "old_hits";
    public static final String OPT_CONSTITUTION = "constitution";
    public static final String OPT_CURSORS = "cursors";
    public static final String OPT_OLD_FRAME = "old_frame";
    public static final String OPT_SMILIES = "smilies";
    public static final String OPT_CENSOR_ACTIVE = "censor_active";
    public static final String OPT_FOG_ACTIVE = "fog_active";
    public static final String OPT_ABSORB_DAMAGE = "absorb_damage";
    public static final String OPT_ANTI_A = "anti_a";
    public static final String OPT_SAVE_INPUT = "save_input";
    private static final Map<String, Integer> OPTION_INTERFACE_IDS;
    private boolean musicEnabled = false;
    private boolean rememberMe = true;
    private int shadowIndex = 4;
    private int clientSize = 0;
    private int[] quickPrayers = new int[30];
    private int[] quickCurses = new int[20];
    private Runnable onMusicDisabled;
    private Runnable onSettingsLoaded;

    private SettingsManager() {
        this.initializeDefaults();
    }

    public static SettingsManager getInstance() {
        if (instance == null) {
            instance = new SettingsManager();
        }
        return instance;
    }

    private void initializeDefaults() {
        this.options.put(OPT_HD_TEX, false);
        this.options.put(OPT_TOOLTIP_HOVER, false);
        this.options.put(OPT_OLD_HITS, false);
        this.options.put(OPT_CONSTITUTION, true);
        this.options.put(OPT_CURSORS, true);
        this.options.put(OPT_OLD_FRAME, true);
        this.options.put(OPT_SMILIES, true);
        this.options.put(OPT_CENSOR_ACTIVE, false);
        this.options.put(OPT_FOG_ACTIVE, true);
        this.options.put(OPT_ABSORB_DAMAGE, true);
        this.options.put(OPT_ANTI_A, false);
        this.options.put(OPT_SAVE_INPUT, true);
    }

    public boolean getOption(String key) {
        Boolean value = this.options.get(key);
        return value != null && value != false;
    }

    public void setOption(String key, boolean value) {
        this.options.put(key, value);
    }

    public boolean toggleOption(String key) {
        boolean newValue = !this.getOption(key);
        this.options.put(key, newValue);
        return newValue;
    }

    public Map<String, Boolean> getOptionsMap() {
        return this.options;
    }

    public void applySettings(int[] variousSettings) {
        for (Map.Entry<String, Integer> entry : OPTION_INTERFACE_IDS.entrySet()) {
            String optionKey = entry.getKey();
            int interfaceId = entry.getValue();
            if (!this.getOption(optionKey)) continue;
            try {
                int settingIndex = RSInterface.interfaceCache[interfaceId].valueIndexArray[0][1];
                variousSettings[settingIndex] = 1 - variousSettings[settingIndex];
            }
            catch (Exception exception) {}
        }
        if (!this.musicEnabled && this.onMusicDisabled != null) {
            this.onMusicDisabled.run();
        }
    }

    public void loadSettings(LoginCredentials credentials) {
        String settingsPath = signlink.findcachedir() + "preferences.set";
        if (!FileOperations.FileExists(settingsPath)) {
            this.clientSize = 0;
            this.rememberMe = true;
            this.musicEnabled = false;
            this.shadowIndex = 4;
            SoundPlayer.setVolume(4);
            this.initializeDefaults();
            this.saveSettings(credentials);
            return;
        }
        try (RandomAccessFile in = new RandomAccessFile(settingsPath, "rw");){
            int i;
            String password;
            String username = in.readUTF();
            if (username.length() > 0 && credentials != null) {
                credentials.setUsername(username);
                this.rememberMe = true;
            }
            if ((password = in.readUTF()).length() > 0 && credentials != null) {
                credentials.setPassword(password);
                this.rememberMe = true;
            }
            SoundPlayer.setVolume(in.readShort());
            this.musicEnabled = in.readByte() == 1;
            this.options.put(OPT_HD_TEX, in.readByte() == 1);
            this.options.put(OPT_TOOLTIP_HOVER, in.readByte() == 1);
            this.options.put(OPT_OLD_HITS, in.readByte() == 1);
            this.options.put(OPT_CONSTITUTION, in.readByte() == 1);
            this.options.put(OPT_CURSORS, in.readByte() == 1);
            this.options.put(OPT_OLD_FRAME, in.readByte() == 1);
            this.options.put(OPT_SMILIES, in.readByte() == 1);
            this.options.put(OPT_CENSOR_ACTIVE, in.readByte() == 1);
            this.options.put(OPT_FOG_ACTIVE, in.readByte() == 1);
            this.options.put(OPT_ABSORB_DAMAGE, in.readByte() == 1);
            this.options.put(OPT_ANTI_A, in.readByte() == 1);
            this.options.put(OPT_SAVE_INPUT, in.readByte() == 1);
            this.shadowIndex = in.readInt();
            String q = in.readUTF();
            for (i = 0; i < q.length() && i < this.quickPrayers.length; ++i) {
                this.quickPrayers[i] = Integer.parseInt(q.substring(i, i + 1));
            }
            q = in.readUTF();
            for (i = 0; i < q.length() && i < this.quickCurses.length; ++i) {
                this.quickCurses[i] = Integer.parseInt(q.substring(i, i + 1));
            }
            RSFontSystem.SMILIES_TOGGLED = this.getOption(OPT_SMILIES);
            if (this.onSettingsLoaded != null) {
                this.onSettingsLoaded.run();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.clientSize = 0;
            this.rememberMe = true;
            this.musicEnabled = false;
            this.shadowIndex = 4;
            SoundPlayer.setVolume(4);
            this.initializeDefaults();
            this.saveSettings(credentials);
        }
    }

    public void saveSettings(LoginCredentials credentials) {
        try (RandomAccessFile out = new RandomAccessFile(signlink.findcachedir() + "preferences.set", "rw");){
            String username = credentials != null && this.rememberMe ? credentials.getUsername() : "";
            String password = credentials != null && this.rememberMe ? credentials.getPassword() : "";
            out.writeUTF(username != null ? username : "");
            out.writeUTF(password != null ? password : "");
            out.writeShort(SoundPlayer.getVolume());
            out.write(this.musicEnabled ? 1 : 0);
            out.write(this.getOption(OPT_HD_TEX) ? 1 : 0);
            out.write(this.getOption(OPT_TOOLTIP_HOVER) ? 1 : 0);
            out.write(this.getOption(OPT_OLD_HITS) ? 1 : 0);
            out.write(this.getOption(OPT_CONSTITUTION) ? 1 : 0);
            out.write(this.getOption(OPT_CURSORS) ? 1 : 0);
            out.write(this.getOption(OPT_OLD_FRAME) ? 1 : 0);
            out.write(this.getOption(OPT_SMILIES) ? 1 : 0);
            out.write(this.getOption(OPT_CENSOR_ACTIVE) ? 1 : 0);
            out.write(this.getOption(OPT_FOG_ACTIVE) ? 1 : 0);
            out.write(this.getOption(OPT_ABSORB_DAMAGE) ? 1 : 0);
            out.write(this.getOption(OPT_ANTI_A) ? 1 : 0);
            out.write(this.getOption(OPT_SAVE_INPUT) ? 1 : 0);
            out.writeInt(this.shadowIndex);
            StringBuilder sb = new StringBuilder();
            for (int prayer : this.quickPrayers) {
                sb.append(prayer);
            }
            out.writeUTF(sb.toString());
            sb.setLength(0);
            for (int curse : this.quickCurses) {
                sb.append(curse);
            }
            out.writeUTF(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMusicEnabled() {
        return this.musicEnabled;
    }

    public void setMusicEnabled(boolean enabled) {
        this.musicEnabled = enabled;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public int getShadowIndex() {
        return this.shadowIndex;
    }

    public void setShadowIndex(int shadowIndex) {
        this.shadowIndex = shadowIndex;
    }

    public int getClientSize() {
        return this.clientSize;
    }

    public void setClientSize(int clientSize) {
        this.clientSize = clientSize;
    }

    public int[] getQuickPrayers() {
        return this.quickPrayers;
    }

    public int[] getQuickCurses() {
        return this.quickCurses;
    }

    public void setOnMusicDisabled(Runnable callback) {
        this.onMusicDisabled = callback;
    }

    public void setOnSettingsLoaded(Runnable callback) {
        this.onSettingsLoaded = callback;
    }

    static {
        OPTION_INTERFACE_IDS = new HashMap<String, Integer>();
        OPTION_INTERFACE_IDS.put(OPT_HD_TEX, 35649);
        OPTION_INTERFACE_IDS.put(OPT_TOOLTIP_HOVER, 35613);
        OPTION_INTERFACE_IDS.put(OPT_OLD_HITS, 35568);
        OPTION_INTERFACE_IDS.put(OPT_CONSTITUTION, 35571);
        OPTION_INTERFACE_IDS.put(OPT_CURSORS, 35584);
        OPTION_INTERFACE_IDS.put(OPT_OLD_FRAME, 35565);
        OPTION_INTERFACE_IDS.put(OPT_SMILIES, 35587);
        OPTION_INTERFACE_IDS.put(OPT_CENSOR_ACTIVE, 35590);
        OPTION_INTERFACE_IDS.put(OPT_FOG_ACTIVE, 35619);
        OPTION_INTERFACE_IDS.put(OPT_ABSORB_DAMAGE, 35643);
        OPTION_INTERFACE_IDS.put(OPT_SAVE_INPUT, 35646);
        OPTION_INTERFACE_IDS.put(OPT_ANTI_A, 35649);
    }

    public static interface LoginCredentials {
        public String getUsername();

        public void setUsername(String var1);

        public String getPassword();

        public void setPassword(String var1);
    }
}

