/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.managers;

import com.teragard.RSFontSystem;
import com.teragard.Sprite;
import com.teragard.SpriteLoader;
import com.teragard.TextDrawingArea;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedList;

public class XPGainDisplay {
    private static XPGainDisplay instance;
    private final LinkedList<XPGain> gains = new LinkedList();
    private long totalXP = 0L;
    private boolean canGainXP = true;
    private final NumberFormat format = NumberFormat.getInstance();
    private static final int SPRITE_OFFSET = 41;
    private static final int SUMMON_SKILL_ID = 23;
    private static final int SUMMON_SPRITE_ID = 95;
    private static final int DUNGEONEERING_SKILL_ID = 24;
    private static final int DUNGEONEERING_SPRITE_ID = 950;
    private static final int STOP_Y = 70;
    private static final int FADE_START = 10;
    private static final int ALPHA_STEP = 30;
    private static final int MAX_GAINS = 2;
    private XPGainCallback xpCallback;

    private XPGainDisplay() {
        this.format.setGroupingUsed(true);
    }

    public static XPGainDisplay getInstance() {
        if (instance == null) {
            instance = new XPGainDisplay();
        }
        return instance;
    }

    public void addXP(int skillID, int xp) {
        if (!this.canGainXP) {
            return;
        }
        if (this.gains.size() >= 2) {
            this.gains.clear();
        }
        this.gains.add(new XPGain(skillID, xp));
        this.totalXP += (long)xp;
        if (this.xpCallback != null) {
            this.xpCallback.onXPGained(xp);
        }
    }

    public void display(int clientSize, int clientWidth, Sprite[] cacheSprite, TextDrawingArea normalFont, RSFontSystem newSmallFont) {
        int spriteY;
        int x = clientSize == 0 ? 419 : clientWidth - 310;
        int y = clientSize == 0 ? 0 : -36;
        int n = spriteY = clientSize == 0 ? 50 : 48 + y;
        if (cacheSprite != null && cacheSprite.length > 40 && cacheSprite[40] != null) {
            cacheSprite[40].drawSprite(x, spriteY);
        }
        String xpText = this.totalXP >= 100000000L ? " XP: A lot!" : "XP:" + String.format("%, d", this.totalXP);
        int textY = (clientSize == 0 ? 63 : 61) + y;
        if (normalFont != null) {
            normalFont.drawRegularText(true, x + 1, 0xFFFFFF, xpText, textY);
        }
        if (!this.gains.isEmpty()) {
            int currentIndex = 0;
            Iterator it = this.gains.iterator();
            while (it.hasNext()) {
                XPGain gain = (XPGain)it.next();
                if (gain.getY() < 70) {
                    if (gain.getY() <= 10) {
                        gain.increaseAlpha();
                    }
                    if (gain.getY() >= 60) {
                        gain.decreaseAlpha();
                    }
                } else {
                    it.remove();
                    continue;
                }
                gain.increaseY();
                int offsetY = 0;
                if (this.gains.size() > 1) {
                    offsetY = (clientSize == 0 ? -5 : -20) + currentIndex * 28;
                }
                if (gain.getSkill() >= 0) {
                    int spriteId = this.getSpriteIdForSkill(gain.getSkill());
                    int xOffset = this.calculateXOffset(gain.getXP());
                    if (SpriteLoader.sprites != null && spriteId < SpriteLoader.sprites.length && SpriteLoader.sprites[spriteId] != null) {
                        Sprite sprite = SpriteLoader.sprites[spriteId];
                        sprite.drawSprite(x + xOffset - 12 - sprite.myWidth / 2, gain.getY() + offsetY + 66 - sprite.myHeight / 2, gain.getAlpha());
                    }
                    if (newSmallFont != null) {
                        String gainText = "<trans=" + gain.getAlpha() + ">+" + this.format.format(gain.getXP()) + "xp";
                        newSmallFont.drawBasicString(gainText, x + xOffset, gain.getY() + offsetY + 70, 0xCC6600, 0);
                    }
                } else if (gain.getSkill() == -244 && gain.getXP() == -244 && newSmallFont != null) {
                    newSmallFont.drawBasicString("XP LOCKED!", x + 30, gain.getY() + offsetY + 50, 0xCC6600, 0);
                }
                ++currentIndex;
            }
        }
    }

    private int getSpriteIdForSkill(int skillId) {
        if (skillId == 23) {
            return 95;
        }
        if (skillId == 24) {
            return 950;
        }
        int id = skillId + 41;
        if (id == 65) {
            return 88;
        }
        return id;
    }

    private int calculateXOffset(int xp) {
        if (xp > 1000000) {
            return 5;
        }
        if (xp > 100000) {
            return 15;
        }
        return 31;
    }

    public long getTotalXP() {
        return this.totalXP;
    }

    public void setTotalXP(long xp) {
        this.totalXP = xp;
    }

    public void resetTotalXP() {
        this.totalXP = 0L;
    }

    public boolean canGainXP() {
        return this.canGainXP;
    }

    public void setCanGainXP(boolean can) {
        this.canGainXP = can;
    }

    public void setXPCallback(XPGainCallback callback) {
        this.xpCallback = callback;
    }

    public LinkedList<XPGain> getGains() {
        return this.gains;
    }

    public static class XPGain {
        private final int skill;
        private final int xp;
        private int y = 0;
        private int alpha = 0;

        public XPGain(int skill, int xp) {
            this.skill = skill;
            this.xp = xp;
        }

        public void increaseY() {
            ++this.y;
        }

        public int getSkill() {
            return this.skill;
        }

        public int getXP() {
            return this.xp;
        }

        public int getY() {
            return this.y;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public void increaseAlpha() {
            this.alpha += this.alpha < 256 ? 30 : 0;
            this.alpha = Math.min(this.alpha, 256);
        }

        public void decreaseAlpha() {
            this.alpha -= this.alpha > 0 ? 30 : 0;
            this.alpha = Math.max(this.alpha, 0);
        }
    }

    public static interface XPGainCallback {
        public void onXPGained(int var1);
    }
}

