/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui;

import com.teragard.DrawingArea;
import com.teragard.RSFontSystem;
import com.teragard.Sprite;
import com.teragard.SpriteLoader;
import com.teragard.TextDrawingArea;
import com.teragard.util.Stopwatch;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LoginScreen {
    private static LoginScreen instance;
    private String username = "";
    private String password = "";
    private int cursorPos = 0;
    private int screenState = 5;
    private String[] messages = new String[]{""};
    private boolean rememberMe = true;
    private boolean showTwoFactorAuth = false;
    private boolean showCaptcha = false;
    private String currentPinCode = "";
    private Sprite captcha;
    private int currentBackgroundSprite = 1625;
    private Stopwatch backgroundTimer = new Stopwatch();
    private Sprite loginLogo;
    private Sprite discordButton;
    private Sprite discordButtonHover;
    private Sprite messageBar;
    private boolean input1Hover = false;
    private boolean input2Hover = false;
    private boolean loginButtonHover = false;
    private boolean rememberMeButtonHover = false;
    private boolean backButtonHover = false;
    private boolean discordHover = false;
    private boolean otherHover = false;
    private boolean soundHover = false;
    private int navHoverIndex = -1;
    private List<SavedAccount> savedAccounts = new ArrayList<SavedAccount>();
    private int hoveredAccountIndex = -1;
    private int selectedAccountIndex = -1;
    private boolean addAccountHover = false;
    private boolean removeAccountHover = false;
    private static final String VALID_USER_PASS_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!\"@#$%^&*()_=+-;:',<>./?";
    private static final String VALID_AUTH_KEYS = "0123456789";
    private static final int SPRITE_LOGIN_BTN = 1626;
    private static final int SPRITE_LOGIN_BTN_HOVER = 1627;
    private static final int SPRITE_USERNAME_FIELD = 1628;
    private static final int SPRITE_USERNAME_FIELD_HOVER = 1629;
    private static final int SPRITE_PASSWORD_FIELD = 1630;
    private static final int SPRITE_PASSWORD_FIELD_HOVER = 1631;
    private static final int SPRITE_CHECKBOX = 1632;
    private static final int SPRITE_CHECKBOX_CHECKED = 1633;
    private static final int SPRITE_LOGIN_BOX = 1638;
    private static final int SPRITE_BACKGROUND = 1625;
    private LoginCallback callback;
    private boolean debugMode = false;

    private LoginScreen() {
        this.backgroundTimer.reset();
    }

    public static LoginScreen getInstance() {
        if (instance == null) {
            instance = new LoginScreen();
        }
        return instance;
    }

    public void setCallback(LoginCallback callback) {
        this.callback = callback;
    }

    public void draw(RSFontSystem newSmallFont, RSFontSystem newRegularFont, TextDrawingArea chatFont, int clientWidth, int clientHeight, int loopCycle, boolean isLoading) {
        this.drawBackground(clientWidth, clientHeight);
        int centerX = clientWidth / 2;
        this.drawNavBar(newSmallFont, centerX);
        int boxY = 160;
        int boxWidth = 335;
        int boxHeight = 213;
        int boxX = centerX - boxWidth / 2;
        if (this.hasSprite(1638)) {
            Sprite boxSprite = SpriteLoader.sprites[1638];
            boxX = centerX - boxSprite.myWidth / 2;
            boxWidth = boxSprite.myWidth;
            boxHeight = boxSprite.myHeight;
            boxSprite.drawSprite(boxX, boxY);
        }
        int fieldWidth = 272;
        int fieldX = centerX - fieldWidth / 2;
        int usernameY = boxY + 45;
        int passwordY = boxY + 105;
        int buttonRowY = boxY + 155;
        this.drawInputFields(fieldX, usernameY, passwordY);
        this.drawButtonRow(fieldX, fieldWidth, buttonRowY);
        int rageY = boxY + boxHeight + 15;
        newSmallFont.drawCenteredString("RAGE", centerX, rageY, 0xCCCCCC, 0);
        this.drawDiscordButton(boxX, boxWidth, boxY, boxHeight);
        this.drawMessageBar(newSmallFont, centerX, clientHeight);
        if (this.debugMode) {
            this.drawDebugInfo(newSmallFont, centerX, boxX, boxY, boxWidth, boxHeight, fieldX, fieldWidth, usernameY, passwordY, buttonRowY, clientWidth, clientHeight);
        }
        if (!this.showTwoFactorAuth) {
            this.drawInputText(chatFont, fieldX, usernameY, passwordY, loopCycle);
        }
        this.drawLoginMessages(chatFont, newRegularFont, centerX, clientWidth, clientHeight);
        if (this.showTwoFactorAuth) {
            this.drawTwoFactorAuth(chatFont, loopCycle);
        }
    }

    private void drawBackground(int clientWidth, int clientHeight) {
        if (this.backgroundTimer.elapsed(60L)) {
            ++this.currentBackgroundSprite;
            this.backgroundTimer.reset();
        }
        if (this.currentBackgroundSprite > 1320) {
            this.currentBackgroundSprite = 1625;
        }
        if (this.hasSprite(this.currentBackgroundSprite)) {
            SpriteLoader.sprites[this.currentBackgroundSprite].drawAdvancedSprite(0, 0);
        }
    }

    private void drawNavBar(RSFontSystem font, int centerX) {
        int navY = 12;
        int navSpacing = 100;
        String[] navItems = new String[]{"HOME", "STORE", "FORUM", "VOTE"};
        int[] navColors = new int[]{5025616, 0xCCCCCC, 0xCCCCCC, 0xCCCCCC};
        int totalNavWidth = (navItems.length - 1) * navSpacing;
        int navStartX = centerX - totalNavWidth / 2;
        for (int i = 0; i < navItems.length; ++i) {
            int navX = navStartX + i * navSpacing;
            int color = this.navHoverIndex == i ? 5025616 : navColors[i];
            font.drawCenteredString(navItems[i], navX, navY + 10, color, 0);
        }
    }

    private void drawInputFields(int fieldX, int usernameY, int passwordY) {
        int spriteId;
        if (this.hasSprite(1628)) {
            spriteId = this.input1Hover ? 1629 : 1628;
            SpriteLoader.sprites[spriteId].drawAdvancedSprite(fieldX, usernameY);
        }
        if (this.hasSprite(1630)) {
            spriteId = this.input2Hover ? 1631 : 1630;
            SpriteLoader.sprites[spriteId].drawAdvancedSprite(fieldX, passwordY);
        }
    }

    private void drawButtonRow(int fieldX, int fieldWidth, int buttonRowY) {
        int checkboxX = fieldX + 95;
        if (this.hasSprite(1632)) {
            int spriteId = this.rememberMe ? 1633 : 1632;
            SpriteLoader.sprites[spriteId].drawAdvancedSprite(checkboxX, buttonRowY + 5);
        }
        int loginBtnWidth = 127;
        int loginBtnX = fieldX + fieldWidth - loginBtnWidth;
        if (this.hasSprite(1626)) {
            int spriteId = this.loginButtonHover ? 1627 : 1626;
            SpriteLoader.sprites[spriteId].drawAdvancedSprite(loginBtnX, buttonRowY);
        }
    }

    private void drawDiscordButton(int boxX, int boxWidth, int boxY, int boxHeight) {
        if (this.discordButton != null) {
            int discordX = boxX + boxWidth + 20;
            int discordY = boxY + boxHeight - 40;
            if (this.discordHover && this.discordButtonHover != null) {
                this.discordButtonHover.drawAdvancedSprite(discordX, discordY);
            } else {
                this.discordButton.drawAdvancedSprite(discordX, discordY);
            }
        }
    }

    private void drawMessageBar(RSFontSystem font, int centerX, int clientHeight) {
        if (this.messageBar != null) {
            int barX = centerX - this.messageBar.myWidth / 2;
            int barY = clientHeight - this.messageBar.myHeight - 5;
            this.messageBar.drawAdvancedSprite(barX, barY);
            String updateMsg = "UPDATE 11/17/2025 - READ ALL ABOUT IT TERGARD.COM/FORUMS/THREAD101";
            font.drawCenteredString(updateMsg, centerX, barY + 45, 0xCCCCCC, 0);
        }
    }

    private void drawInputText(TextDrawingArea font, int fieldX, int usernameY, int passwordY, int loopCycle) {
        int textX = fieldX + 10;
        int usernameTextY = usernameY + 22;
        int passwordTextY = passwordY + 22;
        Object usernameDisplay = this.username;
        if (this.cursorPos == 0 && loopCycle % 45 < 10) {
            usernameDisplay = (String)usernameDisplay + "|";
        }
        font.drawRegularText(true, textX, 0xFFFFFF, (String)usernameDisplay, usernameTextY);
        Object passwordDisplay = this.getStars(this.password);
        if (this.cursorPos == 1 && loopCycle % 45 < 10) {
            passwordDisplay = (String)passwordDisplay + "|";
        }
        font.drawRegularText(true, textX, 0xFFFFFF, (String)passwordDisplay, passwordTextY);
    }

    private void drawLoginMessages(TextDrawingArea chatFont, RSFontSystem regularFont, int centerX, int clientWidth, int clientHeight) {
        if (!this.showTwoFactorAuth) {
            for (int i = 0; i < this.messages.length; ++i) {
                String s = this.messages[i];
                if (s == null || s.isEmpty()) continue;
                int y = clientHeight - 100 + i * 20;
                int x = (clientWidth - chatFont.getTextWidth(s) - 15) / 2;
                chatFont.drawRegularText(true, x, 0xFFFFFF, s, y);
            }
        } else if (this.showCaptcha && this.captcha != null) {
            this.drawColorBox(0xFFFFFF, 268, 198, this.captcha.myWidth + 50, this.captcha.myHeight + 20);
            this.captcha.drawAdvancedSprite((clientWidth - this.captcha.myWidth) / 2, 215);
            int backColor = this.otherHover ? 0xFFFFFF : 16766720;
            regularFont.drawCenteredString("Back", 25, 20, backColor, 0);
        }
    }

    private void drawTwoFactorAuth(TextDrawingArea font, int loopCycle) {
        Object pinDisplay = this.currentPinCode;
        if (this.cursorPos == 0 && loopCycle % 45 < 10) {
            pinDisplay = (String)pinDisplay + "|";
        }
        font.drawRegularText(true, 277, 0xFFFFFF, (String)pinDisplay, 317);
    }

    private void drawDebugInfo(RSFontSystem font, int centerX, int boxX, int boxY, int boxWidth, int boxHeight, int fieldX, int fieldWidth, int usernameY, int passwordY, int buttonRowY, int clientWidth, int clientHeight) {
        int debugY = 20;
        int debugX = 10;
        int lineHeight = 14;
        int mouseX = this.callback != null ? this.callback.getMouseX() : 0;
        int mouseY = this.callback != null ? this.callback.getMouseY() : 0;
        font.drawBasicString("Mouse: " + mouseX + ", " + mouseY, debugX, debugY, 0xFFFF00, 0);
        font.drawBasicString("Screen: " + clientWidth + "x" + clientHeight, debugX, debugY += lineHeight, 0xFFFF00, 0);
        font.drawBasicString("CenterX: " + centerX, debugX, debugY += lineHeight, 0xFFFF00, 0);
        font.drawBasicString("Box: x=" + boxX + " y=" + boxY + " w=" + boxWidth + " h=" + boxHeight, debugX, debugY += lineHeight, 65280, 0);
        font.drawBasicString("Username field: y=" + usernameY, debugX, debugY += lineHeight, 65535, 0);
        font.drawBasicString("Password field: y=" + passwordY, debugX, debugY += lineHeight, 65535, 0);
        font.drawBasicString("Button row: y=" + buttonRowY, debugX, debugY += lineHeight, 65535, 0);
        font.drawBasicString("FieldX: " + fieldX + " width=" + fieldWidth, debugX, debugY += lineHeight, 0xFF00FF, 0);
        debugY += lineHeight;
        StringBuilder hovers = new StringBuilder("Hover: ");
        if (this.input1Hover) {
            hovers.append("USER ");
        }
        if (this.input2Hover) {
            hovers.append("PASS ");
        }
        if (this.loginButtonHover) {
            hovers.append("LOGIN ");
        }
        if (this.rememberMeButtonHover) {
            hovers.append("SAVE ");
        }
        if (this.discordHover) {
            hovers.append("DISCORD ");
        }
        font.drawBasicString(hovers.toString(), debugX, debugY, 0xFFFFFF, 0);
    }

    public void updateHovers(int mouseX, int mouseY, int clientWidth, int clientHeight, boolean isLoading) {
        this.resetHovers();
        int centerX = clientWidth / 2;
        int boxY = 160;
        int boxWidth = 335;
        int boxHeight = 213;
        if (this.hasSprite(1638)) {
            boxWidth = SpriteLoader.sprites[1638].myWidth;
            boxHeight = SpriteLoader.sprites[1638].myHeight;
        }
        int boxX = centerX - boxWidth / 2;
        int fieldWidth = 272;
        int fieldX = centerX - fieldWidth / 2;
        int usernameY = boxY + 45;
        int passwordY = boxY + 105;
        int buttonRowY = boxY + 155;
        if (mouseX >= clientWidth - 59 && mouseX <= clientWidth - 10 && mouseY >= clientHeight - 59 && mouseY <= clientHeight - 10) {
            this.soundHover = true;
        } else if (this.messages[0].length() > 0 && mouseX >= 300 && mouseX <= 428 && mouseY >= 388 && mouseY <= 408) {
            this.backButtonHover = true;
        }
        if (!isLoading) {
            int loginBtnWidth = 127;
            int loginBtnX = fieldX + fieldWidth - loginBtnWidth;
            int loginBtnHeight = 46;
            if (mouseX >= loginBtnX && mouseX <= loginBtnX + loginBtnWidth && mouseY >= buttonRowY && mouseY <= buttonRowY + loginBtnHeight) {
                this.loginButtonHover = true;
            }
            if (this.discordButton != null) {
                int discordX = boxX + boxWidth + 20;
                int discordY = boxY + boxHeight - 40;
                if (mouseX >= discordX && mouseX <= discordX + this.discordButton.myWidth && mouseY >= discordY && mouseY <= discordY + this.discordButton.myHeight) {
                    this.discordHover = true;
                }
            }
            if (this.showTwoFactorAuth) {
                if (mouseX >= 0 && mouseX <= 50 && mouseY >= 0 && mouseY <= 25) {
                    this.otherHover = true;
                }
            } else {
                int checkboxX;
                if (mouseX >= fieldX && mouseX <= fieldX + fieldWidth) {
                    if (mouseY >= usernameY && mouseY <= usernameY + 33) {
                        this.input1Hover = true;
                    } else if (mouseY >= passwordY && mouseY <= passwordY + 33) {
                        this.input2Hover = true;
                    }
                }
                if (mouseX >= (checkboxX = fieldX + 95) && mouseX <= checkboxX + 25 && mouseY >= buttonRowY + 5 && mouseY <= buttonRowY + 25) {
                    this.rememberMeButtonHover = true;
                }
            }
            int navY = 12;
            int navSpacing = 100;
            int totalNavWidth = 3 * navSpacing;
            int navStartX = centerX - totalNavWidth / 2;
            for (int i = 0; i < 4; ++i) {
                int navX = navStartX + i * navSpacing;
                if (mouseX < navX - 30 || mouseX > navX + 30 || mouseY < navY - 5 || mouseY > navY + 15) continue;
                this.navHoverIndex = i;
                break;
            }
        }
    }

    private void resetHovers() {
        this.input1Hover = false;
        this.input2Hover = false;
        this.loginButtonHover = false;
        this.rememberMeButtonHover = false;
        this.backButtonHover = false;
        this.discordHover = false;
        this.otherHover = false;
        this.soundHover = false;
        this.navHoverIndex = -1;
    }

    public void processClick(int mouseX, int mouseY) {
        if (this.messages[0].length() > 0 && this.backButtonHover) {
            this.messages = new String[]{""};
            this.backButtonHover = false;
            return;
        }
        if (this.otherHover) {
            this.showCaptcha = false;
            this.showTwoFactorAuth = false;
            this.messages = new String[]{""};
            return;
        }
        if (this.hoveredAccountIndex != -1 && this.hoveredAccountIndex < this.savedAccounts.size()) {
            if (this.removeAccountHover) {
                SavedAccount removed = this.savedAccounts.remove(this.hoveredAccountIndex);
                this.saveSavedAccounts();
                if (this.selectedAccountIndex == this.hoveredAccountIndex) {
                    this.selectedAccountIndex = -1;
                    this.username = "";
                    this.password = "";
                } else if (this.selectedAccountIndex > this.hoveredAccountIndex) {
                    --this.selectedAccountIndex;
                }
            } else {
                this.selectedAccountIndex = this.hoveredAccountIndex;
                SavedAccount account = this.savedAccounts.get(this.hoveredAccountIndex);
                this.username = account.username;
                this.password = account.password;
            }
            return;
        }
        if (this.addAccountHover && !this.username.isEmpty() && !this.password.isEmpty()) {
            boolean exists = this.savedAccounts.stream().anyMatch(acc -> acc.username.equalsIgnoreCase(this.username));
            if (!exists) {
                this.savedAccounts.add(new SavedAccount(this.username, this.password));
                this.saveSavedAccounts();
            } else {
                this.messages = new String[]{"Account already saved"};
            }
            return;
        }
        if (this.input1Hover) {
            this.cursorPos = 0;
        } else if (this.input2Hover) {
            this.cursorPos = 1;
        } else if (this.loginButtonHover) {
            if (this.callback != null) {
                this.callback.onLogin(this.username, this.password);
            }
        } else if (this.rememberMeButtonHover) {
            boolean bl = this.rememberMe = !this.rememberMe;
            if (this.callback != null) {
                this.callback.onRememberMeToggled(this.rememberMe);
            }
        } else if (this.discordHover && this.callback != null) {
            this.callback.onDiscordClicked();
        }
        if (this.navHoverIndex >= 0 && this.callback != null) {
            String[] navUrls = new String[]{"home", "store", "forum", "vote"};
            this.callback.onNavClicked(navUrls[this.navHoverIndex]);
        }
    }

    public boolean processKey(int key) {
        if (this.messages[0].length() > 0) {
            this.messages = new String[]{""};
        }
        boolean validKey = this.isValidKey(key);
        if (this.cursorPos == 0) {
            if (this.showTwoFactorAuth) {
                return this.processTwoFactorKey(key, validKey);
            }
            return this.processUsernameKey(key, validKey);
        }
        if (this.cursorPos == 1) {
            return this.processPasswordKey(key, validKey);
        }
        return false;
    }

    private boolean processTwoFactorKey(int key, boolean validKey) {
        if (key == 8 && this.currentPinCode.length() > 0) {
            this.currentPinCode = this.currentPinCode.substring(0, this.currentPinCode.length() - 1);
        }
        if (validKey && this.showTwoFactorAuth) {
            this.currentPinCode = this.currentPinCode + (char)key;
        }
        if (this.currentPinCode.length() > 4) {
            this.currentPinCode = this.currentPinCode.substring(0, 4);
        }
        return (key == 10 || key == 13) && this.currentPinCode.length() == 4;
    }

    private boolean processUsernameKey(int key, boolean validKey) {
        if (key == 8 && this.username.length() > 0) {
            this.username = this.username.substring(0, this.username.length() - 1);
        }
        if (key == 9) {
            this.cursorPos = 1;
        }
        if (key == 10 || key == 13) {
            if (this.username.length() > 0 && this.password.length() > 0) {
                return true;
            }
            this.cursorPos = 1;
        }
        if (validKey) {
            this.username = this.username + (char)key;
            this.username = this.optimizeText(this.username.toLowerCase());
        }
        if (this.username.length() > 12) {
            this.username = this.username.substring(0, 12);
        }
        return false;
    }

    private boolean processPasswordKey(int key, boolean validKey) {
        if (key == 8 && this.password.length() > 0) {
            this.password = this.password.substring(0, this.password.length() - 1);
        }
        if (key == 9) {
            this.cursorPos = 0;
        }
        if ((key == 10 || key == 13) && this.username.length() > 0 && this.password.length() > 0) {
            return true;
        }
        if (validKey) {
            this.password = this.password + (char)key;
        }
        if (this.password.length() > 20) {
            this.password = this.password.substring(0, 20);
        }
        return false;
    }

    private boolean isValidKey(int key) {
        String validChars = this.showTwoFactorAuth ? VALID_AUTH_KEYS : VALID_USER_PASS_CHARS;
        for (int i = 0; i < validChars.length(); ++i) {
            if (key != validChars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public void loadSavedAccounts() {
        try {
            File file = new File(this.getSavePath() + "saved_accounts.txt");
            if (!file.exists()) {
                return;
            }
            this.savedAccounts.clear();
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split(":");
                    if (parts.length != 2) continue;
                    this.savedAccounts.add(new SavedAccount(parts[0], parts[1]));
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load saved accounts: " + e.getMessage());
        }
    }

    public void saveSavedAccounts() {
        try {
            File file = new File(this.getSavePath() + "saved_accounts.txt");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (SavedAccount acc : this.savedAccounts) {
                    writer.write(acc.username + ":" + acc.password);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save accounts: " + e.getMessage());
        }
    }

    private String getSavePath() {
        String path = System.getProperty("user.home") + "/.teragard/";
        new File(path).mkdirs();
        return path;
    }

    public void loadUISprites() {
        try {
            String assetsPath = System.getProperty("user.home") + "/Desktop/client assets/";
            this.loginLogo = this.loadSpriteFromFile(assetsPath + "client logo.png");
            this.discordButton = this.loadSpriteFromFile(assetsPath + "discord normal.png");
            this.discordButtonHover = this.loadSpriteFromFile(assetsPath + "discord hover.png");
            this.messageBar = this.loadSpriteFromFile(assetsPath + "message bar.png");
        }
        catch (Exception e) {
            System.err.println("Failed to load login UI sprites: " + e.getMessage());
        }
    }

    private Sprite loadSpriteFromFile(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            return new Sprite(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean hasSprite(int id) {
        return SpriteLoader.sprites != null && id < SpriteLoader.sprites.length && SpriteLoader.sprites[id] != null;
    }

    private String getStars(String s) {
        StringBuilder stars = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            stars.append("*");
        }
        return stars.toString();
    }

    private String optimizeText(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s;
    }

    private void drawColorBox(int color, int x, int y, int width, int height) {
        DrawingArea.drawPixels(height, y, color, width, x);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username != null ? username : "";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password != null ? password : "";
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public void setCursorPos(int pos) {
        this.cursorPos = pos;
    }

    public String[] getMessages() {
        return this.messages;
    }

    public void setMessages(String ... messages) {
        this.messages = messages;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public boolean isShowTwoFactorAuth() {
        return this.showTwoFactorAuth;
    }

    public void setShowTwoFactorAuth(boolean show) {
        this.showTwoFactorAuth = show;
    }

    public boolean isShowCaptcha() {
        return this.showCaptcha;
    }

    public void setShowCaptcha(boolean show) {
        this.showCaptcha = show;
    }

    public String getCurrentPinCode() {
        return this.currentPinCode;
    }

    public void setCurrentPinCode(String code) {
        this.currentPinCode = code;
    }

    public void setCaptcha(Sprite captcha) {
        this.captcha = captcha;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debug) {
        this.debugMode = debug;
    }

    public boolean isLoginButtonHover() {
        return this.loginButtonHover;
    }

    public boolean isInput1Hover() {
        return this.input1Hover;
    }

    public boolean isInput2Hover() {
        return this.input2Hover;
    }

    public boolean isSoundHover() {
        return this.soundHover;
    }

    public boolean isDiscordHover() {
        return this.discordHover;
    }

    public boolean isRememberMeButtonHover() {
        return this.rememberMeButtonHover;
    }

    public static interface LoginCallback {
        public void onLogin(String var1, String var2);

        public void onRememberMeToggled(boolean var1);

        public void onDiscordClicked();

        public void onNavClicked(String var1);

        public int getMouseX();

        public int getMouseY();
    }

    public static class SavedAccount {
        public String username;
        public String password;

        public SavedAccount(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

