/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui;

import com.teragard.ui.UIAssets;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public class ModernLoadingScreen {
    private static final Color TEXT_PRIMARY = new Color(240, 240, 250);
    private static final Color TEXT_SECONDARY = new Color(160, 160, 180);
    private static final Color PROGRESS_FILL = new Color(80, 160, 80);
    private static long animationStart = System.currentTimeMillis();
    private static int currentPercent = 0;
    private static int targetPercent = 0;
    private static LoadingStage currentStage = LoadingStage.INITIALIZING;
    private static String currentMessage = "";
    private static float fadeOpacity = 1.0f;
    private static long completionTime = 0L;
    private static boolean loadingComplete = false;
    private static String[] loadingTips = new String[]{"Tip: Use presets to save your favorite gear setups!", "Tip: Press F11 to toggle fullscreen mode", "Tip: Right-click items for more options", "Tip: Join our Discord community for updates!", "Welcome to Tergard - Adventure awaits!"};
    private static int currentTipIndex = 0;

    public static void draw(Graphics2D g, int width, int height, int percent, String message) {
        long timeSinceComplete;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        targetPercent = Math.min(100, Math.max(0, percent));
        if (message != null && !message.isEmpty()) {
            currentMessage = message;
        }
        if (currentPercent < targetPercent) {
            int diff = targetPercent - currentPercent;
            int increment = currentPercent >= 90 ? Math.max(1, diff / 10) : (currentPercent >= 70 ? Math.max(1, diff / 7) : Math.max(2, diff / 5));
            currentPercent += increment;
        }
        if (currentPercent >= 100 && !loadingComplete) {
            loadingComplete = true;
            completionTime = System.currentTimeMillis();
        }
        if (loadingComplete && (timeSinceComplete = System.currentTimeMillis() - completionTime) > 500L) {
            float fadeProgress = Math.min(1.0f, (float)(timeSinceComplete - 500L) / 1000.0f);
            fadeOpacity = 1.0f - fadeProgress;
        }
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, fadeOpacity));
        BufferedImage bg = UIAssets.getLoadingBackgroundWithLogo();
        if (bg != null) {
            UIAssets.drawCover(g, bg, 0, 0, width, height);
        } else {
            ModernLoadingScreen.drawFallbackBackground(g, width, height);
        }
        ModernLoadingScreen.drawProgressBar(g, width, height);
        g.setComposite(originalComposite);
    }

    private static void drawProgressBar(Graphics2D g, int width, int height) {
        BufferedImage outsideBar = UIAssets.getLoadingOutsideContainer();
        BufferedImage insideBar = UIAssets.getLoadingInsideContainer();
        if (outsideBar != null && insideBar != null) {
            int barX = (width - outsideBar.getWidth()) / 2;
            int barY = height / 2 + 50;
            g.drawImage((Image)outsideBar, barX, barY, null);
            int maxFillWidth = insideBar.getWidth();
            int fillWidth = (int)((double)maxFillWidth * ((double)currentPercent / 100.0));
            if (fillWidth > 0) {
                int insideX = barX + (outsideBar.getWidth() - insideBar.getWidth()) / 2;
                int insideY = barY + (outsideBar.getHeight() - insideBar.getHeight()) / 2;
                Shape oldClip = g.getClip();
                g.setClip(insideX, insideY, fillWidth, insideBar.getHeight());
                g.drawImage((Image)insideBar, insideX, insideY, null);
                g.setClip(oldClip);
            }
            g.setFont(new Font("Arial", 1, 14));
            g.setColor(TEXT_PRIMARY);
            String percentText = currentPercent + "%";
            FontMetrics fm = g.getFontMetrics();
            int textX = barX + (outsideBar.getWidth() - fm.stringWidth(percentText)) / 2;
            int textY = barY + outsideBar.getHeight() / 2 + 5;
            g.drawString(percentText, textX, textY);
        } else {
            ModernLoadingScreen.drawFallbackProgressBar(g, width, height);
        }
    }

    private static void drawFallbackProgressBar(Graphics2D g, int width, int height) {
        int barWidth = 400;
        int barHeight = 25;
        int x = (width - barWidth) / 2;
        int y = height / 2 + 50;
        g.setColor(new Color(40, 40, 40));
        g.fillRoundRect(x, y, barWidth, barHeight, 10, 10);
        int fillWidth = (int)((double)barWidth * ((double)currentPercent / 100.0));
        if (fillWidth > 0) {
            g.setColor(PROGRESS_FILL);
            g.fillRoundRect(x, y, fillWidth, barHeight, 10, 10);
        }
        g.setColor(new Color(80, 80, 80));
        g.drawRoundRect(x, y, barWidth, barHeight, 10, 10);
        g.setFont(new Font("Arial", 1, 14));
        g.setColor(TEXT_PRIMARY);
        String percentText = currentPercent + "%";
        FontMetrics fm = g.getFontMetrics();
        g.drawString(percentText, x + (barWidth - fm.stringWidth(percentText)) / 2, y + barHeight / 2 + 5);
    }

    private static void drawLoadingMessage(Graphics2D g, int width, int height) {
        g.setFont(new Font("Arial", 0, 16));
        g.setColor(TEXT_PRIMARY);
        String msg = currentMessage.isEmpty() ? currentStage.getMessage() : currentMessage;
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, (width - fm.stringWidth(msg)) / 2, height / 2 + 100);
    }

    private static void drawLoadingTip(Graphics2D g, int width, int height) {
        g.setFont(new Font("Arial", 2, 13));
        g.setColor(TEXT_SECONDARY);
        String tip = loadingTips[currentTipIndex];
        FontMetrics fm = g.getFontMetrics();
        g.drawString(tip, (width - fm.stringWidth(tip)) / 2, height - 60);
    }

    private static void drawFallbackBackground(Graphics2D g, int width, int height) {
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(20, 35, 25), 0.0f, height, new Color(30, 50, 35));
        g.setPaint(gradient);
        g.fillRect(0, 0, width, height);
        g.setColor(new Color(100, 180, 100));
        g.setFont(new Font("Arial", 1, 48));
        FontMetrics fm = g.getFontMetrics();
        String title = "TERGARD";
        g.drawString(title, (width - fm.stringWidth(title)) / 2, height / 3);
    }

    public static boolean isFadedOut() {
        return fadeOpacity <= 0.0f;
    }

    public static void reset() {
        currentPercent = 0;
        targetPercent = 0;
        fadeOpacity = 1.0f;
        loadingComplete = false;
        completionTime = 0L;
        animationStart = System.currentTimeMillis();
    }

    public static void setStage(LoadingStage stage) {
        currentStage = stage;
        currentMessage = stage.getMessage();
        targetPercent = stage.getStartPercent();
    }

    public static enum LoadingStage {
        INITIALIZING("Initializing client...", 0, 10),
        DOWNLOADING_ASSETS("Downloading game assets...", 10, 40),
        LOADING_CONFIGS("Loading configurations...", 40, 60),
        LOADING_SPRITES("Loading sprites...", 60, 80),
        CONNECTING("Connecting to server...", 80, 95),
        FINALIZING("Finalizing...", 95, 100);

        private final String message;
        private final int startPercent;
        private final int endPercent;

        private LoadingStage(String message, int startPercent, int endPercent) {
            this.message = message;
            this.startPercent = startPercent;
            this.endPercent = endPercent;
        }

        public String getMessage() {
            return this.message;
        }

        public int getStartPercent() {
            return this.startPercent;
        }

        public int getEndPercent() {
            return this.endPercent;
        }
    }
}

