/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui;

import com.teragard.ui.UIAssets;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ModernLoginScreen {
    private static final Color TEXT_PRIMARY = new Color(200, 200, 200);
    private static final Color TEXT_PLACEHOLDER = new Color(120, 120, 120);
    private static final Color ERROR_COLOR = new Color(255, 100, 100);
    private static long animationStart = System.currentTimeMillis();
    private static float panelOpacity = 0.0f;
    private static final int LOGIN_BOX_WIDTH = 340;
    private static final int LOGIN_BOX_HEIGHT = 220;
    private static final int USERNAME_FIELD_Y_OFFSET = 35;
    private static final int PASSWORD_FIELD_Y_OFFSET = 95;
    private static final int SAVE_CHECKBOX_Y_OFFSET = 155;
    private static final int FIELD_HEIGHT = 30;
    private static final int FIELD_X_PADDING = 40;

    public static void draw(Graphics2D g, int width, int height, String username, String password, int cursorPos, boolean input1Hover, boolean input2Hover, boolean loginButtonHover, boolean rememberMe, String errorMessage, int loopCycle) {
        BufferedImage discordBtn;
        BufferedImage loginBtn;
        BufferedImage saveIcon;
        BufferedImage bgWithLogo;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        long elapsed = System.currentTimeMillis() - animationStart;
        if (panelOpacity < 1.0f) {
            panelOpacity = Math.min(1.0f, (float)elapsed / 800.0f);
        }
        if ((bgWithLogo = UIAssets.getLoginBackgroundWithLogo()) != null) {
            UIAssets.drawCover(g, bgWithLogo, 0, 0, width, height);
        } else {
            ModernLoginScreen.drawFallbackBackground(g, width, height);
        }
        int boxX = (width - 340) / 2;
        int boxY = (height - 220) / 2 + 40;
        ModernLoginScreen.drawInputText(g, username, "Username", boxX + 40, boxY + 35, 260, 30, cursorPos == 0, input1Hover, loopCycle, false);
        ModernLoginScreen.drawInputText(g, password, "Password", boxX + 40, boxY + 95, 260, 30, cursorPos == 1, input2Hover, loopCycle, true);
        BufferedImage bufferedImage = saveIcon = rememberMe ? UIAssets.getSaveIconHover() : UIAssets.getSaveIconNormal();
        if (saveIcon != null) {
            int saveX = boxX + 40 - 5;
            int saveY = boxY + 155;
            g.drawImage((Image)saveIcon, saveX, saveY, null);
        }
        BufferedImage bufferedImage2 = loginBtn = loginButtonHover ? UIAssets.getLoginButtonHover() : UIAssets.getLoginButtonNormal();
        if (loginBtn != null) {
            int btnX = boxX + (340 - loginBtn.getWidth()) / 2;
            int btnY = boxY + 220 + 15;
            g.drawImage((Image)loginBtn, btnX, btnY, null);
        }
        if ((discordBtn = UIAssets.getDiscordButtonNormal()) != null) {
            int discordX = width - discordBtn.getWidth() - 20;
            int discordY = height - discordBtn.getHeight() - 20;
            g.drawImage((Image)discordBtn, discordX, discordY, null);
        }
        if (errorMessage != null && !errorMessage.isEmpty()) {
            BufferedImage msgBar = UIAssets.getMessageBar();
            int msgY = boxY + 220 + 70;
            if (msgBar != null) {
                int msgBarX = (width - msgBar.getWidth()) / 2;
                g.drawImage((Image)msgBar, msgBarX, msgY - 5, null);
            }
            g.setColor(ERROR_COLOR);
            g.setFont(new Font("Arial", 0, 13));
            FontMetrics fm = g.getFontMetrics();
            g.drawString(errorMessage, (width - fm.stringWidth(errorMessage)) / 2, msgY + 12);
        }
    }

    private static void drawInputText(Graphics2D g, String text, String placeholder, int x, int y, int width, int height, boolean focused, boolean hover, int loopCycle, boolean isPassword) {
        g.setFont(new Font("Arial", 0, 14));
        int textY = y + height / 2 + 5;
        int textX = x + 5;
        if (text == null || text.isEmpty()) {
            if (focused && loopCycle % 40 < 20) {
                g.setColor(TEXT_PRIMARY);
                g.drawString("|", textX, textY);
            }
        } else {
            Object displayText;
            g.setColor(TEXT_PRIMARY);
            Object object = displayText = isPassword ? ModernLoginScreen.getStars(text) : text;
            if (focused && loopCycle % 40 < 20) {
                displayText = (String)displayText + "|";
            }
            g.drawString((String)displayText, textX, textY);
        }
    }

    private static void drawFallbackBackground(Graphics2D g, int width, int height) {
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(20, 35, 25), 0.0f, height, new Color(30, 50, 35));
        g.setPaint(gradient);
        g.fillRect(0, 0, width, height);
        g.setColor(new Color(100, 180, 100));
        g.setFont(new Font("Arial", 1, 48));
        FontMetrics fm = g.getFontMetrics();
        String title = "TERGARD";
        g.drawString(title, (width - fm.stringWidth(title)) / 2, 100);
    }

    private static String getStars(String text) {
        StringBuilder stars = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            stars.append("\u2022");
        }
        return stars.toString();
    }

    public static void reset() {
        animationStart = System.currentTimeMillis();
        panelOpacity = 0.0f;
    }

    public static Rectangle getUsernameFieldBounds(int screenWidth, int screenHeight) {
        int boxX = (screenWidth - 340) / 2;
        int boxY = (screenHeight - 220) / 2 + 40;
        return new Rectangle(boxX + 40, boxY + 35, 260, 30);
    }

    public static Rectangle getPasswordFieldBounds(int screenWidth, int screenHeight) {
        int boxX = (screenWidth - 340) / 2;
        int boxY = (screenHeight - 220) / 2 + 40;
        return new Rectangle(boxX + 40, boxY + 95, 260, 30);
    }

    public static Rectangle getLoginButtonBounds(int screenWidth, int screenHeight) {
        BufferedImage loginBtn = UIAssets.getLoginButtonNormal();
        if (loginBtn == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int boxX = (screenWidth - 340) / 2;
        int boxY = (screenHeight - 220) / 2 + 40;
        int btnX = boxX + (340 - loginBtn.getWidth()) / 2;
        int btnY = boxY + 220 + 15;
        return new Rectangle(btnX, btnY, loginBtn.getWidth(), loginBtn.getHeight());
    }

    public static Rectangle getRememberMeBounds(int screenWidth, int screenHeight) {
        int boxX = (screenWidth - 340) / 2;
        int boxY = (screenHeight - 220) / 2 + 40;
        return new Rectangle(boxX + 40 - 5, boxY + 155, 100, 20);
    }
}

