/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui;

import com.teragard.Client;
import com.teragard.ItemDef;
import com.teragard.Jframe;
import com.teragard.ui.SpriteRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ModernSidebar
extends JFrame {
    private static ModernSidebar instance;
    private static final int SIDEBAR_WIDTH = 420;
    private static final int COLLAPSED_WIDTH = 32;
    private static final int TITLE_BAR_HEIGHT = 32;
    private static final int TAB_HEIGHT = 40;
    private static final int DEFAULT_HEIGHT = 800;
    private Point dragOffset;
    private boolean isDragging = false;
    private boolean isCollapsed = false;
    private int expandedWidth = 420;
    private JButton collapseButton;
    private JPanel contentContainer;
    private static final int RESIZE_BORDER_WIDTH = 6;
    private static final int MIN_SIDEBAR_WIDTH = 250;
    private static final int MAX_SIDEBAR_WIDTH = 600;
    private boolean isResizing = false;
    private int resizeStartX;
    private int resizeStartWidth;
    private static final String PREF_X = "sidebar_x";
    private static final String PREF_Y = "sidebar_y";
    private static final String PREF_WIDTH = "sidebar_width";
    private static final String PREF_COLLAPSED = "sidebar_collapsed";
    private static final String PREF_VISIBLE = "sidebar_visible";
    private Preferences prefs;
    private JPanel mainContentPanel;
    private static final Color BG_PRIMARY;
    private static final Color BG_SECONDARY;
    private static final Color BG_TERTIARY;
    private static final Color BG_HOVER;
    private static final Color ACCENT;
    private static final Color TEXT_PRIMARY;
    private static final Color TEXT_SECONDARY;
    private static final Color BORDER_COLOR;
    private JPanel tabButtonPanel;
    private JPanel contentPanel;
    private CardLayout cardLayout;
    private List<SidebarTab> tabs;
    private int selectedTabIndex = 0;
    private JPanel presetListPanel;
    private List<PresetData> currentPresets = new ArrayList<PresetData>();
    private JComboBox<String> presetDropdown;
    private JLabel presetDetailsLabel;
    private JPanel presetDetailsContainer;
    private JButton loadPresetButton;
    private JButton createPresetButton;
    private JButton deletePresetButton;
    private JButton updatePresetButton;
    private List<PresetData> filteredPresets = new ArrayList<PresetData>();
    private static final Map<Integer, String> itemNameCache;
    private static final Map<Integer, Image> spriteCache;
    private Timer spriteRefreshTimer;
    private int lastPendingCount = 0;
    private JCheckBox notifyDropsCheckbox;
    private JCheckBox notifyXpCheckbox;
    private JCheckBox autoCollapseCheckbox;
    private long sessionStartTime = System.currentTimeMillis();
    private JLabel playtimeLabel;
    private JLabel totalXpLabel;
    private JLabel killCountLabel;
    private JLabel deathCountLabel;
    private JLabel lootValueLabel;
    private JPanel topLootPanel;
    private int sessionKills = 0;
    private int sessionDeaths = 0;
    private long sessionXp = 0L;
    private long sessionLootValue = 0L;
    private JTextField itemSearchField;
    private JPanel itemResultPanel;

    public ModernSidebar() {
        super("Teragard Sidebar");
        instance = this;
        this.tabs = new ArrayList<SidebarTab>();
        this.prefs = Preferences.userNodeForPackage(ModernSidebar.class);
        this.initializeWindow();
        this.initializeUI();
        this.createDefaultTabs();
        this.loadSavedState();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (!ModernSidebar.this.isResizing) {
                    ModernSidebar.this.saveState();
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (!ModernSidebar.this.isResizing) {
                    ModernSidebar.this.saveState();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ModernSidebar.this.saveState();
            }
        });
    }

    public static ModernSidebar getInstance() {
        return instance;
    }

    private void initializeWindow() {
        this.setUndecorated(true);
        int gameHeight = 800;
        try {
            JFrame gameFrame = Jframe.frame;
            if (gameFrame != null) {
                gameHeight = gameFrame.getHeight();
                if (gameHeight < 400 || gameHeight > 1200) {
                    gameHeight = 600;
                }
            } else {
                gameHeight = 600;
            }
        }
        catch (Exception e) {
            gameHeight = 600;
        }
        this.setSize(420, gameHeight);
        this.setDefaultCloseOperation(1);
        this.setAlwaysOnTop(false);
        this.setResizable(false);
        this.setFocusableWindowState(false);
        try {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        JFrame gameFrame = Jframe.frame;
                        if (gameFrame != null && gameFrame.isFocused()) {
                            ModernSidebar.this.toFront();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ModernSidebar.this.isCollapsed && e.getX() <= 6) {
                    ModernSidebar.this.isResizing = true;
                    ModernSidebar.this.resizeStartX = e.getXOnScreen();
                    ModernSidebar.this.resizeStartWidth = ModernSidebar.this.getWidth();
                    ModernSidebar.this.setCursor(Cursor.getPredefinedCursor(10));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ModernSidebar.this.isResizing) {
                    ModernSidebar.this.isResizing = false;
                    ModernSidebar.this.expandedWidth = ModernSidebar.this.getWidth();
                    ModernSidebar.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!ModernSidebar.this.isCollapsed && e.getX() <= 6) {
                    ModernSidebar.this.setCursor(Cursor.getPredefinedCursor(10));
                } else if (!ModernSidebar.this.isResizing) {
                    ModernSidebar.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ModernSidebar.this.isResizing) {
                    int deltaX = ModernSidebar.this.resizeStartX - e.getXOnScreen();
                    int newWidth = ModernSidebar.this.resizeStartWidth + deltaX;
                    newWidth = Math.max(250, Math.min(600, newWidth));
                    int newX = ModernSidebar.this.getX() - (newWidth - ModernSidebar.this.getWidth());
                    ModernSidebar.this.setLocation(newX, ModernSidebar.this.getY());
                    ModernSidebar.this.setSize(newWidth, ModernSidebar.this.getHeight());
                    ModernSidebar.this.revalidate();
                    ModernSidebar.this.repaint();
                }
            }
        });
    }

    private void initializeUI() {
        this.mainContentPanel = new JPanel(new BorderLayout());
        this.mainContentPanel.setBackground(BG_PRIMARY);
        this.mainContentPanel.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 2));
        JPanel resizeHandle = this.createResizeHandle();
        this.mainContentPanel.add((Component)resizeHandle, "West");
        JPanel titleBar = this.createTitleBar();
        this.mainContentPanel.add((Component)titleBar, "North");
        this.contentContainer = new JPanel(new BorderLayout());
        this.contentContainer.setBackground(BG_PRIMARY);
        JPanel tabPanel = new JPanel(new BorderLayout());
        tabPanel.setBackground(BG_SECONDARY);
        tabPanel.setPreferredSize(new Dimension(420, 40));
        this.tabButtonPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.tabButtonPanel.setBackground(BG_SECONDARY);
        tabPanel.add((Component)this.tabButtonPanel, "Center");
        this.contentContainer.add((Component)tabPanel, "North");
        this.cardLayout = new CardLayout();
        this.contentPanel = new JPanel(this.cardLayout);
        this.contentPanel.setBackground(BG_PRIMARY);
        this.contentContainer.add((Component)this.contentPanel, "Center");
        this.mainContentPanel.add((Component)this.contentContainer, "Center");
        this.setContentPane(this.mainContentPanel);
    }

    private JPanel createResizeHandle() {
        final JPanel handle = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (!ModernSidebar.this.isCollapsed) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setColor(new Color(80, 80, 85));
                    int centerX = this.getWidth() / 2;
                    int startY = this.getHeight() / 2 - 15;
                    for (int i = 0; i < 3; ++i) {
                        g2d.fillRect(centerX - 2, startY + i * 10, 4, 2);
                    }
                }
            }
        };
        handle.setPreferredSize(new Dimension(6, 0));
        handle.setBackground(BG_SECONDARY);
        handle.setCursor(Cursor.getPredefinedCursor(10));
        handle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ModernSidebar.this.isCollapsed) {
                    ModernSidebar.this.isResizing = true;
                    ModernSidebar.this.resizeStartX = e.getXOnScreen();
                    ModernSidebar.this.resizeStartWidth = ModernSidebar.this.getWidth();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ModernSidebar.this.isResizing) {
                    ModernSidebar.this.isResizing = false;
                    ModernSidebar.this.expandedWidth = ModernSidebar.this.getWidth();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ModernSidebar.this.isCollapsed) {
                    handle.setBackground(BG_HOVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                handle.setBackground(BG_SECONDARY);
            }
        });
        handle.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ModernSidebar.this.isResizing) {
                    int deltaX = ModernSidebar.this.resizeStartX - e.getXOnScreen();
                    int newWidth = ModernSidebar.this.resizeStartWidth + deltaX;
                    newWidth = Math.max(250, Math.min(600, newWidth));
                    int newX = ModernSidebar.this.getX() - (newWidth - ModernSidebar.this.getWidth());
                    ModernSidebar.this.setLocation(newX, ModernSidebar.this.getY());
                    ModernSidebar.this.setSize(newWidth, ModernSidebar.this.getHeight());
                    ModernSidebar.this.revalidate();
                    ModernSidebar.this.repaint();
                }
            }
        });
        return handle;
    }

    private JPanel createTitleBar() {
        JPanel titleBar = new JPanel(new BorderLayout());
        titleBar.setBackground(BG_SECONDARY);
        titleBar.setPreferredSize(new Dimension(420, 32));
        titleBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR));
        JLabel titleLabel = new JLabel("  Teragard");
        titleLabel.setForeground(TEXT_PRIMARY);
        titleLabel.setFont(new Font("Arial", 1, 12));
        titleBar.add((Component)titleLabel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(2, 2, 0));
        controlPanel.setBackground(BG_SECONDARY);
        this.collapseButton = this.createControlButton("\u25c0", "Collapse sidebar");
        this.collapseButton.addActionListener(e -> this.toggleCollapse());
        controlPanel.add(this.collapseButton);
        final JButton closeButton = this.createControlButton("\u2715", "Hide sidebar");
        closeButton.addActionListener(e -> this.setVisible(false));
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                closeButton.setBackground(new Color(200, 60, 60));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                closeButton.setBackground(BG_TERTIARY);
            }
        });
        controlPanel.add(closeButton);
        titleBar.add((Component)controlPanel, "East");
        titleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ModernSidebar.this.isDragging = true;
                ModernSidebar.this.dragOffset = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ModernSidebar.this.isDragging = false;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ModernSidebar.this.toggleCollapse();
                }
            }
        });
        titleBar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ModernSidebar.this.isDragging) {
                    Point currCoords = e.getLocationOnScreen();
                    ModernSidebar.this.setLocation(currCoords.x - ModernSidebar.this.dragOffset.x, currCoords.y - ModernSidebar.this.dragOffset.y);
                }
            }
        });
        return titleBar;
    }

    private JButton createControlButton(String text, String tooltip) {
        final JButton button = new JButton(text);
        button.setPreferredSize(new Dimension(28, 24));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setBackground(BG_TERTIARY);
        button.setForeground(TEXT_PRIMARY);
        button.setFont(new Font("Arial", 0, 12));
        button.setToolTipText(tooltip);
        button.setOpaque(true);
        button.setCursor(new Cursor(12));
        button.addMouseListener(new MouseAdapter(){
            Color originalBg = BG_TERTIARY;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.getBackground().equals(BG_TERTIARY)) {
                    button.setBackground(BG_HOVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (button.getBackground().equals(BG_HOVER)) {
                    button.setBackground(BG_TERTIARY);
                }
            }
        });
        return button;
    }

    public void toggleCollapse() {
        boolean bl = this.isCollapsed = !this.isCollapsed;
        if (this.isCollapsed) {
            this.contentContainer.setVisible(false);
            this.setSize(32, this.getHeight());
            this.collapseButton.setText("\u25b6");
            this.collapseButton.setToolTipText("Expand sidebar");
        } else {
            this.setSize(this.expandedWidth, this.getHeight());
            this.contentContainer.setVisible(true);
            this.collapseButton.setText("\u25c0");
            this.collapseButton.setToolTipText("Collapse sidebar");
        }
        this.revalidate();
        this.repaint();
        this.saveState();
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void toggleVisibility() {
        if (this.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
            this.positionNextToGameWindow();
            this.toFront();
        }
        this.saveState();
    }

    public void showSidebar() {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.positionNextToGameWindow();
        }
        this.toFront();
    }

    public void hideSidebar() {
        this.setVisible(false);
        this.saveState();
    }

    private void saveState() {
        try {
            this.prefs.putInt(PREF_X, this.getX());
            this.prefs.putInt(PREF_Y, this.getY());
            this.prefs.putInt(PREF_WIDTH, this.isCollapsed ? this.expandedWidth : this.getWidth());
            this.prefs.putBoolean(PREF_COLLAPSED, this.isCollapsed);
            this.prefs.putBoolean(PREF_VISIBLE, this.isVisible());
            this.prefs.flush();
        }
        catch (Exception e) {
            System.err.println("[ModernSidebar] Error saving state: " + e.getMessage());
        }
    }

    private void loadSavedState() {
        try {
            int savedX = this.prefs.getInt(PREF_X, -1);
            int savedY = this.prefs.getInt(PREF_Y, -1);
            int savedWidth = this.prefs.getInt(PREF_WIDTH, 420);
            boolean savedCollapsed = this.prefs.getBoolean(PREF_COLLAPSED, false);
            boolean savedVisible = this.prefs.getBoolean(PREF_VISIBLE, true);
            if (savedWidth >= 250 && savedWidth <= 600) {
                this.expandedWidth = savedWidth;
                if (!savedCollapsed) {
                    this.setSize(savedWidth, this.getHeight());
                }
            }
            if (savedX >= 0 && savedY >= 0) {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle screenBounds = ge.getMaximumWindowBounds();
                if (savedX + 50 < screenBounds.x + screenBounds.width && savedY + 50 < screenBounds.y + screenBounds.height) {
                    this.setLocation(savedX, savedY);
                }
            }
            if (savedCollapsed) {
                this.isCollapsed = true;
                this.contentContainer.setVisible(false);
                this.setSize(32, this.getHeight());
                this.collapseButton.setText("\u25b6");
                this.collapseButton.setToolTipText("Expand sidebar");
            }
        }
        catch (Exception e) {
            System.err.println("[ModernSidebar] Error loading saved state: " + e.getMessage());
        }
    }

    public void positionNextToGameWindow() {
        try {
            JFrame gameFrame = Jframe.frame;
            if (gameFrame != null && gameFrame.isVisible()) {
                Point gameLocation = gameFrame.getLocation();
                Dimension gameSize = gameFrame.getSize();
                int sidebarX = gameLocation.x + gameSize.width;
                int sidebarY = gameLocation.y;
                this.setLocation(sidebarX, sidebarY);
                this.setSize(420, gameSize.height);
            }
        }
        catch (Exception e) {
            System.err.println("[ModernSidebar] Error positioning window: " + e.getMessage());
        }
    }

    public void addTab(String name, String icon, JPanel content) {
        SidebarTab tab = new SidebarTab(name, icon, content);
        this.tabs.add(tab);
        JButton tabButton = this.createTabButton(tab, this.tabs.size() - 1);
        this.tabButtonPanel.add(tabButton);
        this.contentPanel.add((Component)content, name);
        if (this.tabs.size() == 1) {
            this.selectTab(0);
        }
        this.revalidate();
        this.repaint();
    }

    private JButton createTabButton(SidebarTab tab, final int index) {
        final JButton button = new JButton(tab.name);
        button.setPreferredSize(new Dimension(100, 40));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setForeground(TEXT_SECONDARY);
        button.setFont(new Font("Arial", 1, 13));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ModernSidebar.this.selectedTabIndex != index) {
                    button.setBackground(BG_HOVER);
                    button.setOpaque(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ModernSidebar.this.selectedTabIndex != index) {
                    button.setOpaque(false);
                }
            }
        });
        button.addActionListener(e -> this.selectTab(index));
        return button;
    }

    private void selectTab(int index) {
        this.selectedTabIndex = index;
        SidebarTab tab = this.tabs.get(index);
        this.cardLayout.show(this.contentPanel, tab.name);
        Component[] buttons = this.tabButtonPanel.getComponents();
        for (int i = 0; i < buttons.length; ++i) {
            JButton btn = (JButton)buttons[i];
            if (i == index) {
                btn.setBackground(BG_PRIMARY);
                btn.setOpaque(true);
                btn.setForeground(ACCENT);
                btn.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, ACCENT));
                continue;
            }
            btn.setOpaque(false);
            btn.setForeground(TEXT_SECONDARY);
            btn.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, BG_SECONDARY));
        }
    }

    private void createDefaultTabs() {
        this.addTab("Presets", "", this.createPresetsPanel());
        this.addTab("Info", "", this.createInfoPanel());
    }

    private JPanel createPresetsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 8));
        panel.setBackground(BG_PRIMARY);
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.setBackground(BG_PRIMARY);
        topPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        JLabel selectLabel = new JLabel("Selected:");
        selectLabel.setForeground(TEXT_SECONDARY);
        selectLabel.setFont(new Font("Arial", 0, 12));
        this.presetDropdown = new JComboBox();
        this.presetDropdown.setMaximumSize(new Dimension(200, 28));
        this.presetDropdown.setPreferredSize(new Dimension(200, 28));
        this.presetDropdown.setBackground(BG_TERTIARY);
        this.presetDropdown.setForeground(TEXT_PRIMARY);
        this.presetDropdown.setFont(new Font("Arial", 0, 12));
        this.presetDropdown.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        this.presetDropdown.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                label.setBackground(isSelected ? BG_HOVER : BG_TERTIARY);
                label.setForeground(isSelected ? ACCENT : TEXT_PRIMARY);
                label.setBorder(new EmptyBorder(4, 8, 4, 8));
                return label;
            }
        });
        this.presetDropdown.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                JButton button = new JButton();
                button.setBackground(BG_TERTIARY);
                button.setBorder(BorderFactory.createEmptyBorder());
                return button;
            }
        });
        this.presetDropdown.addItem("Login to view presets");
        this.presetDropdown.setEnabled(false);
        this.presetDropdown.addActionListener(e -> this.onPresetSelected());
        this.createPresetButton = this.createCompactButton("Create", new Color(40, 160, 75));
        this.createPresetButton.setEnabled(false);
        this.createPresetButton.addActionListener(e -> this.onSavePreset());
        this.deletePresetButton = this.createCompactButton("Delete", new Color(180, 50, 50));
        this.deletePresetButton.setEnabled(false);
        this.deletePresetButton.addActionListener(e -> this.onDeletePreset());
        topPanel.add(selectLabel);
        topPanel.add(Box.createHorizontalStrut(8));
        topPanel.add(this.presetDropdown);
        topPanel.add(Box.createHorizontalStrut(8));
        topPanel.add(this.createPresetButton);
        topPanel.add(Box.createHorizontalStrut(4));
        topPanel.add(this.deletePresetButton);
        topPanel.add(Box.createHorizontalGlue());
        this.presetDetailsContainer = new JPanel();
        this.presetDetailsContainer.setLayout(new BorderLayout());
        this.presetDetailsContainer.setBackground(BG_TERTIARY);
        this.presetDetailsLabel = new JLabel("<html><div style='color: #a0a0aa; font-style: italic; text-align: center;'>Select a preset to view equipment</div></html>");
        this.presetDetailsLabel.setFont(new Font("Arial", 0, 12));
        this.presetDetailsLabel.setVerticalAlignment(0);
        this.presetDetailsLabel.setHorizontalAlignment(0);
        this.presetDetailsContainer.add((Component)this.presetDetailsLabel, "Center");
        JScrollPane scrollPane = new JScrollPane(this.presetDetailsContainer);
        scrollPane.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setBackground(BG_TERTIARY);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridLayout(1, 2, 8, 0));
        bottomPanel.setBackground(BG_PRIMARY);
        bottomPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 32));
        this.loadPresetButton = this.createCompactButton("Load", ACCENT);
        this.loadPresetButton.setEnabled(false);
        this.loadPresetButton.addActionListener(e -> this.onLoadPreset());
        this.updatePresetButton = this.createCompactButton("Update", new Color(100, 100, 140));
        this.updatePresetButton.setEnabled(false);
        this.updatePresetButton.addActionListener(e -> this.onUpdatePreset());
        bottomPanel.add(this.loadPresetButton);
        bottomPanel.add(this.updatePresetButton);
        panel.add((Component)topPanel, "North");
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private void onPresetSelected() {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex < 0 || this.filteredPresets.isEmpty()) {
            this.loadPresetButton.setEnabled(false);
            this.updatePresetButton.setEnabled(false);
            this.deletePresetButton.setEnabled(false);
            this.presetDetailsContainer.removeAll();
            this.presetDetailsLabel.setText("<html><div style='color: #a0a0aa; font-style: italic; text-align: center;'>Select a preset to view equipment</div></html>");
            this.presetDetailsContainer.add((Component)this.presetDetailsLabel, "Center");
            this.presetDetailsContainer.revalidate();
            this.presetDetailsContainer.repaint();
            return;
        }
        PresetData preset = this.filteredPresets.get(selectedIndex);
        this.loadPresetButton.setEnabled(true);
        this.updatePresetButton.setEnabled(true);
        this.deletePresetButton.setEnabled(true);
        int equippedCount = 0;
        for (int i = 0; i < 11 && i < preset.equipmentIds.length; ++i) {
            if (preset.equipmentIds[i] <= 0) continue;
            ++equippedCount;
        }
        int inventoryCount = 0;
        if (preset.inventoryJson != null && !preset.inventoryJson.equals("[]")) {
            inventoryCount = preset.inventoryJson.split("\"id\"").length - 1;
        }
        JPanel equipmentPanel = this.createEquipmentGridPanel(preset, equippedCount, inventoryCount);
        this.presetDetailsContainer.removeAll();
        this.presetDetailsContainer.add((Component)equipmentPanel, "Center");
        this.presetDetailsContainer.revalidate();
        this.presetDetailsContainer.repaint();
    }

    private JPanel createEquipmentGridPanel(PresetData preset, int equippedCount, int inventoryCount) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(BG_TERTIARY);
        panel.setBorder(new EmptyBorder(8, 8, 8, 8));
        JPanel sideBySidePanel = new JPanel();
        sideBySidePanel.setLayout(new BoxLayout(sideBySidePanel, 0));
        sideBySidePanel.setBackground(BG_TERTIARY);
        sideBySidePanel.setAlignmentX(0.0f);
        JPanel equipmentSection = new JPanel();
        equipmentSection.setLayout(new BoxLayout(equipmentSection, 1));
        equipmentSection.setBackground(BG_TERTIARY);
        JLabel equipLabel = new JLabel("Equipment");
        equipLabel.setForeground(TEXT_SECONDARY);
        equipLabel.setFont(new Font("Arial", 1, 10));
        JPanel equipmentGrid = new JPanel(new GridLayout(5, 3, 4, 4));
        equipmentGrid.setBackground(new Color(35, 35, 38));
        equipmentGrid.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(6, 6, 6, 6)));
        String[] slotNames = new String[]{"Head", "Cape", "Neck", "Weapon", "Body", "Shield", "Legs", "Hands", "Feet", "Ring", "Ammo"};
        int[] slotOrder = new int[]{-1, 0, -1, 1, 2, 10, 3, 4, 5, -1, 6, -1, 7, 8, 9};
        for (int i = 0; i < 15; ++i) {
            if (slotOrder[i] >= 0 && slotOrder[i] < preset.equipmentIds.length) {
                equipmentGrid.add(this.createEquipmentSlot(slotNames[slotOrder[i]], preset.equipmentIds[slotOrder[i]], 42));
                continue;
            }
            JPanel emptySlot = new JPanel();
            emptySlot.setBackground(new Color(35, 35, 38));
            equipmentGrid.add(emptySlot);
        }
        equipmentSection.add(equipLabel);
        equipmentSection.add(Box.createVerticalStrut(4));
        equipmentSection.add(equipmentGrid);
        sideBySidePanel.add(equipmentSection);
        sideBySidePanel.add(Box.createHorizontalStrut(8));
        JPanel inventorySection = new JPanel();
        inventorySection.setLayout(new BoxLayout(inventorySection, 1));
        inventorySection.setBackground(BG_TERTIARY);
        JLabel invLabel = new JLabel("Inventory");
        invLabel.setForeground(TEXT_SECONDARY);
        invLabel.setFont(new Font("Arial", 1, 10));
        JPanel inventoryGrid = this.createInventoryGrid(preset.inventoryJson);
        inventoryGrid.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(6, 6, 6, 6)));
        inventorySection.add(invLabel);
        inventorySection.add(Box.createVerticalStrut(4));
        inventorySection.add(inventoryGrid);
        sideBySidePanel.add(inventorySection);
        panel.add(sideBySidePanel);
        return panel;
    }

    private JPanel createEquipmentSlot(String slotName, int itemId, int size) {
        final JPanel slot = new JPanel(new BorderLayout());
        slot.setPreferredSize(new Dimension(size, size));
        slot.setBackground(itemId > 0 ? new Color(50, 50, 54) : new Color(30, 30, 34));
        slot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 74), 1), new EmptyBorder(3, 3, 3, 3)));
        if (itemId > 0) {
            String itemName = this.getItemName(itemId);
            Image sprite = this.loadItemSprite(itemId, 1);
            if (sprite != null) {
                ImageIcon icon = new ImageIcon(sprite.getScaledInstance(size - 6, size - 6, 4));
                JLabel imageLabel = new JLabel(icon);
                imageLabel.setHorizontalAlignment(0);
                imageLabel.setVerticalAlignment(0);
                slot.add((Component)imageLabel, "Center");
            } else {
                JLabel placeholderLabel = new JLabel("<html><center><span style='font-size: 9px; color: rgb(150,150,160);'>Loading...</span></center></html>");
                placeholderLabel.setHorizontalAlignment(0);
                placeholderLabel.setVerticalAlignment(0);
                slot.add((Component)placeholderLabel, "Center");
                this.retryLoadingSprite(slot, itemId, size, placeholderLabel);
            }
            slot.setToolTipText("<html><b>" + slotName + "</b><br>" + itemName + "<br>ID: " + itemId + "</html>");
            this.addContextMenu(slot, itemId, itemName, 1);
            slot.addMouseListener(new MouseAdapter(){
                Color originalColor;
                {
                    this.originalColor = slot.getBackground();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    slot.setBackground(new Color(65, 65, 70));
                    slot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ACCENT, 1), new EmptyBorder(3, 3, 3, 3)));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    slot.setBackground(this.originalColor);
                    slot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 74), 1), new EmptyBorder(3, 3, 3, 3)));
                }
            });
        } else {
            JLabel emptyLabel = new JLabel("<html><center><span style='font-size: 7px; color: rgb(80,80,90);'>" + slotName + "</span></center></html>");
            emptyLabel.setHorizontalAlignment(0);
            emptyLabel.setVerticalAlignment(0);
            emptyLabel.setToolTipText(slotName + " (empty)");
            slot.add((Component)emptyLabel, "Center");
        }
        return slot;
    }

    private void retryLoadingSprite(JPanel slot, int itemId, int size, JLabel placeholderLabel) {
        int[] attemptCount = new int[]{0};
        int MAX_ATTEMPTS = 10;
        int RETRY_DELAY_MS = 500;
        Timer retryTimer = new Timer(500, null);
        retryTimer.addActionListener(e -> {
            attemptCount[0] = attemptCount[0] + 1;
            Image sprite = this.loadItemSprite(itemId, 1);
            if (sprite != null) {
                slot.remove(placeholderLabel);
                ImageIcon icon = new ImageIcon(sprite.getScaledInstance(size - 6, size - 6, 4));
                JLabel imageLabel = new JLabel(icon);
                imageLabel.setHorizontalAlignment(0);
                imageLabel.setVerticalAlignment(0);
                slot.add((Component)imageLabel, "Center");
                slot.revalidate();
                slot.repaint();
                System.out.println("[ModernSidebar] Successfully loaded sprite for item " + itemId + " after " + attemptCount[0] + " attempts");
                retryTimer.stop();
            } else if (attemptCount[0] >= 10) {
                slot.remove(placeholderLabel);
                String itemName = this.getItemName(itemId);
                JLabel nameLabel = new JLabel("<html><center><span style='font-size: 9px; color: rgb(200,200,210);'>" + itemName + "</span></center></html>");
                nameLabel.setHorizontalAlignment(0);
                nameLabel.setVerticalAlignment(0);
                slot.add((Component)nameLabel, "Center");
                slot.revalidate();
                slot.repaint();
                System.err.println("[ModernSidebar] Failed to load sprite for item " + itemId + " after 10 attempts");
                retryTimer.stop();
            }
        });
        retryTimer.start();
    }

    private void addItemIdLabel(JPanel slot, int itemId) {
        JLabel itemLabel = new JLabel("<html><center><span style='font-size: 9px; color: rgb(200,200,210);'>" + itemId + "</span></center></html>");
        itemLabel.setHorizontalAlignment(0);
        itemLabel.setVerticalAlignment(0);
        slot.add((Component)itemLabel, "Center");
    }

    private int extractJsonNumber(String json, String key) {
        char c;
        int endIndex;
        int startIndex = json.indexOf(key);
        if (startIndex == -1) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        for (endIndex = startIndex += key.length(); endIndex < json.length() && Character.isDigit(c = json.charAt(endIndex)); ++endIndex) {
        }
        String numberStr = json.substring(startIndex, endIndex);
        return Integer.parseInt(numberStr);
    }

    private JPanel createInventoryGrid(String inventoryJson) {
        JPanel grid = new JPanel(new GridLayout(7, 4, 4, 4));
        grid.setBackground(new Color(35, 35, 38));
        System.out.println("[ModernSidebar] Raw inventory JSON: " + inventoryJson);
        System.out.println("[ModernSidebar] JSON length: " + (inventoryJson != null ? inventoryJson.length() : 0));
        int[] inventoryItems = new int[28];
        int[] inventoryAmounts = new int[28];
        try {
            String[] items;
            for (String item : items = inventoryJson.split("\\{")) {
                if (!item.contains("\"slot\"") || !item.contains("\"id\"") || !item.contains("\"amount\"")) continue;
                try {
                    int slot = this.extractJsonNumber(item, "\"slot\":");
                    int id = this.extractJsonNumber(item, "\"id\":");
                    int amount = this.extractJsonNumber(item, "\"amount\":");
                    if (slot < 0 || slot >= 28 || id <= 0) continue;
                    inventoryItems[slot] = id;
                    inventoryAmounts[slot] = amount;
                    System.out.println("[ModernSidebar] Parsed inventory item: slot=" + slot + " id=" + id + " amount=" + amount);
                }
                catch (Exception itemEx) {
                    System.err.println("[ModernSidebar] Error parsing inventory item: " + itemEx.getMessage());
                    itemEx.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println("[ModernSidebar] Error parsing inventory JSON: " + e.getMessage());
        }
        for (int i = 0; i < 28; ++i) {
            if (inventoryItems[i] > 0) {
                grid.add(this.createInventorySlot(inventoryItems[i], inventoryAmounts[i]));
                continue;
            }
            grid.add(this.createInventorySlot(-1, 0));
        }
        return grid;
    }

    private JPanel createInventorySlot(int itemId, int amount) {
        final JPanel slot = new JPanel(new BorderLayout());
        slot.setPreferredSize(new Dimension(36, 36));
        slot.setBackground(itemId > 0 ? new Color(50, 50, 54) : new Color(30, 30, 34));
        slot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 74), 1), new EmptyBorder(1, 1, 1, 1)));
        if (itemId > 0) {
            String itemName = this.getItemName(itemId);
            Image sprite = this.loadItemSprite(itemId, amount);
            if (sprite != null) {
                ImageIcon icon = new ImageIcon(sprite.getScaledInstance(32, 32, 4));
                JLabel imageLabel = new JLabel(icon);
                imageLabel.setHorizontalAlignment(0);
                imageLabel.setVerticalAlignment(0);
                slot.add((Component)imageLabel, "Center");
            } else {
                JLabel placeholderLabel = new JLabel("<html><center><span style='font-size: 8px; color: rgb(150,150,160);'>...</span></center></html>");
                placeholderLabel.setHorizontalAlignment(0);
                placeholderLabel.setVerticalAlignment(0);
                slot.add((Component)placeholderLabel, "Center");
                this.retryLoadingInventorySprite(slot, itemId, amount, placeholderLabel);
            }
            if (amount > 1) {
                JLabel amountLabel = new JLabel(" " + this.formatAmount(amount) + " ");
                amountLabel.setFont(new Font("Arial", 1, 10));
                amountLabel.setForeground(Color.YELLOW);
                amountLabel.setBackground(new Color(0, 0, 0, 180));
                amountLabel.setOpaque(true);
                amountLabel.setHorizontalAlignment(4);
                JPanel amountPanel = new JPanel(new FlowLayout(2, 0, 0));
                amountPanel.setOpaque(false);
                amountPanel.add(amountLabel);
                slot.add((Component)amountPanel, "South");
            }
            slot.setToolTipText("<html><b>" + itemName + "</b>" + (String)(amount > 1 ? "<br>Amount: " + amount : "") + "</html>");
            this.addContextMenu(slot, itemId, itemName, amount);
            slot.addMouseListener(new MouseAdapter(){
                Color originalColor;
                {
                    this.originalColor = slot.getBackground();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    slot.setBackground(new Color(65, 65, 70));
                    slot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ACCENT, 1), new EmptyBorder(1, 1, 1, 1)));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    slot.setBackground(this.originalColor);
                    slot.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(70, 70, 74), 1), new EmptyBorder(1, 1, 1, 1)));
                }
            });
        }
        return slot;
    }

    private void retryLoadingInventorySprite(JPanel slot, int itemId, int amount, JLabel placeholderLabel) {
        int[] attemptCount = new int[]{0};
        int MAX_ATTEMPTS = 10;
        int RETRY_DELAY_MS = 500;
        Timer retryTimer = new Timer(500, null);
        retryTimer.addActionListener(e -> {
            attemptCount[0] = attemptCount[0] + 1;
            Image sprite = this.loadItemSprite(itemId, amount);
            if (sprite != null) {
                slot.remove(placeholderLabel);
                ImageIcon icon = new ImageIcon(sprite.getScaledInstance(32, 32, 4));
                JLabel imageLabel = new JLabel(icon);
                imageLabel.setHorizontalAlignment(0);
                imageLabel.setVerticalAlignment(0);
                slot.add((Component)imageLabel, "Center");
                slot.revalidate();
                slot.repaint();
                System.out.println("[ModernSidebar] Successfully loaded inventory sprite for item " + itemId + " after " + attemptCount[0] + " attempts");
                retryTimer.stop();
            } else if (attemptCount[0] >= 10) {
                slot.remove(placeholderLabel);
                String itemName = this.getItemName(itemId);
                Object displayName = itemName;
                if (((String)displayName).length() > 12) {
                    displayName = ((String)displayName).substring(0, 10) + "...";
                }
                JLabel nameLabel = new JLabel("<html><center><span style='font-size: 8px; color: rgb(200,200,210);'>" + (String)displayName + "</span></center></html>");
                nameLabel.setHorizontalAlignment(0);
                nameLabel.setVerticalAlignment(0);
                slot.add((Component)nameLabel, "Center");
                slot.revalidate();
                slot.repaint();
                System.err.println("[ModernSidebar] Failed to load inventory sprite for item " + itemId + " after 10 attempts");
                retryTimer.stop();
            }
        });
        retryTimer.start();
    }

    private String formatAmount(int amount) {
        if (amount >= 1000000) {
            return amount / 1000000 + "M";
        }
        if (amount >= 1000) {
            return amount / 1000 + "K";
        }
        return String.valueOf(amount);
    }

    private void addContextMenu(JComponent component, int itemId, String itemName, int amount) {
        final JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.setBackground(BG_SECONDARY);
        contextMenu.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        JMenuItem viewItem = new JMenuItem("View: " + itemName);
        viewItem.setForeground(TEXT_PRIMARY);
        viewItem.setBackground(BG_SECONDARY);
        viewItem.addActionListener(e -> JOptionPane.showMessageDialog(this, "<html><b>Item Information</b><br><br>Name: " + itemName + "<br>ID: " + itemId + "<br>Amount: " + amount + "</html>", "Item Info", 1));
        JMenuItem copyId = new JMenuItem("Copy Item ID");
        copyId.setForeground(TEXT_SECONDARY);
        copyId.setBackground(BG_SECONDARY);
        copyId.addActionListener(e -> {
            StringSelection stringSelection = new StringSelection(String.valueOf(itemId));
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            System.out.println("[ModernSidebar] Copied item ID to clipboard: " + itemId);
        });
        contextMenu.add(viewItem);
        contextMenu.addSeparator();
        contextMenu.add(copyId);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    contextMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    contextMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private String getItemName(int itemId) {
        if (itemNameCache.containsKey(itemId)) {
            return itemNameCache.get(itemId);
        }
        Object name = null;
        try {
            Field nameField;
            Class<?> itemDefClass = Class.forName("com.teragard.ItemDef");
            Method forIdMethod = itemDefClass.getMethod("forID", Integer.TYPE);
            Object itemDef = forIdMethod.invoke(null, itemId);
            if (itemDef != null && (name = (String)(nameField = itemDefClass.getField("name")).get(itemDef)) != null && !((String)name).isEmpty() && !((String)name).equals("null")) {
                itemNameCache.put(itemId, (String)name);
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        name = "Item #" + itemId;
        itemNameCache.put(itemId, (String)name);
        return name;
    }

    private Image loadItemSprite(int itemId, int amount) {
        int cacheKey = itemId * 10000 + Math.min(amount, 9999);
        if (spriteCache.containsKey(cacheKey)) {
            return spriteCache.get(cacheKey);
        }
        if (!this.isItemCacheLoaded()) {
            return null;
        }
        try {
            BufferedImage image = SpriteRenderer.getOrQueueSprite(itemId, amount, 36, 36);
            if (image != null) {
                int width = image.getWidth();
                int height = image.getHeight();
                if (width < 10 || height < 10 || width > 100 || height > 100) {
                    return null;
                }
                if (this.isSpriteCorrupted(image)) {
                    return null;
                }
                spriteCache.put(cacheKey, image);
                return image;
            }
            this.startSpriteRefreshTimer();
        }
        catch (Exception e) {
            System.err.println("[ModernSidebar] Error loading sprite for item " + itemId + ": " + e.getMessage());
        }
        return null;
    }

    private void startSpriteRefreshTimer() {
        if (this.spriteRefreshTimer == null || !this.spriteRefreshTimer.isRunning()) {
            this.spriteRefreshTimer = new Timer(100, e -> {
                int pending = SpriteRenderer.getPendingRenderCount();
                int cacheSize = SpriteRenderer.getCacheSize();
                if (cacheSize > this.lastPendingCount || pending > 0) {
                    this.lastPendingCount = cacheSize;
                    if (this.presetDetailsContainer != null) {
                        this.presetDetailsContainer.repaint();
                    }
                }
                if (pending == 0) {
                    this.spriteRefreshTimer.stop();
                }
            });
            this.spriteRefreshTimer.start();
        }
    }

    private boolean isSpriteCorrupted(BufferedImage image) {
        try {
            int width = image.getWidth();
            int height = image.getHeight();
            int totalPixels = width * height;
            int opaquePixels = 0;
            for (int y = 0; y < height; y += 2) {
                for (int x = 0; x < width; x += 2) {
                    int pixel = image.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    if (alpha <= 50) continue;
                    ++opaquePixels;
                }
            }
            double opaqueRatio = (double)opaquePixels / (double)(totalPixels / 4);
            return opaqueRatio < 0.02;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isItemCacheLoaded() {
        try {
            return ItemDef.cache != null && ItemDef.totalItems > 0 && ItemDef.cache.length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void enablePresetDragAndDrop() {
        final JPopupMenu dropdownMenu = new JPopupMenu();
        dropdownMenu.setBackground(BG_SECONDARY);
        dropdownMenu.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        JMenuItem moveUp = new JMenuItem("\u2191 Move Up");
        moveUp.setForeground(TEXT_PRIMARY);
        moveUp.setBackground(BG_SECONDARY);
        moveUp.addActionListener(e -> this.movePreset(-1));
        JMenuItem moveDown = new JMenuItem("\u2193 Move Down");
        moveDown.setForeground(TEXT_PRIMARY);
        moveDown.setBackground(BG_SECONDARY);
        moveDown.addActionListener(e -> this.movePreset(1));
        JMenuItem moveToTop = new JMenuItem("\u21c8 Move to Top");
        moveToTop.setForeground(TEXT_SECONDARY);
        moveToTop.setBackground(BG_SECONDARY);
        moveToTop.addActionListener(e -> this.movePresetToPosition(0));
        JMenuItem moveToBottom = new JMenuItem("\u21ca Move to Bottom");
        moveToBottom.setForeground(TEXT_SECONDARY);
        moveToBottom.setBackground(BG_SECONDARY);
        moveToBottom.addActionListener(e -> this.movePresetToPosition(this.currentPresets.size() - 1));
        dropdownMenu.add(moveUp);
        dropdownMenu.add(moveDown);
        dropdownMenu.addSeparator();
        dropdownMenu.add(moveToTop);
        dropdownMenu.add(moveToBottom);
        this.presetDropdown.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && ModernSidebar.this.presetDropdown.isEnabled() && !ModernSidebar.this.currentPresets.isEmpty()) {
                    dropdownMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && ModernSidebar.this.presetDropdown.isEnabled() && !ModernSidebar.this.currentPresets.isEmpty()) {
                    dropdownMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.presetDropdown.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    if (e.getKeyCode() == 38) {
                        ModernSidebar.this.movePreset(-1);
                    } else if (e.getKeyCode() == 40) {
                        ModernSidebar.this.movePreset(1);
                    }
                }
            }
        });
    }

    private void movePreset(int offset) {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex < 0 || this.currentPresets.isEmpty()) {
            return;
        }
        int newIndex = selectedIndex + offset;
        if (newIndex < 0 || newIndex >= this.currentPresets.size()) {
            return;
        }
        this.movePresetToPosition(newIndex);
    }

    private void movePresetToPosition(int newIndex) {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex < 0 || newIndex < 0 || newIndex >= this.currentPresets.size()) {
            return;
        }
        PresetData preset = this.currentPresets.remove(selectedIndex);
        this.currentPresets.add(newIndex, preset);
        this.presetDropdown.removeAllItems();
        for (PresetData p : this.currentPresets) {
            this.presetDropdown.addItem(p.name);
        }
        this.presetDropdown.setSelectedIndex(newIndex);
        System.out.println("[ModernSidebar] Moved preset '" + preset.name + "' from position " + selectedIndex + " to " + newIndex);
    }

    private void onSavePreset() {
        String presetName = JOptionPane.showInputDialog(this, "Enter preset name:", "Save Preset", -1);
        if (presetName != null && !presetName.trim().isEmpty()) {
            this.sendSavePresetPacket(presetName.trim());
            this.showToast("Saving preset: " + presetName.trim());
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.sendRequestPresetsPacket();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }
    }

    private void onUpdatePreset() {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.filteredPresets.size()) {
            PresetData preset = this.filteredPresets.get(selectedIndex);
            int confirm = JOptionPane.showConfirmDialog(this, "Overwrite preset '" + preset.name + "' with current setup?", "Update Preset", 0);
            if (confirm == 0) {
                this.sendUpdatePresetPacket(preset.id);
                this.showToast("Updating preset: " + preset.name);
                new Thread(() -> {
                    try {
                        Thread.sleep(500L);
                        this.sendRequestPresetsPacket();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
    }

    private void onLoadPreset() {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.filteredPresets.size()) {
            PresetData preset = this.filteredPresets.get(selectedIndex);
            this.sendLoadPresetPacket(preset.id);
            this.showToast("Loading preset: " + preset.name);
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.sendRequestPresetsPacket();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }
    }

    private void onRenamePreset() {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.filteredPresets.size()) {
            PresetData preset = this.filteredPresets.get(selectedIndex);
            String newName = (String)JOptionPane.showInputDialog(this, "Enter new name for preset:", "Rename Preset", -1, null, null, preset.name);
            if (newName != null && !newName.trim().isEmpty() && !newName.equals(preset.name)) {
                this.showToast("Rename feature coming soon!");
                System.out.println("[ModernSidebar] Rename preset " + preset.id + " to: " + newName);
            }
        }
    }

    private void onDuplicatePreset() {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.filteredPresets.size()) {
            PresetData preset = this.filteredPresets.get(selectedIndex);
            String newName = (String)JOptionPane.showInputDialog(this, "Enter name for duplicate preset:", "Duplicate Preset", -1, null, null, preset.name + " (copy)");
            if (newName != null && !newName.trim().isEmpty()) {
                this.showToast("Duplicate feature coming soon!");
                System.out.println("[ModernSidebar] Duplicate preset " + preset.id + " as: " + newName);
            }
        }
    }

    private void onDeletePreset() {
        int selectedIndex = this.presetDropdown.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.filteredPresets.size()) {
            PresetData preset = this.filteredPresets.get(selectedIndex);
            int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete preset:\n\"" + preset.name + "\"?\n\nThis action cannot be undone.", "Delete Preset", 0, 2);
            if (confirm == 0) {
                this.sendDeletePresetPacket(preset.id);
                this.showToast("Deleted preset: " + preset.name);
                new Thread(() -> {
                    try {
                        Thread.sleep(500L);
                        this.sendRequestPresetsPacket();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
    }

    private void showToast(String message) {
        System.out.println("[ModernSidebar] " + message);
    }

    private JPanel createSettingsPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBackground(BG_PRIMARY);
        contentPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JLabel header = new JLabel("Sidebar Settings");
        header.setFont(new Font("Arial", 1, 18));
        header.setForeground(TEXT_PRIMARY);
        header.setAlignmentX(0.0f);
        contentPanel.add(header);
        contentPanel.add(Box.createVerticalStrut(15));
        JPanel noticePanel = new JPanel();
        noticePanel.setLayout(new BoxLayout(noticePanel, 1));
        noticePanel.setBackground(new Color(60, 60, 80));
        noticePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(100, 100, 150), 1), new EmptyBorder(8, 10, 8, 10)));
        noticePanel.setMaximumSize(new Dimension(380, 65));
        noticePanel.setAlignmentX(0.0f);
        JLabel noticeHeader = new JLabel("\u26a0\ufe0f Settings Status");
        noticeHeader.setForeground(new Color(180, 180, 220));
        noticeHeader.setFont(new Font("Arial", 1, 11));
        noticeHeader.setAlignmentX(0.0f);
        noticePanel.add(noticeHeader);
        noticePanel.add(Box.createVerticalStrut(4));
        JLabel noticeText = new JLabel("<html><div style='width: 350px;'><span style='color: #b0b0c0; font-size: 9px;'>UI-only features. Game integration coming soon!</span></div></html>");
        noticeText.setAlignmentX(0.0f);
        noticePanel.add(noticeText);
        contentPanel.add(noticePanel);
        contentPanel.add(Box.createVerticalStrut(12));
        contentPanel.add(this.createSettingsSection("\ud83d\udd14 Notifications (UI Only)", new String[][]{{"Drop Notifications", "Show toast when you receive loot"}, {"XP Notifications", "Show toast when you gain XP"}, {"Level Up Notifications", "Show toast when you level up"}}));
        contentPanel.add(Box.createVerticalStrut(15));
        contentPanel.add(this.createSettingsSection("\u2699\ufe0f Sidebar Behavior (Working)", new String[][]{{"Auto-collapse on startup", "Start with sidebar collapsed"}, {"Remember last tab", "Open the last used tab on startup"}, {"Show tooltips", "Display helpful tooltips"}}));
        contentPanel.add(Box.createVerticalStrut(15));
        contentPanel.add(this.createSettingsSection("\ud83d\udcca Session Tracker (Working)", new String[][]{{"Track XP gains", "Monitor experience earned"}, {"Track loot", "Monitor items looted"}, {"Track kills", "Count enemies defeated"}}));
        contentPanel.add(Box.createVerticalStrut(15));
        JPanel aboutCard = new JPanel();
        aboutCard.setLayout(new BoxLayout(aboutCard, 1));
        aboutCard.setBackground(BG_SECONDARY);
        aboutCard.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(10, 12, 10, 12)));
        aboutCard.setMaximumSize(new Dimension(380, 90));
        aboutCard.setAlignmentX(0.0f);
        JLabel aboutHeader = new JLabel("\u2139\ufe0f About");
        aboutHeader.setForeground(TEXT_PRIMARY);
        aboutHeader.setFont(new Font("Arial", 1, 12));
        aboutHeader.setAlignmentX(0.0f);
        aboutCard.add(aboutHeader);
        aboutCard.add(Box.createVerticalStrut(6));
        JLabel versionLabel = new JLabel("Sidebar Version: 1.0.0");
        versionLabel.setForeground(TEXT_SECONDARY);
        versionLabel.setFont(new Font("Arial", 0, 10));
        versionLabel.setAlignmentX(0.0f);
        aboutCard.add(versionLabel);
        JLabel creditLabel = new JLabel("<html><span style='color: #a0a0b4; font-size: 9px;'>Teragard Client v1.0</span></html>");
        creditLabel.setAlignmentX(0.0f);
        aboutCard.add(Box.createVerticalStrut(3));
        aboutCard.add(creditLabel);
        contentPanel.add(aboutCard);
        contentPanel.add(Box.createVerticalStrut(20));
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBackground(BG_PRIMARY);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.getVerticalScrollBar().setBackground(BG_SECONDARY);
        scrollPane.getVerticalScrollBar().setUI(new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = new Color(80, 80, 90);
                this.trackColor = BG_SECONDARY;
            }

            @Override
            protected JButton createDecreaseButton(int orientation) {
                return this.createZeroButton();
            }

            @Override
            protected JButton createIncreaseButton(int orientation) {
                return this.createZeroButton();
            }

            private JButton createZeroButton() {
                JButton button = new JButton();
                button.setPreferredSize(new Dimension(0, 0));
                return button;
            }
        });
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        wrapperPanel.setBackground(BG_PRIMARY);
        wrapperPanel.add((Component)scrollPane, "Center");
        return wrapperPanel;
    }

    private JPanel createSettingsSection(String title, String[][] settings) {
        JPanel section = new JPanel();
        section.setLayout(new BoxLayout(section, 1));
        section.setBackground(BG_SECONDARY);
        section.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(10, 12, 10, 12)));
        section.setMaximumSize(new Dimension(380, 200));
        section.setAlignmentX(0.0f);
        JLabel sectionHeader = new JLabel(title);
        sectionHeader.setForeground(TEXT_PRIMARY);
        sectionHeader.setFont(new Font("Arial", 1, 12));
        sectionHeader.setAlignmentX(0.0f);
        section.add(sectionHeader);
        section.add(Box.createVerticalStrut(8));
        for (String[] setting : settings) {
            JPanel settingRow = this.createSettingToggle(setting[0], setting[1]);
            section.add(settingRow);
            section.add(Box.createVerticalStrut(6));
        }
        return section;
    }

    private JPanel createSettingToggle(String label, String description) {
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 0));
        row.setBackground(BG_SECONDARY);
        row.setMaximumSize(new Dimension(360, 38));
        row.setAlignmentX(0.0f);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        infoPanel.setBackground(BG_SECONDARY);
        infoPanel.setAlignmentY(0.0f);
        JLabel titleLabel = new JLabel(label);
        titleLabel.setForeground(TEXT_PRIMARY);
        titleLabel.setFont(new Font("Arial", 0, 11));
        titleLabel.setAlignmentX(0.0f);
        JLabel descLabel = new JLabel("<html><span style='color: #a0a0b4; font-size: 9px;'>" + description + "</span></html>");
        descLabel.setAlignmentX(0.0f);
        infoPanel.add(titleLabel);
        infoPanel.add(Box.createVerticalStrut(1));
        infoPanel.add(descLabel);
        JCheckBox toggle = new JCheckBox();
        toggle.setBackground(BG_SECONDARY);
        toggle.setFocusPainted(false);
        toggle.setSelected(true);
        toggle.setCursor(Cursor.getPredefinedCursor(12));
        toggle.setAlignmentY(0.0f);
        if (label.equals("Drop Notifications")) {
            this.notifyDropsCheckbox = toggle;
        } else if (label.equals("XP Notifications")) {
            this.notifyXpCheckbox = toggle;
        } else if (label.equals("Auto-collapse on startup")) {
            this.autoCollapseCheckbox = toggle;
        }
        row.add(infoPanel);
        row.add(Box.createHorizontalGlue());
        row.add(toggle);
        row.add(Box.createHorizontalStrut(5));
        return row;
    }

    public boolean isDropNotificationsEnabled() {
        return this.notifyDropsCheckbox != null && this.notifyDropsCheckbox.isSelected();
    }

    public boolean isXpNotificationsEnabled() {
        return this.notifyXpCheckbox != null && this.notifyXpCheckbox.isSelected();
    }

    public boolean isAutoCollapseEnabled() {
        return this.autoCollapseCheckbox != null && this.autoCollapseCheckbox.isSelected();
    }

    private JPanel createInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(BG_PRIMARY);
        panel.setBorder(new EmptyBorder(10, 12, 10, 12));
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBackground(BG_PRIMARY);
        headerPanel.setMaximumSize(new Dimension(380, 32));
        headerPanel.setAlignmentX(0.0f);
        JLabel header = new JLabel("Session Tracker");
        header.setFont(new Font("Arial", 1, 14));
        header.setForeground(TEXT_PRIMARY);
        JButton resetButton = new JButton("Reset");
        resetButton.setBackground(new Color(70, 70, 80));
        resetButton.setForeground(TEXT_PRIMARY);
        resetButton.setFocusPainted(false);
        resetButton.setBorder(new EmptyBorder(4, 10, 4, 10));
        resetButton.setFont(new Font("Arial", 0, 10));
        resetButton.setCursor(Cursor.getPredefinedCursor(12));
        resetButton.addActionListener(e -> this.resetSessionStats());
        headerPanel.add((Component)header, "West");
        headerPanel.add((Component)resetButton, "East");
        panel.add(headerPanel);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.createStatCard("Session Time", "playtime"));
        panel.add(Box.createVerticalStrut(8));
        panel.add(this.createStatCard("Total XP Gained", "xp"));
        panel.add(Box.createVerticalStrut(8));
        JPanel combatCard = this.createSectionCard("Combat Stats");
        this.killCountLabel = this.createStatLabel("0 kills");
        this.deathCountLabel = this.createStatLabel("0 deaths");
        combatCard.add(this.createStatRow("Kills:", this.killCountLabel));
        combatCard.add(Box.createVerticalStrut(6));
        combatCard.add(this.createStatRow("Deaths:", this.deathCountLabel));
        panel.add(combatCard);
        panel.add(Box.createVerticalStrut(8));
        JPanel lootCard = this.createSectionCard("Loot Tracker");
        this.lootValueLabel = this.createStatLabel("0 GP");
        lootCard.add(this.createStatRow("Total Value:", this.lootValueLabel));
        lootCard.add(Box.createVerticalStrut(6));
        JLabel topLootHeader = new JLabel("Recent Drops:");
        topLootHeader.setForeground(TEXT_SECONDARY);
        topLootHeader.setFont(new Font("Arial", 0, 10));
        topLootHeader.setAlignmentX(0.0f);
        lootCard.add(topLootHeader);
        this.topLootPanel = new JPanel();
        this.topLootPanel.setLayout(new BoxLayout(this.topLootPanel, 1));
        this.topLootPanel.setBackground(BG_SECONDARY);
        this.topLootPanel.setAlignmentX(0.0f);
        lootCard.add(this.topLootPanel);
        panel.add(lootCard);
        panel.add(Box.createVerticalGlue());
        this.startSessionUpdateTimer();
        return panel;
    }

    private JPanel createStatCard(String title, String type) {
        JPanel card = this.createSectionCard(title);
        JLabel valueLabel = type.equals("playtime") ? (this.playtimeLabel = this.createStatLabel("0h 0m 0s")) : (this.totalXpLabel = this.createStatLabel("0 XP"));
        valueLabel.setFont(new Font("Arial", 1, 14));
        valueLabel.setAlignmentX(0.0f);
        card.add(valueLabel);
        return card;
    }

    private JPanel createSectionCard(String title) {
        JPanel card = new JPanel();
        card.setLayout(new BoxLayout(card, 1));
        card.setBackground(BG_SECONDARY);
        card.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(8, 10, 8, 10)));
        card.setMaximumSize(new Dimension(380, 150));
        card.setAlignmentX(0.0f);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setForeground(TEXT_PRIMARY);
        titleLabel.setFont(new Font("Arial", 1, 11));
        titleLabel.setAlignmentX(0.0f);
        card.add(titleLabel);
        card.add(Box.createVerticalStrut(6));
        return card;
    }

    private JPanel createStatRow(String label, JLabel valueLabel) {
        JPanel row = new JPanel(new BorderLayout());
        row.setBackground(BG_SECONDARY);
        row.setMaximumSize(new Dimension(360, 22));
        row.setAlignmentX(0.0f);
        JLabel labelText = new JLabel(label);
        labelText.setForeground(TEXT_SECONDARY);
        labelText.setFont(new Font("Arial", 0, 11));
        row.add((Component)labelText, "West");
        row.add((Component)valueLabel, "East");
        return row;
    }

    private JLabel createStatLabel(String text) {
        JLabel label = new JLabel(text);
        label.setForeground(ACCENT);
        label.setFont(new Font("Arial", 1, 11));
        return label;
    }

    private void startSessionUpdateTimer() {
        Timer updateTimer = new Timer(1000, e -> {
            long elapsed = System.currentTimeMillis() - this.sessionStartTime;
            long seconds = elapsed / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            seconds %= 60L;
            minutes %= 60L;
            if (this.playtimeLabel != null) {
                this.playtimeLabel.setText(String.format("%dh %dm %ds", hours, minutes, seconds));
            }
        });
        updateTimer.start();
    }

    private void resetSessionStats() {
        this.sessionStartTime = System.currentTimeMillis();
        this.sessionKills = 0;
        this.sessionDeaths = 0;
        this.sessionXp = 0L;
        this.sessionLootValue = 0L;
        if (this.playtimeLabel != null) {
            this.playtimeLabel.setText("0h 0m 0s");
        }
        if (this.totalXpLabel != null) {
            this.totalXpLabel.setText("0 XP");
        }
        if (this.killCountLabel != null) {
            this.killCountLabel.setText("0 kills");
        }
        if (this.deathCountLabel != null) {
            this.deathCountLabel.setText("0 deaths");
        }
        if (this.lootValueLabel != null) {
            this.lootValueLabel.setText("0 GP");
        }
        if (this.topLootPanel != null) {
            this.topLootPanel.removeAll();
            this.topLootPanel.revalidate();
            this.topLootPanel.repaint();
        }
        System.out.println("[SessionTracker] Stats reset");
    }

    public void addSessionXp(long xp) {
        this.sessionXp += xp;
        if (this.totalXpLabel != null) {
            this.totalXpLabel.setText(this.formatNumber(this.sessionXp) + " XP");
        }
    }

    public void addSessionKill() {
        ++this.sessionKills;
        if (this.killCountLabel != null) {
            this.killCountLabel.setText(this.sessionKills + " kills");
        }
    }

    public void addSessionDeath() {
        ++this.sessionDeaths;
        if (this.deathCountLabel != null) {
            this.deathCountLabel.setText(this.sessionDeaths + " deaths");
        }
    }

    public void addSessionLoot(String itemName, int itemId, long value) {
        this.sessionLootValue += value;
        if (this.lootValueLabel != null) {
            this.lootValueLabel.setText(this.formatNumber(this.sessionLootValue) + " GP");
        }
        if (this.topLootPanel != null) {
            JLabel dropLabel = new JLabel("\u2022 " + itemName + " (" + this.formatNumber(value) + " GP)");
            dropLabel.setForeground(TEXT_SECONDARY);
            dropLabel.setFont(new Font("Arial", 0, 10));
            this.topLootPanel.add((Component)dropLabel, 0);
            while (this.topLootPanel.getComponentCount() > 5) {
                this.topLootPanel.remove(this.topLootPanel.getComponentCount() - 1);
            }
            this.topLootPanel.revalidate();
            this.topLootPanel.repaint();
        }
    }

    public void updateSessionStats(int kills, long lootValue, ArrayList<Client.LootItem> recentLoots) {
        this.sessionKills = kills;
        if (this.killCountLabel != null) {
            this.killCountLabel.setText(kills + " kills");
        }
        this.sessionLootValue = lootValue;
        if (this.lootValueLabel != null) {
            this.lootValueLabel.setText(this.formatNumber(lootValue) + " GP");
        }
        if (this.topLootPanel != null && recentLoots != null) {
            this.topLootPanel.removeAll();
            for (Client.LootItem lootItem : recentLoots) {
                Object itemName = this.getItemName(lootItem.itemId);
                if (itemName == null) {
                    itemName = "Item " + lootItem.itemId;
                }
                long itemValue = lootItem.amount * 1000;
                JLabel dropLabel = new JLabel("\u2022 " + (String)itemName + " x" + lootItem.amount + " (" + this.formatNumber(itemValue) + " GP)");
                dropLabel.setForeground(TEXT_SECONDARY);
                dropLabel.setFont(new Font("Arial", 0, 10));
                this.topLootPanel.add(dropLabel);
            }
            this.topLootPanel.revalidate();
            this.topLootPanel.repaint();
        }
        System.out.println("[SessionTracker] Updated stats - Kills: " + kills + ", Loot: " + this.formatNumber(lootValue) + " GP, Recent drops: " + (recentLoots != null ? recentLoots.size() : 0));
    }

    private String formatNumber(long number) {
        if (number >= 1000000000L) {
            return String.format("%.1fB", (double)number / 1.0E9);
        }
        if (number >= 1000000L) {
            return String.format("%.1fM", (double)number / 1000000.0);
        }
        if (number >= 1000L) {
            return String.format("%.1fK", (double)number / 1000.0);
        }
        return String.valueOf(number);
    }

    private JPanel createToolsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(BG_PRIMARY);
        panel.setBorder(new EmptyBorder(15, 15, 15, 15));
        JLabel header = new JLabel("Item Database");
        header.setFont(new Font("Arial", 1, 18));
        header.setForeground(TEXT_PRIMARY);
        header.setAlignmentX(0.0f);
        panel.add(header);
        panel.add(Box.createVerticalStrut(15));
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.setBackground(BG_SECONDARY);
        searchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(8, 10, 8, 10)));
        searchPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 45));
        this.itemSearchField = new JTextField();
        this.itemSearchField.setBackground(BG_SECONDARY);
        this.itemSearchField.setForeground(TEXT_PRIMARY);
        this.itemSearchField.setCaretColor(TEXT_PRIMARY);
        this.itemSearchField.setBorder(null);
        this.itemSearchField.setFont(new Font("Arial", 0, 14));
        this.itemSearchField.addActionListener(e -> this.searchItem());
        JButton searchButton = new JButton("\ud83d\udd0d");
        searchButton.setBackground(ACCENT);
        searchButton.setForeground(Color.WHITE);
        searchButton.setFocusPainted(false);
        searchButton.setBorder(new EmptyBorder(5, 12, 5, 12));
        searchButton.setCursor(Cursor.getPredefinedCursor(12));
        searchButton.addActionListener(e -> this.searchItem());
        searchPanel.add(this.itemSearchField);
        searchPanel.add(Box.createHorizontalStrut(10));
        searchPanel.add(searchButton);
        panel.add(searchPanel);
        panel.add(Box.createVerticalStrut(15));
        this.itemResultPanel = new JPanel();
        this.itemResultPanel.setLayout(new BoxLayout(this.itemResultPanel, 1));
        this.itemResultPanel.setBackground(BG_PRIMARY);
        this.itemResultPanel.setAlignmentX(0.0f);
        JLabel hintLabel = new JLabel("<html><center><span style='color: #a0a0b4; font-style: italic;'>Search for an item by name or ID</span></center></html>");
        hintLabel.setAlignmentX(0.5f);
        this.itemResultPanel.add(hintLabel);
        panel.add(this.itemResultPanel);
        panel.add(Box.createVerticalStrut(20));
        panel.add(this.createQuickToolsSection());
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private void searchItem() {
        String searchText = this.itemSearchField.getText().trim();
        if (searchText.isEmpty()) {
            return;
        }
        this.itemResultPanel.removeAll();
        try {
            int itemId = -1;
            try {
                itemId = Integer.parseInt(searchText);
            }
            catch (NumberFormatException e) {
                itemId = this.findItemIdByName(searchText);
            }
            if (itemId > 0) {
                this.displayItemInfo(itemId);
            } else {
                JLabel notFoundLabel = new JLabel("<html><center><span style='color: #ff6b6b;'>Item not found</span></center></html>");
                notFoundLabel.setAlignmentX(0.5f);
                this.itemResultPanel.add(notFoundLabel);
            }
        }
        catch (Exception e) {
            System.err.println("[Tools] Error searching item: " + e.getMessage());
            JLabel errorLabel = new JLabel("<html><center><span style='color: #ff6b6b;'>Error searching item</span></center></html>");
            errorLabel.setAlignmentX(0.5f);
            this.itemResultPanel.add(errorLabel);
        }
        this.itemResultPanel.revalidate();
        this.itemResultPanel.repaint();
    }

    private int findItemIdByName(String name) {
        try {
            if (ItemDef.cache == null) {
                return -1;
            }
            String searchLower = name.toLowerCase();
            for (int i = 0; i < ItemDef.cache.length; ++i) {
                ItemDef def = ItemDef.cache[i];
                if (def == null || def.name == null || !def.name.toLowerCase().contains(searchLower)) continue;
                return def.id;
            }
        }
        catch (Exception e) {
            System.err.println("[Tools] Error searching by name: " + e.getMessage());
        }
        return -1;
    }

    private void displayItemInfo(int itemId) {
        String itemName = this.getItemName(itemId);
        JPanel itemCard = new JPanel();
        itemCard.setLayout(new BoxLayout(itemCard, 1));
        itemCard.setBackground(BG_SECONDARY);
        itemCard.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(15, 15, 15, 15)));
        itemCard.setMaximumSize(new Dimension(Integer.MAX_VALUE, 250));
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBackground(BG_SECONDARY);
        headerPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        Image sprite = this.loadItemSprite(itemId, 1);
        if (sprite != null) {
            ImageIcon icon = new ImageIcon(sprite.getScaledInstance(48, 48, 4));
            JLabel spriteLabel = new JLabel(icon);
            headerPanel.add((Component)spriteLabel, "West");
        }
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 1));
        namePanel.setBackground(BG_SECONDARY);
        namePanel.setBorder(new EmptyBorder(0, 15, 0, 0));
        JLabel nameLabel = new JLabel(itemName);
        nameLabel.setForeground(TEXT_PRIMARY);
        nameLabel.setFont(new Font("Arial", 1, 16));
        JLabel idLabel = new JLabel("ID: " + itemId);
        idLabel.setForeground(TEXT_SECONDARY);
        idLabel.setFont(new Font("Arial", 0, 11));
        namePanel.add(nameLabel);
        namePanel.add(idLabel);
        headerPanel.add((Component)namePanel, "Center");
        itemCard.add(headerPanel);
        itemCard.add(Box.createVerticalStrut(15));
        try {
            ItemDef def = ItemDef.forID(itemId);
            if (def != null) {
                this.addItemStat(itemCard, "Stackable", def.stackable ? "Yes" : "No");
                if (def.description != null && !def.description.isEmpty()) {
                    JLabel descLabel = new JLabel("<html><span style='color: #a0a0b4; font-size: 11px;'>" + def.description + "</span></html>");
                    itemCard.add(Box.createVerticalStrut(10));
                    itemCard.add(descLabel);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Tools] Error loading item def: " + e.getMessage());
        }
        this.itemResultPanel.add(itemCard);
    }

    private void addItemStat(JPanel parent, String label, String value) {
        JPanel row = new JPanel(new BorderLayout());
        row.setBackground(BG_SECONDARY);
        row.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        JLabel labelText = new JLabel(label + ":");
        labelText.setForeground(TEXT_SECONDARY);
        labelText.setFont(new Font("Arial", 0, 12));
        JLabel valueText = new JLabel(value);
        valueText.setForeground(ACCENT);
        valueText.setFont(new Font("Arial", 1, 12));
        row.add((Component)labelText, "West");
        row.add((Component)valueText, "East");
        parent.add(row);
        parent.add(Box.createVerticalStrut(5));
    }

    private JPanel createQuickToolsSection() {
        String[] tools;
        JPanel section = new JPanel();
        section.setLayout(new BoxLayout(section, 1));
        section.setBackground(BG_PRIMARY);
        section.setAlignmentX(0.0f);
        section.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
        JLabel header = new JLabel("Quick Tools");
        header.setFont(new Font("Arial", 1, 14));
        header.setForeground(TEXT_PRIMARY);
        header.setAlignmentX(0.0f);
        section.add(header);
        section.add(Box.createVerticalStrut(10));
        for (String tool : tools = new String[]{"Combat Calculator", "Drop Calculator", "XP Calculator"}) {
            JButton toolButton = this.createToolButton(tool);
            section.add(toolButton);
            section.add(Box.createVerticalStrut(8));
        }
        return section;
    }

    private JButton createToolButton(String name) {
        final JButton button = new JButton(name);
        button.setBackground(BG_SECONDARY);
        button.setForeground(TEXT_PRIMARY);
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(10, 15, 10, 15)));
        button.setFont(new Font("Arial", 0, 12));
        button.setAlignmentX(0.0f);
        button.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(e -> JOptionPane.showMessageDialog(this, name + " coming soon!", "Tools", 1));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(new Color(50, 50, 60));
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ACCENT, 1), new EmptyBorder(10, 15, 10, 15)));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(BG_SECONDARY);
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), new EmptyBorder(10, 15, 10, 15)));
            }
        });
        return button;
    }

    private JButton createStyledButton(String text, final Color bg) {
        final JButton button = new JButton(text);
        button.setBackground(bg);
        button.setForeground(Color.WHITE);
        button.setFont(new Font("Arial", 1, 14));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(true);
        button.setPreferredSize(new Dimension(280, 42));
        button.setCursor(new Cursor(12));
        button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bg.darker(), 1), new EmptyBorder(8, 12, 8, 12)));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(bg.brighter());
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bg, 1), new EmptyBorder(8, 12, 8, 12)));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(bg);
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bg.darker(), 1), new EmptyBorder(8, 12, 8, 12)));
            }
        });
        return button;
    }

    private JButton createCompactButton(String text, final Color bg) {
        final JButton button = new JButton(text);
        button.setBackground(bg);
        button.setForeground(Color.WHITE);
        button.setFont(new Font("Arial", 1, 11));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(true);
        button.setPreferredSize(new Dimension(80, 28));
        button.setMaximumSize(new Dimension(100, 28));
        button.setCursor(new Cursor(12));
        button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bg.darker(), 1), new EmptyBorder(4, 8, 4, 8)));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(bg.brighter());
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bg, 1), new EmptyBorder(4, 8, 4, 8)));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(bg);
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bg.darker(), 1), new EmptyBorder(4, 8, 4, 8)));
            }
        });
        return button;
    }

    private void sendSavePresetPacket(String presetName) {
        if (!Client.loggedIn) {
            JOptionPane.showMessageDialog(this, "You must be logged in to save presets.");
            return;
        }
        Client.queuePresetSave(presetName);
        System.out.println("[ModernSidebar] Queued save preset packet: " + presetName);
    }

    private void sendLoadPresetPacket(int presetId) {
        if (!Client.loggedIn) {
            JOptionPane.showMessageDialog(this, "You must be logged in to load presets.");
            return;
        }
        Client.queuePresetLoad(presetId);
        System.out.println("[ModernSidebar] Queued load preset packet: ID=" + presetId);
    }

    private void sendDeletePresetPacket(int presetId) {
        if (!Client.loggedIn) {
            JOptionPane.showMessageDialog(this, "You must be logged in to delete presets.");
            return;
        }
        Client.queuePresetDelete(presetId);
        System.out.println("[ModernSidebar] Queued delete preset packet: ID=" + presetId);
    }

    private void sendUpdatePresetPacket(int presetId) {
        if (!Client.loggedIn) {
            JOptionPane.showMessageDialog(this, "You must be logged in to update presets.");
            return;
        }
        Client.queuePresetUpdate(presetId);
        System.out.println("[ModernSidebar] Queued update preset packet: ID=" + presetId);
    }

    public void sendRequestPresetsPacket() {
        if (!Client.loggedIn) {
            System.out.println("[ModernSidebar] Cannot request presets - not logged in");
            return;
        }
        Client.queuePresetRequest();
        System.out.println("[ModernSidebar] Queued request presets packet");
    }

    public void requestPresetsFromServer() {
        this.sendRequestPresetsPacket();
    }

    public void updatePresetList(List<PresetData> presets) {
        SwingUtilities.invokeLater(() -> {
            try {
                this.currentPresets = new ArrayList<PresetData>(presets);
                this.filteredPresets = new ArrayList<PresetData>(presets);
                this.presetDropdown.removeAllItems();
                this.presetDropdown.setEnabled(!presets.isEmpty());
                this.createPresetButton.setEnabled(true);
                if (presets.isEmpty()) {
                    this.presetDropdown.addItem("No presets found");
                } else {
                    for (PresetData preset : presets) {
                        this.presetDropdown.addItem(preset.name);
                    }
                }
                System.out.println("[ModernSidebar] Updated preset list with " + presets.size() + " presets");
            }
            catch (Exception e) {
                System.err.println("[ModernSidebar] Error updating preset list");
                e.printStackTrace();
            }
        });
    }

    static {
        BG_PRIMARY = new Color(40, 40, 44);
        BG_SECONDARY = new Color(47, 47, 51);
        BG_TERTIARY = new Color(54, 54, 58);
        BG_HOVER = new Color(60, 60, 65);
        ACCENT = new Color(100, 149, 237);
        TEXT_PRIMARY = new Color(240, 240, 245);
        TEXT_SECONDARY = new Color(160, 160, 170);
        BORDER_COLOR = new Color(60, 60, 64);
        itemNameCache = new HashMap<Integer, String>();
        spriteCache = new HashMap<Integer, Image>();
    }

    public static class SidebarTab {
        String name;
        String icon;
        JPanel content;

        public SidebarTab(String name, String icon, JPanel content) {
            this.name = name;
            this.icon = icon;
            this.content = content;
        }
    }

    public static class PresetData {
        public int id;
        public String name;
        public int loadCount;
        public int[] equipmentIds;
        public String inventoryJson;

        public PresetData(int id, String name, int loadCount) {
            this.id = id;
            this.name = name;
            this.loadCount = loadCount;
            this.equipmentIds = new int[11];
            this.inventoryJson = "[]";
        }

        public PresetData(int id, String name, int loadCount, int[] equipmentIds, String inventoryJson) {
            this.id = id;
            this.name = name;
            this.loadCount = loadCount;
            this.equipmentIds = equipmentIds;
            this.inventoryJson = inventoryJson;
        }
    }
}

