/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui.sidebar;

import com.teragard.Client;
import com.teragard.ui.sidebar.SidebarTab;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public class PresetsTab
implements SidebarTab {
    private static final Color BG_PRIMARY = new Color(30, 30, 40);
    private static final Color BG_SECONDARY = new Color(40, 40, 50);
    private static final Color BG_PRESET = new Color(45, 45, 60);
    private static final Color BG_PRESET_HOVER = new Color(55, 55, 75);
    private static final Color BG_PRESET_SELECTED = new Color(70, 70, 120);
    private static final Color TEXT_PRIMARY = new Color(240, 240, 250);
    private static final Color TEXT_SECONDARY = new Color(160, 160, 180);
    private static final Color ACCENT = new Color(120, 120, 255);
    private static final Color SUCCESS = new Color(100, 200, 100);
    private static final Color WARNING = new Color(255, 200, 100);
    private static final Color DANGER = new Color(255, 100, 100);
    private static final Color BORDER = new Color(60, 60, 75);
    private static PresetsTab instance;
    private List<GearPreset> presets = new ArrayList<GearPreset>();
    private GearPreset selectedPreset = null;
    private int scrollOffset = 0;
    private int mouseX = 0;
    private int mouseY = 0;
    private int panelWidth = 250;
    private int panelHeight = 400;
    private int panelX = 0;
    private int panelY = 0;
    private boolean isLoading = false;
    private String statusMessage = "";
    private long statusMessageTime = 0L;
    private static final int PRESET_ITEM_HEIGHT = 55;
    private static final int PRESET_PADDING = 8;
    private static final int BUTTON_HEIGHT = 32;
    private static final int HEADER_HEIGHT = 55;
    private static final int STATUS_HEIGHT = 25;

    public PresetsTab() {
        instance = this;
    }

    public static PresetsTab getInstance() {
        return instance;
    }

    @Override
    public String getName() {
        return "Presets";
    }

    @Override
    public String getDescription() {
        return "Save and load gear setups";
    }

    @Override
    public void render(Graphics2D g, int x, int y, int width, int height) {
        this.panelX = x;
        this.panelY = y;
        this.panelWidth = width;
        this.panelHeight = height;
        g.setColor(BG_PRIMARY);
        g.fillRect(x, y, width, height);
        this.drawHeader(g, x, y, width);
        int buttonY = y + 55;
        this.drawButton(g, x + 10, buttonY, width - 20, 32, "+ Save Current Setup", SUCCESS, this.isMouseOverButton(x + 10, buttonY, width - 20, 32));
        int listY = buttonY + 32 + 10;
        int listHeight = height - 55 - 32 - 20;
        if (this.selectedPreset != null) {
            listHeight -= 42;
        }
        this.drawPresetList(g, x + 10, listY, width - 20, listHeight);
        if (this.selectedPreset != null) {
            int actionsY = y + height - 32 - 10;
            int buttonWidth = (width - 35) / 2;
            this.drawButton(g, x + 10, actionsY, buttonWidth, 32, "Load", ACCENT, this.isMouseOverButton(x + 10, actionsY, buttonWidth, 32));
            this.drawButton(g, x + 20 + buttonWidth, actionsY, buttonWidth, 32, "Delete", DANGER, this.isMouseOverButton(x + 20 + buttonWidth, actionsY, buttonWidth, 32));
        }
        if (this.isLoading) {
            this.drawLoadingOverlay(g, x, y, width, height);
        }
        if (!this.statusMessage.isEmpty() && System.currentTimeMillis() - this.statusMessageTime < 3000L) {
            this.drawStatusMessage(g, x, y + height - 25, width);
        }
    }

    private void drawHeader(Graphics2D g, int x, int y, int width) {
        g.setColor(BG_SECONDARY);
        g.fillRect(x, y, width, 55);
        g.setFont(new Font("Arial", 1, 16));
        g.setColor(TEXT_PRIMARY);
        g.drawString("Gear Presets", x + 15, y + 22);
        g.setFont(new Font("Arial", 0, 12));
        g.setColor(TEXT_SECONDARY);
        String countText = this.presets.size() + " preset" + (this.presets.size() != 1 ? "s" : "") + " saved";
        g.drawString(countText, x + 15, y + 40);
        int refreshX = x + width - 35;
        int refreshY = y + 12;
        int refreshSize = 28;
        boolean hoveringRefresh = this.isMouseOver(refreshX, refreshY, refreshSize, refreshSize);
        g.setColor(hoveringRefresh ? BG_PRESET_HOVER : BG_PRESET);
        g.fillRoundRect(refreshX, refreshY, refreshSize, refreshSize, 6, 6);
        g.setColor(TEXT_PRIMARY);
        g.setStroke(new BasicStroke(2.0f));
        g.drawArc(refreshX + 6, refreshY + 6, 16, 16, 45, 270);
        g.drawLine(refreshX + 18, refreshY + 8, refreshX + 22, refreshY + 8);
        g.drawLine(refreshX + 18, refreshY + 8, refreshX + 18, refreshY + 12);
        g.setStroke(new BasicStroke(1.0f));
    }

    private void drawPresetList(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(BG_SECONDARY);
        g.fillRoundRect(x, y, width, height, 8, 8);
        g.setColor(BORDER);
        g.setStroke(new BasicStroke(1.0f));
        g.drawRoundRect(x, y, width, height, 8, 8);
        if (this.presets.isEmpty()) {
            g.setFont(new Font("Arial", 2, 14));
            g.setColor(TEXT_SECONDARY);
            String msg1 = "No presets saved";
            String msg2 = "Click '+ Save Current Setup'";
            String msg3 = "to create your first preset";
            FontMetrics fm = g.getFontMetrics();
            g.drawString(msg1, x + (width - fm.stringWidth(msg1)) / 2, y + height / 2 - 20);
            g.setFont(new Font("Arial", 0, 12));
            fm = g.getFontMetrics();
            g.drawString(msg2, x + (width - fm.stringWidth(msg2)) / 2, y + height / 2 + 5);
            g.drawString(msg3, x + (width - fm.stringWidth(msg3)) / 2, y + height / 2 + 22);
            return;
        }
        Shape oldClip = g.getClip();
        g.setClip(x + 2, y + 2, width - 4, height - 4);
        int itemY = y + 8 - this.scrollOffset;
        for (int i = 0; i < this.presets.size(); ++i) {
            GearPreset preset = this.presets.get(i);
            if (itemY + 55 < y || itemY > y + height) {
                itemY += 63;
                continue;
            }
            boolean isSelected = preset == this.selectedPreset;
            boolean isHovering = this.isMouseOver(x + 5, itemY, width - 10, 55);
            if (isSelected) {
                g.setColor(BG_PRESET_SELECTED);
            } else if (isHovering) {
                g.setColor(BG_PRESET_HOVER);
            } else {
                g.setColor(BG_PRESET);
            }
            g.fillRoundRect(x + 5, itemY, width - 10, 55, 6, 6);
            if (isSelected) {
                g.setColor(ACCENT);
                g.fillRoundRect(x + 5, itemY, 3, 55, 2, 2);
            }
            g.setFont(new Font("Arial", 1, 18));
            g.setColor(isSelected ? ACCENT : TEXT_SECONDARY);
            String numStr = String.valueOf(i + 1);
            g.drawString(numStr, x + 15, itemY + 32);
            g.setFont(new Font("Arial", 1, 14));
            g.setColor(TEXT_PRIMARY);
            Object name = preset.getName();
            if (((String)name).length() > 20) {
                name = ((String)name).substring(0, 17) + "...";
            }
            g.drawString((String)name, x + 40, itemY + 22);
            g.setFont(new Font("Arial", 0, 11));
            g.setColor(TEXT_SECONDARY);
            String info = preset.getItemCount() + " items";
            if (preset.getLoadCount() > 0) {
                info = info + " \u2022 Loaded " + preset.getLoadCount() + "x";
            }
            g.drawString(info, x + 40, itemY + 40);
            itemY += 63;
        }
        g.setClip(oldClip);
        int totalHeight = this.presets.size() * 63;
        if (totalHeight > height) {
            if (this.scrollOffset > 0) {
                g.setColor(new Color(0, 0, 0, 100));
                g.fillRect(x, y, width, 20);
                g.setColor(TEXT_PRIMARY);
                g.drawString("\u25b2", x + width / 2 - 5, y + 15);
            }
            if (this.scrollOffset < totalHeight - height) {
                g.setColor(new Color(0, 0, 0, 100));
                g.fillRect(x, y + height - 20, width, 20);
                g.setColor(TEXT_PRIMARY);
                g.drawString("\u25bc", x + width / 2 - 5, y + height - 5);
            }
        }
    }

    private void drawButton(Graphics2D g, int x, int y, int width, int height, String text, Color baseColor, boolean isHovering) {
        Color buttonColor = isHovering ? this.brighten(baseColor, 1.2f) : baseColor;
        g.setColor(buttonColor);
        g.fillRoundRect(x, y, width, height, 6, 6);
        g.setColor(this.brighten(baseColor, 0.7f));
        g.drawRoundRect(x, y, width, height, 6, 6);
        g.setFont(new Font("Arial", 1, 12));
        g.setColor(Color.WHITE);
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        int textX = x + (width - textWidth) / 2;
        int textY = y + (height + fm.getAscent()) / 2 - 3;
        g.drawString(text, textX, textY);
    }

    private void drawLoadingOverlay(Graphics2D g, int x, int y, int width, int height) {
        g.setColor(new Color(0, 0, 0, 150));
        g.fillRect(x, y, width, height);
        g.setFont(new Font("Arial", 1, 14));
        g.setColor(TEXT_PRIMARY);
        String msg = "Loading...";
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, x + (width - fm.stringWidth(msg)) / 2, y + height / 2);
    }

    private void drawStatusMessage(Graphics2D g, int x, int y, int width) {
        g.setColor(new Color(0, 0, 0, 200));
        g.fillRect(x, y, width, 25);
        g.setFont(new Font("Arial", 0, 11));
        g.setColor(TEXT_PRIMARY);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.statusMessage, x + (width - fm.stringWidth(this.statusMessage)) / 2, y + 16);
    }

    private Color brighten(Color color, float factor) {
        int r = Math.min(255, (int)((float)color.getRed() * factor));
        int g = Math.min(255, (int)((float)color.getGreen() * factor));
        int b = Math.min(255, (int)((float)color.getBlue() * factor));
        return new Color(r, g, b);
    }

    @Override
    public void handleClick(int x, int y) {
        int relX = x + this.panelX;
        int relY = y + this.panelY;
        int refreshX = this.panelX + this.panelWidth - 35;
        int refreshY = this.panelY + 12;
        if (this.isMouseOver(refreshX, refreshY, 28, 28)) {
            this.requestPresetsFromServer();
            return;
        }
        int saveButtonY = this.panelY + 55;
        if (this.isMouseOver(this.panelX + 10, saveButtonY, this.panelWidth - 20, 32)) {
            this.createNewPreset();
            return;
        }
        int listY = saveButtonY + 32 + 10;
        int listHeight = this.panelHeight - 55 - 32 - 20;
        if (this.selectedPreset != null) {
            listHeight -= 42;
        }
        if (this.isMouseOver(this.panelX + 10, listY, this.panelWidth - 20, listHeight)) {
            int itemY = listY + 8 - this.scrollOffset;
            for (GearPreset preset : this.presets) {
                if (this.isMouseOver(this.panelX + 15, itemY, this.panelWidth - 30, 55)) {
                    if (this.selectedPreset == preset) {
                        this.loadPreset(preset);
                    } else {
                        this.selectedPreset = preset;
                        System.out.println("[PresetsTab] Selected: " + preset.getName());
                    }
                    return;
                }
                itemY += 63;
            }
        }
        if (this.selectedPreset != null) {
            int actionsY = this.panelY + this.panelHeight - 32 - 10;
            int buttonWidth = (this.panelWidth - 35) / 2;
            if (this.isMouseOver(this.panelX + 10, actionsY, buttonWidth, 32)) {
                this.loadPreset(this.selectedPreset);
                return;
            }
            if (this.isMouseOver(this.panelX + 20 + buttonWidth, actionsY, buttonWidth, 32)) {
                this.deletePreset(this.selectedPreset);
                return;
            }
        }
    }

    @Override
    public void handleMouseMove(int x, int y) {
        this.mouseX = x + this.panelX;
        this.mouseY = y + this.panelY;
    }

    public void handleScroll(int scrollAmount) {
        int totalHeight = this.presets.size() * 63;
        int listHeight = this.panelHeight - 55 - 32 - 20;
        if (this.selectedPreset != null) {
            listHeight -= 42;
        }
        this.scrollOffset += scrollAmount * 30;
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, Math.max(0, totalHeight - listHeight)));
    }

    private boolean isMouseOver(int x, int y, int width, int height) {
        return this.mouseX >= x && this.mouseX < x + width && this.mouseY >= y && this.mouseY < y + height;
    }

    private boolean isMouseOverButton(int x, int y, int width, int height) {
        return this.isMouseOver(x, y, width, height);
    }

    public void requestPresetsFromServer() {
        if (!Client.loggedIn) {
            this.showStatus("Must be logged in to view presets");
            return;
        }
        this.isLoading = true;
        this.showStatus("Loading presets...");
        Client.queuePresetRequest();
        System.out.println("[PresetsTab] Requested presets from server");
    }

    private void createNewPreset() {
        if (!Client.loggedIn) {
            this.showStatus("Must be logged in to save presets");
            return;
        }
        String presetName = "Preset " + (this.presets.size() + 1);
        this.isLoading = true;
        this.showStatus("Saving preset...");
        Client.queuePresetSave(presetName);
        System.out.println("[PresetsTab] Saving new preset: " + presetName);
    }

    private void loadPreset(GearPreset preset) {
        if (!Client.loggedIn) {
            this.showStatus("Must be logged in to load presets");
            return;
        }
        if (preset == null) {
            return;
        }
        this.isLoading = true;
        this.showStatus("Loading " + preset.getName() + "...");
        Client.queuePresetLoad(preset.getId());
        System.out.println("[PresetsTab] Loading preset: " + preset.getName() + " (ID: " + preset.getId() + ")");
    }

    private void deletePreset(GearPreset preset) {
        if (!Client.loggedIn) {
            this.showStatus("Must be logged in to delete presets");
            return;
        }
        if (preset == null) {
            return;
        }
        this.isLoading = true;
        this.showStatus("Deleting " + preset.getName() + "...");
        Client.queuePresetDelete(preset.getId());
        this.presets.remove(preset);
        if (this.selectedPreset == preset) {
            this.selectedPreset = null;
        }
        System.out.println("[PresetsTab] Deleting preset: " + preset.getName() + " (ID: " + preset.getId() + ")");
    }

    public void updatePreset(GearPreset preset) {
        if (!Client.loggedIn) {
            this.showStatus("Must be logged in to update presets");
            return;
        }
        if (preset == null) {
            return;
        }
        this.isLoading = true;
        this.showStatus("Updating " + preset.getName() + "...");
        Client.queuePresetUpdate(preset.getId());
        System.out.println("[PresetsTab] Updating preset: " + preset.getName() + " (ID: " + preset.getId() + ")");
    }

    public void onPresetsReceived(List<GearPreset> serverPresets) {
        this.presets = new ArrayList<GearPreset>(serverPresets);
        this.isLoading = false;
        this.scrollOffset = 0;
        if (this.selectedPreset != null) {
            boolean found = false;
            for (GearPreset p : this.presets) {
                if (p.getId() != this.selectedPreset.getId()) continue;
                this.selectedPreset = p;
                found = true;
                break;
            }
            if (!found) {
                this.selectedPreset = null;
            }
        }
        this.showStatus("Loaded " + this.presets.size() + " preset" + (this.presets.size() != 1 ? "s" : ""));
        System.out.println("[PresetsTab] Received " + this.presets.size() + " presets from server");
    }

    public void onPresetSaved(int presetId, String name) {
        this.isLoading = false;
        this.showStatus("Saved: " + name);
        this.requestPresetsFromServer();
    }

    public void onPresetLoaded(int presetId, List<String> missingItems) {
        this.isLoading = false;
        String presetName = "preset";
        for (GearPreset p : this.presets) {
            if (p.getId() != presetId) continue;
            p.incrementLoadCount();
            presetName = p.getName();
            break;
        }
        if (missingItems == null || missingItems.isEmpty()) {
            this.showStatus("Loaded: " + presetName);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Loaded with ").append(missingItems.size()).append(" missing: ");
            for (int i = 0; i < Math.min(3, missingItems.size()); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(missingItems.get(i));
            }
            if (missingItems.size() > 3) {
                sb.append(" +").append(missingItems.size() - 3).append(" more");
            }
            this.showStatus(sb.toString());
            System.out.println("[PresetsTab] Missing items: " + String.valueOf(missingItems));
        }
    }

    public void onPresetLoaded(int presetId) {
        this.onPresetLoaded(presetId, null);
    }

    public void onPresetDeleted(int presetId) {
        this.isLoading = false;
        this.showStatus("Preset deleted");
    }

    public void onPresetError(String message) {
        this.isLoading = false;
        this.showStatus("Error: " + message);
        System.err.println("[PresetsTab] Error: " + message);
    }

    private void showStatus(String message) {
        this.statusMessage = message;
        this.statusMessageTime = System.currentTimeMillis();
    }

    public static class GearPreset {
        private int id;
        private String name;
        private int itemCount;
        private int loadCount;
        private int[] equipmentIds;
        private String inventoryJson;

        public GearPreset(int id, String name, int itemCount) {
            this.id = id;
            this.name = name;
            this.itemCount = itemCount;
            this.loadCount = 0;
            this.equipmentIds = new int[11];
            this.inventoryJson = "[]";
        }

        public GearPreset(int id, String name, int loadCount, int[] equipmentIds, String inventoryJson) {
            this.id = id;
            this.name = name;
            this.loadCount = loadCount;
            this.equipmentIds = equipmentIds;
            this.inventoryJson = inventoryJson;
            this.itemCount = this.calculateItemCount();
        }

        private int calculateItemCount() {
            int count = 0;
            if (this.equipmentIds != null) {
                for (int itemId : this.equipmentIds) {
                    if (itemId <= 0) continue;
                    ++count;
                }
            }
            if (this.inventoryJson != null && !this.inventoryJson.equals("[]")) {
                count += this.inventoryJson.split("\\},\\{").length;
            }
            return count;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getItemCount() {
            return this.itemCount;
        }

        public int getLoadCount() {
            return this.loadCount;
        }

        public void incrementLoadCount() {
            ++this.loadCount;
        }

        public int[] getEquipmentIds() {
            return this.equipmentIds;
        }

        public String getInventoryJson() {
            return this.inventoryJson;
        }
    }
}

