/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.ui.sidebar;

import com.teragard.ui.sidebar.InfoTab;
import com.teragard.ui.sidebar.PresetsTab;
import com.teragard.ui.sidebar.SettingsTab;
import com.teragard.ui.sidebar.SidebarTab;
import com.teragard.ui.sidebar.ToolsTab;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public class SidebarManager {
    private static boolean visible = true;
    private static boolean collapsed = false;
    private static SidebarTab activeTab = null;
    private static List<SidebarTab> tabs = new ArrayList<SidebarTab>();
    private static final int SIDEBAR_WIDTH = 300;
    private static final int SIDEBAR_COLLAPSED_WIDTH = 50;
    private static final int TAB_BUTTON_HEIGHT = 50;
    private static final int HEADER_HEIGHT = 60;
    private static int currentWidth = 300;
    private static int targetWidth = 300;
    private static long lastUpdate = System.currentTimeMillis();
    private static final Color BG_PRIMARY = new Color(30, 30, 40);
    private static final Color BG_SECONDARY = new Color(40, 40, 50);
    private static final Color BG_HEADER = new Color(25, 25, 35);
    private static final Color TEXT_PRIMARY = new Color(240, 240, 250);
    private static final Color TEXT_SECONDARY = new Color(160, 160, 180);
    private static final Color ACCENT = new Color(120, 120, 255);
    private static final Color ACCENT_HOVER = new Color(140, 140, 255);
    private static final Color TAB_ACTIVE = new Color(50, 50, 70);
    private static final Color TAB_HOVER = new Color(45, 45, 60);
    private static int mouseX = 0;
    private static int mouseY = 0;
    private static boolean mousePressed = false;

    public static void initialize() {
        tabs.clear();
        tabs.add(new PresetsTab());
        tabs.add(new SettingsTab());
        tabs.add(new InfoTab());
        tabs.add(new ToolsTab());
        if (!tabs.isEmpty()) {
            activeTab = tabs.get(0);
        }
        System.out.println("[SidebarManager] Initialized with " + tabs.size() + " tabs");
    }

    public static void render(Graphics2D g, int screenWidth, int screenHeight) {
        if (!visible) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        SidebarManager.updateAnimation();
        int x = screenWidth - currentWidth;
        int y = 0;
        g.setColor(BG_PRIMARY);
        g.fillRect(x, y, currentWidth, screenHeight);
        SidebarManager.drawHeader(g, x, y);
        SidebarManager.drawTabButtons(g, x, y + 60, screenHeight - 60);
        if (!collapsed && activeTab != null) {
            int contentX = x + 50;
            int contentY = y + 60;
            int contentWidth = currentWidth - 50;
            int contentHeight = screenHeight - 60;
            Shape oldClip = g.getClip();
            g.setClip(contentX, contentY, contentWidth, contentHeight);
            activeTab.render(g, contentX, contentY, contentWidth, contentHeight);
            g.setClip(oldClip);
        }
        g.setColor(ACCENT);
        g.fillRect(x, y, 2, screenHeight);
    }

    private static void drawHeader(Graphics2D g, int x, int y) {
        int buttonSize;
        int buttonY;
        int buttonX;
        boolean hoveringButton;
        g.setColor(BG_HEADER);
        g.fillRect(x, y, currentWidth, 60);
        if (!collapsed) {
            g.setFont(new Font("Arial", 1, 18));
            g.setColor(TEXT_PRIMARY);
            g.drawString("Teragard Tools", x + 50 + 10, y + 30);
            g.setFont(new Font("Arial", 0, 12));
            g.setColor(TEXT_SECONDARY);
            g.drawString("RuneLite-style Sidebar", x + 50 + 10, y + 48);
        }
        g.setColor((hoveringButton = SidebarManager.isMouseOver(buttonX = x + 10, buttonY = y + 15, buttonSize = 30, buttonSize)) ? TAB_HOVER : BG_SECONDARY);
        g.fillRoundRect(buttonX, buttonY, buttonSize, buttonSize, 8, 8);
        g.setColor(TEXT_PRIMARY);
        g.setStroke(new BasicStroke(2.0f));
        if (collapsed) {
            int[] xPoints = new int[]{buttonX + 12, buttonX + 20, buttonX + 12};
            int[] yPoints = new int[]{buttonY + 10, buttonY + 15, buttonY + 20};
            g.drawPolyline(xPoints, yPoints, 3);
        } else {
            int[] xPoints = new int[]{buttonX + 18, buttonX + 10, buttonX + 18};
            int[] yPoints = new int[]{buttonY + 10, buttonY + 15, buttonY + 20};
            g.drawPolyline(xPoints, yPoints, 3);
        }
        g.setStroke(new BasicStroke(1.0f));
    }

    private static void drawTabButtons(Graphics2D g, int x, int y, int availableHeight) {
        int buttonY = y;
        for (SidebarTab tab : tabs) {
            boolean isActive = tab == activeTab;
            boolean isHovering = SidebarManager.isMouseOver(x, buttonY, 50, 50);
            if (isActive) {
                g.setColor(TAB_ACTIVE);
            } else if (isHovering) {
                g.setColor(TAB_HOVER);
            } else {
                g.setColor(BG_SECONDARY);
            }
            g.fillRect(x, buttonY, 50, 50);
            if (isActive) {
                g.setColor(ACCENT);
                g.fillRect(x, buttonY, 3, 50);
            }
            g.setFont(new Font("Arial", 1, 20));
            g.setColor(isActive ? ACCENT : TEXT_PRIMARY);
            String icon = tab.getName().substring(0, 1);
            FontMetrics fm = g.getFontMetrics();
            int iconWidth = fm.stringWidth(icon);
            int iconX = x + (50 - iconWidth) / 2;
            int iconY = buttonY + (50 + fm.getAscent()) / 2 - 2;
            g.drawString(icon, iconX, iconY);
            if (!collapsed && currentWidth > 100) {
                g.setFont(new Font("Arial", 0, 14));
                g.setColor(TEXT_PRIMARY);
                g.drawString(tab.getName(), x + 50 + 10, buttonY + 25 + 5);
            }
            buttonY += 50;
        }
    }

    private static void updateAnimation() {
        long now = System.currentTimeMillis();
        long delta = now - lastUpdate;
        lastUpdate = now;
        if (currentWidth != targetWidth) {
            int diff = targetWidth - currentWidth;
            int step = (int)((double)diff * 0.2);
            if (Math.abs(step) < 1) {
                step = diff > 0 ? 1 : -1;
            }
            if (step > 0 && (currentWidth += step) > targetWidth || step < 0 && currentWidth < targetWidth) {
                currentWidth = targetWidth;
            }
        }
    }

    private static boolean isMouseOver(int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static void handleClick(int x, int y, int screenWidth, int screenHeight) {
        if (!visible) {
            return;
        }
        int sidebarX = screenWidth - currentWidth;
        int buttonX = sidebarX + 10;
        int buttonY = 15;
        int buttonSize = 30;
        if (SidebarManager.isMouseOver(buttonX, buttonY, buttonSize, buttonSize)) {
            SidebarManager.toggleCollapsed();
            return;
        }
        buttonY = 60;
        for (SidebarTab tab : tabs) {
            if (SidebarManager.isMouseOver(sidebarX, buttonY, 50, 50)) {
                SidebarManager.setActiveTab(tab);
                if (collapsed) {
                    SidebarManager.toggleCollapsed();
                }
                return;
            }
            buttonY += 50;
        }
        if (!collapsed && activeTab != null) {
            int contentX = sidebarX + 50;
            int contentY = 60;
            int contentWidth = currentWidth - 50;
            int contentHeight = screenHeight - 60;
            if (x >= contentX && x < contentX + contentWidth && y >= contentY && y < contentY + contentHeight) {
                activeTab.handleClick(x - contentX, y - contentY);
            }
        }
    }

    public static void handleMouseMove(int x, int y) {
        mouseX = x;
        mouseY = y;
    }

    public static void toggleCollapsed() {
        collapsed = !collapsed;
        targetWidth = collapsed ? 50 : 300;
        System.out.println("[SidebarManager] Sidebar " + (collapsed ? "collapsed" : "expanded"));
    }

    public static void toggleVisible() {
        visible = !visible;
        System.out.println("[SidebarManager] Sidebar visibility: " + visible);
    }

    public static void setActiveTab(SidebarTab tab) {
        if (tabs.contains(tab)) {
            activeTab = tab;
            System.out.println("[SidebarManager] Active tab: " + tab.getName());
        }
    }

    public static SidebarTab getActiveTab() {
        return activeTab;
    }

    public static boolean isVisible() {
        return visible;
    }

    public static boolean isCollapsed() {
        return collapsed;
    }

    public static int getCurrentWidth() {
        return currentWidth;
    }
}

