/*
 * Decompiled with CFR 0.152.
 */
package com.teragard.util;

import com.teragard.DrawingArea;
import com.teragard.Sprite;
import com.teragard.SpriteLoader;
import com.teragard.TextDrawingArea;

public class DrawingUtils {
    private static final int BORDER_TOP_LEFT = 622;
    private static final int BORDER_TOP_CENTER = 623;
    private static final int BORDER_TOP_RIGHT = 624;
    private static final int BORDER_LEFT = 625;
    private static final int BORDER_RIGHT = 626;
    private static final int BORDER_BOTTOM_LEFT = 627;
    private static final int BORDER_BOTTOM_CENTER = 628;
    private static final int BORDER_BOTTOM_RIGHT = 629;

    public static void drawBorder(Sprite backTexture, int x, int y, int width, int height, int alpha, int backColour, boolean filled, boolean shadow) {
        if (SpriteLoader.sprites == null || SpriteLoader.sprites.length < 629) {
            return;
        }
        int pieceWidth = SpriteLoader.sprites[623].myWidth;
        int pieceHeight = SpriteLoader.sprites[625].myHeight;
        byte remainingWidth = (byte)(width % pieceWidth);
        byte remainingHeight = (byte)(height % pieceHeight);
        if (shadow) {
            int n = Math.max(0, alpha - 150);
        }
        if (filled) {
            if (backTexture == null) {
                DrawingArea.drawPixelsWithOpacity(backColour, y + pieceHeight, width - pieceWidth - remainingWidth, height - pieceHeight - remainingHeight, alpha, x + pieceWidth);
            } else {
                byte textureWidth = (byte)backTexture.myWidth;
                byte textureHeight = (byte)backTexture.myHeight;
                for (int textureWidthIndex = 0; textureWidthIndex < width / textureWidth; ++textureWidthIndex) {
                    for (int textureHeightIndex = 0; textureHeightIndex < height / textureHeight; ++textureHeightIndex) {
                        backTexture.drawSprite(x + textureWidthIndex * textureWidth, y + textureHeightIndex * textureHeight, alpha);
                    }
                }
            }
        }
        DrawingUtils.drawBorderPieces(x, y, width, height, pieceWidth, pieceHeight, remainingWidth, remainingHeight, alpha);
    }

    private static void drawBorderPieces(int x, int y, int width, int height, int pieceWidth, int pieceHeight, int remainingWidth, int remainingHeight, int alpha) {
        for (int topIndex = 0; topIndex < (width - pieceWidth - remainingWidth) / pieceWidth; ++topIndex) {
            SpriteLoader.sprites[623].drawSprite(x + pieceWidth + topIndex * pieceWidth, y, alpha);
        }
        for (int bottomIndex = 0; bottomIndex < (width - pieceWidth - remainingWidth) / pieceWidth; ++bottomIndex) {
            SpriteLoader.sprites[628].drawSprite(x + pieceWidth + bottomIndex * pieceWidth, y + height - pieceHeight, alpha);
        }
        for (int leftIndex = 0; leftIndex < (height - pieceHeight - remainingHeight) / pieceHeight; ++leftIndex) {
            SpriteLoader.sprites[625].drawSprite(x, y + pieceHeight + leftIndex * pieceHeight, alpha);
        }
        for (int rightIndex = 0; rightIndex < (height - pieceHeight - remainingHeight) / pieceHeight; ++rightIndex) {
            SpriteLoader.sprites[626].drawSprite(x + width - pieceWidth, y + pieceHeight + rightIndex * pieceHeight, alpha);
        }
        SpriteLoader.sprites[622].drawSprite(x, y, alpha);
        SpriteLoader.sprites[624].drawSprite(x + width - pieceWidth, y, alpha);
        SpriteLoader.sprites[627].drawSprite(x, y + height - pieceHeight, alpha);
        SpriteLoader.sprites[629].drawSprite(x + width - pieceWidth, y + height - pieceHeight, alpha);
    }

    public static void drawColorBox(int colour, int y, int x, int width, int height) {
        DrawingArea.drawPixels(height, y, colour, width, x);
    }

    public static void drawHoverBox(int x, int y, String text, TextDrawingArea font) {
        if (text == null || font == null) {
            return;
        }
        String[] lines = text.split("\\\\n");
        int width = 0;
        int height = lines.length * 15 + 8;
        for (String line : lines) {
            int lineWidth = font.getTextWidth(line);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        DrawingArea.drawPixels(height, y, 4076841, width += 10, x);
        DrawingArea.drawHorizontalLine(x, y, width, 4076841);
        DrawingArea.drawHorizontalLine(x, y + height - 1, width, 4076841);
        DrawingArea.drawVerticalLine(x, y, height, 4076841);
        DrawingArea.drawVerticalLine(x + width - 1, y, height, 4076841);
        int textY = y + 15;
        for (String line : lines) {
            font.drawRegularText(false, x + 5, 0xFFFFFF, line, textY);
            textY += 15;
        }
    }

    public static void drawHoverBox(int x, int y, String text, TextDrawingArea font, int bgColor, int textColor, int borderColor) {
        if (text == null || font == null) {
            return;
        }
        String[] lines = text.split("\\\\n");
        int width = 0;
        int height = lines.length * 15 + 8;
        for (String line : lines) {
            int lineWidth = font.getTextWidth(line);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        DrawingArea.drawPixels(height, y, bgColor, width += 10, x);
        DrawingArea.drawHorizontalLine(x, y, width, borderColor);
        DrawingArea.drawHorizontalLine(x, y + height - 1, width, borderColor);
        DrawingArea.drawVerticalLine(x, y, height, borderColor);
        DrawingArea.drawVerticalLine(x + width - 1, y, height, borderColor);
        int textY = y + 15;
        for (String line : lines) {
            font.drawRegularText(false, x + 5, textColor, line, textY);
            textY += 15;
        }
    }

    public static void drawGradientBox(int x, int y, int width, int height, int startColor, int endColor) {
        for (int i = 0; i < height; ++i) {
            float ratio = (float)i / (float)height;
            int color = DrawingUtils.interpolateColor(startColor, endColor, ratio);
            DrawingArea.drawHorizontalLine(x, y + i, width, color);
        }
    }

    public static int interpolateColor(int color1, int color2, float ratio) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return r << 16 | g << 8 | b;
    }

    public static boolean mouseInRegion(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public static void drawRoundedRect(int x, int y, int width, int height, int color, int alpha) {
        DrawingArea.drawPixelsWithOpacity(color, y, width, height, alpha, x);
    }

    public static void drawOverlay(int x, int y, int width, int height, int color, int alpha) {
        DrawingArea.drawPixelsWithOpacity(color, y, width, height, alpha, x);
    }
}

