/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ByteBuffer;
import com.teragard.Texture;

public final class ARGBTexture
extends Texture {
    public int[] pixels;

    public ARGBTexture(int width, int height, ByteBuffer buffer) {
        super(width, height);
        int count = width * height;
        this.pixels = new int[count];
        int[] pixels = this.pixels;
        for (int i = 0; i != count; ++i) {
            int alpha;
            int pixel = buffer.readDWord();
            if ((pixel & 0xFF000000) == 0) {
                pixel = 0;
            }
            if ((alpha = pixel & 0xFF000000) != -16777216) {
                this.opaque = false;
                if (alpha != 0) {
                    this.hasAlpha = true;
                }
            }
            pixels[i] = pixel;
        }
    }

    @Override
    public int getPixel(int i) {
        return this.pixels[i];
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setPixels(int[] pixels) {
        this.pixels = pixels;
    }

    @Override
    public String toString() {
        return "3\t" + super.toString();
    }
}

