/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.DrawingArea;
import com.teragard.Stream;

public final class Background
extends DrawingArea {
    public byte[] imgPixels;
    public final int[] palette;
    public int imgWidth;
    public int imgHeight;
    public int xDrawOffset;
    public int yDrawOffset;
    public int libWidth;
    private int libHeight;

    public Background(CacheArchive streamLoader, String s, int i) {
        Stream stream = new Stream(streamLoader.getDataForName(s + ".dat"));
        Stream stream_1 = new Stream(streamLoader.getDataForName("index.dat"));
        stream_1.currentOffset = stream.readUnsignedWord();
        this.libWidth = stream_1.readUnsignedWord();
        this.libHeight = stream_1.readUnsignedWord();
        int j = stream_1.readUnsignedByte();
        this.palette = new int[j];
        for (int k = 0; k < j - 1; ++k) {
            this.palette[k + 1] = stream_1.read3Bytes();
        }
        for (int l = 0; l < i; ++l) {
            stream_1.currentOffset += 2;
            stream.currentOffset += stream_1.readUnsignedWord() * stream_1.readUnsignedWord();
            ++stream_1.currentOffset;
        }
        this.xDrawOffset = stream_1.readUnsignedByte();
        this.yDrawOffset = stream_1.readUnsignedByte();
        this.imgWidth = stream_1.readUnsignedWord();
        this.imgHeight = stream_1.readUnsignedWord();
        int type = stream_1.readUnsignedByte();
        int j1 = this.imgWidth * this.imgHeight;
        this.imgPixels = new byte[j1];
        if (type == 0) {
            for (int k1 = 0; k1 < j1; ++k1) {
                this.imgPixels[k1] = stream.readSignedByte();
            }
            return;
        }
        if (type == 1) {
            for (int l1 = 0; l1 < this.imgWidth; ++l1) {
                for (int i2 = 0; i2 < this.imgHeight; ++i2) {
                    this.imgPixels[l1 + i2 * this.imgWidth] = stream.readSignedByte();
                }
            }
        }
    }

    public void reduceSetOffset() {
        this.libWidth /= 2;
        this.libHeight /= 2;
        byte[] pixelBuffer = new byte[this.libWidth * this.libHeight];
        int i = 0;
        for (int j = 0; j < this.imgHeight; ++j) {
            for (int k = 0; k < this.imgWidth; ++k) {
                pixelBuffer[(k + this.xDrawOffset >> 1) + (j + this.yDrawOffset >> 1) * this.libWidth] = this.imgPixels[i++];
            }
        }
        this.imgPixels = pixelBuffer;
        this.imgWidth = this.libWidth;
        this.imgHeight = this.libHeight;
        this.xDrawOffset = 0;
        this.yDrawOffset = 0;
    }

    public void setOffset() {
        if (this.imgWidth == this.libWidth && this.imgHeight == this.libHeight) {
            return;
        }
        byte[] pixelBuffer = new byte[this.libWidth * this.libHeight];
        int i = 0;
        for (int y = 0; y < this.imgHeight; ++y) {
            for (int x = 0; x < this.imgWidth; ++x) {
                pixelBuffer[x + this.xDrawOffset + (y + this.yDrawOffset) * this.libWidth] = this.imgPixels[i++];
            }
        }
        this.imgPixels = pixelBuffer;
        this.imgWidth = this.libWidth;
        this.imgHeight = this.libHeight;
        this.xDrawOffset = 0;
        this.yDrawOffset = 0;
    }

    public void spriteClip(int x, int y, int stretchWidth, int stretchHeight) {
        try {
            int width = this.imgWidth;
            int height = this.imgHeight;
            int k1 = 0;
            int l1 = 0;
            int i2 = (width << 16) / stretchWidth;
            int j2 = (height << 16) / stretchHeight;
            int k2 = this.libWidth;
            int l2 = this.libHeight;
            i2 = (k2 << 16) / stretchWidth;
            j2 = (l2 << 16) / stretchHeight;
            x += (this.xDrawOffset * stretchWidth + k2 - 1) / k2;
            y += (this.yDrawOffset * stretchHeight + l2 - 1) / l2;
            if (this.xDrawOffset * stretchWidth % k2 != 0) {
                k1 = (k2 - this.xDrawOffset * stretchWidth % k2 << 16) / stretchWidth;
            }
            if (this.yDrawOffset * stretchHeight % l2 != 0) {
                l1 = (l2 - this.yDrawOffset * stretchHeight % l2 << 16) / stretchHeight;
            }
            stretchWidth = stretchWidth * (this.imgWidth - (k1 >> 16)) / k2;
            stretchHeight = stretchHeight * (this.imgHeight - (l1 >> 16)) / l2;
            int i3 = x + y * DrawingArea.width;
            int j3 = DrawingArea.width - stretchWidth;
            if (y < DrawingArea.topY) {
                int k3 = DrawingArea.topY - y;
                stretchHeight -= k3;
                y = 0;
                i3 += k3 * DrawingArea.width;
                l1 += j2 * k3;
            }
            if (y + stretchHeight > DrawingArea.bottomX) {
                stretchHeight -= y + stretchHeight - DrawingArea.bottomX;
            }
            if (x < DrawingArea.topX) {
                int width2 = DrawingArea.topX - x;
                stretchWidth -= width2;
                x = 0;
                i3 += width2;
                k1 += i2 * width2;
                j3 += width2;
            }
            if (x + stretchWidth > DrawingArea.bottomY) {
                int i4 = x + stretchWidth - DrawingArea.bottomY;
                stretchWidth -= i4;
                j3 += i4;
            }
            this.plotScale(DrawingArea.pixels, this.imgPixels, this.palette, k1, l1, i3, j3, stretchWidth, stretchHeight, i2, j2, width);
        }
        catch (Exception exception) {
            System.out.println("error in sprite clipping routine");
        }
    }

    public void plotScale(int[] pixels, byte[] imgPixels, int[] palette, int i, int j, int k, int l, int stretchWidth, int stretchHeight, int k1, int l1, int width) {
        try {
            int j2 = i;
            for (int k2 = -stretchHeight; k2 < 0; ++k2) {
                int l2 = (j >> 16) * width;
                for (int i3 = -stretchWidth; i3 < 0; ++i3) {
                    byte byte0 = imgPixels[(i >> 16) + l2];
                    if (byte0 != 0) {
                        pixels[k++] = palette[byte0 & 0xFF];
                    } else {
                        ++k;
                    }
                    i += k1;
                }
                j += l1;
                i = j2;
                k += l;
            }
        }
        catch (Exception exception) {
            System.out.println("error in plot_scale");
        }
    }

    public void decodePalette(int r, int g, int b) {
        for (int i1 = 0; i1 < this.palette.length; ++i1) {
            int j1 = this.palette[i1] >> 16 & 0xFF;
            if ((j1 += r) < 0) {
                j1 = 0;
            } else if (j1 > 255) {
                j1 = 255;
            }
            int k1 = this.palette[i1] >> 8 & 0xFF;
            if ((k1 += g) < 0) {
                k1 = 0;
            } else if (k1 > 255) {
                k1 = 255;
            }
            int l1 = this.palette[i1] & 0xFF;
            if ((l1 += b) < 0) {
                l1 = 0;
            } else if (l1 > 255) {
                l1 = 255;
            }
            this.palette[i1] = (j1 << 16) + (k1 << 8) + l1;
        }
    }

    public void drawBackground(int i, int k) {
        int l = (i += this.xDrawOffset) + (k += this.yDrawOffset) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.imgHeight;
        int k1 = this.imgWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.topY) {
            int j2 = DrawingArea.topY - k;
            j1 -= j2;
            k = DrawingArea.topY;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.bottomY) {
            j1 -= k + j1 - DrawingArea.bottomY;
        }
        if (i < DrawingArea.topX) {
            int k2 = DrawingArea.topX - i;
            k1 -= k2;
            i = DrawingArea.topX;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.bottomX) {
            int l2 = i + k1 - DrawingArea.bottomX;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.drawPixels(j1, DrawingArea.pixels, this.imgPixels, l1, l, k1, i1, this.palette, i2);
        }
    }

    private void drawPixels(int i, int[] ai, byte[] abyte0, int j, int k, int l, int i1, int[] ai1, int j1) {
        int k1 = -(l >> 2);
        l = -(l & 3);
        for (int l1 = -i; l1 < 0; ++l1) {
            for (int i2 = k1; i2 < 0; ++i2) {
                byte byte1;
                if ((byte1 = abyte0[i1++]) != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                    continue;
                }
                ++k;
            }
            for (int j2 = l; j2 < 0; ++j2) {
                byte byte2;
                if ((byte2 = abyte0[i1++]) != 0) {
                    ai[k++] = ai1[byte2 & 0xFF];
                    continue;
                }
                ++k;
            }
            k += j;
            i1 += j1;
        }
    }
}

