/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

final class CollisionDetection {
    private final int sizeX;
    private final int sizeY;
    public final int[][] clipData;

    public CollisionDetection() {
        this.sizeX = 104;
        this.sizeY = 104;
        this.clipData = new int[this.sizeX][this.sizeY];
        this.setDefault();
    }

    public void setDefault() {
        for (int i = 0; i < this.sizeX; ++i) {
            for (int j = 0; j < this.sizeY; ++j) {
                this.clipData[i][j] = i == 0 || j == 0 || i == this.sizeX - 1 || j == this.sizeY - 1 ? 0xFFFFFF : 0x1000000;
            }
        }
    }

    public void method211(int i, int j, int k, int l, boolean flag) {
        if (l == 0) {
            if (j == 0) {
                this.appendFlag(k, i, 128);
                this.appendFlag(k - 1, i, 8);
            }
            if (j == 1) {
                this.appendFlag(k, i, 2);
                this.appendFlag(k, i + 1, 32);
            }
            if (j == 2) {
                this.appendFlag(k, i, 8);
                this.appendFlag(k + 1, i, 128);
            }
            if (j == 3) {
                this.appendFlag(k, i, 32);
                this.appendFlag(k, i - 1, 2);
            }
        }
        if (l == 1 || l == 3) {
            if (j == 0) {
                this.appendFlag(k, i, 1);
                this.appendFlag(k - 1, i + 1, 16);
            }
            if (j == 1) {
                this.appendFlag(k, i, 4);
                this.appendFlag(k + 1, i + 1, 64);
            }
            if (j == 2) {
                this.appendFlag(k, i, 16);
                this.appendFlag(k + 1, i - 1, 1);
            }
            if (j == 3) {
                this.appendFlag(k, i, 64);
                this.appendFlag(k - 1, i - 1, 4);
            }
        }
        if (l == 2) {
            if (j == 0) {
                this.appendFlag(k, i, 130);
                this.appendFlag(k - 1, i, 8);
                this.appendFlag(k, i + 1, 32);
            }
            if (j == 1) {
                this.appendFlag(k, i, 10);
                this.appendFlag(k, i + 1, 32);
                this.appendFlag(k + 1, i, 128);
            }
            if (j == 2) {
                this.appendFlag(k, i, 40);
                this.appendFlag(k + 1, i, 128);
                this.appendFlag(k, i - 1, 2);
            }
            if (j == 3) {
                this.appendFlag(k, i, 160);
                this.appendFlag(k, i - 1, 2);
                this.appendFlag(k - 1, i, 8);
            }
        }
        if (flag) {
            if (l == 0) {
                if (j == 0) {
                    this.appendFlag(k, i, 65536);
                    this.appendFlag(k - 1, i, 4096);
                }
                if (j == 1) {
                    this.appendFlag(k, i, 1024);
                    this.appendFlag(k, i + 1, 16384);
                }
                if (j == 2) {
                    this.appendFlag(k, i, 4096);
                    this.appendFlag(k + 1, i, 65536);
                }
                if (j == 3) {
                    this.appendFlag(k, i, 16384);
                    this.appendFlag(k, i - 1, 1024);
                }
            }
            if (l == 1 || l == 3) {
                if (j == 0) {
                    this.appendFlag(k, i, 512);
                    this.appendFlag(k - 1, i + 1, 8192);
                }
                if (j == 1) {
                    this.appendFlag(k, i, 2048);
                    this.appendFlag(k + 1, i + 1, 32768);
                }
                if (j == 2) {
                    this.appendFlag(k, i, 8192);
                    this.appendFlag(k + 1, i - 1, 512);
                }
                if (j == 3) {
                    this.appendFlag(k, i, 32768);
                    this.appendFlag(k - 1, i - 1, 2048);
                }
            }
            if (l == 2) {
                if (j == 0) {
                    this.appendFlag(k, i, 66560);
                    this.appendFlag(k - 1, i, 4096);
                    this.appendFlag(k, i + 1, 16384);
                }
                if (j == 1) {
                    this.appendFlag(k, i, 5120);
                    this.appendFlag(k, i + 1, 16384);
                    this.appendFlag(k + 1, i, 65536);
                }
                if (j == 2) {
                    this.appendFlag(k, i, 20480);
                    this.appendFlag(k + 1, i, 65536);
                    this.appendFlag(k, i - 1, 1024);
                }
                if (j == 3) {
                    this.appendFlag(k, i, 81920);
                    this.appendFlag(k, i - 1, 1024);
                    this.appendFlag(k - 1, i, 4096);
                }
            }
        }
    }

    public void method212(boolean flag, int j, int k, int l, int i1, int j1) {
        int k1 = 256;
        if (flag) {
            k1 += 131072;
        }
        if (j1 == 1 || j1 == 3) {
            int l1 = j;
            j = k;
            k = l1;
        }
        for (int i2 = l; i2 < l + j; ++i2) {
            if (i2 < 0 || i2 >= this.sizeX) continue;
            for (int j2 = i1; j2 < i1 + k; ++j2) {
                if (j2 < 0 || j2 >= this.sizeY) continue;
                this.appendFlag(i2, j2, k1);
            }
        }
    }

    public void appendSolidFlag(int i, int k) {
        int[] nArray = this.clipData[k];
        int n = i;
        nArray[n] = nArray[n] | 0x200000;
    }

    private void appendFlag(int x, int y, int flag) {
        int[] nArray = this.clipData[x];
        int n = y;
        nArray[n] = nArray[n] | flag;
    }

    public void addClip(int i, int j, boolean flag, int k, int l) {
        if (j == 0) {
            if (i == 0) {
                this.method217(128, k, l);
                this.method217(8, k - 1, l);
            }
            if (i == 1) {
                this.method217(2, k, l);
                this.method217(32, k, l + 1);
            }
            if (i == 2) {
                this.method217(8, k, l);
                this.method217(128, k + 1, l);
            }
            if (i == 3) {
                this.method217(32, k, l);
                this.method217(2, k, l - 1);
            }
        }
        if (j == 1 || j == 3) {
            if (i == 0) {
                this.method217(1, k, l);
                this.method217(16, k - 1, l + 1);
            }
            if (i == 1) {
                this.method217(4, k, l);
                this.method217(64, k + 1, l + 1);
            }
            if (i == 2) {
                this.method217(16, k, l);
                this.method217(1, k + 1, l - 1);
            }
            if (i == 3) {
                this.method217(64, k, l);
                this.method217(4, k - 1, l - 1);
            }
        }
        if (j == 2) {
            if (i == 0) {
                this.method217(130, k, l);
                this.method217(8, k - 1, l);
                this.method217(32, k, l + 1);
            }
            if (i == 1) {
                this.method217(10, k, l);
                this.method217(32, k, l + 1);
                this.method217(128, k + 1, l);
            }
            if (i == 2) {
                this.method217(40, k, l);
                this.method217(128, k + 1, l);
                this.method217(2, k, l - 1);
            }
            if (i == 3) {
                this.method217(160, k, l);
                this.method217(2, k, l - 1);
                this.method217(8, k - 1, l);
            }
        }
        if (flag) {
            if (j == 0) {
                if (i == 0) {
                    this.method217(65536, k, l);
                    this.method217(4096, k - 1, l);
                }
                if (i == 1) {
                    this.method217(1024, k, l);
                    this.method217(16384, k, l + 1);
                }
                if (i == 2) {
                    this.method217(4096, k, l);
                    this.method217(65536, k + 1, l);
                }
                if (i == 3) {
                    this.method217(16384, k, l);
                    this.method217(1024, k, l - 1);
                }
            }
            if (j == 1 || j == 3) {
                if (i == 0) {
                    this.method217(512, k, l);
                    this.method217(8192, k - 1, l + 1);
                }
                if (i == 1) {
                    this.method217(2048, k, l);
                    this.method217(32768, k + 1, l + 1);
                }
                if (i == 2) {
                    this.method217(8192, k, l);
                    this.method217(512, k + 1, l - 1);
                }
                if (i == 3) {
                    this.method217(32768, k, l);
                    this.method217(2048, k - 1, l - 1);
                }
            }
            if (j == 2) {
                if (i == 0) {
                    this.method217(66560, k, l);
                    this.method217(4096, k - 1, l);
                    this.method217(16384, k, l + 1);
                }
                if (i == 1) {
                    this.method217(5120, k, l);
                    this.method217(16384, k, l + 1);
                    this.method217(65536, k + 1, l);
                }
                if (i == 2) {
                    this.method217(20480, k, l);
                    this.method217(65536, k + 1, l);
                    this.method217(1024, k, l - 1);
                }
                if (i == 3) {
                    this.method217(81920, k, l);
                    this.method217(1024, k, l - 1);
                    this.method217(4096, k - 1, l);
                }
            }
        }
    }

    public void addInteractableObjectClip(int i, int j, int k, int l, int i1, boolean flag) {
        int j1 = 256;
        if (flag) {
            j1 += 131072;
        }
        if (i == 1 || i == 3) {
            int k1 = j;
            j = i1;
            i1 = k1;
        }
        for (int l1 = k; l1 < k + j; ++l1) {
            if (l1 < 0 || l1 >= this.sizeX) continue;
            for (int i2 = l; i2 < l + i1; ++i2) {
                if (i2 < 0 || i2 >= this.sizeY) continue;
                this.method217(j1, l1, i2);
            }
        }
    }

    private void method217(int i, int j, int k) {
        int[] nArray = this.clipData[j];
        int n = k;
        nArray[n] = nArray[n] & 0xFFFFFF - i;
    }

    public void addGroundDecClip(int j, int k) {
        int[] nArray = this.clipData[k];
        int n = j;
        nArray[n] = nArray[n] & 0xDFFFFF;
    }

    public boolean checkWallClipping(int i, int x, int y, int i1, int j1, int k1) {
        if (x == i && y == k1) {
            return true;
        }
        if (j1 == 0) {
            if (i1 == 0) {
                if (x == i - 1 && y == k1) {
                    return true;
                }
                if (x == i && y == k1 + 1 && (this.clipData[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == i && y == k1 - 1 && (this.clipData[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (i1 == 1) {
                if (x == i && y == k1 + 1) {
                    return true;
                }
                if (x == i - 1 && y == k1 && (this.clipData[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == i + 1 && y == k1 && (this.clipData[x][y] & 0x1280180) == 0) {
                    return true;
                }
            } else if (i1 == 2) {
                if (x == i + 1 && y == k1) {
                    return true;
                }
                if (x == i && y == k1 + 1 && (this.clipData[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == i && y == k1 - 1 && (this.clipData[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (i1 == 3) {
                if (x == i && y == k1 - 1) {
                    return true;
                }
                if (x == i - 1 && y == k1 && (this.clipData[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == i + 1 && y == k1 && (this.clipData[x][y] & 0x1280180) == 0) {
                    return true;
                }
            }
        }
        if (j1 == 2) {
            if (i1 == 0) {
                if (x == i - 1 && y == k1) {
                    return true;
                }
                if (x == i && y == k1 + 1) {
                    return true;
                }
                if (x == i + 1 && y == k1 && (this.clipData[x][y] & 0x1280180) == 0) {
                    return true;
                }
                if (x == i && y == k1 - 1 && (this.clipData[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (i1 == 1) {
                if (x == i - 1 && y == k1 && (this.clipData[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == i && y == k1 + 1) {
                    return true;
                }
                if (x == i + 1 && y == k1) {
                    return true;
                }
                if (x == i && y == k1 - 1 && (this.clipData[x][y] & 0x1280102) == 0) {
                    return true;
                }
            } else if (i1 == 2) {
                if (x == i - 1 && y == k1 && (this.clipData[x][y] & 0x1280108) == 0) {
                    return true;
                }
                if (x == i && y == k1 + 1 && (this.clipData[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == i + 1 && y == k1) {
                    return true;
                }
                if (x == i && y == k1 - 1) {
                    return true;
                }
            } else if (i1 == 3) {
                if (x == i - 1 && y == k1) {
                    return true;
                }
                if (x == i && y == k1 + 1 && (this.clipData[x][y] & 0x1280120) == 0) {
                    return true;
                }
                if (x == i + 1 && y == k1 && (this.clipData[x][y] & 0x1280180) == 0) {
                    return true;
                }
                if (x == i && y == k1 - 1) {
                    return true;
                }
            }
        }
        if (j1 == 9) {
            if (x == i && y == k1 + 1 && (this.clipData[x][y] & 0x20) == 0) {
                return true;
            }
            if (x == i && y == k1 - 1 && (this.clipData[x][y] & 2) == 0) {
                return true;
            }
            if (x == i - 1 && y == k1 && (this.clipData[x][y] & 8) == 0) {
                return true;
            }
            if (x == i + 1 && y == k1 && (this.clipData[x][y] & 0x80) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean checkWallDecorationClipping(int i, int j, int y, int l, int i1, int x) {
        if (x == i && y == j) {
            return true;
        }
        if (l == 6 || l == 7) {
            if (l == 7) {
                i1 = i1 + 2 & 3;
            }
            if (i1 == 0) {
                if (x == i + 1 && y == j && (this.clipData[x][y] & 0x80) == 0) {
                    return true;
                }
                if (x == i && y == j - 1 && (this.clipData[x][y] & 2) == 0) {
                    return true;
                }
            } else if (i1 == 1) {
                if (x == i - 1 && y == j && (this.clipData[x][y] & 8) == 0) {
                    return true;
                }
                if (x == i && y == j - 1 && (this.clipData[x][y] & 2) == 0) {
                    return true;
                }
            } else if (i1 == 2) {
                if (x == i - 1 && y == j && (this.clipData[x][y] & 8) == 0) {
                    return true;
                }
                if (x == i && y == j + 1 && (this.clipData[x][y] & 0x20) == 0) {
                    return true;
                }
            } else if (i1 == 3) {
                if (x == i + 1 && y == j && (this.clipData[x][y] & 0x80) == 0) {
                    return true;
                }
                if (x == i && y == j + 1 && (this.clipData[x][y] & 0x20) == 0) {
                    return true;
                }
            }
        }
        if (l == 8) {
            if (x == i && y == j + 1 && (this.clipData[x][y] & 0x20) == 0) {
                return true;
            }
            if (x == i && y == j - 1 && (this.clipData[x][y] & 2) == 0) {
                return true;
            }
            if (x == i - 1 && y == j && (this.clipData[x][y] & 8) == 0) {
                return true;
            }
            if (x == i + 1 && y == j && (this.clipData[x][y] & 0x80) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean canWalkToEntity(int i, int j, int x, int l, int i1, int j1, int y) {
        int l1 = j + j1 - 1;
        int i2 = i + l - 1;
        if (x >= j && x <= l1 && y >= i && y <= i2) {
            return true;
        }
        if (x == j - 1 && y >= i && y <= i2 && (this.clipData[x][y] & 8) == 0 && (i1 & 8) == 0) {
            return true;
        }
        if (x == l1 + 1 && y >= i && y <= i2 && (this.clipData[x][y] & 0x80) == 0 && (i1 & 2) == 0) {
            return true;
        }
        return y == i - 1 && x >= j && x <= l1 && (this.clipData[x][y] & 2) == 0 && (i1 & 4) == 0 || y == i2 + 1 && x >= j && x <= l1 && (this.clipData[x][y] & 0x20) == 0 && (i1 & 1) == 0;
    }
}

