/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teragard.ItemDef;
import com.teragard.signlink;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomItemLoader {
    private static final String CUSTOM_ITEMS_PATH = "data/custom_items.json";
    private static final Map<Integer, CustomItemDef> customItems = new HashMap<Integer, CustomItemDef>();
    private static final Map<Integer, TierColor> tierColors = new HashMap<Integer, TierColor>();
    private static final Set<Integer> stackableOverrides = new HashSet<Integer>();
    private static boolean loaded = false;
    private static final Gson gson = new Gson();

    public static void load() {
        if (loaded) {
            return;
        }
        try {
            String localPath = "./data/custom_items.json";
            String cachePath = signlink.findcachedir() + CUSTOM_ITEMS_PATH;
            Object jsonPath = null;
            if (Files.exists(Paths.get(localPath, new String[0]), new LinkOption[0])) {
                jsonPath = localPath;
            } else if (Files.exists(Paths.get(cachePath, new String[0]), new LinkOption[0])) {
                jsonPath = cachePath;
            }
            if (jsonPath == null) {
                System.out.println("[CustomItemLoader] No custom_items.json found, skipping custom items");
                loaded = true;
                return;
            }
            String content = new String(Files.readAllBytes(Paths.get((String)jsonPath, new String[0])));
            JsonObject root = gson.fromJson(content, JsonObject.class);
            if (root.has("tier_colors")) {
                JsonObject colors = root.getAsJsonObject("tier_colors");
                for (String tierKey : colors.keySet()) {
                    int tier = Integer.parseInt(tierKey);
                    JsonObject colorData = colors.getAsJsonObject(tierKey);
                    TierColor tc = new TierColor();
                    String string = tc.namePrefix = colorData.has("namePrefix") ? colorData.get("namePrefix").getAsString() : "";
                    if (colorData.has("modelColor") && !colorData.get("modelColor").isJsonNull()) {
                        JsonObject mc = colorData.getAsJsonObject("modelColor");
                        tc.colorFind = mc.get("find").getAsInt();
                        tc.colorReplace = mc.get("replace").getAsInt();
                    }
                    tierColors.put(tier, tc);
                }
            }
            if (root.has("item_sets")) {
                JsonObject itemSets = root.getAsJsonObject("item_sets");
                for (String setName : itemSets.keySet()) {
                    CustomItemLoader.loadItemSet(itemSets.getAsJsonObject(setName));
                }
            }
            if (root.has("materials")) {
                JsonArray materials = root.getAsJsonArray("materials");
                for (JsonElement elem : materials) {
                    CustomItemLoader.loadMaterial(elem.getAsJsonObject());
                }
            }
            if (root.has("stackable_items")) {
                JsonArray stackables = root.getAsJsonArray("stackable_items");
                for (JsonElement elem : stackables) {
                    stackableOverrides.add(elem.getAsInt());
                }
                System.out.println("[CustomItemLoader] Loaded " + stackableOverrides.size() + " stackable overrides");
            }
            System.out.println("[CustomItemLoader] Loaded " + customItems.size() + " custom items from " + (String)jsonPath);
            loaded = true;
        }
        catch (Exception e) {
            System.err.println("[CustomItemLoader] Failed to load custom items: " + e.getMessage());
            e.printStackTrace();
            loaded = true;
        }
    }

    private static void loadItemSet(JsonObject setData) {
        JsonObject baseModels = setData.getAsJsonObject("base_models");
        JsonArray items = setData.getAsJsonArray("items");
        for (JsonElement elem : items) {
            JsonObject itemData = elem.getAsJsonObject();
            String slot = itemData.get("slot").getAsString();
            JsonObject slotModels = baseModels.getAsJsonObject(slot);
            CustomItemDef def = new CustomItemDef();
            def.id = itemData.get("id").getAsInt();
            def.name = itemData.get("name").getAsString();
            def.tier = itemData.has("tier") ? itemData.get("tier").getAsInt() : 0;
            def.modelId = slotModels.get("modelId").getAsInt();
            def.maleEquip = slotModels.get("equipId").getAsInt();
            def.femaleEquip = slotModels.get("equipId").getAsInt();
            def.modelZoom = slotModels.get("zoom").getAsInt();
            def.rotationX = slotModels.get("rotationX").getAsInt();
            def.rotationY = slotModels.get("rotationY").getAsInt();
            def.action = itemData.has("action") ? itemData.get("action").getAsString() : "Wear";
            def.stackable = false;
            customItems.put(def.id, def);
        }
    }

    private static void loadMaterial(JsonObject materialData) {
        CustomItemDef def = new CustomItemDef();
        def.id = materialData.get("id").getAsInt();
        def.name = materialData.get("name").getAsString();
        def.tier = 0;
        def.modelId = materialData.get("modelId").getAsInt();
        def.maleEquip = materialData.get("equipId").getAsInt();
        def.femaleEquip = materialData.get("equipId").getAsInt();
        def.modelZoom = materialData.get("zoom").getAsInt();
        def.rotationX = materialData.get("rotationX").getAsInt();
        def.rotationY = materialData.get("rotationY").getAsInt();
        def.action = null;
        def.stackable = materialData.has("stackable") && materialData.get("stackable").getAsBoolean();
        customItems.put(def.id, def);
    }

    public static boolean hasCustomItem(int itemId) {
        return customItems.containsKey(itemId);
    }

    public static boolean isStackableOverride(int itemId) {
        return stackableOverrides.contains(itemId);
    }

    public static void applyStackableOverride(ItemDef itemDef) {
        if (stackableOverrides.contains(itemDef.id)) {
            itemDef.stackable = true;
        }
    }

    public static int getItemTier(int itemId) {
        CustomItemDef def = customItems.get(itemId);
        if (def == null) {
            return -1;
        }
        return def.tier;
    }

    public static String getTierOverlayText(int tier) {
        switch (tier) {
            case 1: {
                return "(i)";
            }
            case 2: {
                return "(ii)";
            }
            case 3: {
                return "(iii)";
            }
        }
        return null;
    }

    public static int getTierOverlayColor(int tier) {
        switch (tier) {
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFF00FF;
            }
            case 3: {
                return 0xFF9900;
            }
        }
        return -1;
    }

    public static void applyToItemDef(ItemDef itemDef, int itemId) {
        CustomItemDef custom = customItems.get(itemId);
        if (custom == null) {
            return;
        }
        TierColor tc = tierColors.get(custom.tier);
        itemDef.name = tc != null && tc.namePrefix != null && !tc.namePrefix.isEmpty() ? tc.namePrefix + custom.name : custom.name;
        itemDef.modelID = custom.modelId;
        itemDef.maleEquip1 = custom.maleEquip;
        itemDef.femaleEquip1 = custom.femaleEquip;
        itemDef.modelZoom = custom.modelZoom;
        itemDef.rotationX = custom.rotationX;
        itemDef.rotationY = custom.rotationY;
        if (tc != null && tc.colorFind != null && tc.colorReplace != null) {
            itemDef.editedModelColor = new int[]{tc.colorFind};
            itemDef.newModelColor = new int[]{tc.colorReplace};
        }
        if (custom.stackable) {
            itemDef.stackable = true;
        }
        itemDef.actions = new String[5];
        if (custom.action != null) {
            itemDef.actions[1] = custom.action;
        }
        itemDef.actions[4] = "Drop";
    }

    public static class TierColor {
        public String namePrefix;
        public Integer colorFind;
        public Integer colorReplace;
    }

    public static class CustomItemDef {
        public int id;
        public String name;
        public int modelId;
        public int maleEquip;
        public int femaleEquip;
        public int modelZoom;
        public int rotationX;
        public int rotationY;
        public String action;
        public boolean stackable;
        public int tier;
    }
}

