/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.Stream;
import java.util.Date;

public final class Flo {
    public static Flo[] cache;
    public static int colour2;
    public int texture = -1;
    public boolean occlude = true;
    public int hue;
    public int saturation;
    public int lightness;
    public int hue2;
    public int hue_weight;
    public int hslColour;
    public String name;

    public static void unpackConfig(CacheArchive streamLoader) {
        Stream stream = new Stream(streamLoader.getDataForName("flo.dat"));
        int cacheSize = stream.readUnsignedWord();
        if (cache == null) {
            cache = new Flo[cacheSize];
        }
        for (int j = 0; j < cacheSize; ++j) {
            if (cache[j] == null) {
                Flo.cache[j] = new Flo();
            }
            cache[j].readValues(stream);
        }
    }

    private void readValues(Stream stream) {
        int opcode;
        while ((opcode = stream.readUnsignedByte()) != 0) {
            Date date;
            if (opcode == 1) {
                colour2 = stream.read3Bytes();
                date = new Date();
                this.rgb2hsl(colour2);
            } else if (opcode == 2) {
                this.texture = stream.readUnsignedByte();
            }
            if ((date = new Date()).getMonth() == 11 || date.getMonth() == 0 && date.getDate() <= 27) continue;
            if (opcode == 3) {
                boolean dummy = true;
                continue;
            }
            if (opcode == 5) {
                this.occlude = false;
                continue;
            }
            if (opcode == 6) {
                this.name = stream.readString();
                continue;
            }
            if (opcode != 7) continue;
            int j = this.hue;
            int k = this.saturation;
            int l = this.lightness;
            int i1 = this.hue2;
            int j1 = stream.read3Bytes();
            this.rgb2hsl(j1);
            this.hue = j;
            this.saturation = k;
            this.lightness = l;
            this.hue2 = i1;
            this.hue_weight = i1;
        }
        return;
    }

    private void rgb2hsl(int i) {
        double d4;
        double d = (double)(i >> 16 & 0xFF) / 256.0;
        double d1 = (double)(i >> 8 & 0xFF) / 256.0;
        double d2 = (double)(i & 0xFF) / 256.0;
        double d3 = d;
        if (d1 < d3) {
            d3 = d1;
        }
        if (d2 < d3) {
            d3 = d2;
        }
        if (d1 > (d4 = d)) {
            d4 = d1;
        }
        if (d2 > d4) {
            d4 = d2;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = (d3 + d4) / 2.0;
        if (d3 != d4) {
            if (d7 < 0.5) {
                d6 = (d4 - d3) / (d4 + d3);
            }
            if (d7 >= 0.5) {
                d6 = (d4 - d3) / (2.0 - d4 - d3);
            }
            if (d == d4) {
                d5 = (d1 - d2) / (d4 - d3);
            } else if (d1 == d4) {
                d5 = 2.0 + (d2 - d) / (d4 - d3);
            } else if (d2 == d4) {
                d5 = 4.0 + (d - d1) / (d4 - d3);
            }
        }
        this.hue = (int)((d5 /= 6.0) * 256.0);
        this.saturation = (int)(d6 * 256.0);
        this.lightness = (int)(d7 * 256.0);
        if (this.saturation < 0) {
            this.saturation = 0;
        } else if (this.saturation > 255) {
            this.saturation = 255;
        }
        if (this.lightness < 0) {
            this.lightness = 0;
        } else if (this.lightness > 255) {
            this.lightness = 255;
        }
        this.hue_weight = d7 > 0.5 ? (int)((1.0 - d7) * d6 * 512.0) : (int)(d7 * d6 * 512.0);
        if (this.hue_weight < 1) {
            this.hue_weight = 1;
        }
        this.hue2 = (int)(d5 * (double)this.hue_weight);
        int k = this.hue + (int)(Math.random() * 16.0) - 8;
        if (k < 0) {
            k = 0;
        } else if (k > 255) {
            k = 255;
        }
        int l = this.saturation + (int)(Math.random() * 48.0) - 24;
        if (l < 0) {
            l = 0;
        } else if (l > 255) {
            l = 255;
        }
        int i1 = this.lightness + (int)(Math.random() * 48.0) - 24;
        if (i1 < 0) {
            i1 = 0;
        } else if (i1 > 255) {
            i1 = 255;
        }
        this.hslColour = this.packHSL(k, l, i1);
    }

    private int packHSL(int i, int j, int k) {
        if (k > 179) {
            j /= 2;
        }
        if (k > 192) {
            j /= 2;
        }
        if (k > 217) {
            j /= 2;
        }
        if (k > 243) {
            j /= 2;
        }
        return (i / 4 << 10) + (j / 32 << 7) + k / 2;
    }

    private Flo() {
    }
}

