/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Client;
import com.teragard.SkinList;
import com.teragard.Stream;

public final class FrameReader {
    public static FrameReader[][] animationlist;
    public int displayLength;
    public SkinList mySkinList;
    public int stepCount;
    public static byte[][] frameData;
    public static byte[][] skinData;
    public static Client instance;
    public int[] opCodeLinkTable;
    public int[] xOffset;
    public int[] yOffset;
    public int[] zOffset;
    public static boolean[] aBooleanArray643;

    public static byte[] getData(int type, int index) {
        if (type == 0) {
            return frameData[index];
        }
        return skinData[index];
    }

    public static void initialise(int i) {
        animationlist = new FrameReader[5000][0];
    }

    public static void load(int file, byte[] fileData) {
        try {
            Stream stream = new Stream(fileData);
            SkinList skinList = new SkinList(stream, 0);
            int k1 = stream.readUnsignedWord();
            FrameReader.animationlist[file] = new FrameReader[(int)((double)k1 * 3.5)];
            int[] ai = new int[500];
            int[] ai1 = new int[500];
            int[] ai2 = new int[500];
            int[] ai3 = new int[500];
            for (int l1 = 0; l1 < k1; ++l1) {
                int i2 = stream.readUnsignedWord();
                FrameReader frameReader = new FrameReader();
                FrameReader.animationlist[file][i2] = frameReader;
                FrameReader frameReader2 = frameReader;
                frameReader2.mySkinList = skinList;
                int j2 = stream.readUnsignedByte();
                int l2 = 0;
                int k2 = -1;
                for (int i3 = 0; i3 < j2; ++i3) {
                    int j3 = stream.readUnsignedByte();
                    if (j3 <= 0) continue;
                    if (skinList.opcodes[i3] != 0) {
                        for (int l3 = i3 - 1; l3 > k2; --l3) {
                            if (skinList.opcodes[l3] != 0) continue;
                            ai[l2] = l3;
                            ai1[l2] = 0;
                            ai2[l2] = 0;
                            ai3[l2] = 0;
                            ++l2;
                            break;
                        }
                    }
                    ai[l2] = i3;
                    int c = 0;
                    if (skinList.opcodes[i3] == 3) {
                        c = 128;
                    }
                    ai1[l2] = (j3 & 1) != 0 ? stream.readShort2() : c;
                    ai2[l2] = (j3 & 2) != 0 ? stream.readShort2() : c;
                    ai3[l2] = (j3 & 4) != 0 ? stream.readShort2() : c;
                    if (skinList.opcodes[i3] == 2) {
                        ai1[l2] = ((ai1[l2] & 0xFF) << 3) + (ai1[l2] >> 8 & 7);
                        ai2[l2] = ((ai2[l2] & 0xFF) << 3) + (ai2[l2] >> 8 & 7);
                        ai3[l2] = ((ai3[l2] & 0xFF) << 3) + (ai3[l2] >> 8 & 7);
                    }
                    k2 = i3;
                    ++l2;
                }
                frameReader2.stepCount = l2;
                frameReader2.opCodeLinkTable = new int[l2];
                frameReader2.xOffset = new int[l2];
                frameReader2.yOffset = new int[l2];
                frameReader2.zOffset = new int[l2];
                for (int k3 = 0; k3 < l2; ++k3) {
                    frameReader2.opCodeLinkTable[k3] = ai[k3];
                    frameReader2.xOffset[k3] = ai1[k3];
                    frameReader2.yOffset[k3] = ai2[k3];
                    frameReader2.zOffset[k3] = ai3[k3];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void nullLoader() {
        animationlist = null;
    }

    public static FrameReader forID(int int1) {
        try {
            int int2 = int1 >> 16;
            int1 &= 0xFFFF;
            if (animationlist[int2].length == 0) {
                Client.instance.onDemandFetcher.requestFileData(1, int2);
                return null;
            }
            return animationlist[int2][int1];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static FrameReader getTween(FrameReader f1, FrameReader f2) {
        int i;
        FrameReader newFrame = new FrameReader();
        newFrame.displayLength = f1.displayLength;
        newFrame.stepCount = f1.stepCount;
        newFrame.opCodeLinkTable = f1.opCodeLinkTable;
        newFrame.xOffset = new int[f1.xOffset.length];
        newFrame.mySkinList = f1.mySkinList;
        for (i = 0; i < f1.xOffset.length; ++i) {
            try {
                int middleXOffset;
                newFrame.xOffset[i] = middleXOffset = (f2.xOffset[i] - f1.xOffset[i]) / 2 + f1.xOffset[i];
                continue;
            }
            catch (Exception e) {
                newFrame.xOffset[i] = f1.xOffset[i];
            }
        }
        newFrame.yOffset = new int[f1.yOffset.length];
        for (i = 0; i < f1.yOffset.length; ++i) {
            try {
                int middleYOffset;
                newFrame.yOffset[i] = middleYOffset = (f2.yOffset[i] - f1.yOffset[i]) / 2 + f1.yOffset[i];
                continue;
            }
            catch (Exception e) {
                newFrame.yOffset[i] = f1.yOffset[i];
            }
        }
        newFrame.zOffset = new int[f1.zOffset.length];
        for (i = 0; i < f1.zOffset.length; ++i) {
            try {
                int middleZOffset;
                newFrame.zOffset[i] = middleZOffset = (f2.zOffset[i] - f1.zOffset[i]) / 2 + f1.zOffset[i];
                continue;
            }
            catch (Exception e) {
                newFrame.zOffset[i] = f1.zOffset[i];
            }
        }
        return newFrame;
    }

    public static boolean isNullFrame(int frame) {
        return frame == -1;
    }

    private FrameReader() {
    }

    static {
        frameData = null;
        skinData = null;
    }
}

