/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.signlink;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public enum GamePreferences {
    PARTICLES(1);

    private static final File SAVED_PREF;
    private int state = 0;
    private int[] revisions;

    private GamePreferences(int state) {
        this.state = state;
    }

    private GamePreferences(int ... revisions) {
        this.revisions = revisions;
        this.state = revisions[0];
    }

    public void toggle() {
        if (this.state > 1) {
            new IllegalStateException("You can not toggle this setting.");
        }
        this.state = this.toggled() ? 0 : 1;
        this.save();
    }

    public void cycle() {
        for (int index = 0; index < this.revisions.length; ++index) {
            if (index != this.revisions[index]) continue;
            this.state = index == this.revisions.length - 1 ? this.revisions[0] : this.revisions[index + 1];
            this.save();
            return;
        }
    }

    public static void load() throws IOException {
        if (SAVED_PREF.exists()) {
            try (FileReader fr = new FileReader(SAVED_PREF);
                 BufferedReader br = new BufferedReader(fr);){
                for (GamePreferences preference : GamePreferences.values()) {
                    preference.setState(br.read());
                }
            }
        }
    }

    private void save() {
        try {
            if (!SAVED_PREF.exists()) {
                SAVED_PREF.createNewFile();
            }
            try (FileWriter fw = new FileWriter(SAVED_PREF);
                 BufferedWriter bw = new BufferedWriter(fw);){
                for (GamePreferences preference : GamePreferences.values()) {
                    bw.write(preference.getState());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean toggled() {
        return this.state == 1;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    static {
        SAVED_PREF = new File(signlink.findcachedir() + ".preference.sim");
    }
}

