/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Client;
import com.teragard.ResourceLoader;
import com.teragard.signlink;
import com.teragard.ui.ModernSidebar;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Jframe
extends Client
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static JFrame frame;
    public static TrayIcon trayIcon;
    private static final Color BG_PRIMARY;
    private static final Color BG_SECONDARY;
    private static final Color BG_TERTIARY;
    private static final Color BG_HOVER;
    private static final Color ACCENT;
    private static final Color TEXT_PRIMARY;
    private static final Color TEXT_SECONDARY;
    private static final Color BORDER_COLOR;
    private static JPanel menuPanel;
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screenSize = this.toolkit.getScreenSize();
    int screenWidth = (int)this.screenSize.getWidth();
    int screenHeight = (int)this.screenSize.getHeight();
    private Point dragStart;
    private Point windowStart;

    public Jframe(String[] args, int width, int height, boolean resizable) {
        this.setTray();
        try {
            signlink.startpriv(InetAddress.getByName("157.180.65.96"));
            this.initUI(width, height, resizable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setTray() {
        if (SystemTray.isSupported()) {
            Image icon = Toolkit.getDefaultToolkit().getImage(signlink.findcachedir() + "/Interfaces/icon.png");
            trayIcon = new TrayIcon(icon, "Teragard");
            trayIcon.setImageAutoSize(true);
            try {
                SystemTray tray = SystemTray.getSystemTray();
                PopupMenu popup = new PopupMenu();
                final MenuItem minimizeItem = new MenuItem("Hide Teragard");
                MenuItem exitItem = new MenuItem("Quit");
                ActionListener minimizeListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (frame != null) {
                            if (frame.isVisible()) {
                                frame.setVisible(false);
                                minimizeItem.setLabel("Show Teragard");
                            } else {
                                frame.setVisible(true);
                                minimizeItem.setLabel("Hide Teragard");
                            }
                        }
                    }
                };
                minimizeItem.addActionListener(minimizeListener);
                ActionListener exitListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                };
                exitItem.addActionListener(exitListener);
                popup.add(minimizeItem);
                popup.addSeparator();
                popup.add(exitItem);
                trayIcon.setPopupMenu(popup);
                tray.add(trayIcon);
                trayIcon.displayMessage("Teragard", "Teragard has been launched!", TrayIcon.MessageType.INFO);
            }
            catch (AWTException e) {
                System.err.println(e);
            }
        }
    }

    public void initUI(int width, int height, boolean resizable) {
        try {
            this.applyDarkTheme();
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            frame = new JFrame("Teragard");
            frame.setUndecorated(true);
            frame.setLayout(new BorderLayout());
            frame.setDefaultCloseOperation(0);
            frame.getContentPane().setBackground(BG_PRIMARY);
            try {
                URL url = new URL("https://i.imgur.com/FZCmNF8.png");
                Toolkit kit = Toolkit.getDefaultToolkit();
                Image img = kit.createImage(url);
                frame.setIconImage(img);
            }
            catch (Exception e) {
                System.out.println("Icon load failed");
            }
            frame.setAlwaysOnTop(false);
            this.setFocusTraversalKeysEnabled(false);
            JPanel titleBar = this.createCustomTitleBar("Teragard", resizable);
            JPanel gamePanel = new JPanel();
            Insets insets = this.getInsets();
            super.setPreferredSize(new Dimension(width - 10, height - 10));
            gamePanel.setLayout(new BorderLayout());
            gamePanel.add(this);
            gamePanel.setBackground(BG_PRIMARY);
            JPanel mainContainer = new JPanel(new BorderLayout());
            mainContainer.setBackground(BG_PRIMARY);
            mainContainer.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
            mainContainer.add((Component)titleBar, "North");
            mainContainer.add((Component)gamePanel, "Center");
            this.initializeMenuBar();
            frame.getContentPane().add((Component)mainContainer, "Center");
            frame.pack();
            frame.setResizable(resizable);
            this.init();
            this.graphics = this.getGameComponent().getGraphics();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            frame.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    SwingUtilities.invokeLater(() -> {
                        ModernSidebar sidebar = ModernSidebar.getInstance();
                        if (sidebar != null && sidebar.isVisible()) {
                            sidebar.toFront();
                        }
                    });
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rebuildFrame(int width, int height, boolean resizable, boolean undecorated) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        frame = new JFrame("Teragard");
        frame.setUndecorated(true);
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(0);
        frame.getContentPane().setBackground(BG_PRIMARY);
        this.setFocusTraversalKeysEnabled(false);
        JPanel titleBar = undecorated ? null : this.createCustomTitleBar("Teragard", resizable);
        final JPanel gamePanel = new JPanel();
        Insets insets = this.getInsets();
        super.setPreferredSize(new Dimension(width - 10, height - 10));
        gamePanel.setLayout(new BorderLayout());
        gamePanel.add((Component)this, "Center");
        gamePanel.setBackground(BG_PRIMARY);
        JPanel mainContainer = new JPanel(new BorderLayout());
        mainContainer.setBackground(BG_PRIMARY);
        mainContainer.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        if (titleBar != null) {
            mainContainer.add((Component)titleBar, "North");
        }
        mainContainer.add((Component)gamePanel, "Center");
        frame.getContentPane().add((Component)mainContainer, "Center");
        frame.pack();
        frame.setResizable(resizable);
        this.graphics = this.getGameComponent().getGraphics();
        frame.setLocation((this.screenWidth - width) / 2, (this.screenHeight - height) / 2 - this.screenHeight == Client.getMaxHeight() ? 0 : (undecorated ? 0 : 70));
        frame.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            ModernSidebar sidebar = ModernSidebar.getInstance();
            if (sidebar != null && sidebar.isVisible()) {
                sidebar.positionNextToGameWindow();
            }
        });
        frame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SwingUtilities.invokeLater(() -> {
                    ModernSidebar sidebar = ModernSidebar.getInstance();
                    if (sidebar != null && sidebar.isVisible()) {
                        sidebar.toFront();
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dimension = new Dimension(frame.getWidth(), frame.getHeight());
                gamePanel.setMinimumSize(dimension);
                gamePanel.setPreferredSize(dimension);
                gamePanel.setSize(dimension);
                Jframe.super.setPreferredSize(new Dimension(frame.getWidth() - 10, frame.getHeight() - 10));
                Jframe.super.revalidate();
                Jframe.super.repaint();
                Jframe.this.graphics = Jframe.this.getGameComponent().getGraphics();
            }
        });
    }

    public void setClientIcon() {
        Image img = Toolkit.getDefaultToolkit().getImage(signlink.findcachedir() + "epicicon.png");
        if (img == null) {
            return;
        }
        frame.setIconImage(img);
    }

    public void initializeMenuBar() {
        menuPanel = new JPanel();
        menuPanel.setFocusable(false);
        menuPanel.setFocusTraversalKeysEnabled(false);
        menuPanel.setFocusTraversalKeys(0, null);
        menuPanel.setFocusTraversalKeys(1, null);
    }

    private JButton createButton(String title, String image, String tooltip) {
        JButton button = new JButton(title);
        if (image != null) {
            button.setIcon(new ImageIcon(ResourceLoader.loadImage(image)));
        }
        button.addActionListener(this);
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    @Override
    public URL getCodeBase() {
        try {
            return new URL("http://157.180.65.96/");
        }
        catch (Exception e) {
            return super.getCodeBase();
        }
    }

    @Override
    public URL getDocumentBase() {
        return this.getCodeBase();
    }

    public void loadError(String s) {
        System.out.println("loadError: " + s);
    }

    @Override
    public String getParameter(String key) {
        return "";
    }

    public static void openUpWebSite(String url) {
        Desktop d = Desktop.getDesktop();
        try {
            d.browse(new URI(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        try {
            if (cmd != null) {
                switch (cmd) {
                    case "Forums": {
                        Jframe.openURL("https://discord.gg/jPcWDrc846");
                        break;
                    }
                    case "Store": {
                        Jframe.openURL("https://teragard.everythingrs.com/services/store");
                        break;
                    }
                    case "Vote": {
                        Jframe.openURL("https://teragard.everythingrs.com/services/vote");
                        break;
                    }
                    case "Join Discord": {
                        Jframe.openURL("https://discord.gg/jPcWDrc846");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void openURL(String url) {
        Desktop d = Desktop.getDesktop();
        try {
            d.browse(new URI(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel createCustomTitleBar(String title, boolean resizable) {
        JPanel titleBar = new JPanel(new BorderLayout());
        titleBar.setBackground(BG_SECONDARY);
        titleBar.setPreferredSize(new Dimension(0, 32));
        titleBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR));
        JLabel titleLabel = new JLabel("  " + title);
        titleLabel.setForeground(TEXT_PRIMARY);
        titleLabel.setFont(new Font("SansSerif", 1, 12));
        titleBar.add((Component)titleLabel, "West");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        buttonPanel.setOpaque(false);
        JButton minimizeBtn = this.createTitleBarButton("\u2014", BG_HOVER);
        minimizeBtn.addActionListener(e -> frame.setState(1));
        buttonPanel.add(minimizeBtn);
        if (resizable) {
            JButton maximizeBtn = this.createTitleBarButton("\u25a1", BG_HOVER);
            maximizeBtn.addActionListener(e -> {
                if (frame.getExtendedState() == 6) {
                    frame.setExtendedState(0);
                } else {
                    frame.setExtendedState(6);
                }
            });
            buttonPanel.add(maximizeBtn);
        }
        JButton closeBtn = this.createTitleBarButton("\u2715", new Color(200, 60, 60));
        closeBtn.addActionListener(e -> this.showExitConfirmation());
        buttonPanel.add(closeBtn);
        titleBar.add((Component)buttonPanel, "East");
        titleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Jframe.this.dragStart = e.getPoint();
                Jframe.this.windowStart = frame.getLocation();
            }
        });
        titleBar.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Jframe.this.dragStart != null) {
                    Point current = e.getLocationOnScreen();
                    frame.setLocation(current.x - Jframe.this.dragStart.x, current.y - Jframe.this.dragStart.y);
                }
            }
        });
        return titleBar;
    }

    private JButton createTitleBarButton(String text, final Color hoverColor) {
        final JButton button = new JButton(text);
        button.setPreferredSize(new Dimension(46, 32));
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setOpaque(true);
        button.setBackground(BG_SECONDARY);
        button.setForeground(TEXT_PRIMARY);
        button.setFont(new Font("SansSerif", 0, 14));
        button.setCursor(new Cursor(12));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(hoverColor);
                if (hoverColor.getRed() > 150) {
                    button.setForeground(Color.WHITE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(BG_SECONDARY);
                button.setForeground(TEXT_PRIMARY);
            }
        });
        return button;
    }

    private void applyDarkTheme() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            UIManager.put("Panel.background", BG_PRIMARY);
            UIManager.put("Panel.foreground", TEXT_PRIMARY);
            UIManager.put("OptionPane.background", BG_SECONDARY);
            UIManager.put("OptionPane.messageForeground", TEXT_PRIMARY);
            UIManager.put("OptionPane.foreground", TEXT_PRIMARY);
            UIManager.put("Button.background", BG_TERTIARY);
            UIManager.put("Button.foreground", TEXT_PRIMARY);
            UIManager.put("Button.select", ACCENT);
            UIManager.put("Button.focus", ACCENT);
            UIManager.put("Label.foreground", TEXT_PRIMARY);
            UIManager.put("Label.background", BG_PRIMARY);
            UIManager.put("TextField.background", BG_TERTIARY);
            UIManager.put("TextField.foreground", TEXT_PRIMARY);
            UIManager.put("TextField.caretForeground", TEXT_PRIMARY);
            UIManager.put("ComboBox.background", BG_TERTIARY);
            UIManager.put("ComboBox.foreground", TEXT_PRIMARY);
            UIManager.put("ComboBox.selectionBackground", ACCENT);
            UIManager.put("ComboBox.selectionForeground", TEXT_PRIMARY);
            UIManager.put("List.background", BG_SECONDARY);
            UIManager.put("List.foreground", TEXT_PRIMARY);
            UIManager.put("List.selectionBackground", ACCENT);
            UIManager.put("List.selectionForeground", TEXT_PRIMARY);
            UIManager.put("ScrollPane.background", BG_PRIMARY);
            UIManager.put("ScrollBar.background", BG_SECONDARY);
            UIManager.put("ScrollBar.thumb", BG_TERTIARY);
            UIManager.put("ScrollBar.track", BG_SECONDARY);
            UIManager.put("MenuBar.background", BG_PRIMARY);
            UIManager.put("MenuBar.foreground", TEXT_PRIMARY);
            UIManager.put("Menu.background", BG_PRIMARY);
            UIManager.put("Menu.foreground", TEXT_PRIMARY);
            UIManager.put("Menu.selectionBackground", ACCENT);
            UIManager.put("Menu.selectionForeground", TEXT_PRIMARY);
            UIManager.put("MenuItem.background", BG_SECONDARY);
            UIManager.put("MenuItem.foreground", TEXT_PRIMARY);
            UIManager.put("MenuItem.selectionBackground", ACCENT);
            UIManager.put("MenuItem.selectionForeground", TEXT_PRIMARY);
            UIManager.put("PopupMenu.background", BG_SECONDARY);
            UIManager.put("PopupMenu.foreground", TEXT_PRIMARY);
            UIManager.put("ToolTip.background", BG_TERTIARY);
            UIManager.put("ToolTip.foreground", TEXT_PRIMARY);
            UIManager.put("TitledBorder.titleColor", TEXT_PRIMARY);
            UIManager.put("control", BG_PRIMARY);
            UIManager.put("controlHighlight", BG_TERTIARY);
            UIManager.put("controlShadow", BORDER_COLOR);
            UIManager.put("controlDkShadow", BORDER_COLOR);
            UIManager.put("controlLtHighlight", BG_HOVER);
            UIManager.put("text", TEXT_PRIMARY);
            UIManager.put("textText", TEXT_PRIMARY);
            UIManager.put("textHighlight", ACCENT);
            UIManager.put("textHighlightText", TEXT_PRIMARY);
            UIManager.put("window", BG_PRIMARY);
            UIManager.put("windowBorder", BORDER_COLOR);
            UIManager.put("windowText", TEXT_PRIMARY);
            UIManager.put("menu", BG_PRIMARY);
            UIManager.put("menuText", TEXT_PRIMARY);
            UIManager.put("info", BG_TERTIARY);
            UIManager.put("infoText", TEXT_PRIMARY);
        }
        catch (Exception e) {
            System.err.println("[Jframe] Failed to apply dark theme: " + e.getMessage());
        }
    }

    private void showExitConfirmation() {
        JDialog dialog = new JDialog(frame, "Teragard", true);
        dialog.setUndecorated(true);
        dialog.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout(0, 15));
        mainPanel.setBackground(BG_SECONDARY);
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ACCENT, 2), BorderFactory.createEmptyBorder(20, 25, 20, 25)));
        JLabel titleLabel = new JLabel("Exit Teragard?", 0);
        titleLabel.setForeground(TEXT_PRIMARY);
        titleLabel.setFont(new Font("SansSerif", 1, 16));
        JLabel messageLabel = new JLabel("Are you sure you wish to exit?", 0);
        messageLabel.setForeground(TEXT_SECONDARY);
        messageLabel.setFont(new Font("SansSerif", 0, 13));
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 0));
        buttonPanel.setBackground(BG_SECONDARY);
        JButton yesButton = this.createStyledButton("Yes", true);
        JButton noButton = this.createStyledButton("No", false);
        yesButton.addActionListener(e -> {
            dialog.dispose();
            System.exit(0);
        });
        noButton.addActionListener(e -> dialog.dispose());
        buttonPanel.add(yesButton);
        buttonPanel.add(noButton);
        JPanel textPanel = new JPanel(new BorderLayout(0, 5));
        textPanel.setBackground(BG_SECONDARY);
        textPanel.add((Component)titleLabel, "North");
        textPanel.add((Component)messageLabel, "Center");
        mainPanel.add((Component)textPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        dialog.add(mainPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        dialog.setVisible(true);
    }

    private JButton createStyledButton(String text, final boolean isPrimary) {
        final JButton button = new JButton(text);
        button.setPreferredSize(new Dimension(80, 32));
        button.setFocusPainted(false);
        button.setFont(new Font("SansSerif", 1, 12));
        button.setCursor(new Cursor(12));
        if (isPrimary) {
            button.setBackground(ACCENT);
            button.setForeground(Color.WHITE);
            button.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        } else {
            button.setBackground(BG_TERTIARY);
            button.setForeground(TEXT_PRIMARY);
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1), BorderFactory.createEmptyBorder(4, 14, 4, 14)));
        }
        final Color originalBg = button.getBackground();
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(isPrimary ? ACCENT.brighter() : BG_HOVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(originalBg);
            }
        });
        return button;
    }

    static {
        BG_PRIMARY = new Color(40, 40, 44);
        BG_SECONDARY = new Color(47, 47, 51);
        BG_TERTIARY = new Color(54, 54, 58);
        BG_HOVER = new Color(60, 60, 65);
        ACCENT = new Color(100, 149, 237);
        TEXT_PRIMARY = new Color(240, 240, 245);
        TEXT_SECONDARY = new Color(160, 160, 170);
        BORDER_COLOR = new Color(60, 60, 64);
    }
}

