/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.Client;
import com.teragard.FrameReader;
import com.teragard.MemCache;
import com.teragard.Model;
import com.teragard.NPCDefinitionLoader;
import com.teragard.Stream;
import com.teragard.VarBit;
import com.teragard.signlink;

public final class NPCDef {
    public int frontLight = 84;
    public int backLight = 1000;
    public int rightLight = -90;
    public int middleLight = -580;
    public int leftLight = -90;
    public int colourRedefine = 0;
    public int colourRedefine2 = 0;
    public int colourRedefine3 = 0;
    public int colourRedefine4 = 0;
    public static int NPCAMOUNT = 11599;
    public static boolean USE_JSON_DEFINITIONS = true;
    public static String JSON_DEFINITIONS_PATH = "data/client_npcs.json";
    public int turn90CCWAnimIndex = -1;
    public static int cacheIndex;
    public int varbitId = -1;
    public int turn180AnimIndex = -1;
    public int varSettingsId = -1;
    public static Stream stream;
    public int combatLevel = -1;
    public String name;
    public String[] actions;
    public int walkAnim = -1;
    public int runAnim;
    public byte squaresNeeded = 1;
    public int[] destColours;
    public static int[] streamIndices;
    public int[] npcHeadModels;
    public int headIcon = -1;
    public int elementalIcon;
    public int[] originalColours;
    public int standAnim = -1;
    public long type = -1L;
    public int degreesToTurn = 32;
    public static NPCDef[] cache;
    public static Client clientInstance;
    public int turn90CWAnimIndex = -1;
    public boolean clickable = true;
    public int lightning;
    public int sizeY = 128;
    public boolean drawMinimapDot = true;
    public int[] childrenIDs;
    public String description;
    public int sizeXZ = 128;
    public int shadow;
    public boolean hasRenderPriority = false;
    public int[] models;
    public static MemCache modelCache;
    public int id;

    public static void copyDef(NPCDef copyFrom, NPCDef copyTo) {
        copyTo.models = copyFrom.models;
        copyTo.runAnim = copyFrom.runAnim;
        copyTo.standAnim = copyFrom.standAnim;
        copyTo.walkAnim = copyFrom.walkAnim;
        copyTo.actions = copyFrom.actions;
        copyTo.name = copyFrom.name;
        copyTo.npcHeadModels = copyFrom.npcHeadModels;
    }

    public static void copyDef(int copyFromId, NPCDef copyTo) {
        NPCDef.copyDef(NPCDef.forID(copyFromId), copyTo);
    }

    public static NPCDef forID(int i) {
        for (int j = 0; j < 20; ++j) {
            if (NPCDef.cache[j].type != (long)i) continue;
            return cache[j];
        }
        cacheIndex = (cacheIndex + 1) % 20;
        NPCDef npc = NPCDef.cache[NPCDef.cacheIndex] = new NPCDef();
        if (i >= streamIndices.length) {
            return null;
        }
        NPCDef.stream.currentOffset = streamIndices[i];
        npc.type = i;
        npc.readValues(stream);
        if (npc.name != null && npc.name.toLowerCase().contains("bank") && npc.actions != null) {
            for (int l = 0; l < npc.actions.length; ++l) {
                if (npc.actions[l] == null || !npc.actions[l].equalsIgnoreCase("Collect")) continue;
                npc.actions[l] = null;
            }
        }
        npc.id = i;
        switch (i) {
            case 659: {
                npc.actions = new String[]{"Open-shop", null, null, null, null};
                npc.name = "Party Pete (AFK Weed Shop)";
                break;
            }
            case 924: {
                npc.name = "Skilling Tutor";
                npc.actions = new String[5];
                npc.actions[0] = "Open-shop";
                break;
            }
            case 1597: {
                npc.name = "Shadow [Easy Slayer]";
                npc.models = new int[]{24444};
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.squaresNeeded = 1;
                npc.combatLevel = 100;
                npc.sizeXZ = (int)((double)npc.sizeXZ * 1.75);
                npc.sizeY = (int)((double)npc.sizeY * 1.75);
                npc.actions = new String[5];
                npc.actions[0] = "Get-task";
                npc.actions[2] = "Reset-task";
                npc.actions[3] = "Open-shop";
                break;
            }
            case 8275: {
                npc.models = new int[]{23611};
                npc.name = "Neoshadow [Hard Slayer]";
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.squaresNeeded = 1;
                npc.combatLevel = 200;
                npc.actions = new String[5];
                npc.actions[0] = "Get-task";
                npc.actions[2] = "Reset-task";
                npc.actions[3] = "Open-shop";
                break;
            }
            case 9085: {
                npc.models = new int[]{25945};
                npc.name = "Fat buu [DBZ Slayer]";
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.squaresNeeded = 1;
                npc.combatLevel = 2000;
                npc.sizeXZ = (int)((double)npc.sizeXZ * 1.2);
                npc.sizeY = (int)((double)npc.sizeY * 1.2);
                npc.actions = new String[5];
                npc.actions[0] = "Get-task";
                npc.actions[2] = "Reset-task";
                npc.actions[3] = "Open-shop";
                break;
            }
            case 7780: {
                npc.models = new int[]{94425, 94427, 94429, 94430, 94432, 96114, 95043};
                npc.destColours = new int[]{65, 65, 65, 65};
                npc.originalColours = new int[]{60, 40, 31, 51};
                npc.name = "@red@Extreme Slayer";
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.squaresNeeded = 1;
                npc.combatLevel = 92;
                npc.sizeXZ = (int)((double)npc.sizeXZ * 1.2);
                npc.sizeY = (int)((double)npc.sizeY * 1.2);
                break;
            }
            case 7781: {
                npc.models = new int[]{94425, 94427, 94429, 94430, 94432, 96114, 95043};
                npc.destColours = new int[]{65, 65, 65, 65};
                npc.originalColours = new int[]{60, 40, 31, 51};
                npc.name = "@red@Extreme Slayer Pet";
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.squaresNeeded = 1;
                npc.combatLevel = 92;
                npc.sizeXZ = (int)((double)npc.sizeXZ * 0.7);
                npc.sizeY = (int)((double)npc.sizeY * 0.7);
                break;
            }
            case 1257: {
                npc.name = "Gold bag (small)";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 33;
                npc.squaresNeeded = 1;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.models = new int[]{28035};
                npc.drawMinimapDot = true;
                break;
            }
            case 1258: {
                npc.name = "Gold bag (medium)";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 66;
                npc.squaresNeeded = 1;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.models = new int[]{28036};
                npc.drawMinimapDot = true;
                break;
            }
            case 1261: {
                npc.name = "Gold bag (big)";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 99;
                npc.squaresNeeded = (byte)2;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.models = new int[]{28037};
                npc.drawMinimapDot = true;
                break;
            }
            case 1262: {
                npc.name = "Gold bag (huge)";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 333;
                npc.squaresNeeded = (byte)2;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.models = new int[]{28038};
                npc.drawMinimapDot = true;
                break;
            }
            case 4392: {
                npc.models = new int[2];
                npc.name = "Baby yoda";
                npc.models[1] = 27577;
                npc.combatLevel = 1000;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.actions = new String[5];
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                break;
            }
            case 8009: {
                npc.name = "@gre@Brutal Hulk";
                npc.models = new int[]{64064};
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.squaresNeeded = 1;
                npc.combatLevel = 138;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeXZ = 250;
                npc.sizeY = 250;
                break;
            }
            case 9786: {
                npc.name = "Rick";
                npc.models = new int[]{28041};
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.squaresNeeded = 1;
                npc.combatLevel = 840;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeXZ = 110;
                npc.sizeY = 110;
                break;
            }
            case 8146: {
                npc.name = "Morty";
                npc.models = new int[]{28040};
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.squaresNeeded = 1;
                npc.combatLevel = 420;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeXZ = 180;
                npc.sizeY = 180;
                break;
            }
            case 6679: {
                npc.models = new int[]{27752};
                npc.name = "Yoshi";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 777;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = (int)((double)npc.sizeY * 1.25);
                npc.sizeXZ = (int)((double)npc.sizeXZ * 1.25);
                npc.squaresNeeded = 1;
                break;
            }
            case 6680: {
                npc.models = new int[]{27751};
                npc.name = "Pet Yoshi";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6681: {
                npc.models = new int[]{27753};
                npc.name = "Pet Yoshi (Pink)";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6683: {
                npc.models = new int[]{24444};
                npc.name = "Pet Shadow";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6684: {
                npc.models = new int[]{23611};
                npc.name = "Pet Neoshadow";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 100;
                npc.sizeXZ = 100;
                npc.squaresNeeded = 1;
                break;
            }
            case 7500: {
                npc.name = "Pikachu";
                npc.models = new int[]{27500};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7501: {
                npc.name = "Bulbasaur";
                npc.models = new int[]{27501};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7502: {
                npc.name = "Charmander";
                npc.models = new int[]{27502};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7503: {
                npc.name = "Eevee";
                npc.models = new int[]{27503};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ /= 2;
                npc.sizeY /= 2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7504: {
                npc.name = "Flareon";
                npc.models = new int[]{27504};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7505: {
                npc.name = "Jolteon";
                npc.models = new int[]{27505};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7506: {
                npc.name = "Vaporeon";
                npc.models = new int[]{27506};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7507: {
                npc.name = "Espeon";
                npc.models = new int[]{27507};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7508: {
                npc.name = "Raichu";
                npc.models = new int[]{27508};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7509: {
                npc.name = "Venosaur";
                npc.models = new int[]{27509};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ /= 2;
                npc.sizeY /= 2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7510: {
                npc.name = "Charizard";
                npc.models = new int[]{27510};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7511: {
                npc.name = "Deoxys Melee";
                npc.models = new int[]{27511};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ /= 2;
                npc.sizeY /= 2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7512: {
                npc.name = "Deoxys Mage";
                npc.models = new int[]{27512};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ /= 2;
                npc.sizeY /= 2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7513: {
                npc.name = "Deoxys Range";
                npc.models = new int[]{27513};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ /= 2;
                npc.sizeY /= 2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7514: {
                npc.name = "MewTwo";
                npc.models = new int[]{27514};
                npc.combatLevel = 3;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 7516: {
                npc.name = "Jessie";
                npc.models = new int[]{27516};
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.actions = new String[]{"Open-shop", null, "Teleport", null, null};
                npc.drawMinimapDot = true;
                npc.clickable = true;
                break;
            }
            case 7851: {
                npc.name = "Mr Meeseeks";
                npc.squaresNeeded = 1;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.models = new int[]{28044};
                npc.actions = new String[]{"Open-shop", null, null, null, null};
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                break;
            }
            case 8721: {
                npc.name = "Darth Vader";
                npc.actions[0] = "Open-shop";
                npc.actions[2] = "Teleport";
                npc.combatLevel = 333;
                npc.squaresNeeded = 1;
                npc.combatLevel = 653;
                npc.standAnim = 11973;
                npc.walkAnim = 11975;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.models = new int[]{28810, 28808, 28806, 28804, 28803, 28801};
                break;
            }
            case 1951: {
                npc.name = "Inuyasha";
                npc.models = new int[]{24201, 24203, 24205, 24207, 24209, 24210};
                npc.combatLevel = 1000;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1952: {
                npc.name = "Manray";
                npc.models = new int[]{24212, 24214, 24216, 24218, 24219, 24221};
                npc.combatLevel = 1000;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1953: {
                npc.name = "Aang";
                npc.models = new int[]{24223, 22136, 22138, 22140, 22141, 22145};
                npc.combatLevel = 1000;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1095: {
                npc.name = "Spyro";
                npc.models = new int[]{27588};
                npc.combatLevel = 69;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 96;
                npc.sizeY = 96;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1096: {
                npc.name = "Chuck";
                npc.models = new int[]{27591};
                npc.combatLevel = 138;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 96;
                npc.sizeY = 96;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1097: {
                npc.name = "Police car";
                npc.models = new int[]{27594};
                npc.combatLevel = 420;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 96;
                npc.sizeY = 96;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1098: {
                npc.name = "Otherworldly being";
                npc.models = new int[]{27600};
                npc.combatLevel = 666;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1954: {
                npc.name = "Deadpool";
                npc.models = new int[]{27602};
                npc.combatLevel = 420;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1955: {
                npc.name = "Harry potter";
                npc.models = new int[]{27611};
                npc.combatLevel = 7;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1956: {
                npc.name = "Masterchief";
                npc.models = new int[]{27626};
                npc.combatLevel = 1976;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1958: {
                npc.name = "Golden knight";
                npc.models = new int[]{27638};
                npc.combatLevel = 999;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 128;
                npc.sizeY = 128;
                npc.drawMinimapDot = true;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1101: {
                npc.name = "Space Alien";
                npc.models = new int[]{28049};
                npc.combatLevel = 7777;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 196;
                npc.sizeY = 196;
                npc.drawMinimapDot = true;
                npc.squaresNeeded = (byte)2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1102: {
                npc.name = "UFO";
                npc.models = new int[]{28046};
                npc.combatLevel = 777;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ = 64;
                npc.sizeY = 64;
                npc.drawMinimapDot = true;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 1327: {
                npc.name = "Exodia";
                npc.models = new int[]{27520};
                npc.combatLevel = 9999;
                npc.walkAnim = 819;
                npc.standAnim = 808;
                npc.sizeXZ *= 2;
                npc.sizeY *= 2;
                npc.actions = new String[]{null, "Attack", null, null, null};
                break;
            }
            case 9172: {
                npc.models = new int[]{28060};
                npc.name = "Blood nex";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 2002;
                npc.standAnim = 6320;
                npc.walkAnim = 6319;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1103: {
                npc.models = new int[]{28071, 28073, 28075, 28076, 28078};
                npc.name = "Goku";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1104: {
                npc.models = new int[]{28080, 28082, 28084, 28085, 28087};
                npc.name = "Vegeta";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1105: {
                npc.models = new int[]{28089, 28091, 28093, 28094, 28096};
                npc.name = "Perfect cell";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1106: {
                npc.models = new int[]{28098, 28100, 28102, 28103, 28105};
                npc.name = "Piccolo";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1107: {
                npc.models = new int[]{28107, 28109, 28111, 28112, 28114};
                npc.name = "SSJ3";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1108: {
                npc.models = new int[]{28116, 28118, 28120, 28121, 28123};
                npc.name = "Raditiz";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1109: {
                npc.models = new int[]{28125, 28127, 28129, 28130, 28078};
                npc.name = "Black goku";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1110: {
                npc.models = new int[]{28132, 28134, 28136, 28137, 28087};
                npc.name = "Black vegeta";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1112: {
                npc.models = new int[]{28139, 28141, 28143, 28144, 28146};
                npc.name = "SSJ4";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1115: {
                npc.models = new int[]{28148, 28150, 28152, 28153, 28155};
                npc.name = "Majin buu";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1116: {
                npc.models = new int[]{25901, 25903, 25905, 25906, 25908};
                npc.name = "Freeza";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1117: {
                npc.models = new int[]{25910, 25912, 25914, 25915, 25917};
                npc.name = "Beerus";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1118: {
                npc.models = new int[]{25919, 25921, 25923, 25924, 25926};
                npc.name = "Jiren";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 156;
                npc.sizeXZ = 156;
                npc.squaresNeeded = 1;
                break;
            }
            case 1119: {
                npc.models = new int[]{25944};
                npc.name = "Zeno";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 100;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 64;
                npc.sizeXZ = 64;
                npc.squaresNeeded = 1;
                break;
            }
            case 1120: {
                npc.models = new int[]{25945};
                npc.name = "Pet Fat buu";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 96;
                npc.sizeXZ = 96;
                npc.squaresNeeded = (byte)2;
                break;
            }
            case 1121: {
                npc.models = new int[]{25946};
                npc.name = "Pet Golden Oozaru";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 56;
                npc.sizeXZ = 56;
                npc.squaresNeeded = (byte)2;
                break;
            }
            case 1122: {
                npc.models = new int[]{25945};
                npc.name = "DBZ Slayer Master";
                npc.actions = new String[]{"Talk-to", null, null, null, null};
                npc.combatLevel = 9001;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 96;
                npc.sizeXZ = 32;
                npc.squaresNeeded = (byte)2;
                break;
            }
            case 1123: {
                npc.models = new int[]{25947};
                npc.name = "Pet Shenron";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 96;
                npc.sizeXZ = 32;
                npc.squaresNeeded = (byte)2;
                break;
            }
            case 6351: {
                npc.models = new int[]{28041};
                npc.name = "Pet Rick";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6353: {
                npc.models = new int[]{28040};
                npc.name = "Pet Morty";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6359: {
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.models = new int[1];
                npc.models[0] = 27543;
                npc.name = "Pet Pepe";
                npc.combatLevel = 0;
                npc.description = "It's pepe pet.";
                npc.standAnim = 11973;
                npc.walkAnim = 11975;
                npc.squaresNeeded = 1;
                npc.sizeXZ = 32;
                npc.sizeY = 32;
                break;
            }
            case 6666: {
                npc.models = new int[]{28071, 28073, 28075, 28076, 28078};
                npc.name = "Pet Goku";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6667: {
                npc.models = new int[]{28080, 28082, 28084, 28085, 28087};
                npc.name = "Pet Vegeta";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6668: {
                npc.models = new int[]{28089, 28091, 28093, 28094, 28096};
                npc.name = "Pet Cell";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6669: {
                npc.models = new int[]{28098, 28100, 28102, 28103, 28105};
                npc.name = "Pet Piccolo";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6670: {
                npc.models = new int[]{28107, 28109, 28111, 28112, 28114};
                npc.name = "Pet SSJ3";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6671: {
                npc.models = new int[]{28116, 28118, 28120, 28121, 28123};
                npc.name = "Pet Raditz";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6672: {
                npc.models = new int[]{28125, 28127, 28129, 28130, 28078};
                npc.name = "Pet Black Goku";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6673: {
                npc.models = new int[]{28132, 28134, 28136, 28137, 28087};
                npc.name = "Pet Black Vegeta";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6674: {
                npc.models = new int[]{28139, 28141, 28143, 28144, 28146};
                npc.name = "Pet SSJ4";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6675: {
                npc.models = new int[]{28148, 28150, 28152, 28153, 28155};
                npc.name = "Pet Buu";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6676: {
                npc.models = new int[]{25901, 25903, 25905, 25906, 25908};
                npc.name = "Pet Freeza";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6677: {
                npc.models = new int[]{25910, 25912, 25914, 25915, 25917};
                npc.name = "Pet Beerus";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 6678: {
                npc.models = new int[]{25919, 25921, 25923, 25924, 25926};
                npc.name = "Pet Jiren";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
                break;
            }
            case 13000: {
                npc.models = new int[]{65534, 65536, 65538, 65540, 65542, 65544};
                npc.name = "Madara";
                npc.actions = new String[]{null, "Attack", null, null, null};
                npc.combatLevel = 1337;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 250;
                npc.sizeXZ = 250;
                npc.squaresNeeded = 1;
                break;
            }
            case 13001: {
                npc.models = new int[]{65534, 65536, 65538, 65540, 65542, 65544};
                npc.name = "Pet Madara";
                npc.actions = new String[]{"Pick-up", null, null, null, null};
                npc.combatLevel = 0;
                npc.standAnim = 808;
                npc.walkAnim = 819;
                npc.sizeY = 78;
                npc.sizeXZ = 78;
                npc.squaresNeeded = 1;
            }
        }
        if (USE_JSON_DEFINITIONS && NPCDefinitionLoader.hasOverride(i)) {
            npc = NPCDefinitionLoader.applyOverrides(npc, i);
        }
        return npc;
    }

    public Model getHeadModel() {
        if (this.childrenIDs != null) {
            NPCDef altered = this.getAlteredNPCDef();
            if (altered == null) {
                return null;
            }
            return altered.getHeadModel();
        }
        if (this.npcHeadModels == null) {
            return null;
        }
        boolean everyFetched = false;
        for (int i = 0; i < this.npcHeadModels.length; ++i) {
            if (Model.modelIsFetched(this.npcHeadModels[i])) continue;
            everyFetched = true;
        }
        if (everyFetched) {
            return null;
        }
        Model[] parts = new Model[this.npcHeadModels.length];
        for (int j = 0; j < this.npcHeadModels.length; ++j) {
            parts[j] = Model.fetchModel(this.npcHeadModels[j]);
        }
        Model completeModel = parts.length == 1 ? parts[0] : new Model(parts.length, parts);
        if (this.originalColours != null) {
            for (int k = 0; k < this.originalColours.length; ++k) {
                completeModel.recolour(this.originalColours[k], this.destColours[k]);
            }
        }
        if (this.colourRedefine > 0) {
            completeModel.method1337(this.colourRedefine);
        }
        if (this.colourRedefine2 != 0) {
            completeModel.method1338(this.colourRedefine2);
        }
        if (this.colourRedefine3 != 0) {
            completeModel.method1339(this.colourRedefine3);
        }
        this.applyTexturing(completeModel, this.id);
        return completeModel;
    }

    public NPCDef getAlteredNPCDef() {
        try {
            int j = -1;
            if (this.varbitId != -1) {
                VarBit varBit = VarBit.cache[this.varbitId];
                int k = varBit.configId;
                int l = varBit.leastSignificantBit;
                int i1 = varBit.mostSignificantBit;
                int j1 = Client.anIntArray1232[i1 - l];
                j = NPCDef.clientInstance.variousSettings[k] >> l & j1;
            } else if (this.varSettingsId != -1) {
                j = NPCDef.clientInstance.variousSettings[this.varSettingsId];
            }
            if (j < 0 || j >= this.childrenIDs.length || this.childrenIDs[j] == -1) {
                return null;
            }
            return NPCDef.forID(this.childrenIDs[j]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void unpackConfig(CacheArchive streamLoader) {
        stream = new Stream(streamLoader.getDataForName("npc.dat"));
        Stream stream2 = new Stream(streamLoader.getDataForName("npc.idx"));
        int totalNPCs = stream2.readUnsignedWord();
        streamIndices = new int[totalNPCs];
        int i = 2;
        for (int j = 0; j < totalNPCs; ++j) {
            NPCDef.streamIndices[j] = i;
            i += stream2.readUnsignedWord();
        }
        cache = new NPCDef[20];
        for (int k = 0; k < 20; ++k) {
            NPCDef.cache[k] = new NPCDef();
        }
        if (USE_JSON_DEFINITIONS) {
            try {
                String jsonPath = signlink.findcachedir() + JSON_DEFINITIONS_PATH;
                NPCDefinitionLoader.load(jsonPath);
            }
            catch (Exception e) {
                System.err.println("[NPCDef] Failed to load JSON definitions: " + e.getMessage());
                USE_JSON_DEFINITIONS = false;
            }
        }
    }

    public static void printDefinitionsForId(int mobId) {
        int i;
        NPCDef dump = NPCDef.forID(mobId);
        if (dump.name != null) {
            System.out.println("Dumping: " + dump.name);
        } else {
            System.out.println("MobDefinition.get(" + mobId + ").name == null");
        }
        System.out.println("combatlevel: " + dump.combatLevel);
        System.out.println("id: " + dump.id);
        if (dump.models != null) {
            for (i = 0; i < dump.models.length; ++i) {
                System.out.println("npcModels[" + i + "]: " + dump.models[i]);
            }
        }
        if (dump.actions != null) {
            for (i = 0; i < dump.actions.length; ++i) {
                System.out.println("Action[" + i + "]: " + dump.actions[i]);
            }
        }
        System.out.println("degreesToTurn: " + dump.degreesToTurn);
    }

    public static void nullLoader() {
        modelCache = null;
        streamIndices = null;
        cache = null;
        stream = null;
    }

    public Model getAnimatedModel(int j, int k, int[] ai) {
        if (this.childrenIDs != null) {
            NPCDef npc = this.getAlteredNPCDef();
            if (npc == null) {
                return null;
            }
            return npc.getAnimatedModel(j, k, ai);
        }
        Model completedModel = (Model)modelCache.get(this.type);
        if (completedModel == null) {
            boolean everyModelFetched = false;
            for (int ptr = 0; ptr < this.models.length; ++ptr) {
                if (Model.modelIsFetched(this.models[ptr])) continue;
                everyModelFetched = true;
            }
            if (everyModelFetched) {
                return null;
            }
            Model[] parts = new Model[this.models.length];
            for (int j1 = 0; j1 < this.models.length; ++j1) {
                parts[j1] = Model.fetchModel(this.models[j1]);
            }
            completedModel = parts.length == 1 ? parts[0] : new Model(parts.length, parts);
            if (this.originalColours != null) {
                for (int k1 = 0; k1 < this.originalColours.length; ++k1) {
                    completedModel.recolour(this.originalColours[k1], this.destColours[k1]);
                }
            }
            if (this.colourRedefine > 0) {
                completedModel.method1337(this.colourRedefine);
            }
            if (this.colourRedefine2 != 0) {
                completedModel.method1338(this.colourRedefine2);
            }
            if (this.colourRedefine3 != 0) {
                completedModel.method1339(this.colourRedefine3);
            }
            if (this.id == 13700) {
                completedModel.method1337(9600);
            }
            this.applyTexturing(completedModel, this.id);
            completedModel.createBones();
            completedModel.light(this.frontLight, this.backLight, this.rightLight, this.middleLight, this.leftLight, true);
            modelCache.put(completedModel, this.type);
        }
        Model animatedModel = Model.entityModelDesc;
        animatedModel.method464(completedModel, FrameReader.isNullFrame(k) & FrameReader.isNullFrame(j));
        if (k != -1 && j != -1) {
            animatedModel.method471(ai, j, k);
        } else if (k != -1) {
            animatedModel.applyTransform(k);
        }
        if (this.sizeXZ != 128 || this.sizeY != 128) {
            animatedModel.scaleT(this.sizeXZ, this.sizeXZ, this.sizeY);
        }
        animatedModel.calculateDiagonals();
        animatedModel.triangleSkin = null;
        animatedModel.vertexSkin = null;
        if (this.squaresNeeded == 1) {
            animatedModel.rendersWithinOneTile = true;
        }
        return animatedModel;
    }

    public Model method164(int j, int frame, int[] ai, int nextFrame, int idk, int idk2) {
        if (this.childrenIDs != null) {
            NPCDef npc = this.getAlteredNPCDef();
            if (npc == null) {
                return null;
            }
            return npc.method164(j, frame, ai, nextFrame, idk, idk2);
        }
        Model completedModel = (Model)modelCache.get(this.type);
        if (completedModel == null) {
            boolean everyModelFetched = false;
            for (int ptr = 0; ptr < this.models.length; ++ptr) {
                if (Model.modelIsFetched(this.models[ptr])) continue;
                everyModelFetched = true;
            }
            if (everyModelFetched) {
                return null;
            }
            Model[] parts = new Model[this.models.length];
            for (int j1 = 0; j1 < this.models.length; ++j1) {
                parts[j1] = Model.fetchModel(this.models[j1]);
            }
            completedModel = parts.length == 1 ? parts[0] : new Model(parts.length, parts);
            if (this.originalColours != null) {
                for (int k1 = 0; k1 < this.originalColours.length; ++k1) {
                    completedModel.recolour(this.originalColours[k1], this.destColours[k1]);
                }
            }
            if (this.colourRedefine > 0) {
                completedModel.method1337(this.colourRedefine);
            }
            if (this.colourRedefine2 != 0) {
                completedModel.method1338(this.colourRedefine2);
            }
            if (this.colourRedefine3 != 0) {
                completedModel.method1339(this.colourRedefine3);
            }
            if (this.id == 13700) {
                completedModel.method1337(9600);
            }
            this.applyTexturing(completedModel, this.id);
            completedModel.createBones();
            completedModel.light(this.frontLight, this.backLight, this.rightLight, this.middleLight, this.leftLight, true);
            modelCache.put(completedModel, this.type);
        }
        Model animatedModel = Model.entityModelDesc;
        animatedModel.method464(completedModel, FrameReader.isNullFrame(frame) & FrameReader.isNullFrame(j));
        if (frame != -1 && j != -1) {
            animatedModel.method471(ai, j, frame);
        } else if (frame != -1 && nextFrame != -1) {
            animatedModel.applyTransform(frame, nextFrame, idk, idk2);
        } else if (frame != -1) {
            animatedModel.applyTransform(frame);
        }
        if (this.sizeXZ != 128 || this.sizeY != 128) {
            animatedModel.scaleT(this.sizeXZ, this.sizeXZ, this.sizeY);
        }
        animatedModel.calculateDiagonals();
        animatedModel.triangleSkin = null;
        animatedModel.vertexSkin = null;
        if (this.squaresNeeded == 1) {
            animatedModel.rendersWithinOneTile = true;
        }
        return animatedModel;
    }

    public void readValues(Stream stream) {
        int i;
        block0: while ((i = stream.readUnsignedByte()) != 0) {
            if (i == 1) {
                int j = stream.readUnsignedByte();
                this.models = new int[j];
                for (int j1 = 0; j1 < j; ++j1) {
                    this.models[j1] = stream.readUnsignedWord();
                }
            } else if (i == 2) {
                this.name = stream.readNewString();
            } else if (i == 3) {
                this.description = stream.readNewString();
            } else if (i == 12) {
                this.squaresNeeded = stream.readSignedByte();
            } else if (i == 13) {
                this.standAnim = stream.readUnsignedWord();
            } else if (i == 14) {
                this.runAnim = this.walkAnim = stream.readUnsignedWord();
            } else if (i == 17) {
                this.walkAnim = stream.readUnsignedWord();
                this.turn180AnimIndex = stream.readUnsignedWord();
                this.turn90CWAnimIndex = stream.readUnsignedWord();
                this.turn90CCWAnimIndex = stream.readUnsignedWord();
                if (this.walkAnim == 65535) {
                    this.walkAnim = -1;
                }
                if (this.turn180AnimIndex == 65535) {
                    this.turn180AnimIndex = -1;
                }
                if (this.turn90CWAnimIndex == 65535) {
                    this.turn90CWAnimIndex = -1;
                }
                if (this.turn90CCWAnimIndex == 65535) {
                    this.turn90CCWAnimIndex = -1;
                }
            } else if (i >= 30 && i < 40) {
                if (this.actions == null) {
                    this.actions = new String[5];
                }
                this.actions[i - 30] = stream.readNewString();
                if (this.actions[i - 30].equalsIgnoreCase("hidden")) {
                    this.actions[i - 30] = null;
                }
            } else if (i == 40) {
                int k = stream.readUnsignedByte();
                this.destColours = new int[k];
                this.originalColours = new int[k];
                for (int k1 = 0; k1 < k; ++k1) {
                    this.originalColours[k1] = stream.readUnsignedWord();
                    this.destColours[k1] = stream.readUnsignedWord();
                }
            } else if (i == 60) {
                int l = stream.readUnsignedByte();
                this.npcHeadModels = new int[l];
                for (int l1 = 0; l1 < l; ++l1) {
                    this.npcHeadModels[l1] = stream.readUnsignedWord();
                }
            } else if (i == 90) {
                stream.readUnsignedWord();
            } else if (i == 91) {
                stream.readUnsignedWord();
            } else if (i == 92) {
                stream.readUnsignedWord();
            } else if (i == 93) {
                this.drawMinimapDot = false;
            } else if (i == 95) {
                this.combatLevel = stream.readUnsignedWord();
            } else if (i == 97) {
                this.sizeXZ = stream.readUnsignedWord();
            } else if (i == 98) {
                this.sizeY = stream.readUnsignedWord();
            } else if (i == 99) {
                this.hasRenderPriority = true;
            } else if (i == 100) {
                this.lightning = stream.readSignedByte();
            } else if (i == 101) {
                this.shadow = stream.readSignedByte() * 5;
            } else if (i == 102) {
                this.headIcon = stream.readUnsignedWord();
            }
            if (i == 103) {
                this.degreesToTurn = stream.readUnsignedWord();
                continue;
            }
            if (i == 106) {
                this.varbitId = stream.readUnsignedWord();
                if (this.varbitId == 65535) {
                    this.varbitId = -1;
                }
                this.varSettingsId = stream.readUnsignedWord();
                if (this.varSettingsId == 65535) {
                    this.varSettingsId = -1;
                }
                int i1 = stream.readUnsignedByte();
                this.childrenIDs = new int[i1 + 1];
                int i2 = 0;
                while (true) {
                    if (i2 > i1) continue block0;
                    this.childrenIDs[i2] = stream.readUnsignedWord();
                    if (this.childrenIDs[i2] == 65535) {
                        this.childrenIDs[i2] = -1;
                    }
                    ++i2;
                }
            }
            if (i != 107) continue;
            this.clickable = false;
        }
        return;
    }

    public void applyTexturing(Model model, int id) {
    }

    static {
        modelCache = new MemCache(30);
    }
}

