/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.NPCDef;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NPCDefinitionLoader {
    private static Map<Integer, JsonNPCDefinition> loadedDefinitions = new HashMap<Integer, JsonNPCDefinition>();
    private static boolean isLoaded = false;

    public static void load(String jsonPath) {
        if (isLoaded) {
            return;
        }
        try {
            if (!Files.exists(Paths.get(jsonPath, new String[0]), new LinkOption[0])) {
                System.out.println("[NPCDefinitionLoader] No custom definitions file found at: " + jsonPath);
                isLoaded = true;
                return;
            }
            System.out.println("[NPCDefinitionLoader] Loading definitions from: " + jsonPath);
            String content = new String(Files.readAllBytes(Paths.get(jsonPath, new String[0])));
            NPCDefinitionLoader.parseJsonArray(content);
            isLoaded = true;
            System.out.println("[NPCDefinitionLoader] Loaded " + loadedDefinitions.size() + " NPC definitions");
        }
        catch (Exception e) {
            System.err.println("[NPCDefinitionLoader] Failed to load definitions: " + e.getMessage());
            isLoaded = true;
        }
    }

    public static NPCDef applyOverrides(NPCDef npc, int id) {
        if (!isLoaded || !loadedDefinitions.containsKey(id)) {
            return npc;
        }
        JsonNPCDefinition json = loadedDefinitions.get(id);
        if (json.name != null) {
            npc.name = json.name;
        }
        if (json.models != null && json.models.length > 0) {
            npc.models = json.models;
        }
        if (json.standAnim > 0) {
            npc.standAnim = json.standAnim;
        }
        if (json.walkAnim > 0) {
            npc.walkAnim = json.walkAnim;
        }
        if (json.runAnim > 0) {
            npc.runAnim = json.runAnim;
        }
        if (json.combatLevel > 0) {
            npc.combatLevel = json.combatLevel;
        }
        if (json.squaresNeeded > 0) {
            npc.squaresNeeded = (byte)json.squaresNeeded;
        }
        if (json.sizeXZMultiplier > 0.0) {
            npc.sizeXZ = (int)((double)npc.sizeXZ * json.sizeXZMultiplier);
        }
        if (json.sizeYMultiplier > 0.0) {
            npc.sizeY = (int)((double)npc.sizeY * json.sizeYMultiplier);
        }
        if (json.actions != null) {
            npc.actions = new String[5];
            for (int i = 0; i < Math.min(json.actions.length, 5); ++i) {
                npc.actions[i] = json.actions[i];
            }
        }
        if (json.destColours != null && json.destColours.length > 0) {
            npc.destColours = json.destColours;
        }
        if (json.originalColours != null && json.originalColours.length > 0) {
            npc.originalColours = json.originalColours;
        }
        if (json.npcHeadModels != null && json.npcHeadModels.length > 0) {
            npc.npcHeadModels = json.npcHeadModels;
        }
        if (json.drawMinimapDot) {
            npc.drawMinimapDot = true;
        }
        return npc;
    }

    public static boolean hasOverride(int id) {
        return loadedDefinitions.containsKey(id);
    }

    public static int getDefinitionCount() {
        return loadedDefinitions.size();
    }

    private static void parseJsonArray(String json) {
        if ((json = json.trim()).startsWith("[")) {
            json = json.substring(1);
        }
        if (json.endsWith("]")) {
            json = json.substring(0, json.length() - 1);
        }
        int depth = 0;
        int objectStart = -1;
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                if (depth == 0) {
                    objectStart = i;
                }
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0 || objectStart < 0) continue;
            String objectJson = json.substring(objectStart, i + 1);
            JsonNPCDefinition def = NPCDefinitionLoader.parseJsonObject(objectJson);
            if (def != null && def.id >= 0) {
                loadedDefinitions.put(def.id, def);
            }
            objectStart = -1;
        }
    }

    private static JsonNPCDefinition parseJsonObject(String json) {
        String[] parts;
        JsonNPCDefinition def = new JsonNPCDefinition();
        if ((json = json.trim()).startsWith("{")) {
            json = json.substring(1);
        }
        if (json.endsWith("}")) {
            json = json.substring(0, json.length() - 1);
        }
        for (String part : parts = NPCDefinitionLoader.splitJsonPairs(json)) {
            int colonIndex;
            if ((part = part.trim()).isEmpty() || (colonIndex = part.indexOf(58)) < 0) continue;
            String key = part.substring(0, colonIndex).trim();
            String value = part.substring(colonIndex + 1).trim();
            if (key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            try {
                switch (key) {
                    case "id": {
                        def.id = Integer.parseInt(value);
                        break;
                    }
                    case "name": {
                        def.name = NPCDefinitionLoader.parseStringValue(value);
                        break;
                    }
                    case "models": {
                        def.models = NPCDefinitionLoader.parseIntArray(value);
                        break;
                    }
                    case "standAnim": {
                        def.standAnim = Integer.parseInt(value);
                        break;
                    }
                    case "walkAnim": {
                        def.walkAnim = Integer.parseInt(value);
                        break;
                    }
                    case "runAnim": {
                        def.runAnim = Integer.parseInt(value);
                        break;
                    }
                    case "combatLevel": {
                        def.combatLevel = Integer.parseInt(value);
                        break;
                    }
                    case "squaresNeeded": {
                        def.squaresNeeded = Integer.parseInt(value);
                        break;
                    }
                    case "sizeXZMultiplier": {
                        def.sizeXZMultiplier = Double.parseDouble(value);
                        break;
                    }
                    case "sizeYMultiplier": {
                        def.sizeYMultiplier = Double.parseDouble(value);
                        break;
                    }
                    case "actions": {
                        def.actions = NPCDefinitionLoader.parseStringArray(value);
                        break;
                    }
                    case "destColours": {
                        def.destColours = NPCDefinitionLoader.parseIntArray(value);
                        break;
                    }
                    case "originalColours": {
                        def.originalColours = NPCDefinitionLoader.parseIntArray(value);
                        break;
                    }
                    case "npcHeadModels": {
                        def.npcHeadModels = NPCDefinitionLoader.parseIntArray(value);
                        break;
                    }
                    case "drawMinimapDot": {
                        def.drawMinimapDot = Boolean.parseBoolean(value);
                        break;
                    }
                    case "visible": {
                        def.visible = Boolean.parseBoolean(value);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private static String[] splitJsonPairs(String json) {
        ArrayList<String> pairs = new ArrayList<String>();
        int depth = 0;
        int start = 0;
        boolean inString = false;
        for (int i = 0; i < json.length(); ++i) {
            char prev;
            char c = json.charAt(i);
            char c2 = prev = i > 0 ? json.charAt(i - 1) : (char)'\u0000';
            if (c == '\"' && prev != '\\') {
                inString = !inString;
                continue;
            }
            if (inString) continue;
            if (c == '[' || c == '{') {
                ++depth;
                continue;
            }
            if (c == ']' || c == '}') {
                --depth;
                continue;
            }
            if (c != ',' || depth != 0) continue;
            pairs.add(json.substring(start, i));
            start = i + 1;
        }
        if (start < json.length()) {
            pairs.add(json.substring(start));
        }
        return pairs.toArray(new String[0]);
    }

    private static String parseStringValue(String value) {
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value.replace("\\\"", "\"").replace("\\n", "\n").replace("\\\\", "\\");
    }

    private static String[] parseStringArray(String value) {
        if (!(value = value.trim()).startsWith("[") || !value.endsWith("]")) {
            return new String[0];
        }
        if ((value = value.substring(1, value.length() - 1)).isEmpty()) {
            return new String[0];
        }
        ArrayList<String> items = new ArrayList<String>();
        boolean inString = false;
        int start = 0;
        for (int i = 0; i < value.length(); ++i) {
            char prev;
            char c = value.charAt(i);
            char c2 = prev = i > 0 ? value.charAt(i - 1) : (char)'\u0000';
            if (c == '\"' && prev != '\\') {
                inString = !inString;
                continue;
            }
            if (c != ',' || inString) continue;
            String item = value.substring(start, i).trim();
            if (item.equals("null")) {
                items.add(null);
            } else {
                items.add(NPCDefinitionLoader.parseStringValue(item));
            }
            start = i + 1;
        }
        if (start < value.length()) {
            String item = value.substring(start).trim();
            if (item.equals("null")) {
                items.add(null);
            } else {
                items.add(NPCDefinitionLoader.parseStringValue(item));
            }
        }
        return items.toArray(new String[0]);
    }

    private static int[] parseIntArray(String value) {
        if (!(value = value.trim()).startsWith("[") || !value.endsWith("]")) {
            return new int[0];
        }
        if ((value = value.substring(1, value.length() - 1).trim()).isEmpty()) {
            return new int[0];
        }
        String[] parts = value.split(",");
        int[] result = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                result[i] = Integer.parseInt(parts[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                result[i] = 0;
            }
        }
        return result;
    }

    private static class JsonNPCDefinition {
        int id = -1;
        String name;
        int[] models;
        int standAnim = 0;
        int walkAnim = 0;
        int runAnim = 0;
        int combatLevel = 0;
        int squaresNeeded = 0;
        double sizeXZMultiplier = 0.0;
        double sizeYMultiplier = 0.0;
        String[] actions;
        int[] destColours;
        int[] originalColours;
        int[] npcHeadModels;
        boolean drawMinimapDot = false;
        boolean visible = true;

        private JsonNPCDefinition() {
        }
    }
}

