/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Animable;
import com.teragard.Animation;
import com.teragard.Client;
import com.teragard.Model;
import com.teragard.ObjectDef;
import com.teragard.VarBit;

final class ObjectOnTile
extends Animable {
    private int frame;
    private final int[] objectConfigs;
    private final int varbitIndex;
    private final int configId;
    private final int a_y;
    private final int b_y;
    private final int d_y;
    private final int c_y;
    private Animation animation;
    private int nextFrameTime;
    public static Client clientInstance;
    private final int objectId;
    private final int type;
    private final int orientation;

    @Override
    public Model getRotatedModel() {
        ObjectDef objectDef;
        int anim = -1;
        if (this.animation != null) {
            int currentTime = Client.loopCycle - this.nextFrameTime;
            if (currentTime > 100 && this.animation.loopDelay > 0) {
                currentTime = 100;
            }
            while (currentTime > this.animation.getFrameLength(this.frame)) {
                currentTime -= this.animation.getFrameLength(this.frame);
                ++this.frame;
                if (this.frame < this.animation.frameCount) continue;
                this.frame -= this.animation.loopDelay;
                if (this.frame >= 0 && this.frame < this.animation.frameCount) continue;
                this.animation = null;
                break;
            }
            this.nextFrameTime = Client.loopCycle - currentTime;
            if (this.animation != null) {
                anim = this.animation.frameIDs[this.frame];
            }
        }
        if ((objectDef = this.objectConfigs != null ? this.getObjectForVarbitConfig() : ObjectDef.forID(this.objectId)) == null) {
            return null;
        }
        return objectDef.renderObject(this.type, this.orientation, this.a_y, this.b_y, this.d_y, this.c_y, anim);
    }

    private ObjectDef getObjectForVarbitConfig() {
        try {
            int i = -1;
            if (this.varbitIndex != -1) {
                VarBit varBit = VarBit.cache[this.varbitIndex];
                int k = varBit.configId;
                int l = varBit.leastSignificantBit;
                int i1 = varBit.mostSignificantBit;
                int j1 = Client.anIntArray1232[i1 - l];
                i = ObjectOnTile.clientInstance.variousSettings[k] >> l & j1;
            } else if (this.configId != -1) {
                i = ObjectOnTile.clientInstance.variousSettings[this.configId];
            }
            if (i < 0 || i >= this.objectConfigs.length || this.objectConfigs[i] == -1) {
                return null;
            }
            return ObjectDef.forID(this.objectConfigs[i]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public ObjectOnTile(int i, int j, int k, int l, int i1, int j1, int k1, int anim, boolean randomizeAnimStart) {
        this.objectId = i;
        this.type = k;
        this.orientation = j;
        this.a_y = j1;
        this.b_y = l;
        this.d_y = i1;
        this.c_y = k1;
        if (anim != -1) {
            this.animation = Animation.anims[anim];
            this.frame = 0;
            this.nextFrameTime = Client.loopCycle;
            if (randomizeAnimStart && this.animation.loopDelay != -1) {
                this.frame = (int)(Math.random() * (double)this.animation.frameCount);
                this.nextFrameTime -= (int)(Math.random() * (double)this.animation.getFrameLength(this.frame));
            }
        }
        ObjectDef object = ObjectDef.forID(this.objectId);
        this.varbitIndex = object.varbitIndex;
        this.configId = object.configID;
        this.objectConfigs = object.configObjectIDs;
    }
}

