/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.Client;
import java.nio.ByteBuffer;

public class OverLayFlo317 {
    public boolean aBoolean393;
    public static OverLayFlo317[] overLayFlo317s;
    public int groundTextureOverlay = -1;
    public int groundColorOverlay;
    public boolean occludeOverlay;
    public int detailedColor;
    public int detailedTexture9;
    public boolean boolean_10;
    public int detailedTexture11;
    public boolean boolean_12;
    public int detailedColor13;
    public int detailedTexture14;
    public int int_15;
    public int alpha;
    public int groundHueOverlay;
    public int groundSaturationOverlay;
    public int groundLightnessOverlay;
    public int weighted_hue;
    public int chroma_overlay;
    public int hslOverlayColor;
    public int anInt390;

    public static void unpackConfig(CacheArchive streamLoader) {
        ByteBuffer buffer = ByteBuffer.wrap(streamLoader.getDataForName("flo2.dat"));
        int count = buffer.getShort();
        overLayFlo317s = new OverLayFlo317[count];
        for (int i = 0; i < count; ++i) {
            if (overLayFlo317s[i] == null) {
                OverLayFlo317.overLayFlo317s[i] = new OverLayFlo317();
            }
            overLayFlo317s[i].parse(buffer);
            if (i != 113) continue;
            OverLayFlo317.overLayFlo317s[i].groundTextureOverlay = 25;
        }
    }

    private void parse(ByteBuffer byteBuffer) {
        byte attributeId;
        while ((attributeId = byteBuffer.get()) != 0) {
            if (attributeId == 1) {
                this.groundColorOverlay = ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
                if (Client.getOption("hd_tex")) {
                    this.groundColorOverlay = OverLayFlo317.setColor(this.groundColorOverlay);
                    continue;
                }
                this.rgbhsl(this.groundColorOverlay);
                continue;
            }
            if (attributeId == 2) {
                this.groundTextureOverlay = byteBuffer.get() & 0xFF;
                continue;
            }
            if (attributeId == 3) {
                this.groundTextureOverlay = byteBuffer.getShort() & 0xFFFF;
                if (this.groundTextureOverlay != 65535) continue;
                this.groundTextureOverlay = -1;
                continue;
            }
            if (attributeId == 4) continue;
            if (attributeId == 5) {
                this.occludeOverlay = false;
                continue;
            }
            if (attributeId == 6) continue;
            if (attributeId == 7) {
                this.detailedColor = ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
                if (Client.getOption("hd_tex")) {
                    this.detailedColor = OverLayFlo317.setColor(this.detailedColor);
                    continue;
                }
                this.rgbhsl(this.detailedColor);
                continue;
            }
            if (attributeId == 8) continue;
            if (attributeId == 9) {
                this.detailedTexture9 = byteBuffer.getShort() & 0xFFFF;
                continue;
            }
            if (attributeId == 10) {
                this.boolean_10 = false;
                continue;
            }
            if (attributeId == 11) {
                this.detailedTexture11 = byteBuffer.get() & 0xFF;
                continue;
            }
            if (attributeId == 12) {
                this.boolean_12 = true;
                continue;
            }
            if (attributeId == 13) {
                this.detailedColor13 = ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
                continue;
            }
            if (attributeId == 14) {
                this.detailedTexture14 = byteBuffer.get() & 0xFF;
                continue;
            }
            if (attributeId == 15) {
                this.int_15 = byteBuffer.getShort() & 0xFFFF;
                if (this.int_15 != 65535) continue;
                this.int_15 = -1;
                continue;
            }
            if (attributeId == 16) {
                this.alpha = byteBuffer.get() & 0xFF;
                continue;
            }
            System.err.println("[OverlayFloor] Missing AttributeId: " + attributeId);
        }
    }

    private static int setColor(int color) {
        return color != 0xFF00FF ? OverLayFlo317.rgb2hsl(color) : -1;
    }

    private static int rgb2hsl(int color) {
        double max;
        double r = (double)(color >>> 16 & 0xFF) / 256.0;
        double g = (double)(color >>> 8 & 0xFF) / 256.0;
        double b = (double)(color & 0xFF) / 256.0;
        double min = r;
        if (min > g) {
            min = g;
        }
        if (min > b) {
            min = b;
        }
        if (g > (max = r)) {
            max = g;
        }
        if (b > max) {
            max = b;
        }
        double hue = 0.0;
        double saturation = 0.0;
        double luminance = (min + max) / 2.0;
        if (max != min) {
            if (luminance < 0.5) {
                saturation = (max - min) / (min + max);
            }
            if (max != r) {
                if (max == g) {
                    hue = (b - r) / (max - min) + 2.0;
                } else if (max == b) {
                    hue = (r - g) / (max - min) + 4.0;
                }
            } else {
                hue = (g - b) / (max - min);
            }
            if (luminance >= 0.5) {
                saturation = (max - min) / (2.0 - min - max);
            }
        }
        int hueOverlay = (int)((hue /= 6.0) * 256.0);
        int satOverlay = (int)(saturation * 256.0);
        int lumOverlay = (int)(luminance * 256.0);
        if (satOverlay < 0) {
            satOverlay = 0;
        } else if (satOverlay > 255) {
            satOverlay = 255;
        }
        if (lumOverlay < 0) {
            lumOverlay = 0;
        } else if (lumOverlay > 255) {
            lumOverlay = 255;
        }
        if (lumOverlay > 242) {
            satOverlay >>= 4;
        } else if (lumOverlay > 217) {
            satOverlay >>= 3;
        } else if (lumOverlay > 192) {
            satOverlay >>= 2;
        } else if (lumOverlay > 179) {
            satOverlay >>= 1;
        }
        return (lumOverlay >> 1) + ((satOverlay >> 5 << 7) + ((hueOverlay & 0xFF) >> 2 << 10));
    }

    private void rgbhsl(int color) {
        double max;
        double red = (double)(color >> 16 & 0xFF) / 255.0;
        double green = (double)(color >> 8 & 0xFF) / 255.0;
        double blue = (double)(color & 0xFF) / 255.0;
        double min = red;
        if (green < min) {
            min = green;
        }
        if (blue < min) {
            min = blue;
        }
        if (green > (max = red)) {
            max = green;
        }
        if (blue > max) {
            max = blue;
        }
        double hue = 0.0;
        double saturation = 0.0;
        double luminance = (min + max) / 2.0;
        if (min != max) {
            if (luminance < 0.5) {
                saturation = (max - min) / (max + min);
            }
            if (luminance >= 0.5) {
                saturation = (max - min) / (2.0 - max - min);
            }
            if (red == max) {
                hue = (green - blue) / (max - min);
            } else if (green == max) {
                hue = 2.0 + (blue - red) / (max - min);
            } else if (blue == max) {
                hue = 4.0 + (red - green) / (max - min);
            }
        }
        this.groundHueOverlay = (int)((hue /= 6.0) * 255.0);
        this.groundSaturationOverlay = (int)(saturation * 255.0);
        this.groundLightnessOverlay = (int)(luminance * 255.0);
        int hue_overlay = this.groundHueOverlay;
        int sat_overlay = this.groundSaturationOverlay;
        int lum_overlay = this.groundLightnessOverlay;
        if (sat_overlay < 0) {
            sat_overlay = 0;
        } else if (sat_overlay > 255) {
            sat_overlay = 255;
        }
        if (lum_overlay < 0) {
            lum_overlay = 0;
        } else if (lum_overlay > 255) {
            lum_overlay = 255;
        }
        this.chroma_overlay = luminance > 0.5 ? (int)((1.0 - luminance) * saturation * 512.0) : (int)(luminance * saturation * 512.0);
        if (this.chroma_overlay < 1) {
            this.chroma_overlay = 1;
        }
        this.weighted_hue = (int)(hue * (double)this.chroma_overlay);
        int hue_offset = hue_overlay;
        int sat_offset = sat_overlay;
        int lum_offset = lum_overlay;
        this.hslOverlayColor = this.encode(hue_offset, sat_offset, lum_offset);
    }

    private final int encode(int arg0, int arg1, int arg2) {
        if (arg2 > 179) {
            arg1 /= 2;
        }
        if (arg2 > 192) {
            arg1 /= 2;
        }
        if (arg2 > 217) {
            arg1 /= 2;
        }
        if (arg2 > 243) {
            arg1 /= 2;
        }
        int i = (arg0 / 4 << 10) + (arg1 / 32 << 7) + arg2 / 2;
        return i;
    }
}

