/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ByteBuffer;
import com.teragard.Texture;

public class PalettedTexture
extends Texture {
    public int[] palette;
    public byte[] indices;

    public PalettedTexture(int width, int height, ByteBuffer buffer, boolean alpha) {
        super(width, height);
        int paletteSize = buffer.readUnsignedByte();
        this.palette = new int[1 + paletteSize];
        int[] palette = this.palette;
        for (int i = 0; i != paletteSize; ++i) {
            int pixel = buffer.getMedium();
            if (!alpha) {
                pixel |= 0xFF000000;
            }
            palette[1 + i] = pixel;
        }
        int count = width * height;
        this.indices = new byte[count];
        byte[] indices = this.indices;
        for (int i = 0; i != count; ++i) {
            indices[i] = buffer.readSignedByte();
            if (alpha || indices[i] != 0) continue;
            this.opaque = false;
        }
    }

    @Override
    public int getPixel(int i) {
        return this.palette[this.indices[i] & 0xFF];
    }

    public byte[] getIndices() {
        return this.indices;
    }

    public void setIndices(byte[] indices) {
        this.indices = indices;
    }

    public String getType() {
        return "0";
    }

    @Override
    public String toString() {
        return this.getType() + "\t" + super.toString() + "\t" + (this.palette.length - 1);
    }
}

