/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ParticleVector;
import com.teragard.PointSpawnShape;
import com.teragard.SpawnShape;
import com.teragard.Sprite;
import java.util.Random;

public class ParticleDefinition {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    private ParticleVector gravity;
    private float startSize = 1.0f;
    private float endSize = 1.0f;
    public int particleDepth;
    private int startColor = -1;
    private int endColor = -1;
    private ParticleVector startVelocity = ParticleVector.ZERO;
    private ParticleVector endVelocity = ParticleVector.ZERO;
    private SpawnShape spawnShape = new PointSpawnShape(ParticleVector.ZERO);
    private float startAlpha = 1.0f;
    private float endAlpha = 0.05f;
    private int lifeSpan = 1;
    private int spawnRate = 1;
    private Sprite sprite;
    private ParticleVector velocityStep;
    private int colorStep;
    private float sizeStep;
    private float alphaStep;
    public static ParticleDefinition[] cache = new ParticleDefinition[]{new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -3, 0));
            this.setEndVelocity(new ParticleVector(0, -3, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(0xFFFFFF);
            this.setSpawnRate(4);
            this.setStartSize(1.4f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.035f);
            this.updateSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -3, 0));
            this.setEndVelocity(new ParticleVector(0, -3, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(0xFFFFFF);
            this.setSpawnRate(4);
            this.setStartSize(1.4f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.035f);
            this.updateSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -3, 0));
            this.setEndVelocity(new ParticleVector(0, -3, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(0xFFFFFF);
            this.setSpawnRate(4);
            this.setStartSize(1.4f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.035f);
            this.updateSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(1, -1, 1));
            this.setEndVelocity(new ParticleVector(1, -1, 1));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(9883875);
            this.setSpawnRate(1);
            this.setStartSize(1.4f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.updateSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(1, -1, 1));
            this.setEndVelocity(new ParticleVector(1, -1, 1));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(0);
            this.setSpawnRate(3);
            this.setStartSize(0.9f);
            this.setEndSize(0.05f);
            this.setStartAlpha(0.06f);
            this.updateSteps();
            this.setColorStep(0);
        }
    }};

    public final SpawnShape getSpawnedShape() {
        return this.spawnShape;
    }

    public final float getStartAlpha() {
        return this.startAlpha;
    }

    public final void setStartAlpha(float startAlpha) {
        this.startAlpha = startAlpha;
    }

    public final float getAlphaStep() {
        return this.alphaStep;
    }

    public final Sprite getSprite() {
        return this.sprite;
    }

    public final void setSprite(Sprite sprite) {
        this.sprite = sprite;
    }

    public final int getSpawnRate() {
        return this.spawnRate;
    }

    public final void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    public final void setStartSize(float startSize) {
        this.startSize = startSize;
    }

    public final float getStartSize() {
        return this.startSize;
    }

    public float getEndSize() {
        return this.endSize;
    }

    public int getEndColor() {
        return this.endColor;
    }

    public final void setEndSize(float endSize) {
        this.endSize = endSize;
    }

    public final int getStartColor() {
        return this.startColor;
    }

    public final void setStartColor(int startColor) {
        this.startColor = startColor;
    }

    public int randomWithRange(int min, int max) {
        int range = max - min + 1;
        return (int)(Math.random() * (double)range) + min;
    }

    public final ParticleVector getStartVelocity(int id) {
        switch (id) {
            default: 
        }
        return new ParticleVector(this.startVelocity.getX() + this.randomWithRange(-1, 1), this.startVelocity.getY() + this.randomWithRange(0, 0), this.startVelocity.getZ() + this.randomWithRange(-1, 1));
    }

    public ParticleVector getGravity() {
        return this.gravity;
    }

    public void setGravity(ParticleVector gravity) {
        this.gravity = gravity;
    }

    public final void setStartVelocity(ParticleVector startVelocity) {
        this.startVelocity = startVelocity;
    }

    public ParticleVector getEndVelocity() {
        return this.endVelocity;
    }

    public final void setEndVelocity(ParticleVector endVelocity) {
        this.endVelocity = endVelocity;
    }

    public final int getLifeSpan() {
        return this.lifeSpan;
    }

    public final void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public final void setColorStep(int colorStep) {
        this.colorStep = colorStep;
    }

    public final float getSizeStep() {
        return this.sizeStep;
    }

    public final ParticleVector getVelocityStep() {
        return this.velocityStep;
    }

    public final int getColorStep() {
        return this.colorStep;
    }

    public final void updateSteps() {
        this.sizeStep = (this.endSize - this.startSize) / ((float)this.lifeSpan * 1.0f);
        this.colorStep = (this.endColor - this.startColor) / this.lifeSpan;
        this.velocityStep = this.endVelocity.subtract(this.startVelocity).divide(this.lifeSpan);
        this.alphaStep = (this.endAlpha - this.startAlpha) / (float)this.lifeSpan;
    }
}

