/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.Animation;
import com.teragard.NPCDef;

public class PetSystem {
    private final int[] modelArray;
    private final int modelArrayLength;
    private final String name;
    private final String description;
    private static int animation;
    private static int animationDelay;
    public static int animationFrame;
    public static int petSelected;
    public static float npcSize;
    private static long timeForAnim;

    public PetSystem(NPCDef entity) {
        this.modelArray = entity.models;
        this.modelArrayLength = 1;
        this.name = entity.name;
        this.description = entity.description;
        animation = entity.standAnim;
        if (animationFrame >= Animation.anims[PetSystem.animation].delays.length) {
            animationFrame = 0;
        }
        animationDelay = Animation.anims[PetSystem.animation].delays[animationFrame];
    }

    public static void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < timeForAnim) {
            return;
        }
        if (++animationFrame >= Animation.anims[PetSystem.animation].frameIDs.length) {
            animationFrame = 0;
        }
        timeForAnim = currentTime + (long)(Animation.anims[PetSystem.animation].delays[animationFrame] * 13);
    }

    public int getAnimationDelay() {
        return animationDelay;
    }

    public int getAnimation() {
        return animation;
    }

    public String getName() {
        return this.name;
    }

    public int getAnimationFrame() {
        return animationFrame;
    }

    public String getDescription() {
        return this.description;
    }

    public int getModelArrayLength() {
        return this.modelArrayLength;
    }

    public int[] getModelArray() {
        return this.modelArray;
    }

    public int getPetSelected() {
        return petSelected;
    }

    public void setPetSelected(int petID) {
        petSelected = petID;
    }

    static {
        petSelected = -1;
        npcSize = 1.0f;
        timeForAnim = System.currentTimeMillis();
    }
}

