/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.ByteBuffer;
import com.teragard.Texture;

public final class RGBTexture
extends Texture {
    public int[] pixels;

    public RGBTexture(int width, int height, ByteBuffer buffer) {
        super(width, height);
        int count = width * height;
        this.pixels = new int[count];
        int[] pixels = this.pixels;
        for (int i = 0; i != count; ++i) {
            int pixel = buffer.getMedium();
            if (pixel != 0) {
                pixel |= 0xFF000000;
            } else {
                this.opaque = false;
            }
            pixels[i] = pixel;
        }
    }

    @Override
    public int getPixel(int i) {
        return this.pixels[i];
    }

    @Override
    public String toString() {
        return "1\t" + super.toString();
    }

    public void setPixels(int[] pixels) {
        this.pixels = pixels;
    }

    public int[] getPixels() {
        return this.pixels;
    }
}

