/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.CacheArchive;
import com.teragard.MemCache;
import com.teragard.RSInterface;
import com.teragard.Sprite;
import com.teragard.Stream;
import com.teragard.TextClass;
import com.teragard.TextDrawingArea;

public class RSInterfaceDecoder {
    private static MemCache spriteCache;
    private static TextDrawingArea[] fonts;

    public static RSInterface[] decode(CacheArchive interfaceArchive, TextDrawingArea[] textDrawingAreas, CacheArchive mediaArchive) {
        fonts = textDrawingAreas;
        spriteCache = new MemCache(150000);
        Stream stream = new Stream(interfaceArchive.getDataForName("data"));
        int parentId = -1;
        int totalInterfaces = stream.readUnsignedWord();
        RSInterface[] interfaceCache = new RSInterface[150000];
        while (stream.currentOffset < stream.buffer.length) {
            int indexAmt;
            int opcode = stream.readUnsignedWord();
            if (opcode == 65535) {
                parentId = stream.readUnsignedWord();
                opcode = stream.readUnsignedWord();
            }
            RSInterface rsi = interfaceCache[opcode] = new RSInterface();
            rsi.id = opcode;
            rsi.parentID = parentId;
            rsi.type = stream.readUnsignedByte();
            rsi.atActionType = stream.readUnsignedByte();
            rsi.contentType = stream.readUnsignedWord();
            rsi.width = stream.readUnsignedWord();
            rsi.height = stream.readUnsignedWord();
            rsi.opacity = (byte)stream.readUnsignedByte();
            rsi.hoverType = stream.readUnsignedByte();
            rsi.hoverType = rsi.hoverType != 0 ? (rsi.hoverType - 1 << 8) + stream.readUnsignedByte() : -1;
            int valueCompareAmt = stream.readUnsignedByte();
            if (valueCompareAmt > 0) {
                rsi.valueCompareType = new int[valueCompareAmt];
                rsi.requiredValues = new int[valueCompareAmt];
                for (int idx = 0; idx < valueCompareAmt; ++idx) {
                    rsi.valueCompareType[idx] = stream.readUnsignedByte();
                    rsi.requiredValues[idx] = stream.readUnsignedWord();
                }
            }
            if ((indexAmt = stream.readUnsignedByte()) > 0) {
                rsi.valueIndexArray = new int[indexAmt][];
                for (int idx = 0; idx < indexAmt; ++idx) {
                    int value = stream.readUnsignedWord();
                    rsi.valueIndexArray[idx] = new int[value];
                    for (int idx1 = 0; idx1 < value; ++idx1) {
                        rsi.valueIndexArray[idx][idx1] = stream.readUnsignedWord();
                    }
                }
            }
            RSInterfaceDecoder.decodeByType(rsi, stream, textDrawingAreas, mediaArchive);
            if (rsi.atActionType != 1 && rsi.atActionType != 4 && rsi.atActionType != 5 && rsi.atActionType != 6) continue;
            rsi.tooltip = stream.readString();
            if (rsi.tooltip.length() != 0) continue;
            switch (rsi.atActionType) {
                case 1: {
                    rsi.tooltip = "Ok";
                    break;
                }
                case 4: 
                case 5: {
                    rsi.tooltip = "Select";
                    break;
                }
                case 6: {
                    rsi.tooltip = "Continue";
                }
            }
        }
        return interfaceCache;
    }

    private static void decodeByType(RSInterface rsi, Stream stream, TextDrawingArea[] textDrawingAreas, CacheArchive mediaArchive) {
        switch (rsi.type) {
            case 0: {
                RSInterfaceDecoder.decodeContainer(rsi, stream);
                break;
            }
            case 1: {
                stream.readUnsignedWord();
                stream.readUnsignedByte();
                RSInterfaceDecoder.decodeTextBase(rsi, stream, textDrawingAreas);
                break;
            }
            case 2: {
                RSInterfaceDecoder.decodeInventory(rsi, stream, mediaArchive);
                break;
            }
            case 3: {
                rsi.filled = stream.readUnsignedByte() == 1;
                RSInterfaceDecoder.decodeColors(rsi, stream);
                break;
            }
            case 4: {
                RSInterfaceDecoder.decodeTextBase(rsi, stream, textDrawingAreas);
                rsi.message = stream.readString().replaceAll("RuneScape", "Teragard");
                if (rsi.message.toLowerCase().equals("the bank of teragard")) {
                    rsi.message = "        Teragard's Bank";
                }
                rsi.enabledMessage = stream.readString();
                RSInterfaceDecoder.decodeColors(rsi, stream);
                break;
            }
            case 5: {
                RSInterfaceDecoder.decodeSprite(rsi, stream, mediaArchive);
                break;
            }
            case 6: {
                RSInterfaceDecoder.decodeModel(rsi, stream);
                break;
            }
            case 7: {
                RSInterfaceDecoder.decodeInventoryText(rsi, stream, textDrawingAreas);
                break;
            }
            case 8: {
                rsi.message = stream.readString();
            }
        }
        if (rsi.atActionType == 2 || rsi.type == 2) {
            rsi.selectedActionName = stream.readString();
            rsi.spellName = stream.readString();
            rsi.spellUsableOn = stream.readUnsignedWord();
        }
    }

    private static void decodeContainer(RSInterface rsi, Stream stream) {
        rsi.drawsTransparent = false;
        rsi.scrollMax = stream.readUnsignedWord();
        rsi.interfaceShown = stream.readUnsignedByte() == 1;
        int childCount = stream.readUnsignedWord();
        rsi.children = new int[childCount];
        rsi.childX = new int[childCount];
        rsi.childY = new int[childCount];
        for (int i = 0; i < childCount; ++i) {
            rsi.children[i] = stream.readUnsignedWord();
            rsi.childX[i] = stream.readSignedWord();
            rsi.childY[i] = stream.readSignedWord();
        }
    }

    private static void decodeInventory(RSInterface rsi, Stream stream, CacheArchive mediaArchive) {
        int i;
        rsi.inv = new int[rsi.width * rsi.height];
        rsi.invStackSizes = new int[rsi.width * rsi.height];
        rsi.deleteOnDrag2 = stream.readUnsignedByte() == 1;
        rsi.isInventoryInterface = stream.readUnsignedByte() == 1;
        rsi.usableItemInterface = stream.readUnsignedByte() == 1;
        rsi.dragDeletes = stream.readUnsignedByte() == 1;
        rsi.invSpritePadX = stream.readUnsignedByte();
        rsi.invSpritePadY = stream.readUnsignedByte();
        rsi.spritesX = new int[20];
        rsi.spritesY = new int[20];
        rsi.sprites = new Sprite[20];
        for (i = 0; i < 20; ++i) {
            int hasSprite = stream.readUnsignedByte();
            if (hasSprite != 1) continue;
            rsi.spritesX[i] = stream.readSignedWord();
            rsi.spritesY[i] = stream.readSignedWord();
            String spriteDef = stream.readString();
            if (mediaArchive == null || spriteDef.length() <= 0) continue;
            int commaIdx = spriteDef.lastIndexOf(",");
            int spriteId = Integer.parseInt(spriteDef.substring(commaIdx + 1));
            String spriteName = spriteDef.substring(0, commaIdx);
            rsi.sprites[i] = RSInterfaceDecoder.getSprite(spriteId, mediaArchive, spriteName);
        }
        rsi.actions = new String[5];
        for (i = 0; i < 5; ++i) {
            rsi.actions[i] = stream.readString();
            if (rsi.actions[i].length() != 0) continue;
            rsi.actions[i] = null;
        }
        RSInterfaceDecoder.applyCustomActions(rsi);
    }

    private static void applyCustomActions(RSInterface rsi) {
        if (rsi.parentID == 3824) {
            rsi.actions[4] = "@or2@Buy X";
        }
        if (rsi.parentID == 3822) {
            rsi.actions[4] = "@or2@Sell X";
        }
        if (rsi.parentID == 1644) {
            rsi.actions[2] = "@or2@Operate";
        }
        if (rsi.parentID == 5292) {
            rsi.actions = new String[]{"@or2@Withdraw-1", "@or2@Withdraw-5", "@or2@Withdraw-10", "@or2@Withdraw-All", null, "@or2@Withdraw-X"};
        }
    }

    private static void decodeTextBase(RSInterface rsi, Stream stream, TextDrawingArea[] textDrawingAreas) {
        rsi.centerText = stream.readUnsignedByte() == 1;
        int fontIdx = stream.readUnsignedByte();
        if (textDrawingAreas != null) {
            rsi.textDrawingAreas = textDrawingAreas[fontIdx];
        }
        rsi.shadowed = stream.readUnsignedByte() == 1;
    }

    private static void decodeColors(RSInterface rsi, Stream stream) {
        if (rsi.type == 1 || rsi.type == 3 || rsi.type == 4) {
            rsi.disabledColor = stream.readDWord();
        }
        if (rsi.type == 3 || rsi.type == 4) {
            rsi.enabledColor = stream.readDWord();
            rsi.disabledMouseOverColor = stream.readDWord();
            rsi.enabledMouseOverColor = stream.readDWord();
        }
    }

    private static void decodeSprite(RSInterface rsi, Stream stream, CacheArchive mediaArchive) {
        rsi.drawsTransparent = false;
        String disabledDef = stream.readString();
        if (mediaArchive != null && disabledDef.length() > 0) {
            int commaIdx = disabledDef.lastIndexOf(",");
            int spriteId = Integer.parseInt(disabledDef.substring(commaIdx + 1));
            String spriteName = disabledDef.substring(0, commaIdx);
            rsi.disabledSprite = RSInterfaceDecoder.getSprite(spriteId, mediaArchive, spriteName);
            rsi.disabledSpriteId = spriteId;
        }
        String enabledDef = stream.readString();
        if (mediaArchive != null && enabledDef.length() > 0) {
            int commaIdx = enabledDef.lastIndexOf(",");
            int spriteId = Integer.parseInt(enabledDef.substring(commaIdx + 1));
            String spriteName = enabledDef.substring(0, commaIdx);
            rsi.enabledSprite = RSInterfaceDecoder.getSprite(spriteId, mediaArchive, spriteName);
            rsi.enabledSpriteId = spriteId;
        }
    }

    private static void decodeModel(RSInterface rsi, Stream stream) {
        int mediaMarker = stream.readUnsignedByte();
        if (mediaMarker != 0) {
            rsi.mediaType = 1;
            rsi.mediaID = (mediaMarker - 1 << 8) + stream.readUnsignedByte();
        }
        if ((mediaMarker = stream.readUnsignedByte()) != 0) {
            rsi.setEnabledMediaType(1);
            rsi.setEnabledMediaID((mediaMarker - 1 << 8) + stream.readUnsignedByte());
        }
        rsi.disabledAnimationId = (mediaMarker = stream.readUnsignedByte()) != 0 ? (mediaMarker - 1 << 8) + stream.readUnsignedByte() : -1;
        mediaMarker = stream.readUnsignedByte();
        rsi.enabledAnimationId = mediaMarker != 0 ? (mediaMarker - 1 << 8) + stream.readUnsignedByte() : -1;
        rsi.modelZoom = stream.readUnsignedWord();
        rsi.modelRotation1 = stream.readUnsignedWord();
        rsi.modelRotation2 = stream.readUnsignedWord();
    }

    private static void decodeInventoryText(RSInterface rsi, Stream stream, TextDrawingArea[] textDrawingAreas) {
        rsi.inv = new int[rsi.width * rsi.height];
        rsi.invStackSizes = new int[rsi.width * rsi.height];
        rsi.centerText = stream.readUnsignedByte() == 1;
        int fontIdx = stream.readUnsignedByte();
        if (textDrawingAreas != null) {
            rsi.textDrawingAreas = textDrawingAreas[fontIdx];
        }
        rsi.shadowed = stream.readUnsignedByte() == 1;
        rsi.disabledColor = stream.readDWord();
        rsi.invSpritePadX = stream.readSignedWord();
        rsi.invSpritePadY = stream.readSignedWord();
        rsi.isInventoryInterface = stream.readUnsignedByte() == 1;
        rsi.actions = new String[5];
        for (int i = 0; i < 5; ++i) {
            rsi.actions[i] = stream.readString();
            if (rsi.actions[i].length() != 0) continue;
            rsi.actions[i] = null;
        }
    }

    private static Sprite getSprite(int spriteId, CacheArchive mediaArchive, String spriteName) {
        if (spriteName.equals("headicons") && spriteId == 0) {
            return null;
        }
        long cacheKey = (TextClass.method585(spriteName) << 8) + (long)spriteId;
        Sprite sprite = (Sprite)spriteCache.get(cacheKey);
        if (sprite != null) {
            return sprite;
        }
        try {
            sprite = new Sprite(mediaArchive, spriteName, spriteId);
            spriteCache.put(sprite, cacheKey);
        }
        catch (Exception e) {
            System.out.println("Unable to load sprite: " + spriteName + " " + spriteId);
            return null;
        }
        return sprite;
    }

    public static void clearSpriteCache() {
        if (spriteCache != null) {
            spriteCache.clear();
        }
    }

    public static TextDrawingArea[] getFonts() {
        return fonts;
    }
}

