/*
 * Decompiled with CFR 0.152.
 */
package com.teragard;

import com.teragard.DrawingArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class RealFont {
    private static final RSFontChar DUMMY_FONT_CHAR = new RSFontChar(new byte[0], 0, 0, 0, 0, 0, 0);
    private static final int FOREGROUND = -1;
    private static final int BACKGROUND = 0;
    private boolean disposed;
    private RSFontChar[][] charCache;
    private int bufferWidth;
    private int bufferHeight;
    private int[] bufferPixels;
    private int bufferSize;
    private int ascent;
    private Graphics2D bufferGraphics;
    private BufferedImage buffer;
    private FontMetrics fontMetrics;
    public final Font font;

    public RealFont(Component context, String name, int style, int size, boolean smooth) {
        this(context, new Font(name, style, size), smooth);
    }

    public RealFont(Component context, Font font, boolean smooth) {
        if (context == null || font == null) {
            throw new IllegalArgumentException();
        }
        this.font = font;
        this.fontMetrics = context.getFontMetrics(font);
        if (this.fontMetrics == null) {
            throw new RuntimeException();
        }
        this.ascent = this.fontMetrics.getAscent();
        Rectangle bounds = font.getMaxCharBounds(this.fontMetrics.getFontRenderContext()).getBounds();
        this.bufferWidth = bounds.width;
        this.bufferHeight = bounds.height;
        if (this.bufferWidth < 1 || this.bufferHeight < 1) {
            throw new RuntimeException();
        }
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.bufferPixels = new int[this.bufferSize];
        this.buffer = RealFont.wrapPixels(this.bufferPixels, this.bufferWidth, this.bufferHeight);
        this.bufferGraphics = this.buffer.createGraphics();
        if (this.bufferGraphics == null) {
            throw new RuntimeException();
        }
        this.bufferGraphics.setFont(font);
        if (smooth) {
            this.bufferGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, smooth ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        this.bufferGraphics.setColor(new Color(-1, true));
        this.charCache = new RSFontChar[256][];
    }

    public RealFont(URL url) throws IOException {
        this(url.openStream());
    }

    public RealFont(String file) {
        this(new File(file));
    }

    public RealFont(File file) {
        this.font = null;
        try (FileInputStream in = new FileInputStream(file);){
            this.load(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RealFont(byte[] data) throws IOException {
        this(new ByteArrayInputStream(data, 0, data.length));
    }

    public RealFont(byte[] data, int offset, int length) throws IOException {
        this(new ByteArrayInputStream(data, offset, length));
    }

    public RealFont(InputStream in) throws IOException {
        this.font = null;
        this.load(in);
    }

    private void load(InputStream in0) throws IOException {
        DataInputStream in = new DataInputStream(new GZIPInputStream(in0));
        int bufferWidth = RealFont.readInt(in);
        int bufferHeight = RealFont.readInt(in);
        int ascent = RealFont.readInt(in);
        if (bufferWidth == 0 || bufferHeight == 0) {
            bufferHeight = 0;
            bufferWidth = 0;
        }
        this.bufferWidth = bufferWidth;
        this.bufferHeight = bufferHeight;
        this.ascent = ascent;
        for (int i = 0; i != 65536; ++i) {
            this.provideFontChar((char)i, new RSFontChar(in));
        }
    }

    public void writeTo(OutputStream out0) throws IOException {
        GZIPOutputStream gzipOut = new GZIPOutputStream(out0);
        DataOutputStream out = new DataOutputStream(gzipOut);
        RealFont.writeInt(out, this.bufferWidth);
        RealFont.writeInt(out, this.bufferHeight);
        RealFont.writeInt(out, this.ascent);
        for (int i = 0; i != 65536; ++i) {
            RSFontChar chr = this.getFontChar((char)i, false);
            if (chr == null) {
                out.writeByte(0);
                continue;
            }
            chr.writeTo(out);
        }
        gzipOut.finish();
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(out);
        return out.toByteArray();
    }

    public void writeTo(String file) throws IOException {
        this.writeTo(new File(file));
    }

    public void writeTo(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(out);
        }
    }

    public int drawStringCenter(String str, int x, int y, int color, boolean shadow) {
        if (shadow) {
            this.drawStringCenter(str, x + 1, y + 1, 0, false, false);
        }
        return this.drawStringCenter(str, x, y, color, false, false);
    }

    public int drawStringCenter(String str, int x, int y, int color, boolean validAlpha, boolean dummy) {
        return this.drawString(str, x - this.stringWidth(str) / 2, y, color, validAlpha);
    }

    public int drawStringRight(String str, int x, int y, int color, boolean shadow) {
        if (shadow) {
            this.drawStringRight(str, x + 1, y + 1, 0, false, false);
        }
        return this.drawStringRight(str, x, y, color, false, shadow);
    }

    public int drawStringRight(String str, int x, int y, int color, boolean validAlpha, boolean dummy) {
        return this.drawString(str, x - this.stringWidth(str), y, color, validAlpha);
    }

    public int drawString(String str, int x, int y, int color, boolean shadow) {
        if (shadow) {
            this.drawString(str, x + 1, y + 1, 0, false, false);
        }
        return this.drawString(str, x, y, color, false, shadow);
    }

    public int drawString(String str, int x, int y, int color, boolean validAlpha, boolean dummy) {
        if (str == null) {
            return 0;
        }
        if (!validAlpha) {
            color |= 0xFF000000;
        }
        int length = str.length();
        int width = 0;
        for (int i = 0; i != length; ++i) {
            width += this.drawChar(str.charAt(i), width + x, y, color, true);
        }
        return width;
    }

    public int drawChar(char chr, int x, int y, int color) {
        return this.drawChar(chr, x, y, color, false);
    }

    public int drawChar(char chr, int x, int y, int color, boolean validAlpha) {
        RSFontChar fontChar = this.getFontChar(chr);
        this.drawPixels(fontChar.pixels, fontChar.width, fontChar.height, fontChar.xOffset + x, fontChar.yOffset + y - this.ascent, validAlpha ? color : color | 0xFF000000);
        return fontChar.widthOffset;
    }

    public int stringWidth(String str) {
        if (str == null) {
            return 0;
        }
        int width = 0;
        int length = str.length();
        for (int i = 0; i != length; ++i) {
            width += this.charWidth(str.charAt(i));
        }
        return width;
    }

    public int stringHeight(String str) {
        if (str == null) {
            return 0;
        }
        int height = 0;
        int length = str.length();
        for (int i = 0; i != length; ++i) {
            int h = this.charHeight(str.charAt(i));
            if (height >= h) continue;
            height = h;
        }
        return height;
    }

    public int stringX(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return this.charX(str.charAt(0));
    }

    public int stringY(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int y = 0;
        int length = str.length();
        for (int i = 0; i != length; ++i) {
            int y0 = this.charY(str.charAt(i));
            if (y <= y0) continue;
            y = y0;
        }
        return y;
    }

    public Rectangle stringBounds(String str) {
        return new Rectangle(this.stringX(str), this.stringY(str), this.stringWidth(str), this.stringHeight(str));
    }

    public int charX(char chr) {
        return this.getFontChar((char)chr).xOffset;
    }

    public int charY(char chr) {
        return this.ascent + this.getFontChar((char)chr).yOffset;
    }

    public int charWidth(char chr) {
        return this.getFontChar((char)chr).widthOffset;
    }

    public int charHeight(char chr) {
        return this.getFontChar((char)chr).heightOffset;
    }

    public Rectangle charBounds(char chr) {
        return this.getFontChar(chr).getBounds();
    }

    public int getMaxCharWidth() {
        return this.bufferWidth;
    }

    public int getMaxCharHeight() {
        return this.bufferHeight;
    }

    public int getDescent() {
        return this.ascent;
    }

    public void provideFontChar(char chr, RSFontChar fontChar) {
        if (this.disposed) {
            return;
        }
        if (fontChar == null) {
            fontChar = DUMMY_FONT_CHAR;
        }
        int sector = chr >>> 8;
        int index = chr & 0xFF;
        RSFontChar[][] charCache = this.charCache;
        RSFontChar[] cacheSector = charCache[sector];
        if (cacheSector != null) {
            cacheSector[index] = fontChar;
            return;
        }
        charCache[sector] = new RSFontChar[256];
        cacheSector = charCache[sector];
        cacheSector[index] = fontChar;
    }

    public RSFontChar getFontChar(char chr) {
        return this.getFontChar(chr, true);
    }

    public RSFontChar getFontChar(char chr, boolean giveDummy) {
        RSFontChar fontChar;
        if (this.disposed) {
            return giveDummy ? DUMMY_FONT_CHAR : null;
        }
        int sector = chr >>> 8;
        int index = chr & 0xFF;
        RSFontChar[][] charCache = this.charCache;
        RSFontChar[] cacheSector = charCache[sector];
        if (cacheSector != null && (fontChar = cacheSector[index]) != null) {
            return fontChar;
        }
        fontChar = this.getFontChar0(chr);
        if (fontChar == null) {
            if (!giveDummy) {
                return null;
            }
            fontChar = DUMMY_FONT_CHAR;
        }
        if (cacheSector == null) {
            charCache[sector] = new RSFontChar[256];
            cacheSector = charCache[sector];
        }
        cacheSector[index] = fontChar;
        return fontChar;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        BufferedImage img;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.charCache = null;
        this.bufferPixels = null;
        this.fontMetrics = null;
        Graphics2D gfx = this.bufferGraphics;
        if (gfx != null) {
            this.bufferGraphics = null;
            try {
                gfx.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((img = this.buffer) != null) {
            this.buffer = null;
            try {
                img.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static BufferedImage wrapPixels(int[] pixels, int width, int height) {
        DirectColorModel model = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        return new BufferedImage(model, Raster.createWritableRaster(model.createCompatibleSampleModel(width, height), new DataBufferInt(pixels, width * height), null), false, new Hashtable());
    }

    private static int bind(int a, int b) {
        return a * (b + 1) >>> 8;
    }

    private void drawPixels(byte[] pixels, int width, int height, int xPos, int yPos, int color) {
        if (width < 1 || height < 1) {
            return;
        }
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        int tmp = DrawingArea.topX;
        if (xPos < tmp) {
            x += tmp - xPos;
            w -= tmp - xPos;
            xPos = tmp;
        }
        if (yPos < (tmp = DrawingArea.topY)) {
            y += tmp - yPos;
            h -= tmp - yPos;
            yPos = tmp;
        }
        if (xPos + w > (tmp = DrawingArea.bottomX)) {
            w = tmp - xPos;
        }
        if (yPos + h > (tmp = DrawingArea.bottomY)) {
            h = tmp - yPos;
        }
        if (w < 1 || h < 1) {
            return;
        }
        tmp = DrawingArea.width;
        int localIndex = x + y * width;
        int globalIndex = xPos + yPos * tmp;
        int[] dst = DrawingArea.pixels;
        for (int i = 0; i != h; ++i) {
            for (int i1 = 0; i1 != w; ++i1) {
                dst[globalIndex + i1] = RealFont.blend(dst[globalIndex + i1], color, RealFont.bind(pixels[localIndex + i1] & 0xFF, color >>> 24)) & 0xFFFFFF;
            }
            localIndex += width;
            globalIndex += tmp;
        }
    }

    private RSFontChar getFontChar0(char chr) {
        if (!this.font.canDisplay(chr)) {
            return null;
        }
        int bufferSize = this.bufferSize;
        int bufferWidth = this.bufferWidth;
        int bufferHeight = this.bufferHeight;
        int[] bufferPixels = this.bufferPixels;
        for (int i = 0; i != bufferSize; ++i) {
            bufferPixels[i] = 0;
        }
        this.bufferGraphics.drawString(String.valueOf(chr), 0, this.fontMetrics.getMaxAscent());
        int startX = bufferWidth;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        int offset = 0;
        for (int i = 0; i != bufferHeight; ++i) {
            int startX0 = bufferWidth;
            for (int i1 = 0; i1 != startX0; ++i1) {
                if ((bufferPixels[offset + i1] & 0xFF000000) == 0) continue;
                startX0 = i1;
                break;
            }
            offset += bufferWidth;
            if (startX0 == bufferWidth) {
                if (startY != i) continue;
                startY = 1 + i;
                continue;
            }
            endY = 1 + i;
            int endX0 = bufferWidth - startX0 - 1;
            if (endX0 < endX) {
                endX0 = endX;
            }
            for (int i1 = 0; i1 != endX0; ++i1) {
                if ((bufferPixels[offset - i1 - 1] & 0xFF000000) == 0) continue;
                endX0 = bufferWidth - i1;
                break;
            }
            if (startX > startX0) {
                startX = startX0;
            }
            if (endX >= endX0) continue;
            endX = endX0;
        }
        if (startX < 0) {
            endX += startX;
            startX = 0;
        }
        if (startY < 0) {
            endY += startY;
            startY = 0;
        }
        if (startX > endX) {
            endX = startX;
        }
        if (startY > endY) {
            endY = startY;
        }
        int x = startX;
        int y = startY;
        int width = endX - x;
        int height = endY - y;
        byte[] fontPixels = new byte[width * height];
        int localIndex = 0;
        int globalIndex = x + y * bufferWidth;
        for (int i = 0; i != height; ++i) {
            for (int i1 = 0; i1 != width; ++i1) {
                fontPixels[localIndex + i1] = (byte)(bufferPixels[globalIndex + i1] >>> 24);
            }
            localIndex += width;
            globalIndex += bufferWidth;
        }
        return new RSFontChar(fontPixels, width, height, x, y, this.fontMetrics.charWidth(chr), bufferHeight);
    }

    private static int blend(int dst, int src, int alpha) {
        if (alpha == 0) {
            return dst;
        }
        if (alpha == 255) {
            return src;
        }
        int delta = 255 - alpha;
        return src & 0xFF000000 | ((src & 0xFF00FF) * alpha + (dst & 0xFF00FF) * delta & 0xFF00FF00 | (src & 0xFF00) * alpha + (dst & 0xFF00) * delta & 0xFF0000) >>> 8;
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private static int readInt(DataInputStream in) throws IOException {
        int b = in.readByte() & 0xFF;
        if ((b & 0x80) == 0) {
            return b;
        }
        return b | (in.readByte() & 0xFF) << 7 | (in.readByte() & 0xFF) << 15 | (in.readByte() & 0xFF) << 23;
    }

    private static void writeInt(DataOutputStream out, int val) throws IOException {
        if ((val & 0x7F) == val) {
            out.writeByte((byte)val);
            return;
        }
        out.writeByte((byte)(val | 0x80));
        out.writeByte((byte)(val >>> 7));
        out.writeByte((byte)(val >>> 15));
        out.writeByte((byte)(val >>> 23));
    }

    public static class RSFontChar {
        public final byte[] pixels;
        public final int width;
        public final int height;
        public final int xOffset;
        public final int yOffset;
        public final int widthOffset;
        public final int heightOffset;

        public RSFontChar(byte[] pixels, int width, int height, int xOffset, int yOffset, int widthOffset, int heightOffset) {
            if (width < 0 || height < 0 || pixels == null || width * height > pixels.length) {
                height = 0;
                width = 0;
            }
            if (pixels == null) {
                pixels = new byte[]{};
            }
            if (xOffset < 0) {
                xOffset = 0;
            }
            if (yOffset < 0) {
                yOffset = 0;
            }
            if (widthOffset < 0) {
                widthOffset = 0;
            }
            if (heightOffset < 0) {
                heightOffset = 0;
            }
            this.pixels = pixels;
            this.width = width;
            this.height = height;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.widthOffset = widthOffset;
            this.heightOffset = heightOffset;
        }

        public RSFontChar(InputStream in0) throws IOException {
            int height;
            int width;
            DataInputStream in = in0 instanceof DataInputStream ? (DataInputStream)in0 : new DataInputStream(in0);
            int flags = in.readByte() & 0xFF;
            if ((flags & 1) != 0) {
                width = RealFont.readInt(in);
                height = RealFont.readInt(in);
                if (width == 0 || height == 0) {
                    height = 0;
                    width = 0;
                }
            } else {
                height = 0;
                width = 0;
            }
            int count = width * height;
            byte[] pixels = new byte[count];
            for (int i = 0; i != count; ++i) {
                pixels[i] = in.readByte();
            }
            int xOffset = (flags & 3) == 3 ? RealFont.readInt(in) : 0;
            int yOffset = (flags & 5) == 5 ? RealFont.readInt(in) : 0;
            int widthOffset = (flags & 8) != 0 ? RealFont.readInt(in) : 0;
            int heightOffset = (flags & 0x10) != 0 ? RealFont.readInt(in) : 0;
            this.width = width;
            this.height = height;
            this.pixels = pixels;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.widthOffset = widthOffset;
            this.heightOffset = heightOffset;
        }

        public void writeTo(OutputStream out0) throws IOException {
            DataOutputStream out = out0 instanceof DataOutputStream ? (DataOutputStream)out0 : new DataOutputStream(out0);
            int flags = 0;
            int width = this.width;
            int height = this.height;
            int xOffset = this.xOffset;
            int yOffset = this.yOffset;
            int widthOffset = this.widthOffset;
            int heightOffset = this.heightOffset;
            if (width > 0 && height > 0) {
                flags |= 1;
                if (xOffset != 0) {
                    flags |= 2;
                }
                if (yOffset != 0) {
                    flags |= 4;
                }
            }
            if (widthOffset != 0) {
                flags |= 8;
            }
            if (heightOffset != 0) {
                flags |= 0x10;
            }
            out.writeByte(flags);
            if ((flags & 1) != 0) {
                byte[] pixels = this.pixels;
                RealFont.writeInt(out, width);
                RealFont.writeInt(out, height);
                int count = width * height;
                for (int i = 0; i != count; ++i) {
                    out.writeByte(pixels[i]);
                }
            }
            if ((flags & 3) == 3) {
                RealFont.writeInt(out, xOffset);
            }
            if ((flags & 5) == 5) {
                RealFont.writeInt(out, yOffset);
            }
            if ((flags & 8) != 0) {
                RealFont.writeInt(out, widthOffset);
            }
            if ((flags & 0x10) != 0) {
                RealFont.writeInt(out, heightOffset);
            }
        }

        public Rectangle getBounds() {
            return new Rectangle(this.xOffset, this.yOffset, this.widthOffset, this.heightOffset);
        }
    }
}

